/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omr_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omr-etablissement');
var omr_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'omr-depot');
var omr_aProvenances = new Arbre("ComboListe/combo-sitesWeb.tmpl","omr-provenance");
var omr_aRetours = new Arbre("Facturation/Retours_Clients/list-retourClient.tmpl", "omr-listeRetours");
var omr_aApercuRetour = new Arbre("Facturation/Retours_Clients/list-apercuRetourClient.tmpl", "omr-apercuRetour");
var omr_qListRC = new QueryHttp("Facturation/Retours_Clients/getDataListRC.tmpl");

var omr_pageCourante;
var omr_nbPages;

var omr_langueDefaut;
var omr_retourId;



function omr_init() {
	try {

		omr_aProvenances.initTree();

		omr_aEtablissements.setParam('Selection', gEtablissementDefaut);
		omr_aEtablissements.initTree(omr_initEtablissement);

		if (!gSiteWeb) {
			document.getElementById('omr-colRefRetourWeb').collapsed = true;
			document.getElementById('omr-colRefRetourWeb').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('omr-colProvenance').collapsed = true;
			document.getElementById('omr-colProvenance').setAttribute("ignoreincolumnpicker", true);
		}

		document.getElementById('omr-boxProvenance').collapsed = !gSiteWeb;
		document.getElementById('omr-boxNouveauRetour').collapsed = !gProfil.isMenuGC_VAffaires();

		document.getElementById('omr-miProvenanceHL').collapsed = !gProfil.isProvenanceHL();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initEtablissement() {
	try {

		omr_aDepots.setParam('Selection', gDepotDefautRC);
		omr_aDepots.initTree(omr_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initCriteres() {
	try {

		document.getElementById('omr-numRetour').value = "";
		document.getElementById('omr-numClient').value = "";
		document.getElementById('omr-denomination').value = "";
		document.getElementById('omr-etablissement').value = gEtablissementDefaut;
		document.getElementById('omr-depot').value = gDepotDefautRC;
		document.getElementById('omr-dateDebut').value = "";
		document.getElementById('omr-dateFin').value = "";
		document.getElementById('omr-refArticle').value = "";
		document.getElementById('omr-etatRetour').value = "N";
		document.getElementById('omr-typeRetour').value = "";
		document.getElementById('omr-provenance').value = "";

		omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_listerRetours() {
	try {

		var numRetour = document.getElementById('omr-numRetour').value;
		var numClient = document.getElementById('omr-numClient').value;
		var denomination = document.getElementById('omr-denomination').value;
		var etablissement = document.getElementById('omr-etablissement').value;
		var depot = document.getElementById('omr-depot').value;
		var dateDebut = document.getElementById('omr-dateDebut').value;
		var dateFin = document.getElementById('omr-dateFin').value;
		var refArticle = document.getElementById('omr-refArticle').value;
		var etat = document.getElementById('omr-etatRetour').value;
		var typeRetour = document.getElementById('omr-typeRetour').value;
		var provenance = document.getElementById('omr-provenance').value;
		var nbLignesParPage = document.getElementById('omr-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			omr_pageCourante = 1;
			omr_nbPages = 1;
			document.getElementById('omr-pageDeb').value = 1;
			document.getElementById('omr-pageFin').value = 1;
			document.getElementById('omr-bPrec').disabled = true;
			document.getElementById('omr-bSuiv').disabled = true;

			document.getElementById('omr-listeRetours').disabled = true;
			document.getElementById('omr-bEditionCsv').disabled = true;
			document.getElementById('omr-bEditionDetailCsv').disabled = true;
			document.getElementById('omr-bEditionPDF').disabled = true;
			document.getElementById('omr-bValiderRetour').disabled = true;
			document.getElementById('omr-bReceptionRetour').disabled = true;
			document.getElementById('omr-numRetourSelect').value = "";
			omr_aApercuRetour.deleteTree();
			omr_aRetours.deleteTree();

			omr_qListRC.setParam("Num_Retour", numRetour);
			omr_qListRC.setParam("Num_Client", numClient);
			omr_qListRC.setParam("Denomination", denomination);
			omr_qListRC.setParam("Etablissement", etablissement);
			omr_qListRC.setParam("Depot", depot);
			omr_qListRC.setParam("Date_Debut", dateDebut);
			omr_qListRC.setParam("Date_Fin", dateFin);
			omr_qListRC.setParam("Ref_Article", refArticle);
			omr_qListRC.setParam("Etat", etat);
			omr_qListRC.setParam("Type_Retour", typeRetour);
			omr_qListRC.setParam("Provenance", provenance);
			omr_qListRC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omr_qListRC.setParam("Current_Page", omr_pageCourante);

			var result = omr_qListRC.execute();

			var contenu = result.responseXML.documentElement;

			omr_nbPages = contenu.getAttribute("Nb_Pages");
			var listRetourId = contenu.getAttribute("List_Retour_Id");

			omr_aRetours.setParam("List_Retour_Id", listRetourId);
			omr_aRetours.initTree(omr_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_initPagination() {
	try {

		document.getElementById('omr-pageDeb').value = omr_pageCourante;
		document.getElementById('omr-pageFin').value = (omr_nbPages>0?omr_nbPages:1);
		document.getElementById('omr-bPrec').disabled = (omr_pageCourante==1);
		document.getElementById('omr-bSuiv').disabled = (omr_pageCourante>=omr_nbPages); // peut se produire si omr_nbPages=0

		omr_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnPagePrec() {
	try {

		omr_pageCourante--;
		omr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnPageSuiv() {
	try {

		omr_pageCourante++;
		omr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_majPagination() {
	try {

		document.getElementById('omr-pageDeb').value = omr_pageCourante;
		document.getElementById('omr-bPrec').disabled = (omr_pageCourante==1);
		document.getElementById('omr-bSuiv').disabled = (omr_pageCourante==omr_nbPages);

		document.getElementById('omr-numRetourSelect').value = "";

		document.getElementById('omr-listeRetours').disabled = true;
		document.getElementById('omr-bEditionCsv').disabled = true;
		document.getElementById('omr-bEditionDetailCsv').disabled = true;
		document.getElementById('omr-bEditionPDF').disabled = true;
		document.getElementById('omr-bValiderRetour').disabled = true;
		document.getElementById('omr-bReceptionRetour').disabled = true;
		omr_aApercuRetour.deleteTree();

		omr_qListRC.setParam("Current_Page", omr_pageCourante);
		var result = omr_qListRC.execute();
		var listRetourId = result.responseXML.documentElement.getAttribute("List_Retour_Id");

		omr_aRetours.setParam("List_Retour_Id", listRetourId);
		omr_aRetours.initTree(omr_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_afterMajPagination() {
	try {

		document.getElementById('omr-listeRetours').disabled = false;
		document.getElementById('omr-bEditionCsv').disabled = (omr_aRetours.nbLignes()==0);
		document.getElementById('omr-bEditionDetailCsv').disabled = (omr_aRetours.nbLignes()==0);
		document.getElementById('omr-numRetour').focus();
		omr_retourId = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_selectOnListeRetours() {
	try {

		if (omr_aRetours.isSelected()) {
			omr_retourId = omr_aRetours.getSelectedCellText("omr-colRetourId");
			document.getElementById('omr-numRetourSelect').value = omr_aRetours.getSelectedCellText("omr-colNumRetour");
			omr_aApercuRetour.setParam("Retour_Id", omr_retourId);
			omr_aApercuRetour.initTree();

			var etat = omr_aRetours.getSelectedCellText("omr-colEtat");
			document.getElementById('omr-bEditionPDF').disabled = (etat=="N");
			document.getElementById('omr-bValiderRetour').disabled = (etat!="N");
			document.getElementById('omr-bReceptionRetour').disabled = (etat!="E");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omr_listerRetours();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnListeRetours(ev) {
	try {

		if (ev.keyCode==13) {
			omr_ouvrirRetour();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_ouvrirRetour() {
  try {

  	if (omr_aRetours.isSelected() && gProfil.isMenuGC_VAffaires()) {
			var retourId = omr_aRetours.getSelectedCellText('omr-colRetourId');
			window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Retour_Id="+ retourId +"&Origine=MenuRetours";
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnEditionPDF() {
  try {

		document.getElementById("bMenuRetours").collapsed = false;
		document.getElementById("omr-deckMenuRetours").selectedIndex = 1;

		var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qLangueDefaut.setParam("Type_Doc", "RC");
		qLangueDefaut.setParam("Doc_Id", omr_retourId);
		var result = qLangueDefaut.execute();
		omr_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

		var aLangues = new Arbre("ComboListe/combo-langues.tmpl", "omr-langueDefaut");
		aLangues.setParam("Selection", omr_langueDefaut);
		aLangues.initTree(omr_initLangue);

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_initLangue() {
	try {

		document.getElementById('omr-langueDefaut').value = omr_langueDefaut;
		omr_editerRetourPDF();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_editerRetourPDF() {
  try {

		var langue = document.getElementById('omr-langueDefaut').value;

		var qGenPdf = new QueryHttp("Facturation/Affaires/pdfRetourClient.tmpl");
		qGenPdf.setParam('Bon_Id', omr_retourId);
	  qGenPdf.setParam('Langue', langue);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');

		document.getElementById('omr-pdfRetour').setAttribute("src", page);

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnNouveauRetour() {
	try {

		var url = "chrome://opensi/content/facturation/user/traitement_retours/popup-nouveauRetour.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omr_retourNouveauRetour);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_retourNouveauRetour(retourId) {
	try {

		window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Retour_Id="+ retourId +"&Origine=MenuRetours";

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_pressOnValiderRetour() {
  try {

		if (omr_aRetours.isSelected()) {
			if (window.confirm("Confirmez-vous la validation du retour s\u00E9lectionn\u00E9 ?\n(Attention le retour valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {

				if (isEmpty(omr_aRetours.getSelectedCellText('omr-colType'))) {
					var url = "chrome://opensi/content/facturation/user/traitement_retours/popup-choixTypeRetour.xul";
					window.openDialog(url,'','chrome,modal,centerscreen', omr_retourId);
				}

				var qValider = new QueryHttp("Facturation/Affaires/validRetourClient.tmpl");
				qValider.setParam('Retour_Id', omr_retourId);
				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				omr_listerRetours();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnReceptionRetour() {
  try {

		if (omr_aRetours.isSelected()) {
			if (window.confirm("Confirmez-vous la r\u00E9ception du retour s\u00E9lectionn\u00E9 ?")) {
				var qValiderReception = new QueryHttp("Facturation/Affaires/receiveRetourClient.tmpl");
				qValiderReception.setParam('Retour_Id', omr_retourId);
				var result = qValiderReception.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else if (gProfil.isMenuGC_VAffaires()) {
					var typeRetour = omr_aRetours.getSelectedCellText('omr-colType');

					if (typeRetour=="R") {
						var qCheck = new QueryHttp("Facturation/Affaires/checkAvoirRetourPossible.tmpl");
						qCheck.setParam('Retour_Id', omr_retourId);

						result = qCheck.execute();

						var possible = result.responseXML.documentElement.getAttribute("Possible")=="true";

						if (possible && window.confirm("Voulez-vous cr\u00E9er un avoir pour ce retour ?")) {

							var qTrans = new QueryHttp("Facturation/Affaires/transformRetourAvoir.tmpl");
							qTrans.setParam('Retour_Id', omr_retourId);

							result = qTrans.execute();

							var errors = new Errors(result);
							if (errors.hasNext()) {
								errors.show();
							}
							else {
								var avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
								var affaireId = omr_aRetours.getSelectedCellText('omr-colAffaireId');
								window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Avoir_Id="+ avoirId +"&Avoir_Affaire_Id="+ affaireId;
							}
						}
					}
				}

				omr_listerRetours();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omr_pressOnEditionCsv(detail) {
	try {

		var numRetour = document.getElementById('omr-numRetour').value;
		var numClient = document.getElementById('omr-numClient').value;
		var denomination = document.getElementById('omr-denomination').value;
		var etablissement = document.getElementById('omr-etablissement').value;
		var depot = document.getElementById('omr-depot').value;
		var dateDebut = document.getElementById('omr-dateDebut').value;
		var dateFin = document.getElementById('omr-dateFin').value;
		var refArticle = document.getElementById('omr-refArticle').value;
		var etat = document.getElementById('omr-etatRetour').value;
		var typeRetour = document.getElementById('omr-typeRetour').value;
		var provenance = document.getElementById('omr-provenance').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Retours_Clients/"+ (detail?"csvDetailRetourClient.tmpl":"csvRetourClient.tmpl"));
			qEditionCsv.setParam("Num_Retour", numRetour);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Depot", depot);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Type_Retour", typeRetour);
			qEditionCsv.setParam("Provenance", provenance);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omr_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_retourRechercherClient(numClient) {
	try {

  	document.getElementById('omr-numClient').value = numClient;
  	omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_envoyer() {
	try {

		var langue = document.getElementById('omr-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "RC", omr_retourId, langue);

	}	catch (e) {
    recup_erreur(e);
  }
}


function omr_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omr_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omr_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omr-refArticle').value = reference;
  	omr_listerRetours();

	} catch (e) {
		recup_erreur(e);
	}
}
