/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var gEtablissementDefaut;
var gDepotDefaut;
var gProfil;
var gConfig;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gProfil = getProfil();
		gConfig = getConfig();

		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();

		if (!actUnites) {
			document.getElementById('oet-colSymboleUnite').collapsed = true;
			document.getElementById('oet-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oet-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oet-colNbPieces').collapsed = true;
			document.getElementById('oet-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oet-fieldNbPieces').collapsed = true;
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				var intituleGroupe = contenu.getAttribute("Intitule_"+ i);
				document.getElementById("oet-colAttribut"+ i).setAttribute("label", intituleGroupe);
			}
			else {
				document.getElementById("oet-colAttribut"+ i).collapsed = true;
				document.getElementById("oet-colAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		gEtablissementDefaut = gProfil.getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", gEtablissementDefaut);
		result = qDepotDefaut.execute();
		gDepotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

  	document.getElementById('deck').selectedIndex = 0;
  	omt_init();
		oet_init();

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oet_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuTransferts() {
	try {

		document.getElementById('oet-pdfTransfert').setAttribute("src", "");
		document.getElementById('omt-deckMenu').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuTransferts').collapsed = true;
		document.getElementById('bRetourTransfert').collapsed = true;

		document.activeElement.blur();
		omt_listerTransferts();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourTransfert() {
  try {

		document.getElementById('oet-pdfTransfert').setAttribute("src", "");
		oet_chargerTransfert();
		document.getElementById('oet-deckTransfert').selectedIndex = 0;
		document.getElementById('bRetourTransfert').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		switch (currentDeck) {
			case 1: oet_demandeEnregistrement(); break;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
