/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oet_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oet-etablissement');
var oet_aDepotsStock = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oet-depotStock');
var oet_aLignes = new Arbre('Facturation/Transferts_Emplacements/list-ligneTransfertEmplacement.tmpl', 'oet-tLignesTransfert');
var oet_aVersion = new Arbre("Facturation/Transferts_Emplacements/list-versionTransfertEmplacement.tmpl","oet-listeVersion");

var oet_transfertId;
var oet_ligneId = null;
var oet_articleId = null;
var oet_mode;
var oet_etatTransfert;
var oet_flashRunning;
var oet_modified = false;
var oet_curEtablissement;
var oet_curDepotStock;
var oet_uniteDefaut;
var oet_currentIndex;
var oet_toSelectLigne = null;
var oet_insertionLigneId;



function oet_init() {
  try {

		oet_uniteDefaut = gConfig.getUniteDefaut();

		var aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl", "oet-unite");
		aUnites.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oet_chargerDepotStock(selection) {
	try {

		oet_curDepotStock = selection;
		oet_aDepotsStock.setParam("Selection", selection);
		oet_aDepotsStock.initTree(oet_initDepotStock);

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_initDepotStock() {
	try {

		document.getElementById('oet-depotStock').value = oet_curDepotStock;

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_chargerEtablissement(selection) {
	try {

		oet_curEtablissement = selection;
		oet_aEtablissements.setParam("Selection", selection);
		oet_aEtablissements.initTree(oet_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_initEtablissement() {
	try {

		document.getElementById('oet-etablissement').value = oet_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_initIHM() {
	try {

		document.getElementById('oet-bEnregistrerTE').collapsed = oet_mode=="V";
		document.getElementById('oet-bSupprimerTE').collapsed = oet_mode!="M" || oet_etatTransfert!="N";
		document.getElementById('oet-bAnnulerTE').collapsed = oet_mode!="M" || oet_etatTransfert!="T" || oet_flashRunning;
		document.getElementById('oet-bVisualiserTE').collapsed = oet_mode=="C" || oet_etatTransfert=="N";
		document.getElementById('oet-bValiderTE').collapsed = oet_mode!="M" || oet_etatTransfert!="N";
		document.getElementById('oet-bConfirmerTE').collapsed = oet_mode!="M" || oet_etatTransfert!="T" || oet_flashRunning;
		document.getElementById('oet-bChoisirMentions').disabled = oet_mode!="M";
		document.getElementById('oet-bOuvrirCommentairesCaches').disabled = oet_mode=="C";
		document.getElementById('oet-bImporterLignes').disabled = oet_mode!="M" || oet_etatTransfert=="T";
		document.getElementById('oet-bGenReassort').collapsed = oet_mode!="M" || oet_etatTransfert!="N";
		document.getElementById('oet-bMultiSuppression').disabled = true;

		document.getElementById('oet-ligneTransfert').collapsed = oet_mode!="M";
		oet_annulerLigne();

		document.getElementById('oet-etablissement').disabled = oet_mode=="V";
		document.getElementById('oet-depotStock').disabled = oet_mode!="C";
		document.getElementById('oet-commentairesFin').disabled = oet_mode=="V";
		document.getElementById('oet-commentairesInt').disabled = oet_mode=="V";

		document.getElementById('oet-tLignesTransfert').disabled = false;
		document.getElementById('oet-tabEntete').selectedIndex = 0;

		if (oet_mode=="C" || oet_etatTransfert=="N") {
			document.getElementById('oet-colQteManquante').collapsed = true;
			document.getElementById('oet-colQteManquante').setAttribute("ignoreincolumnpicker", true);
		}
		else {
			document.getElementById('oet-colQteManquante').collapsed = false;
			document.getElementById('oet-colQteManquante').removeAttribute("ignoreincolumnpicker");
		}

		oet_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_nouveauTransfert() {
  try {

		document.getElementById('oet-deckTransfert').selectedIndex = 0;
		document.getElementById('oet-tLignesTransfert').disabled = true;

		oet_transfertId = "";
		oet_mode = "C";
		oet_etatTransfert = "N";
		oet_flashRunning = false;
  	oet_chargerDepotStock(gDepotDefaut);
		oet_chargerEtablissement(gEtablissementDefaut);
		oet_aLignes.deleteTree();
		oet_aVersion.deleteTree();
		document.getElementById('oet-tabVersionDocument').collapsed = true;

		document.getElementById('oet-numTransfert').value = "";
		document.getElementById('oet-dateTransfert').value = "";
		document.getElementById('oet-etat').value = "Nouveau";
		document.getElementById('oet-commentairesFin').value = "";
		document.getElementById('oet-commentairesInt').value = "";

		document.getElementById('oet-creation').setAttribute("label", "");
		document.getElementById('oet-modification').setAttribute("label", "");
		document.getElementById('oet-document').setAttribute("label", "");

		oet_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oet_chargerTransfert() {
  try {

		document.getElementById('oet-deckTransfert').selectedIndex = 0;
		document.getElementById('oet-tLignesTransfert').disabled = true;
		document.getElementById('oet-tabVersionDocument').collapsed = false;

		var qLoad = new QueryHttp('Facturation/Transferts_Emplacements/loadTransfertEmplacement.tmpl');
		qLoad.setParam("Transfert_Id", oet_transfertId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oet_etatTransfert = contenu.getAttribute("Etat");
		oet_flashRunning = contenu.getAttribute("Flash_Running")=="true";
		oet_mode = (oet_etatTransfert=="N" || oet_etatTransfert=="T"?"M":"V");

		oet_chargerDepotStock(contenu.getAttribute('Depot_Id'));
		oet_chargerEtablissement(contenu.getAttribute('Etab_Id'));

		document.getElementById('oet-numTransfert').value = contenu.getAttribute("Num_Transfert");
		document.getElementById('oet-dateTransfert').value = contenu.getAttribute("Date_Transfert");
		document.getElementById('oet-etat').value = contenu.getAttribute("Libelle_Etat") + (oet_flashRunning && oet_etatTransfert=="T"?" (Flash)":"");
		document.getElementById('oet-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oet-commentairesInt').value = contenu.getAttribute("Commentaires_Int");

		document.getElementById('oet-creation').setAttribute("label", "Transfert cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oet-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oet-document').setAttribute("label", "Transfert N\u00B0 "+ contenu.getAttribute('Num_Transfert'));

		oet_aLignes.setParam('Transfert_Id', oet_transfertId);
		oet_aLignes.initTree();

		oet_aVersion.setParam("Transfert_Id", oet_transfertId);
		oet_aVersion.initTree();

		oet_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oet_enregistrerTransfert(rafraichir) {
  try {

  	var ok = false;

		var qSave;

		if (oet_mode=="C") {
			qSave = new QueryHttp("Facturation/Transferts_Emplacements/createTransfertEmplacement.tmpl");
		}
		else {
			qSave = new QueryHttp("Facturation/Transferts_Emplacements/updateTransfertEmplacement.tmpl");
			qSave.setParam("Transfert_Id", oet_transfertId);
		}

		var etablissement = document.getElementById('oet-etablissement').value;
		var depotStock = document.getElementById('oet-depotStock').value;
		var commentairesFin = document.getElementById('oet-commentairesFin').value;
		var commentairesInt = document.getElementById('oet-commentairesInt').value;

		if (isEmpty(depotStock)) { showWarning("Veuillez indiquer un d\u00E9p\u00F4t de stock"); }
		else {

			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Depot_Id", depotStock);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oet_mode=="C") {
					oet_transfertId = result.responseXML.documentElement.getAttribute("Transfert_Id");
					if (rafraichir) {
						oet_chargerTransfert();
					}
				}

				oet_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oet_supprimerTransfert() {
  try {

		if (window.confirm("Confirmez-vous la suppression du transfert ?")) {

			var qDelete = new QueryHttp("Facturation/Transferts_Emplacements/deleteTransfertEmplacement.tmpl");
			qDelete.setParam("Transfert_Id", oet_transfertId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le transfert a \u00E9t\u00E9 supprim\u00E9.");
				retourMenuTransferts();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oet_annulerLigne() {
	try {

		oet_aLignes.clearSelection();
		oet_ligneId = null;

		oet_initLigneIHM();

		document.getElementById('oet-reference').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_pressOnWindow(ev) {
	try {

		if (ev.altKey && oet_mode!="V" && oet_etatTransfert!='T') {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
					oet_rechercherArticle();
        	break;
    	}
		}
		else if (ev.ctrlKey && oet_mode!="V" && ev.keyCode==46) {
			// ctrl + suppr
			ev.preventDefault();
			oet_supprimerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_initLigneIHM() {
	try {

		document.getElementById('oet-bMoveUp').disabled = true;
		document.getElementById('oet-bMoveDown').disabled = true;
		document.getElementById('oet-bMoveFirst').disabled = true;
		document.getElementById('oet-bMoveLast').disabled = true;

		oet_insertionLigneId = 0;
		document.getElementById('oet-bInsererLigne').disabled = true;
		document.getElementById('oet-actInsert').collapsed = true;
		oet_aLignes.setCellSrc(oet_currentIndex, 'oet-colReference', "");

		oet_articleId = null;
		document.getElementById('oet-reference').value = "";
		document.getElementById('oet-designation').value = "";
		document.getElementById('oet-nbPieces').value = "";
		document.getElementById('oet-quantite').value = "1";
		document.getElementById('oet-qteManquante').value = "";
		document.getElementById('oet-unite').value = oet_uniteDefaut;
		document.getElementById('oet-codeEmplacementFrom').value = "";
		document.getElementById('oet-codeEmplacementTo').value = "";
		document.getElementById('oet-bArticle').disabled = false;
		document.getElementById('oet-bCommentaire').disabled = true;
		document.getElementById('oet-bSupprimer').disabled = true;
		document.getElementById('oet-reference').removeAttribute("readonly");

		var modeManquant = oet_etatTransfert=="T";

		document.getElementById('oet-reference').disabled = modeManquant;
		document.getElementById('oet-designation').disabled = modeManquant;
		document.getElementById('oet-nbPieces').disabled = modeManquant;
		document.getElementById('oet-quantite').disabled = modeManquant;
		document.getElementById('oet-unite').disabled = modeManquant;
		document.getElementById('oet-codeEmplacementFrom').disabled = modeManquant;
		document.getElementById('oet-codeEmplacementTo').disabled = modeManquant;
		document.getElementById('oet-bAnnuler').collapsed = modeManquant;
		document.getElementById('oet-bValider').collapsed = modeManquant;
		document.getElementById('oet-bSupprimer').collapsed = modeManquant;
		document.getElementById('oet-bRechercherEmplacementFrom').collapsed = modeManquant;
		document.getElementById('oet-bRechercherEmplacementTo').collapsed = modeManquant;
		document.getElementById('oet-bArticle').collapsed = modeManquant;

		document.getElementById('oet-fieldQteManquante').collapsed = !modeManquant;
		document.getElementById('oet-qteManquante').disabled = true;
		document.getElementById('oet-bManquant').collapsed = !modeManquant;
		document.getElementById('oet-bManquant').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_ouvrirCommentaire() {
  try {

		if (oet_aLignes.isSelected() && oet_mode=="M") {
			if (oet_aLignes.getSelectedCellText('oet-colTypeLigne')=="C") {
				oet_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oet_editerCommentaire() {
  try {

		if (oet_ligneId!=null) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "TE", oet_ligneId);

			oet_annulerLigne();
			oet_aLignes.initTree(oet_afterRefreshLignes);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_deplacerLigne(moveType) {
	try {

		if (oet_ligneId!=null && oet_mode=="M" && oet_aLignes.getSelectedCellText('oet-colTypeLigne')!="C") {

			document.getElementById('oet-bMoveUp').disabled = true;
			document.getElementById('oet-bMoveDown').disabled = true;
			document.getElementById('oet-bMoveFirst').disabled = true;
			document.getElementById('oet-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Transferts_Emplacements/moveLigneTransfertEmplacement.tmpl");
			qMove.setParam("Ligne_Id", oet_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oet_toSelectLigne = oet_ligneId;
				oet_annulerLigne();
				oet_aLignes.initTree(oet_afterRefreshLignes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_afterRefreshLignes() {
	try {

		if (oet_toSelectLigne!=null) {
			for (var i=0; i<oet_aLignes.nbLignes(); i++) {
				if (oet_aLignes.getCellText(i, "oet-colLigneId")==oet_toSelectLigne && oet_aLignes.getCellText(i, "oet-colTypeLigne")!="C") {
					oet_aLignes.select(i);
					break;
				}
			}
			oet_toSelectLigne = null;
		}
		oet_aLignes.ensureRowIsVisible(oet_currentIndex);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oet_pressOnQuantite(ev) {
	try {

		if (ev.keyCode==13) {
			oet_validerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_validerLigne() {
	try {

		var nbPieces = document.getElementById('oet-nbPieces').value;
		var quantite = document.getElementById('oet-quantite').value;
		var unite = document.getElementById('oet-unite').value;
		var codeEmplacementFrom = document.getElementById('oet-codeEmplacementFrom').value;
		var codeEmplacementTo = document.getElementById('oet-codeEmplacementTo').value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		if (oet_articleId==null) { showWarning("Article incorrect"); }
		else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
		else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect"); }
		else if (isEmpty(codeEmplacementFrom)) { showWarning("Emplacement de d\u00E9part incorrect"); }
		else if (isEmpty(codeEmplacementTo)) { showWarning("Emplacement d'arriv\u00E9e incorrect"); }
		else if (codeEmplacementFrom==codeEmplacementTo) { showWarning("Les emplacements de d\u00E9part et d'arriv\u00E9e ne peuvent pas \u00EAtre identiques"); }
		else {

			var emplacementFrom = oet_getEmplacementId(codeEmplacementFrom);
			var emplacementTo = oet_getEmplacementId(codeEmplacementTo);

			if (isEmpty(emplacementFrom)) {
				showWarning("Emplacement de d\u00E9part inexistant");
			}
			else if (isEmpty(emplacementTo)) {
				showWarning("Emplacement d'arriv\u00E9e inexistant");
			}
			else {
				var saved = true;
				if (oet_mode=="C") {
					saved = oet_enregistrerTransfert(true);
				}

				if (saved) {
					var qValider;

					if (oet_ligneId!=null) {
						qValider = new QueryHttp("Facturation/Transferts_Emplacements/updateLigneTransfertEmplacement.tmpl");
						qValider.setParam("Ligne_Id", oet_ligneId);
					}
					else {
						qValider = new QueryHttp("Facturation/Transferts_Emplacements/createLigneTransfertEmplacement.tmpl");
						qValider.setParam("Transfert_Id", oet_transfertId);
						qValider.setParam("Article_Id", oet_articleId);
					}

					qValider.setParam("Nb_Pieces", nbPieces);
					qValider.setParam("Quantite", quantite);
					qValider.setParam("Unite_Id", unite);
					qValider.setParam("Emplacement_From", emplacementFrom);
					qValider.setParam("Emplacement_To", emplacementTo);
					qValider.setParam("Insertion_Ligne_Id", oet_insertionLigneId);

					var result = qValider.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
					else {
						oet_annulerLigne();
						oet_aLignes.initTree(oet_afterRefreshLignes);
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_supprimerLigne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oet_aLignes.nbSelection()==1) {
			listLigneId = oet_ligneId;
			maxIndex = oet_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oet_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oet_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oet_aLignes.getCellText(v,'oet-colTypeLigne')!="C") {
			  		listLigneId += oet_aLignes.getCellText(v,'oet-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Transferts_Emplacements/deleteLigneTransfertEmplacement.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oet_currentIndex = maxIndex-1;
				oet_annulerLigne();
				oet_aLignes.initTree(oet_afterRefreshLignes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_insererLigne() {
  try {

		if (oet_aLignes.isSelected() && oet_mode=="M") {
			var idx = oet_aLignes.getCurrentIndex();
			oet_currentIndex = idx;
			var ligneId = oet_aLignes.getCellText(idx,'oet-colLigneId');
			oet_annulerLigne();

			oet_aLignes.setCellSrc(idx, 'oet-colReference', "chrome://opensi/content/design/insertbefore.png");

			oet_insertionLigneId = ligneId;

			document.getElementById('oet-actInsert').collapsed = false;
			document.getElementById('oet-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oet_pressOnLigneTransfert(ev) {
	try {

		if (ev.keyCode==45 && ev.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oet_insererLigne();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_selectOnLignesTransfert() {
	try {

		if (oet_mode!="V" && oet_aLignes.isSelected()) {

			if (oet_aLignes.nbSelection()==1) {
				oet_currentIndex = oet_aLignes.getCurrentIndex();
				oet_ligneId = oet_aLignes.getSelectedCellText('oet-colLigneId');
				document.getElementById('oet-bMultiSuppression').disabled = true;

				if (oet_aLignes.getSelectedCellText('oet-colTypeLigne')=="C") {
					oet_initLigneIHM();
				}
				else {
					oet_articleId = oet_aLignes.getSelectedCellText('oet-colArticleId');
					document.getElementById('oet-reference').value = oet_aLignes.getSelectedCellText('oet-colReference');
					document.getElementById('oet-designation').value = oet_aLignes.getSelectedCellText('oet-colDesignation');
					document.getElementById('oet-nbPieces').value = oet_aLignes.getSelectedCellText('oet-colNbPieces');
					document.getElementById('oet-quantite').value = oet_aLignes.getSelectedCellText('oet-colQuantite');
					document.getElementById('oet-unite').value = oet_aLignes.getSelectedCellText('oet-colUniteId');
					document.getElementById('oet-codeEmplacementFrom').value = oet_aLignes.getSelectedCellText('oet-colCodeEmplacementFrom');
					document.getElementById('oet-codeEmplacementTo').value = oet_aLignes.getSelectedCellText('oet-colCodeEmplacementTo');
					document.getElementById('oet-bSupprimer').disabled = false;
					document.getElementById('oet-bCommentaire').disabled = false;

					if (oet_etatTransfert=="T") {
						document.getElementById('oet-qteManquante').value = oet_aLignes.getSelectedCellText('oet-colQteManquante');
						document.getElementById('oet-qteManquante').disabled = oet_flashRunning;
						document.getElementById('oet-bManquant').disabled = oet_flashRunning;
					}
					else {
						if (oet_aLignes.getSelectedCellText('oet-colTypeLigne')=="S") {
							document.getElementById('oet-reference').setAttribute("readonly", true);
						}

						oet_aLignes.setCellSrc(oet_currentIndex, 'oet-colReference', "");

						document.getElementById('oet-bInsererLigne').disabled = false;
						oet_insertionLigneId = 0;
						document.getElementById('oet-actInsert').collapsed = true;

						var firstIndex = 0;
						var lastIndex = oet_aLignes.nbLignes()-1;

						if (oet_aLignes.getCellText(firstIndex,'oet-colTypeLigne')=="C") { firstIndex++; }
						if (oet_aLignes.getCellText(lastIndex,'oet-colTypeLigne')=="C") { lastIndex--; }

						document.getElementById('oet-bMoveUp').disabled = (oet_currentIndex==firstIndex);
						document.getElementById('oet-bMoveDown').disabled = (oet_currentIndex==lastIndex);
						document.getElementById('oet-bMoveFirst').disabled = (oet_currentIndex==firstIndex);
						document.getElementById('oet-bMoveLast').disabled = (oet_currentIndex==lastIndex);
					}
				}
			}
			else {
				oet_initLigneIHM();
				document.getElementById('oet-bMultiSuppression').disabled = oet_etatTransfert=="T";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_demandeEnregistrement() {
  try {

		if (oet_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au transfert ?")) {
				oet_enregistrerTransfert(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oet_setModified(m) {
  try {

  	oet_modified = m;
		if (m) {
			document.getElementById('oet-tabTransfert').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oet-bValiderTE').disabled = true;
		}
		else {
			document.getElementById('oet-tabTransfert').setAttribute('image', null);
			document.getElementById('oet-bValiderTE').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oet_editerTransfert() {
	try {

		document.getElementById('oet-pdfTransfert').setAttribute("src", "");
		document.getElementById("bRetourTransfert").collapsed = false;
		document.getElementById("oet-deckTransfert").selectedIndex = 1;

		var qGenPdf = new QueryHttp("Facturation/Transferts_Emplacements/pdfTransfertEmplacement.tmpl");
		qGenPdf.setParam("Transfert_Id", oet_transfertId);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oet-pdfTransfert').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_validerTransfert() {
  try {

		if (oet_aLignes.nbLignes()==0) {
			showWarning("Le transfert ne contient aucune ligne.");
		}
  	else if (window.confirm("Confirmez-vous la validation du transfert ?")) {

			var qValid = new QueryHttp("Facturation/Transferts_Emplacements/validTransfertEmplacement.tmpl");
			qValid.setParam("Transfert_Id", oet_transfertId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oet_chargerTransfert();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_confirmerTransfert() {
  try {

		if (window.confirm("Confirmez-vous le transfert ?")) {

			var qValid = new QueryHttp("Facturation/Transferts_Emplacements/confirmTransfertEmplacement.tmpl");
			qValid.setParam("Transfert_Id", oet_transfertId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oet_chargerTransfert();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_annulerTransfert() {
	try {

		if (window.confirm("Confirmez-vous l'annulation du transfert ?")) {
			var qAnnuler = new QueryHttp("Facturation/Transferts_Emplacements/cancelTransfertEmplacement.tmpl");
			qAnnuler.setParam("Transfert_Id", oet_transfertId);
			var result = qAnnuler.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le transfert a \u00E9t\u00E9 annul\u00E9.");
				oet_chargerTransfert();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_initLigneArticle(reference, articleId) {
	try {

		oet_ligneId = null;
		oet_articleId = articleId;
		document.getElementById('oet-reference').value = reference;
		document.getElementById('oet-quantite').value = 1;
		document.getElementById('oet-quantite').focus();

		var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
		qDesignation.setParam("Article_Id", articleId);
		var result = qDesignation.execute();
		document.getElementById('oet-designation').value = result.responseXML.documentElement.getAttribute("Designation");

		document.getElementById('oet-reference').setAttribute("readonly", true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", oet_curDepotStock);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_rechercherArticle(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oet_initLigneArticle, null, reference, null, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oet_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_rechercherReference() {
	try {

		var reference = document.getElementById('oet-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "A");
		qSearch.setParam("No_Forfait", true);
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");

		if (!isEmpty(articleId)) {
			var findReference = result.responseXML.documentElement.getAttribute("Reference");
			oet_initLigneArticle(findReference, articleId);
		}
		else {
			oet_rechercherArticle(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_rechercherEmplacementFrom() {
	try {

		var reference = document.getElementById('oet-reference').value;

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oet_retourRechercherEmplacementFrom, oet_curDepotStock, reference);

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_retourRechercherEmplacementFrom(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oet-codeEmplacementFrom').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_rechercherEmplacementTo() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oet_retourRechercherEmplacementTo, oet_curDepotStock);

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_retourRechercherEmplacementTo(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oet-codeEmplacementTo').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_choisirMentions() {
  try {

  	var ok = true;

  	if (oet_mode=="C") {
			ok = oet_enregistrerTransfert(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "TE", oet_transfertId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oet_editerCommentairesInternes() {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "TE", oet_transfertId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oet_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oet-commentairesFin').value;
		var commentairesInt = document.getElementById('oet-commentairesInt').value;
		var readOnly = (oet_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oet_retourEditerCommentaires, "TE", oet_transfertId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oet-commentairesFin').value = commentairesFin;
		document.getElementById('oet-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_envoyer() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "TE", oet_transfertId, "");

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_importLignes() {
  try {

	  var url = "chrome://opensi/content/facturation/user/transemp/popup-importerLignes.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oet_retourImportLignes, oet_transfertId);

  } catch (e) {
    recup_erreur(e);
  }
}


function oet_retourImportLignes() {
	try {

		oet_aLignes.initTree(oet_afterRefreshLignes);

	} catch (e) {
	  recup_erreur(e);
	}
}


function oet_pressOnQteManquante(ev) {
	try {

		if (ev.keyCode==13) {
			oet_validerQuantiteManquante();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oet_validerQuantiteManquante() {
	try {

		var qteManquante = document.getElementById('oet-qteManquante').value;
		var quantite = document.getElementById('oet-quantite').value;

		if (!isPositiveOrNull(qteManquante) || !checkDecimal(qteManquante,3)) { showWarning("Quantit\u00E9 manquante incorrecte"); }
		else if (parseFloat(qteManquante)>parseFloat(quantite)) { showWarning("La quantit\u00E9 manquante ne peut pas \u00EAtre sup\u00E9rieure \u00E0 la quantit\u00E9 \u00E0 transf\u00E9rer"); }
		else {

			var qValider = new QueryHttp("Facturation/Transferts_Emplacements/updateQteManquanteLTE.tmpl");
			qValider.setParam("Ligne_Id", oet_ligneId);
			qValider.setParam("Qte_Manquante", qteManquante);

			var result = qValider.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oet_annulerLigne();
				oet_aLignes.initTree(oet_afterRefreshLignes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oet_genReassort() {
	try {

		var qReassort = new QueryHttp("Facturation/Transferts_Emplacements/genReassortTransfertEmplacement.tmpl");
		qReassort.setParam('Transfert_Id', oet_transfertId);
		qReassort.execute();

		oet_annulerLigne();
		oet_aLignes.initTree(oet_afterRefreshLignes);

	} catch (e) {
		recup_erreur(e);
	}
}
