/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

const gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);

var oets_aArticlesBL = new Arbre('Facturation/Transferts_Stocks/list-ligneBonLivraison.tmpl', 'oets-tArticlesBL');
var oets_aArticlesTS = new Arbre('Facturation/Transferts_Stocks/liste-articlesNonExpediesTS.tmpl', 'oets-tArticlesTS');
var oets_aExpeditions = new Arbre('Facturation/Transferts_Stocks/list-bonLivraison.tmpl', 'oets-tExpeditions');
var oets_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl", "oets-modeExpedition");
var oets_aVersions = new Arbre("Facturation/Transferts_Stocks/list-versionBonLivraison.tmpl","oets-tVersions");
var oets_aLiensColis = new Arbre("Facturation/Affaires/list-colisBL.tmpl","oets-liensColis");
var oets_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oets-langueDefaut");


var oets_modified = false;

var oets_editBP;
var oets_actSuiviSerie;
var oets_actSuiviLot;
var oets_etapePrepaBL;
var oets_defautEtapePrepaBLTS;

var oets_bonId;
var oets_transfertId;
var oets_depotId;
var oets_bloquerBLSansStock;

var oets_mode;
var oets_etatBon;
var oets_statutExpedition;
var oets_etatTS;
var oets_soldeLiv;
var oets_langueDefaut;
var oets_selectModeExpedition;
var oets_envoiTrans;



function oets_init() {
	try {

		var config = getConfig();

		oets_editBP = config.isGACEditBP();
		oets_actSuiviLot = config.isActSuiviLot();
		oets_actSuiviSerie = config.isActSuiviSerie();
		oets_defautEtapePrepaBLTS = config.isEtapePrepaBLTS();
		oets_envoiTrans = config.isGTSEnvoiTransFTP();
		var actNbPieces = config.isActNbPieces();
		oets_bloquerBLSansStock = config.isBloquerBLSansStock();

		document.getElementById("oets-colVolumeColis").setAttribute("label", "Volume ("+ config.getSymboleUniteVolume() +")");

		document.getElementById('oets-bConsultSerieLigne').collapsed = !oets_actSuiviSerie;
		document.getElementById('oets-boxSaisieSerie').collapsed = !oets_actSuiviSerie;

		if (!oets_actSuiviLot) {
			document.getElementById('oets-colNumLotBL').collapsed = true;
			document.getElementById('oets-colNumLotBL').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oets-colDatePeremptionBL').collapsed = true;
			document.getElementById('oets-colDatePeremptionBL').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oets-rowNumLot').collapsed = true;
			document.getElementById('oets-rowDLC').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oets-colNbPiecesTS').collapsed = true;
			document.getElementById('oets-colNbPiecesTS').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oets-colNbPiecesBL').collapsed = true;
			document.getElementById('oets-colNbPiecesBL').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oets-rowNbPieces').collapsed = true;
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function oets_initModeExpedition() {
	try {

		document.getElementById('oets-modeExpedition').value = oets_selectModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_chargerModesExpedition(selection) {
	try {

		oets_selectModeExpedition = selection;
		oets_aModesExpedition.setParam("Selection", selection);
		oets_aModesExpedition.initTree(oets_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_start() {
	try {

		var qGet = new QueryHttp('Facturation/Transferts_Stocks/getFirstBLNonValide.tmpl');
		qGet.setParam("Transfert_Id", oets_transfertId);
		var result = qGet.execute();

		if (result.responseXML.documentElement.getAttribute("HasBLNonValide")=="true") {
			oets_bonId = result.responseXML.documentElement.getAttribute("Bon_Id");
			oets_chargerBon();
		}
		else {
			oets_nouveauBon();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_reinitialiser() {
	try {

		oets_mode = "C";
		oets_etatBon = "N";
		oets_statutExpedition = "N";
		oets_modified = false;

		document.getElementById('oets-deckBonLivraison').selectedIndex = 0;
		document.getElementById('oets-tbExpedition').selectedIndex = 0;
		document.getElementById('oets-tabBon').setAttribute('image', null);
		document.getElementById('oets-numeroBL').value = "";
		document.getElementById('oets-numeroBP').value = "";
		document.getElementById('oets-tabVersions').collapsed = true;
		document.getElementById('oets-tabColis').collapsed = true;

		oets_aVersions.deleteTree();
		oets_aLiensColis.deleteTree();
		oets_aExpeditions.setParam("Transfert_Id", oets_transfertId);
		oets_aExpeditions.initTree();

		document.getElementById('oets-numSerie').value = "";
		document.getElementById('oets-dateBL').value = "";
		document.getElementById('oets-dateBP').value = "";
		document.getElementById('oets-etat').value = "";
		document.getElementById('oets-commentairesFin').value = "";
		document.getElementById('oets-commentairesInt').value = "";
		document.getElementById('oets-numLot').value = "";
		document.getElementById('oets-datePeremption').value = "";
		document.getElementById('oets-nbPieces').value = "";
		document.getElementById('oets-quantite').value = "";
		document.getElementById('oets-creation').value = "";
		document.getElementById('oets-modification').value = "";
		document.getElementById('oets-document').value = "";
		document.getElementById('oets-consignesLiv').value = "";
		document.getElementById('oets-envoiTrans').checked = false;
		document.getElementById('oets-infoExpeLot').value = "";
		document.getElementById('oets-infoPrepaExpe').value = "";
		document.getElementById('oets-infoEnvoiTrans').value = "";
		document.getElementById('oets-infoExpeLot').collapsed = true;
		document.getElementById('oets-infoPrepaExpe').collapsed = true;
		document.getElementById('oets-infoEnvoiTrans').collapsed = true;

		document.getElementById('oets-bChoisirMentions').disabled = true;
		document.getElementById('oets-bAjouter').disabled = true;
		document.getElementById('oets-bToutAjouter').disabled = true;
		document.getElementById('oets-bToutAjouterDispo').disabled = true;
		document.getElementById('oets-bEnlever').disabled = true;
		document.getElementById('oets-bToutEnlever').disabled = true;
		document.getElementById('oets-bEnregistrer').disabled = true;
		document.getElementById('oets-bGenerateBP').disabled = true;
		document.getElementById('oets-bAnnuler').disabled = true;
		document.getElementById('oets-bGenerateBL').collapsed = true;
		document.getElementById('oets-bConfirmer').collapsed = true;
		document.getElementById('oets-bSupprimer').disabled = true;
		document.getElementById('oets-bEditionBL').disabled = true;
		document.getElementById('oets-bEditionBP').disabled = true;
		document.getElementById('oets-envoiTrans').disabled = true;
		document.getElementById('oets-bAnnulerColis').disabled = true;
		document.getElementById('oets-bCsvColisage').disabled = true;
		document.getElementById('oets-bPdfColisage').disabled = true;

		document.getElementById('oets-modeExpedition').disabled = true;
		document.getElementById('oets-consignesLiv').disabled = true;
		document.getElementById('oets-commentairesFin').disabled = true;
		document.getElementById('oets-commentairesInt').disabled = true;
		document.getElementById('oets-numLot').disabled = true;
		document.getElementById('oets-datePeremption').disabled = true;
		document.getElementById('oets-nbPieces').disabled = true;
		document.getElementById('oets-quantite').disabled = true;
		document.getElementById('oets-bConsultSerieLigne').disabled = true;
		document.getElementById('oets-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('oets-bEditionBL').collapsed = true;
		document.getElementById('oets-bEditionBP').collapsed = true;
		document.getElementById('oets-boxSaisieSerie').collapsed = (!oets_actSuiviSerie || oets_etatBon!="N");
		document.getElementById('oets-chkEditBP').checked = !oets_etapePrepaBL && oets_editBP;
		document.getElementById('oets-envoiTrans').collapsed = true;

		if (oets_etatBon=="N") {
			document.getElementById('oets-numSerie').focus();
		}

		oets_aArticlesBL.deleteTree();
		oets_aArticlesTS.deleteTree();

		// chargement des infos du transfert

		var qLoad = new QueryHttp('Facturation/Transferts_Stocks/loadTransfertStock.tmpl');
		qLoad.setParam('Transfert_Id', oets_transfertId);
		var result = qLoad.execute();
		oets_depotId = result.responseXML.documentElement.getAttribute('Depot_Depart');
		oets_etatTS = result.responseXML.documentElement.getAttribute('Etat');
		oets_soldeLiv = (result.responseXML.documentElement.getAttribute('Solde_Liv')=="true");
		document.getElementById('oets-numTransfert').value = result.responseXML.documentElement.getAttribute('Numero');
		document.getElementById('oets-commentairesFin').value = result.responseXML.documentElement.getAttribute('Commentaires_Fin');
		document.getElementById('oets-commentairesInt').value = result.responseXML.documentElement.getAttribute('Commentaires_Int');

		document.getElementById('oets-bNouveau').disabled = (oets_etatTS=="C" || oets_etatTS=="A" || oets_soldeLiv);

		oets_chargerModesExpedition(result.responseXML.documentElement.getAttribute('Mode_Expedition'));

		var qGet = new QueryHttp("Facturation/Commun/getDepotStock.tmpl");
		qGet.setParam("Depot_Id", oets_depotId);
		result = qGet.execute();

		oets_etapePrepaBL = oets_defautEtapePrepaBLTS;
		var etapePrepaDepotBL = result.responseXML.documentElement.getAttribute("Etape_Prepa_BL_TS");
		if (!isEmpty(etapePrepaDepotBL)) {
			oets_etapePrepaBL = (etapePrepaDepotBL=="true");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_debloquerChamps() {
	try {

		document.getElementById('oets-bChoisirMentions').disabled = false;
		document.getElementById('oets-bAjouter').disabled = false;
		document.getElementById('oets-bToutAjouter').disabled = oets_bloquerBLSansStock;
		document.getElementById('oets-bToutAjouterDispo').disabled = false;
		document.getElementById('oets-bEnlever').disabled = false;

		document.getElementById('oets-modeExpedition').disabled = false;
		document.getElementById('oets-consignesLiv').disabled = false;
		document.getElementById('oets-commentairesFin').disabled = false;
		document.getElementById('oets-commentairesInt').disabled = false;
		document.getElementById('oets-bEnregistrer').disabled = false;
		document.getElementById('oets-bSupprimer').disabled = false;

		document.getElementById('oets-bAjouter').disabled = true;
		document.getElementById('oets-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_nouveauBon() {
  try {

		oets_bonId = "";
		oets_reinitialiser();

		if (oets_etatTS!="C" && oets_etatTS!="A" && !oets_soldeLiv) {
			oets_aArticlesTS.clearParams();
			oets_aArticlesTS.setParam('Transfert_Id', oets_transfertId);
			oets_aArticlesTS.initTree();

			document.getElementById('oets-bEditionBL').collapsed = false;
			document.getElementById('oets-bEditionBP').collapsed = false;
			document.getElementById('oets-bSupprimer').collapsed = true;
			document.getElementById('oets-bAnnuler').collapsed = true;
			document.getElementById('oets-bGenerateBL').collapsed = true;
			document.getElementById('oets-bConfirmer').collapsed = true;
			oets_debloquerChamps();

			document.getElementById('oets-bGenerateBP').disabled = true;
			document.getElementById('oets-bEditionBL').disabled = true;
			document.getElementById('oets-bEditionBP').disabled = true;
			document.getElementById('oets-boxArticlesTS').collapsed = false;
			document.getElementById('oets-boxActions').collapsed = false;

			oets_setModified(false);
		}
		else {
			document.getElementById('oets-boxActions').collapsed = true;
			document.getElementById('oets-boxArticlesTS').collapsed = true;
			document.getElementById('oets-boxSaisieSerie').collapsed = true;
			document.getElementById('oets-bGenerateBP').collapsed = true;
			document.getElementById('oets-bSupprimer').collapsed = true;
			document.getElementById('oets-bAnnuler').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_pressOnExpeditions(ev) {
  try {

		if (ev.keyCode==13) {
			oets_bonId = oets_aExpeditions.getSelectedCellText('oets-colBonId');
			oets_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_dblclickOnExpeditions() {
  try {

		if (oets_aExpeditions.isSelected()) {
			oets_bonId = oets_aExpeditions.getSelectedCellText('oets-colBonId');
			oets_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_chargerBon() {
  try {

		oets_reinitialiser();
		oets_aArticlesBL.setParam('Bon_Id', oets_bonId);
		oets_aArticlesTS.setParam('Bon_Id', oets_bonId);

		document.getElementById('oets-bEditionBL').collapsed = false;
		document.getElementById('oets-bEditionBP').collapsed = false;

		oets_mode = "M";

		var qLoad = new QueryHttp('Facturation/Transferts_Stocks/loadBonLivraison.tmpl');
		qLoad.setParam("Bon_Id", oets_bonId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oets_etatBon = contenu.getAttribute("Etat");
		oets_statutExpedition = contenu.getAttribute("Statut_Expedition");
		oets_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));

		document.getElementById('oets-bGenerateBL').collapsed = true;
		document.getElementById('oets-bConfirmer').collapsed = true;
		document.getElementById('oets-etat').value = contenu.getAttribute('LibEtat');

		if (oets_etatBon=="V") {
			document.getElementById('oets-bSupprimer').collapsed = true;
			document.getElementById('oets-bAnnuler').collapsed = (oets_etatTS=="C");
			document.getElementById('oets-boxArticlesTS').collapsed = true;
			document.getElementById('oets-boxActions').collapsed = true;
			document.getElementById('oets-bAnnuler').disabled = (oets_etatTS=="C");
			if (oets_statutExpedition=="P") {
				document.getElementById('oets-bGenerateBL').collapsed = false;
				document.getElementById('oets-envoiTrans').collapsed = !oets_envoiTrans;
				document.getElementById('oets-envoiTrans').checked = oets_envoiTrans;
				document.getElementById('oets-envoiTrans').disabled = false;
			}
			else if (oets_statutExpedition=="C") {
				document.getElementById('oets-bConfirmer').collapsed = false;
			}
		}
		else if (oets_etatBon=="A") {
			document.getElementById('oets-bSupprimer').collapsed = true;
			document.getElementById('oets-bAnnuler').collapsed = true;
			document.getElementById('oets-boxArticlesTS').collapsed = true;
			document.getElementById('oets-boxActions').collapsed = true;
		}
		else {
			document.getElementById('oets-bAnnuler').collapsed = true;
			document.getElementById('oets-bSupprimer').collapsed = false;
			document.getElementById('oets-boxArticlesTS').collapsed = false;
			document.getElementById('oets-boxActions').collapsed = false;
			document.getElementById('oets-bNouveau').disabled = true;
			document.getElementById('oets-envoiTrans').collapsed = !(oets_envoiTrans && !oets_etapePrepaBL);
			document.getElementById('oets-envoiTrans').checked = (oets_envoiTrans && !oets_etapePrepaBL);
			document.getElementById('oets-envoiTrans').disabled = oets_etapePrepaBL;
		}

		if (oets_etatBon!="N") {
			document.getElementById('oets-bCsvColisage').disabled = false;
			document.getElementById('oets-bPdfColisage').disabled = false;
			document.getElementById('oets-tabVersions').collapsed = false;
			document.getElementById('oets-tabColis').collapsed = false;
			oets_initVersion();
			if (!isEmpty(contenu.getAttribute("Date_Expe_Lot"))) {
				document.getElementById('oets-infoExpeLot').value = "Exp\u00E9dition en lot n\u00B0 "+ contenu.getAttribute("Num_Expedition") +" r\u00E9alis\u00E9e le "+ contenu.getAttribute("Date_Expe_Lot");
				document.getElementById('oets-infoExpeLot').collapsed = false;
			}
			if (!isEmpty(contenu.getAttribute("Date_Prepa_Expe"))) {
				document.getElementById('oets-infoPrepaExpe').value = "Pr\u00E9paration d'exp\u00E9dition valid\u00E9e le "+ contenu.getAttribute("Date_Prepa_Expe");
				document.getElementById('oets-infoPrepaExpe').collapsed = false;
			}
			if (contenu.getAttribute("Envoi_Trans")=="true") {
				document.getElementById('oets-infoEnvoiTrans').value = "Export transporteur effectu\u00E9";
				document.getElementById('oets-infoEnvoiTrans').collapsed = false;
			}
		}
		else {
			document.getElementById('oets-numSerie').focus();
		}

		document.getElementById('oets-boxSaisieSerie').collapsed = (!oets_actSuiviSerie || oets_etatBon!="N");
		document.getElementById('oets-consignesLiv').value = contenu.getAttribute('Consignes_Liv');

		document.getElementById('oets-dateBL').value = contenu.getAttribute("Date_BL");
		document.getElementById('oets-dateBP').value = contenu.getAttribute("Date_BP");
		document.getElementById('oets-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oets-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oets-numeroBL').value = contenu.getAttribute("Numero");
		document.getElementById('oets-numeroBP').value = contenu.getAttribute("Numero_BP");

		document.getElementById('oets-creation').setAttribute("label", "Exp\u00E9dition cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oets-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oets-document').setAttribute("label", "Bon de livraison N\u00B0 "+ contenu.getAttribute('Numero'));
		document.getElementById('oets-creation').collapsed = false;
		document.getElementById('oets-modification').collapsed = false;

		document.getElementById('oets-bOuvrirCommentairesCaches').disabled = false;

		oets_aLiensColis.setParam("Bon_Id", oets_bonId);
		oets_aLiensColis.initTree();

		oets_aArticlesBL.initTree();

		oets_setModified(false);

		if (oets_etatBon!='V' && oets_etatBon!='A') {
			oets_aArticlesTS.setParam('Transfert_Id', oets_transfertId);
			oets_aArticlesTS.initTree();
			oets_debloquerChamps();
			document.getElementById('oets-bToutEnlever').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_editerCommentairesInternes()  {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "BLT", oets_bonId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oets-commentairesFin').value;
		var commentairesInt = document.getElementById('oets-commentairesInt').value;
		var readOnly = (oets_etatBon!="N");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oets_retourEditerCommentaires, "BLT", oets_bonId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oets-commentairesFin').value = commentairesFin;
		document.getElementById('oets-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_enregistrerBon(rafraichir) {
  try {

  	var ok = false;

		var modeExpedition = document.getElementById('oets-modeExpedition').value;
		var consignesLiv = document.getElementById('oets-consignesLiv').value;
		var commentairesFin = document.getElementById('oets-commentairesFin').value;
		var commentairesInt = document.getElementById('oets-commentairesInt').value;

		if (!isEmpty(consignesLiv) && consignesLiv.length>100) {
			showWarning("Consignes de livraison incorrectes (longueur max = 100 caract\u00E8res)");
		}
		else {
			var qSave;

			if (oets_mode=="C") {
				qSave = new QueryHttp("Facturation/Transferts_Stocks/createBonLivraison.tmpl");
				qSave.setParam("Transfert_Id", oets_transfertId);
			}
			else {
				qSave = new QueryHttp("Facturation/Transferts_Stocks/updateBonLivraison.tmpl");
				qSave.setParam("Bon_Id", oets_bonId);
			}

			qSave.setParam("Depot_Id", oets_depotId);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Consignes_Liv", consignesLiv);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oets_mode=="C") {
					oets_bonId = result.responseXML.documentElement.getAttribute("Bon_Id");

					if (rafraichir) {
						oets_chargerBon();
					}
				}
				oets_aExpeditions.initTree();

				oets_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de cette exp\u00E9dition ?")) {

			var qDelete = new QueryHttp("Facturation/Transferts_Stocks/deleteBonLivraison.tmpl");
			qDelete.setParam("Bon_Id", oets_bonId);
			qDelete.execute();

			showMessage("L'exp\u00E9dition a \u00E9t\u00E9 supprim\u00E9e avec succ\u00E8s");
			oets_nouveauBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_generateBL() {
  try {

		if (oets_aArticlesBL.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient aucune ligne !");
		}
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de livraison ?\n(Attention le bon de livraison valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {

			var ok = true;

			if (oets_actSuiviSerie) {
				var qChkNS = new QueryHttp("Facturation/Transferts_Stocks/checkNumSerieBL.tmpl");
				qChkNS.setParam("Bon_Id", oets_bonId);
				var result = qChkNS.execute();
				var errors = new Errors(result);
				if (errors.hasNext()) {
					ok = false;
					errors.show();
				}
			}

			if (oets_statutExpedition!="P") {

				if (oets_actSuiviLot && ok) {
					var qChkLot = new QueryHttp("Facturation/Transferts_Stocks/checkNumLotBL.tmpl");
					qChkLot.setParam("Bon_Id", oets_bonId);
					var resultLot = qChkLot.execute();
					var errorsLot = new Errors(resultLot);
					if (errorsLot.hasNext()) {
						ok = false;
						errorsLot.show();
					}
				}

				if (ok) {
					var qValider = new QueryHttp("Facturation/Transferts_Stocks/validBonLivraison.tmpl");
					qValider.setParam('Bon_Id', oets_bonId);
					var result = qValider.execute();

					var errors = new Errors(result);

					if (errors.hasNext()) {
						ok = false;
						errors.show();
					}
				}
			}

			if (ok) {
				var qGenBL = new QueryHttp("Facturation/Transferts_Stocks/generateBonLivraison.tmpl");
				qGenBL.setParam("Bon_Id", oets_bonId);
				qGenBL.setParam("Envoi_Trans", document.getElementById('oets-envoiTrans').checked);
				var result = qGenBL.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oets_chargerBon();
					oets_chargerPdfBL();
				}
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_confirmerExpedition() {
  try {

  	if (window.confirm("Confirmez-vous l'exp\u00E9dition ?")) {

			var qConfExpe = new QueryHttp("Facturation/Transferts_Stocks/confirmExpedition.tmpl");
			qConfExpe.setParam("Bon_Id", oets_bonId);
			var result = qConfExpe.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oets_chargerBon();
			}
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_toutTransferer() {
  try {

  	var ok = true;
		if (oets_mode=="C") {
			ok = oets_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addAllBL.tmpl');
			qAdd.setParam("Bon_Id", oets_bonId);
			qAdd.setParam("Transfert_Id", oets_transfertId);
			qAdd.execute();

			oets_aArticlesTS.initTree();
			oets_aArticlesBL.initTree();

			document.getElementById('oets-nbPieces').value = "";
			document.getElementById('oets-quantite').value = "";
			document.getElementById('oets-numLot').value = "";
			document.getElementById('oets-datePeremption').value = "";

			document.getElementById('oets-bAjouter').disabled = true;
			document.getElementById('oets-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_toutTransfererDispo() {
  try {

  	var ok = true;
		if (oets_mode=="C") {
			ok = oets_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addAllDispoBL.tmpl');
			qAdd.setParam("Bon_Id", oets_bonId);
			qAdd.setParam("Transfert_Id", oets_transfertId);
			qAdd.execute();

			oets_aArticlesTS.initTree();
			oets_aArticlesBL.initTree();

			document.getElementById('oets-nbPieces').value = "";
			document.getElementById('oets-quantite').value = "";
			document.getElementById('oets-numLot').value = "";
			document.getElementById('oets-datePeremption').value = "";

			document.getElementById('oets-bAjouter').disabled = true;
			document.getElementById('oets-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Transferts_Stocks/removeAllBL.tmpl');
		qRemove.setParam("Bon_Id", oets_bonId);
		qRemove.execute();

		oets_aArticlesTS.initTree();
		oets_aArticlesBL.initTree();

		document.getElementById('oets-nbPieces').value = "";
		document.getElementById('oets-quantite').value = "";
		document.getElementById('oets-numLot').value = "";
		document.getElementById('oets-datePeremption').value = "";

		document.getElementById('oets-bAjouter').disabled = true;
		document.getElementById('oets-bEnlever').disabled = true;

		document.getElementById("oets-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_ajouter() {
  try {

		if (oets_aArticlesTS.isSelected()) {

			if (oets_aArticlesTS.nbSelection()==1) {

				var articleId = oets_aArticlesTS.getSelectedCellText('oets-colArticleIdTS');
				var ligneTS = oets_aArticlesTS.getSelectedCellText('oets-colLigneIdTS');
				var isSuiviLot = oets_aArticlesTS.getSelectedCellText('oets-colSuiviLotTS')=="true";
				var isSuiviDLC = oets_aArticlesTS.getSelectedCellText('oets-colSuiviDLCTS')=="true";
				var isSuiviSerie = oets_aArticlesTS.getSelectedCellText('oets-colSuiviSerieTS')=="true";
				var qteRestante = oets_aArticlesTS.getSelectedCellText('oets-colQuantiteTS');
				var quantiteMax = oets_aArticlesTS.getSelectedCellText('oets-colQteMaxTS');
				var nbPiecesRestant = oets_aArticlesTS.getSelectedCellText('oets-colNbPiecesTS');
				if (isEmpty(nbPiecesRestant)) { nbPiecesRestant = 0; }

				var quantite = document.getElementById('oets-quantite').value;
				var numLot = document.getElementById('oets-numLot').value;
				var datePeremption = document.getElementById('oets-datePeremption').value;
				var nbPieces = document.getElementById('oets-nbPieces').value;
				if (isEmpty(nbPieces)) { nbPieces = 0; }

				if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer"); }
				else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
				else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
				else if (parseFloat(qteRestante)-parseFloat(quantite)<0) { showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 livrer"); }
				else if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) { showWarning("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer d\u00E9passe le nb de pi\u00E8ces restant \u00E0 livrer");	}
				else if (oets_bloquerBLSansStock && parseFloat(quantite)>parseFloat(quantiteMax)) { showWarning("Quantit\u00E9 en stock insuffisante (max: "+ quantiteMax +")"); }
				else if (oets_checkNumLotLigne(numLot, datePeremption, articleId, isSuiviLot, isSuiviDLC)) {

					var ok = true;

					if (oets_mode=="C") {
						ok = oets_enregistrerBon(true);
					}

					if (ok) {
						var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addLigneBL.tmpl');
						qAdd.setParam("Bon_Id", oets_bonId);
						qAdd.setParam("Ligne_TS", ligneTS);
						qAdd.setParam("Quantite", quantite);
						qAdd.setParam("Num_Lot", numLot);
						qAdd.setParam("Nb_Pieces", nbPieces);
						qAdd.setParam("Date_Peremption", datePeremption);
						var result = qAdd.execute();

						var ligneBL = result.responseXML.documentElement.getAttribute('Ligne_Id');
						var quantiteBL = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

						oets_aArticlesTS.initTree();
						oets_aArticlesBL.initTree();

						document.getElementById('oets-nbPieces').value = "";
						document.getElementById('oets-quantite').value = "";
						document.getElementById('oets-numLot').value = "";
						document.getElementById('oets-datePeremption').value = "";

						document.getElementById('oets-bAjouter').disabled = true;

						if (!oets_etapePrepaBL) {
							oets_checkNumSerieLigne(ligneBL, isSuiviSerie, quantiteBL);
						}
					}
				}
			}
			else {
				var listLigneId = "";
				var rangeCount = oets_aArticlesTS.getRangeCount();

				for (var j=0; j<rangeCount; j++) {
					var start = {};
					var end = {};
					oets_aArticlesTS.getRangeAt(j,start,end);

					for (var c=start.value; c<=end.value; c++) {
						listLigneId += oets_aArticlesTS.getCellText(c, "oets-colLigneIdTS") +",";
					}
				}

				var ok = true;
				if (oets_mode=="C") {
					ok = oets_enregistrerBon(true);
				}
				if (ok) {
					var qAdd = new QueryHttp('Facturation/Transferts_Stocks/addAllBL.tmpl');
					qAdd.setParam("Bon_Id", oets_bonId);
					qAdd.setParam("Transfert_Id", oets_transfertId);
					qAdd.setParam("List_Ligne_Id", listLigneId);
					var result = qAdd.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					oets_aArticlesTS.initTree();
					oets_aArticlesBL.initTree();
					document.getElementById('oets-bAjouter').disabled = true;
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_enlever() {
  try {

		if (oets_aArticlesBL.isSelected()) {

			var ligneId = oets_aArticlesBL.getSelectedCellText('oets-colLigneIdBL');
			var qteInit = oets_aArticlesBL.getSelectedCellText('oets-colQuantiteBL');
			var quantite = document.getElementById('oets-quantite').value;
			var nbPiecesInit = oets_aArticlesBL.getSelectedCellText('oets-colNbPiecesBL');
			if (isEmpty(nbPiecesInit)) {
				nbPiecesInit = 0;
			}
			var nbPieces = document.getElementById('oets-nbPieces').value;
			if (isEmpty(nbPieces)) {
				nbPieces = 0;
			}

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteInit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans l'exp\u00E9dition !");
			}
			else if (!isPositiveOrNullInteger(nbPieces)) {
				showWarning("Nombre de pi\u00E8ces incorrect !");
			}
			else if (parseFloat(nbPiecesInit)-parseFloat(nbPieces)<0) {
				showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans l'exp\u00E9dition !");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Transferts_Stocks/removeLigneBL.tmpl');
				qRemove.setParam("Ligne_Id", ligneId);
				qRemove.setParam("Quantite", quantite);
				qRemove.setParam("Nb_Pieces", nbPieces);
				qRemove.execute();

				oets_aArticlesTS.initTree();
				oets_aArticlesBL.initTree();

				document.getElementById('oets-nbPieces').value = "";
				document.getElementById('oets-quantite').value = "";
				document.getElementById('oets-numLot').value = "";
				document.getElementById('oets-datePeremption').value = "";

				document.getElementById('oets-bEnlever').disabled = true;

				document.getElementById("oets-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_demandeEnregistrement() {
  try {

		if (oets_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'exp\u00E9dition ?")) {
				oets_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_setModified(modified) {
  try {

		oets_modified = modified;

		if (modified) {
			document.getElementById('oets-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oets-bGenerateBP').disabled = true;
			document.getElementById('oets-bEditionBL').disabled = true;
			document.getElementById('oets-bEditionBP').disabled = true;
		}
		else {
			document.getElementById('oets-tabBon').setAttribute('image', null);
			document.getElementById('oets-bGenerateBP').disabled = (oets_etatBon=='V');
			document.getElementById('oets-bGenerateBP').collapsed = oets_mode=='C' || (!oets_etapePrepaBL || oets_etatBon!='N');
			document.getElementById('oets-bGenerateBL').collapsed = oets_mode=='C' || (oets_statutExpedition!='P' && (oets_etapePrepaBL || oets_etatBon!='N'));
			document.getElementById('oets-bEditionBL').disabled = false;
			document.getElementById('oets-bEditionBL').collapsed = (oets_etatBon=='N' || oets_statutExpedition=='P' || isEmpty(document.getElementById('oets-dateBL').value));
			document.getElementById('oets-bEditionBP').disabled = false;
			document.getElementById('oets-bEditionBP').collapsed = (oets_etatBon=='N');
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oets_chargerPdfBL() {
  try {

		var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qLangueDefaut.setParam("Type_Doc", "BL");
		qLangueDefaut.setParam("Doc_Id", oets_bonId);
		var result = qLangueDefaut.execute();
		oets_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

		oets_aLangues.setParam("Selection", oets_langueDefaut);
		oets_aLangues.initTree(oets_initLangue);

  } catch (e) {
    recup_erreur(e);
  }
}


function oets_initLangue() {
	try {

		document.getElementById('oets-langueDefaut').value = oets_langueDefaut;
		oets_editerBon();

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_editerBP() {
	try {

		document.getElementById("oets-barEdition").collapsed = true;
		document.getElementById('oets-pdfBonLivraison').setAttribute("src", "");
		document.getElementById("bRetourExpedition").collapsed = false;
		document.getElementById("oets-deckBonLivraison").selectedIndex = 1;

		var oets_qGenPdf = new QueryHttp("Facturation/Transferts_Stocks/pdfBonPreparation.tmpl");
		oets_qGenPdf.setParam('Bon_Id', oets_bonId);

		var result = oets_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oets-pdfBonLivraison').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_editerBon() {
	try {

		document.getElementById("oets-barEdition").collapsed = false;
		document.getElementById('oets-pdfBonLivraison').setAttribute("src", "");
		document.getElementById("bRetourExpedition").collapsed = false;
		document.getElementById("oets-deckBonLivraison").selectedIndex = 1;

		var langue = document.getElementById('oets-langueDefaut').value;
		var editBP = document.getElementById('oets-chkEditBP').checked;

		var oets_qGenPdf = new QueryHttp("Facturation/Transferts_Stocks/pdfBonLivraison.tmpl");
		oets_qGenPdf.setParam('Bon_Id', oets_bonId);
	  oets_qGenPdf.setParam("Edit_BP", editBP);
	  oets_qGenPdf.setParam('Langue_Id', langue);

		var result = oets_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oets-pdfBonLivraison').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_generateBP() {
  try {

		if (oets_aArticlesBL.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient aucune ligne !");
		}
		else {
			var isValid = true;

			if (oets_actSuiviLot && isValid) {
				var qChkLot = new QueryHttp("Facturation/Transferts_Stocks/checkNumLotBL.tmpl");
				qChkLot.setParam("Bon_Id", oets_bonId);
				var resultLot = qChkLot.execute();
				var errorsLot = new Errors(resultLot);
				if (errorsLot.hasNext()) {
					isValid = false;
					errorsLot.show();
				}
			}
			if (isValid && window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de pr\u00E9paration ?")) {

				var qValider = new QueryHttp("Facturation/Transferts_Stocks/validBonLivraison.tmpl");
				qValider.setParam('Bon_Id', oets_bonId);
				var result = qValider.execute();

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oets_chargerBon();
					oets_editerBP();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_annulerBon() {
  try {

		if (window.confirm("Confirmez-vous l'annulation de l'exp\u00E9dition ?")) {

			var qCancel = new QueryHttp("Facturation/Transferts_Stocks/cancelBonLivraison.tmpl");
			qCancel.setParam('Bon_Id', oets_bonId);
			qCancel.execute();

			showMessage("L'exp\u00E9dition a \u00E9t\u00E9 annul\u00E9e");

			oets_chargerBon();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_choisirMentions() {
  try {

  	var ok = true;

  	if (oets_mode=="C") {
			ok = oets_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "BLT", oets_bonId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_initVersion() {
	try {

		oets_aVersions.setParam("Bon_Id", oets_bonId);
		oets_aVersions.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_selectLigneBL()  {
	try {

		if (oets_aArticlesBL.isSelected()) {
			document.getElementById('oets-nbPieces').value = oets_aArticlesBL.getSelectedCellText('oets-colNbPiecesBL');
			document.getElementById('oets-quantite').value = oets_aArticlesBL.getSelectedCellText('oets-colQuantiteBL');
			document.getElementById('oets-numLot').value = "";
			document.getElementById('oets-datePeremption').value = "";
			document.getElementById('oets-nbPieces').disabled = false;
			document.getElementById('oets-quantite').disabled = false;
			document.getElementById('oets-numLot').disabled = true;
			document.getElementById('oets-datePeremption').disabled = true;
			document.getElementById('oets-bEnlever').disabled = false;
			document.getElementById('oets-bAjouter').disabled = true;
			document.getElementById('oets-bConsultSerieLigne').disabled = false;
			oets_aArticlesTS.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_selectLigneTS() {
	try {

		if (oets_aArticlesTS.isSelected()) {
			if (oets_aArticlesTS.nbSelection()==1) {
				document.getElementById('oets-nbPieces').value = oets_aArticlesTS.getSelectedCellText('oets-colNbPiecesTS');
				document.getElementById('oets-quantite').value = oets_aArticlesTS.getSelectedCellText('oets-colQuantiteTS');
				document.getElementById('oets-nbPieces').disabled = false;
				document.getElementById('oets-quantite').disabled = false;
				document.getElementById('oets-numLot').disabled = false;
				document.getElementById('oets-datePeremption').disabled = false;
			}
			else {
				document.getElementById('oets-nbPieces').value = "";
				document.getElementById('oets-quantite').value = "";
				document.getElementById('oets-nbPieces').disabled = true;
				document.getElementById('oets-quantite').disabled = true;
				document.getElementById('oets-numLot').disabled = true;
				document.getElementById('oets-datePeremption').disabled = true;
			}

			document.getElementById('oets-numLot').value = "";
			document.getElementById('oets-datePeremption').value = "";
			document.getElementById('oets-bAjouter').disabled = false;
			document.getElementById('oets-bEnlever').disabled = true;
			oets_aArticlesBL.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (oets_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Transferts_Stocks/getNbNumSerieLigneBL.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "BLT", ligneId, oets_depotId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_consulterNumSerie()  {
	try {

		if (oets_aArticlesBL.isSelected()) {
			var ligneId = oets_aArticlesBL.getSelectedCellText('oets-colLigneIdBL');
			var mode = (oets_etatBon=="A" || oets_statutExpedition=="E" || oets_statutExpedition=="C"?"C":"S");
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', mode, "BLT", ligneId, oets_depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_checkNumLotLigne(numero, datePeremption, articleId, isSuiviLot, isSuiviDLC) {
	try {

		var ok = true;

		if (oets_actSuiviLot && !isEmpty(articleId)) {

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13 && oets_aArticlesTS.isSelected()) {
			var articleId = oets_aArticlesTS.getSelectedCellText('oets-colArticleIdTS');
			var numero = document.getElementById("oets-numLot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oets_retourRechercherLot, articleId, numero, oets_depotId, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oets-numLot").value = numero;
		document.getElementById("oets-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_updateDLC() {
	try {

		if (oets_aArticlesTS.isSelected()) {
			var numero = document.getElementById("oets-numLot").value;
			var articleId = oets_aArticlesTS.getSelectedCellText('oets-colArticleIdTS');

			if (!isEmpty(numero) && !isEmpty(articleId)) {
				var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
				qGetDLC.setParam("Article_Id", articleId);
				qGetDLC.setParam("Numero", numero);
				var result = qGetDLC.execute();
				var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
				if (!isEmpty(datePeremption)) {
					document.getElementById("oets-datePeremption").value = datePeremption;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			oets_validerSaisieBySerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_validerSaisieBySerie(ligneId) {
	try {

		var listLigneTS = ligneId;

		if (listLigneTS==null) {
			listLigneTS = "";
			var nbLignes = oets_aArticlesTS.nbLignes();
			for (i=0; i<nbLignes; i++) {
				if (parseFloat(oets_aArticlesTS.getCellText(i, 'oets-colQuantiteTS'))>0) {
					listLigneTS += oets_aArticlesTS.getCellText(i, 'oets-colLigneIdTS') +",";
				}
			}
		}

		var numSerie = document.getElementById("oets-numSerie").value;

		if (!isEmpty(numSerie)) {

			var ok = true;
			if (oets_mode=="C") {
				ok = oets_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterNumSerie = new QueryHttp('Facturation/Transferts_Stocks/addNumSerieBL.tmpl');
				qAjouterNumSerie.setParam("Bon_Id", oets_bonId);
				qAjouterNumSerie.setParam("Num_Serie", numSerie);
				qAjouterNumSerie.setParam("List_Ligne_TS", listLigneTS);
				var result = qAjouterNumSerie.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit) {
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/transferts_stocks/popup-conflitNumSerieTS.xul";
			      window.openDialog(url,'','chrome,modal,centerscreen', listConflit, oets_retourChoixConflit);
					}
					else {
						oets_aArticlesTS.initTree();
						oets_aArticlesBL.initTree();
						document.getElementById("oets-numSerie").value = "";
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_retourChoixConflit(ligneId) {
	try {

		oets_validerSaisieBySerie(ligneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oets_clickOnColis(tree, ev) {

	gClipboardHelper.copyString(oets_aLiensColis.getSelectedCellText("oets-colNumColis"));

	var col = oets_aLiensColis.getClickedCol(ev);

	if (col!=null && col.id=="oets-colNumColis") {
		var lien = oets_aLiensColis.getSelectedCellValue("oets-colNumColis");
		if (!isEmpty(lien)) {
			//window.open(lien);
			openInNavigator(lien);
		}
	}
	else if (col!=null && col.id=="oets-colCTC") {
		window.open(oets_aLiensColis.getSelectedCellValue("oets-colCTC"));
	}
}


function oets_keypressOnColis(ev) {
  try {

		if ((ev.key=='w' || ev.key=='W') && ev.ctrlKey && oets_aLiensColis.isSelected()) {
			// ctrl + w pour copier l'adresse du lien
			gClipboardHelper.copyString(oets_aLiensColis.getSelectedCellValue("oets-colNumColis"));
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_pressOnColis() {
  try {

		if (oets_aLiensColis.isSelected()) {
			document.getElementById('oets-bAnnulerColis').disabled = (oets_aLiensColis.getSelectedCellText("oets-colStatut")!="V");
		}
		else {
			document.getElementById('oets-bAnnulerColis').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oets_annulerColis() {
  try {

		document.getElementById('oets-bAnnulerColis').disabled = true;

		if (window.confirm("Confirmez-vous l'annulation du colis s\u00E9lectionn\u00E9 ?")) {

			var colisId = oets_aLiensColis.getSelectedCellText("oets-colColisId");

			var qCancel = new QueryHttp("Facturation/Transferts_Stocks/cancelColis.tmpl");
			qCancel.setParam("Colis_Id", colisId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le colis a \u00E9t\u00E9 annul\u00E9");
			}
			oets_aLiensColis.initTree();
		}
		else {
			document.getElementById('oets-bAnnulerColis').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_editerColisageCSV() {
  try {

		if (oets_aLiensColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionCsv = new QueryHttp("Facturation/Transferts_Stocks/csvColisageBL.tmpl");
			qEditionCsv.setParam("Bon_Liv_Id", oets_bonId);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_editerColisagePDF() {
  try {

		if (oets_aLiensColis.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionPdf = new QueryHttp("Facturation/Transferts_Stocks/pdfColisageBL.tmpl");
			qEditionPdf.setParam("Bon_Liv_Id", oets_bonId);

			document.getElementById('oets-deckBonLivraison').selectedIndex = 2;

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('oets-pdfEdition').setAttribute("src", page);

				document.getElementById('bRetourExpedition').collapsed = false;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oets_envoyerMail() {
	try {

		var langue = document.getElementById('oets-langueDefaut').value;
		var editBP = document.getElementById('oets-chkEditBP').checked;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "BLT", oets_bonId, langue, editBP);

	} catch (e) {
		recup_erreur(e);
	}
}
