
/* charger pralablement util.js */



var tabTVA;
var codeTvaNormalFrance;


function getTva(codeTVA) {

	if (tabTVA==null) {
		var qTabTva = new QueryHttp("Commun/getTableauTVA.tmpl");
		var result = qTabTva.execute();
		tabTVA = result.responseXML.documentElement.getElementsByTagName("tva");
	}

	for (var i=0;i<tabTVA.length;i++) {
		if (tabTVA.item(i).getAttribute("Code_TVA")==codeTVA) {
			return tabTVA.item(i).getAttribute("Taux_TVA");
		}
	}

	return 0;
}


function getCodeTvaNormal(codePays, assujettiTVA, regimeTVA) {
  var qTCT = new QueryHttp("Commun/getTheoreticalCodeTVA.tmpl");
	qTCT.setParam("Code_Pays", codePays);
	qTCT.setParam("Regime_TVA", regimeTVA);
	qTCT.setParam("Assujetti_TVA", assujettiTVA);
	var result = qTCT.execute();
	return result.responseXML.documentElement.getAttribute("Code_TVA");
}


//retourne le code tva correspondant au codeTVA en parametre pour le codePays en parametre
// a enlever lorsque l'on gerera le taux de tva par pays dans la fiche article
function getCodeTvaCorrespondant(codeTVA, codePays, assujettiTVA, regimeTVA) {
	var valRetour = codeTVA;
	var continuer = true;

	if (codePays!="FR" && !assujettiTVA && regimeTVA!="E") {
		// si taxationTVALiv=0 et zoneUE=1, alors continuer=FALSE
		var qCheckTaxationZoneUE = new QueryHttp("Commun/getTaxationZoneUE.tmpl");
		qCheckTaxationZoneUE.setParam("Code_Pays", codePays);
		var result = qCheckTaxationZoneUE.execute();
		var contenu = result.responseXML.documentElement;
		if (contenu.getAttribute("Zone_UE")=="true" && contenu.getAttribute("Taxation_TVA_Liv")=="false") { continuer=false; }
	}

  if (continuer && (codePays!="FR" || regimeTVA=="E")) {
  	valRetour = getCodeTvaNormal(codePays, assujettiTVA, regimeTVA);
  }
	else if (codePays!="FR" && getTva(codeTVA)==0) {
		valRetour = getCodeTvaZero(codePays);
	}

  return valRetour;
}


function getCodeTvaZero(codePays) {
	var qCTE = new QueryHttp("Commun/getCodeTVAExonere.tmpl");
	qCTE.setParam("Code_Pays", codePays);
	var result = qCTE.execute();
	return result.responseXML.documentElement.getAttribute('Code_TVA');
}


function getCodeTvaNormalFrance() {

	if (codeTvaNormalFrance==null) {
  	var qCTNF = new QueryHttp("Commun/getCodeTVANormalFrance.tmpl");
		var result = qCTNF.execute();
		codeTvaNormalFrance = result.responseXML.documentElement.getAttribute("Code_TVA");
	}

	return codeTvaNormalFrance;
}
