/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");



function init() {
  try {

		document.getElementById('entreprise').value = window.arguments[1];
		document.getElementById('login').value = window.arguments[2];

  } catch (e) {
    recup_erreur(e);
  }
}


function changePassword() {
  try {

		var oldPassword = document.getElementById('oldPassword').value;
  	var newPassword = document.getElementById('newPassword').value;
		var newPassword2 = document.getElementById('newPassword2').value;

		if (isEmpty(oldPassword)) { showWarning("Veuillez indiquer votre mot de passe actuel"); }
		else if (isEmpty(newPassword)) { showWarning("Veuillez indiquer votre nouveau mot de passe"); }
		else if (newPassword.length<8) { showWarning("Le mot de passe doit contenir au minimum 8 caract\u00E8res"); }
		else if (!isValidPassword(newPassword)) { showWarning("Le mot de passe doit contenir au moins 3 des 4 types de caract\u00E8res (minuscule, majuscule, chiffre, car. sp\u00E9cial)"); }
		else if (newPassword==oldPassword) { showWarning("Le nouveau mot de passe ne peut pas \u00EAtre identique au pr\u00E9c\u00E9dent"); }
		else if (isEmpty(newPassword2)) { showWarning("Veuillez confirmer votre nouveau mot de passe"); }
		else if (newPassword2!=newPassword) {
			showWarning("Les mots de passe saisis sont diff\u00E9rents. Veuillez reconfirmer le mot de passe");
			document.getElementById('Password2').value = '';
			document.getElementById('Password2').focus();
		}
		else {

			var qChange = new QueryHttp("changePassword.tmpl");
			qChange.setParam("Old_Password", oldPassword);
			qChange.setParam("New_Password", newPassword);
			var result = qChange.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				document.getElementById('oldPassword').value = "";
				document.getElementById('oldPassword').focus();
			}
			else {
				showMessage("Votre mot de passe a \u00E9t\u00E9 chang\u00E9 avec succ\u00E9s.\n\nSaisissez votre nouveau mot de passe pour vous connecter.");
				window.arguments[0]();
  			setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
