/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
var tabAttachedFiles = new Array();
var incFileId = 0;
var attachSize = 0;



function init() {
	try {


	}	catch (e) {
		recup_erreur(e);
	}
}


function consultationManuel() {
	try {

		window.maximize();
		document.getElementById('deckSupport').selectedIndex = 1;
		document.getElementById('manuel').setAttribute("src", "http://manuel.opensi.fr");

	}	catch (e) {
		recup_erreur(e);
	}
}


function demandeAssistance() {
	try {

		window.resizeTo(660, 660);
		document.getElementById('deckSupport').selectedIndex = 2;

		var qUtil = new QueryHttp("Commun/getDemandeurAssistance.tmpl");

		var result = qUtil.execute();

		document.getElementById('Nom').value = result.responseXML.documentElement.getAttribute("Nom");
		document.getElementById('Prenom').value = result.responseXML.documentElement.getAttribute("Prenom");
		document.getElementById('Telephone').value = result.responseXML.documentElement.getAttribute("Telephone");
		document.getElementById('Email').value = result.responseXML.documentElement.getAttribute("Email");

	}	catch (e) {
		recup_erreur(e);
	}
}


function envoyerDemande() {
	try {

		var produit = document.getElementById('Produit').value;
		var objet = document.getElementById('Objet').value;
		var description = document.getElementById('Description').value;
		var nom = document.getElementById('Nom').value;
		var prenom = document.getElementById('Prenom').value;
		var telephone = document.getElementById('Telephone').value;
		var email = document.getElementById('Email').value;

		if (isEmpty(produit)) { showWarning("Veuillez indiquer le produit concern\u00E9"); }
		else if (isEmpty(objet)) { showWarning("Veuillez indiquer l'objet de votre demande"); }
		else if (isEmpty(description)) { showWarning("Veuillez indiquer la description de votre demande"); }
		else if (isEmpty(nom)) { showWarning("Veuillez indiquer votre nom"); }
		else if (isEmpty(prenom)) { showWarning("Veuillez indiquer votre pr\u00E9nom"); }
		else if (isEmpty(telephone)) { showWarning("Veuillez indiquer votre num\u00E9ro de t\u00E9l\u00E9phone"); }
		else if (isEmpty(email)) { showWarning("Veuillez indiquer votre adresse e-mail"); }
		else if (!isEmail(email)) { showWarning("Adresse e-mail incorrecte"); }
		else if (!isPhone(telephone)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone incorrect"); }
		else {
			var qEnvoi = new QueryHttp("Commun/sendDemandeAssistance.tmpl");
			qEnvoi.setParam('Produit', produit);
			qEnvoi.setParam('Objet', objet);
			qEnvoi.setParam('Description', description);
			qEnvoi.setParam('Nom', nom);
			qEnvoi.setParam('Prenom', prenom);
			qEnvoi.setParam('Telephone', telephone);
			qEnvoi.setParam('Email', email);
			qEnvoi.setParam('AttachedFiles', tabAttachedFiles);

			var result = qEnvoi.execute();

			showMessage("Votre demande a \u00E9t\u00E9 envoy\u00E9e");

			retourSupport();
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function retourSupport() {
	try {

		window.resizeTo(600, 500);
		document.getElementById('deckSupport').selectedIndex = 0;

	}	catch (e) {
		recup_erreur(e);
	}
}


function removeFile(fileId, value, size) {
	try {

		var wFile = document.getElementById(fileId);
		document.getElementById("boxFichiers").removeChild(wFile);
		tabAttachedFiles.splice(tabAttachedFiles.indexOf(value), 1);
		attachSize -= size;

		if (tabAttachedFiles.length==0) {
			document.getElementById("rowFichiers").collapsed = true;
		}

	}	catch (e) {
		recup_erreur(e);
	}
}


function attachFile() {
	try {

		document.getElementById("rowFichiers").collapsed = false;

		var file = fileChooser("open");
		if (file!=null) {

			if (file.fileSize>5242880) {
				showWarning("Taille de fichier trop importante (5 Mo max.)");
			}
			else if (attachSize+file.fileSize>10485760) {
				showWarning("Impossible d'ajouter le fichier, taille maximale atteinte (10 Mo max.)");
			}
			else if (checkUploadFile(file)) {

				uploadFile(file);

				tabAttachedFiles.push(file.leafName);

				attachSize += file.fileSize;
				var fileId = "FID"+ incFileId++;

				var xulHbox = document.createElementNS(XUL_NS, "xul:hbox");
				xulHbox.setAttribute("id", fileId);
				xulHbox.setAttribute("align", "center");

				var xulLabel = document.createElementNS(XUL_NS, "xul:label");
				xulLabel.setAttribute("value", file.leafName);

				var xulButton = document.createElementNS(XUL_NS, "xul:button");
				xulButton.setAttribute("class", "bIcoSupprimer");
				xulButton.setAttribute("oncommand", "removeFile('"+ fileId +"','"+ file.leafName +"',"+ file.fileSize +")");
				xulButton.setAttribute("tooltiptext", "enlever le fichier");

				xulHbox.appendChild(xulLabel);
				xulHbox.appendChild(xulButton);
				document.getElementById("boxFichiers").appendChild(xulHbox);
			}
		}

	}	catch (e) {
		recup_erreur(e);
	}
}
