/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omd_aDossiers = new Arbre("Superviseur/dossiers/list-dossier.tmpl", "omd-listeDossiers");
var omd_qListFD = new QueryHttp("Superviseur/dossiers/getDataListFD.tmpl");

var omd_pageCourante;
var omd_nbPages;



function omd_init() {
	try {

		document.getElementById('omd-dossier').focus();
		omd_loadChiffresCles();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnNouveauDossier() {
	try {

		document.getElementById("bMenuDossiers").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		ofd_nouveauDossier();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initCriteres() {
	try {

		document.getElementById('omd-dossier').value = "";
		document.getElementById('omd-numClient').value = "";
		document.getElementById('omd-type').value = "";
		document.getElementById('omd-actif').checked = true;

		omd_listerDossiers();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_listerDossiers() {
	try {

		var dossier = document.getElementById('omd-dossier').value;
		var numClient = document.getElementById('omd-numClient').value;
		var type = document.getElementById('omd-type').value;
		var actif = document.getElementById('omd-actif').checked;
		var nbLignesParPage = document.getElementById('omd-nbLignesParPage').value;

		omd_pageCourante = 1;
		omd_nbPages = 1;
		document.getElementById('omd-pageDeb').value = 1;
		document.getElementById('omd-pageFin').value = 1;
		document.getElementById('omd-bPrec').disabled = true;
		document.getElementById('omd-bSuiv').disabled = true;

		document.getElementById('omd-listeDossiers').disabled = true;
		document.getElementById('omd-bEditionCsv').disabled = true;
		omd_aDossiers.deleteTree();

		omd_qListFD.setParam("Dossier", dossier);
		omd_qListFD.setParam("Num_Client", numClient);
		omd_qListFD.setParam("Type", type);
		omd_qListFD.setParam("Actif", actif);
		omd_qListFD.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		omd_qListFD.setParam("Current_Page", omd_pageCourante);

		var result = omd_qListFD.execute();

		var contenu = result.responseXML.documentElement;

		omd_nbPages = contenu.getAttribute("Nb_Pages");
		var listDossierId = contenu.getAttribute("List_Dossier_Id");

		omd_aDossiers.setParam("List_Dossier_Id", listDossierId);
		omd_aDossiers.initTree(omd_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_initPagination() {
	try {

		document.getElementById('omd-pageDeb').value = omd_pageCourante;
		document.getElementById('omd-pageFin').value = (omd_nbPages>0?omd_nbPages:1);
		document.getElementById('omd-bPrec').disabled = (omd_pageCourante==1);
		document.getElementById('omd-bSuiv').disabled = (omd_pageCourante>=omd_nbPages); // peut se produire si omd_nbPages=0

		omd_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnPagePrec() {
	try {

		omd_pageCourante--;
		omd_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnPageSuiv() {
	try {

		omd_pageCourante++;
		omd_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_majPagination() {
	try {

		document.getElementById('omd-pageDeb').value = omd_pageCourante;
		document.getElementById('omd-bPrec').disabled = (omd_pageCourante==1);
		document.getElementById('omd-bSuiv').disabled = (omd_pageCourante==omd_nbPages);

		document.getElementById('omd-listeDossiers').disabled = true;
		document.getElementById('omd-bEditionCsv').disabled = true;

		omd_qListFD.setParam("Current_Page", omd_pageCourante);
		var result = omd_qListFD.execute();
		var listDossierId = result.responseXML.documentElement.getAttribute("List_Dossier_Id");

		omd_aDossiers.setParam("List_Dossier_Id", listDossierId);
		omd_aDossiers.initTree(omd_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_afterMajPagination() {
	try {

		document.getElementById('omd-listeDossiers').disabled = false;
		document.getElementById('omd-bEditionCsv').disabled = (omd_aDossiers.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omd_listerDossiers();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_pressOnListeDossiers(ev) {
	try {

		if (ev.keyCode==13) {
			omd_ouvrirDossier();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_ouvrirDossier() {
  try {

  	if (omd_aDossiers.isSelected()) {

			ofd_dossierId = omd_aDossiers.getSelectedCellText('omd-colDossierId');
			document.getElementById('bMenuDossiers').collapsed = false;

			ofd_chargerDossier();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omd_pressOnEditionCsv() {
	try {

		var dossier = document.getElementById('omd-dossier').value;
		var numClient = document.getElementById('omd-numClient').value;
		var type = document.getElementById('omd-type').value;
		var actif = document.getElementById('omd-actif').checked;

		var qEditionCsv = new QueryHttp("Superviseur/dossiers/csvDossier.tmpl");
		qEditionCsv.setParam("Dossier", dossier);
		qEditionCsv.setParam("Num_Client", numClient);
		qEditionCsv.setParam("Type", type);
		qEditionCsv.setParam("Actif", actif);

		var result = qEditionCsv.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Superviseur/dossiers/getStatsDossier.tmpl");
		var result = qStats.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("omd-nbFDTotal").value = contenu.getAttribute("Nb_FD_Total");
		document.getElementById("omd-nbFDTotalActif").value = contenu.getAttribute("Nb_FD_Total_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}
