/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var dossierId;
var codeDossier;


function init() {
	try {

		dossierId = window.arguments[1];

		var qLoad = new QueryHttp("Superviseur/dossiers/loadDossier.tmpl");
		qLoad.setParam("Dossier_Id", dossierId);
		var result = qLoad.execute();

		codeDossier = result.responseXML.documentElement.getAttribute("Code_Dossier");
		var nomDossier = result.responseXML.documentElement.getAttribute("Nom");

		document.getElementById('lblPopup').value = "SUPPRESSION DU DOSSIER "+ codeDossier;
		document.getElementById('lblConfirm').value = "Vous allez supprimer le dossier "+ codeDossier +" - "+ nomDossier;

	} catch (e) {
  	recup_erreur(e);
  }
}


function supprimer() {
	try {

		if (document.getElementById('txtConfirm').value!="oui") {
			showWarning("Veuillez saisir le texte 'oui' pour confirmer la suppression du dossier");
		}
		else if (window.confirm("Etes-vous s\u00FBr de vouloir supprimer ce dossier ?")) {

			document.getElementById('bAnnuler').disabled = true;
			document.getElementById('bSupprimer').disabled = true;

			var qSupp = new QueryHttp("Superviseur/dossiers/deleteDossier.tmpl");
			qSupp.setParam('Dossier_Id', dossierId);
			var result = qSupp.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le dossier "+ codeDossier +" a \u00E9t\u00E9 supprim\u00E9");
			}

			window.arguments[0]();
			window.close();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}
