/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ome_aEntreprises = new Arbre("Superviseur/entreprises/list-entreprise.tmpl", "ome-listeEntreprises");
var ome_qListFE = new QueryHttp("Superviseur/entreprises/getDataListFE.tmpl");

var ome_pageCourante;
var ome_nbPages;



function ome_init() {
	try {

		document.getElementById('ome-identifiant').focus();
		ome_loadChiffresCles();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnNouveauEntreprise() {
	try {

		document.getElementById("bMenuEntreprises").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;
		ofe_nouveauEntreprise();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initCriteres() {
	try {

		document.getElementById('ome-identifiant').value = "";
		document.getElementById('ome-denomination').value = "";
		document.getElementById('ome-actif').checked = true;

		ome_listerEntreprises();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_listerEntreprises() {
	try {

		var identifiant = document.getElementById('ome-identifiant').value;
		var denomination = document.getElementById('ome-denomination').value;
		var actif = document.getElementById('ome-actif').checked;
		var nbLignesParPage = document.getElementById('ome-nbLignesParPage').value;

		ome_pageCourante = 1;
		ome_nbPages = 1;
		document.getElementById('ome-pageDeb').value = 1;
		document.getElementById('ome-pageFin').value = 1;
		document.getElementById('ome-bPrec').disabled = true;
		document.getElementById('ome-bSuiv').disabled = true;

		document.getElementById('ome-listeEntreprises').disabled = true;
		document.getElementById('ome-bEditionCsv').disabled = true;
		ome_aEntreprises.deleteTree();

		ome_qListFE.setParam("Identifiant", identifiant);
		ome_qListFE.setParam("Denomination", denomination);
		ome_qListFE.setParam("Actif", actif);
		ome_qListFE.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		ome_qListFE.setParam("Current_Page", ome_pageCourante);

		var result = ome_qListFE.execute();

		var contenu = result.responseXML.documentElement;

		ome_nbPages = contenu.getAttribute("Nb_Pages");
		var listEntrepriseId = contenu.getAttribute("List_Entreprise_Id");

		ome_aEntreprises.setParam("List_Entreprise_Id", listEntrepriseId);
		ome_aEntreprises.initTree(ome_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initPagination() {
	try {

		document.getElementById('ome-pageDeb').value = ome_pageCourante;
		document.getElementById('ome-pageFin').value = (ome_nbPages>0?ome_nbPages:1);
		document.getElementById('ome-bPrec').disabled = (ome_pageCourante==1);
		document.getElementById('ome-bSuiv').disabled = (ome_pageCourante>=ome_nbPages); // peut se produire si ome_nbPages=0

		ome_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnPagePrec() {
	try {

		ome_pageCourante--;
		ome_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnPageSuiv() {
	try {

		ome_pageCourante++;
		ome_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_majPagination() {
	try {

		document.getElementById('ome-pageDeb').value = ome_pageCourante;
		document.getElementById('ome-bPrec').disabled = (ome_pageCourante==1);
		document.getElementById('ome-bSuiv').disabled = (ome_pageCourante==ome_nbPages);

		document.getElementById('ome-listeEntreprises').disabled = true;
		document.getElementById('ome-bEditionCsv').disabled = true;

		ome_qListFE.setParam("Current_Page", ome_pageCourante);
		var result = ome_qListFE.execute();
		var listEntrepriseId = result.responseXML.documentElement.getAttribute("List_Entreprise_Id");

		ome_aEntreprises.setParam("List_Entreprise_Id", listEntrepriseId);
		ome_aEntreprises.initTree(ome_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_afterMajPagination() {
	try {

		document.getElementById('ome-listeEntreprises').disabled = false;
		document.getElementById('ome-bEditionCsv').disabled = (ome_aEntreprises.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ome_listerEntreprises();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_pressOnListeEntreprises(ev) {
	try {

		if (ev.keyCode==13) {
			ome_ouvrirEntreprise();
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_ouvrirEntreprise() {
  try {

  	if (ome_aEntreprises.isSelected()) {

			ofe_entrepriseId = ome_aEntreprises.getSelectedCellText('ome-colEntrepriseId');
			document.getElementById('bMenuEntreprises').collapsed = false;

			ofe_chargerEntreprise();

			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_pressOnEditionCsv() {
	try {

		var identifiant = document.getElementById('ome-identifiant').value;
		var denomination = document.getElementById('ome-denomination').value;
		var actif = document.getElementById('ome-actif').checked;

		var qEditionCsv = new QueryHttp("Superviseur/entreprises/csvEntreprise.tmpl");
		qEditionCsv.setParam("Identifiant", identifiant);
		qEditionCsv.setParam("Denomination", denomination);
		qEditionCsv.setParam("Actif", actif);

		var result = qEditionCsv.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_loadChiffresCles() {
	try {

		var qStats = new QueryHttp("Superviseur/entreprises/getStatsEntreprise.tmpl");
		var result = qStats.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("ome-nbFETotal").value = contenu.getAttribute("Nb_FE_Total");
		document.getElementById("ome-nbFETotalActif").value = contenu.getAttribute("Nb_FE_Total_Actif");

	} catch (e) {
		recup_erreur(e);
	}
}
