/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omm_aMandats = new Arbre('TB/Mandats/list-mandat.tmpl', 'omm-tMandats');
var omm_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omm-etablissement');
var omm_qListMP = new QueryHttp("TB/Mandats/getDataListMP.tmpl");

var omm_pageCourante;
var omm_nbPages;


function omm_init() {
  try {

		omm_aEtablissements.initTree(omm_initCriteres);

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_initCriteres() {
	try {

		document.getElementById('omm-numeroRUM').value = "";
		document.getElementById('omm-etat').value = "N";
		document.getElementById('omm-typePaiement').value = "";
		document.getElementById('omm-typeMandat').value = "";
		document.getElementById('omm-etablissement').value = etablissementDefaut;
		document.getElementById('omm-dateDebutSignature').value = "";
		document.getElementById('omm-dateFinSignature').value = "";
		document.getElementById('omm-denomination').value = "";
		document.getElementById('omm-numClient').value = "";
		omm_listerMandats();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_listerMandats() {
	try {

		var numeroRUM = document.getElementById('omm-numeroRUM').value;
		var etat = document.getElementById('omm-etat').value;
		var typePaiement = document.getElementById('omm-typePaiement').value;
		var typeMandat = document.getElementById('omm-typeMandat').value;
		var etablissement = document.getElementById('omm-etablissement').value;
		var dateDebutSignature = document.getElementById('omm-dateDebutSignature').value;
		var dateFinSignature = document.getElementById('omm-dateFinSignature').value;
		var denomination = document.getElementById('omm-denomination').value;
		var numClient = document.getElementById('omm-numClient').value;
		var nbLignesParPage = document.getElementById('omm-nbLignesParPage').value;

		if (!isEmpty(dateDebutSignature) && !isDate(dateDebutSignature)) { showWarning("Date de remise de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinSignature) && !isDate(dateFinSignature)) { showWarning("Date de remise de fin incorrecte !"); }
		else if (!isEmpty(dateDebutSignature) && !isEmpty(dateFinSignature) && !isDateInterval(dateDebutSignature, dateFinSignature)) { showWarning("Plage de dates de remise incorrecte !"); }
		else {

			omm_pageCourante = 1;
			omm_nbPages = 1;
			document.getElementById('omm-pageDeb').value = 1;
			document.getElementById('omm-pageFin').value = 1;
			document.getElementById('omm-bPrec').disabled = true;
			document.getElementById('omm-bSuiv').disabled = true;

			document.getElementById('omm-tMandats').disabled = true;
			document.getElementById('omm-bEditionCsv').disabled = true;
			omm_aMandats.deleteTree();

			omm_qListMP.setParam("Numero_RUM", numeroRUM);
			omm_qListMP.setParam("Etat", etat);
			omm_qListMP.setParam("Type_Paiement", typePaiement);
			omm_qListMP.setParam("Type_Mandat", typeMandat);
			omm_qListMP.setParam("Etablissement", etablissement);
			omm_qListMP.setParam("Date_Debut_Signature", dateDebutSignature);
			omm_qListMP.setParam("Date_Fin_Signature", dateFinSignature);
			omm_qListMP.setParam("Denomination", denomination);
			omm_qListMP.setParam("Num_Client", numClient);
			omm_qListMP.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omm_qListMP.setParam("Current_Page", omm_pageCourante);

			var result = omm_qListMP.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('omm-nombreMandats').value = contenu.getAttribute("Nb_Resultats");
			omm_nbPages = contenu.getAttribute("Nb_Pages");
			var listMandatId = contenu.getAttribute("List_Mandat_Id");

			omm_aMandats.setParam("List_Mandat_Id", listMandatId);
			omm_aMandats.initTree(omm_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_initPagination() {
	try {

		document.getElementById('omm-pageDeb').value = omm_pageCourante;
		document.getElementById('omm-pageFin').value = (omm_nbPages>0?omm_nbPages:1);
		document.getElementById('omm-bPrec').disabled = (omm_pageCourante==1);
		document.getElementById('omm-bSuiv').disabled = (omm_pageCourante>=omm_nbPages); // peut se produire si omm_nbPages=0

		document.getElementById('omm-tMandats').disabled = false;
		document.getElementById('omm-bEditionCsv').disabled = (omm_aMandats.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnPagePrec() {
	try {

		omm_pageCourante--;
		omm_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnPageSuiv() {
	try {

		omm_pageCourante++;
		omm_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_majPagination() {
	try {

		document.getElementById('omm-pageDeb').value = omm_pageCourante;
		document.getElementById('omm-bPrec').disabled = (omm_pageCourante==1);
		document.getElementById('omm-bSuiv').disabled = (omm_pageCourante==omm_nbPages);

		document.getElementById('omm-tMandats').disabled = true;
		document.getElementById('omm-bEditionCsv').disabled = true;

		omm_qListMP.setParam("Current_Page", omm_pageCourante);
		var result = omm_qListMP.execute();
		var listMandatId = result.responseXML.documentElement.getAttribute("List_Mandat_Id");

		omm_aMandats.setParam("List_Mandat_Id", listMandatId);
		omm_aMandats.initTree(omm_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_afterMajPagination() {
	try {

		document.getElementById('omm-tMandats').disabled = false;
		document.getElementById('omm-bEditionCsv').disabled=(omm_aMandats.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnNouveauMandat() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuMandats').collapsed = false;
		oem_nouveauMandat();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omm_listerMandats();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_pressOnListeMandats(ev) {
  try {

		if (ev.keyCode==13) {
			omm_ouvrirMandat();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_ouvrirMandat() {
  try {

  	if (omm_aMandats.isSelected()) {
			var mandatId = omm_aMandats.getSelectedCellText('omm-colMandatId');
			document.getElementById('bMenuMandats').collapsed = false;

			document.getElementById('deck').selectedIndex = 1;
			oem_mandatId = mandatId;
			oem_chargerMandat();
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omm_pressOnEditionCsv() {
	try {

		var numeroRUM = document.getElementById('omm-numeroRUM').value;
		var etat = document.getElementById('omm-etat').value;
		var typePaiement = document.getElementById('omm-typePaiement').value;
		var typeMandat = document.getElementById('omm-typeMandat').value;
		var etablissement = document.getElementById('omm-etablissement').value;
		var dateDebutSignature = document.getElementById('omm-dateDebutSignature').value;
		var dateFinSignature = document.getElementById('omm-dateFinSignature').value;
		var denomination = document.getElementById('omm-denomination').value;
		var numClient = document.getElementById('omm-numClient').value;

		if (!isEmpty(dateDebutSignature) && !isDate(dateDebutSignature)) { showWarning("Date de remise de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinSignature) && !isDate(dateFinSignature)) { showWarning("Date de remise de fin incorrecte !"); }
		else if (!isEmpty(dateDebutSignature) && !isEmpty(dateFinSignature) && !isDateInterval(dateDebutSignature, dateFinSignature)) { showWarning("Plage de dates de remise incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("TB/Mandats/csvMandat.tmpl");
			qEditionCsv.setParam("Numero_RUM", numeroRUM);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Date_Debut_Signature", dateDebutSignature);
			qEditionCsv.setParam("Date_Fin_Signature", dateFinSignature);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Num_Client", numClient);
			qEditionCsv.setParam("Type_Paiement", typePaiement);
			qEditionCsv.setParam("Type_Mandat", typeMandat);

			var result = qEditionCsv.execute();
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
