/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");



function init() {
  try {

		document.getElementById('news').setAttribute("src", "https://connect.opensi.fr/actus-frame");
		initActivite();

  } catch (e) {
    recup_erreur(e);
  }
}


function goToMenu(m) {
  try {

		switch(m) {
			case 1:	 window.location = "chrome://opensi/content/tb/virements/gestionVirements.xul?"+ cookie();						break;
			case 2:	 window.location = "chrome://opensi/content/tb/virements/preparationVirements.xul?"+ cookie();				break;
			case 3:  window.location = "chrome://opensi/content/tb/prelevements/gestionPrelevements.xul?"+ cookie();			break;
			case 4:	 window.location = "chrome://opensi/content/tb/prelevements/preparationPrelevements.xul?"+ cookie();	break;
			case 5:	 window.location = "chrome://opensi/content/tb/mandats/gestionMandats.xul?"+ cookie();								break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initActivite() {
  try {

		var querySuivi = new QueryHttp("TB/getIndicateursCles.tmpl");
		var result = querySuivi.execute();

    var contenu = result.responseXML.documentElement;

    document.getElementById('VirMoisN').value = contenu.getAttribute('VirMoisN') +" \u20AC";
		document.getElementById('VirMoisN1').value = contenu.getAttribute('VirMoisN1') +" \u20AC";
		document.getElementById('VirAnneeN').value = contenu.getAttribute('VirAnneeN') +" \u20AC";
		document.getElementById('VirAnneeN1').value = contenu.getAttribute('VirAnneeN1') +" \u20AC";
		document.getElementById('NbMandats').value = contenu.getAttribute('NbMandats');
		document.getElementById('PrelMoisN').value = contenu.getAttribute('PrelMoisN') +" \u20AC";
		document.getElementById('PrelMoisN1').value = contenu.getAttribute('PrelMoisN1') +" \u20AC";
		document.getElementById('PrelAnneeN').value = contenu.getAttribute('PrelAnneeN') +" \u20AC";
    document.getElementById('PrelAnneeN1').value = contenu.getAttribute('PrelAnneeN1') +" \u20AC";

	} catch (e) {
    recup_erreur(e);
  }
}


function retourChoixDossier() {
	try {

    window.location = "chrome://opensi/content/tb/menu.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}
