/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oerp_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'oerp-banque');
var oerp_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oerp-etablissement');
var oerp_aPrelevements = new Arbre('TB/Prelevements/list-prelevement.tmpl', 'oerp-tPrelevements');

var oerp_remiseId;
var oerp_mode;
var oerp_etatRemise;
var oerp_modified = false;
var oerp_curBanque;
var oerp_curEtablissement;
var oerp_curMandatId = "";
var oerp_defautComptaGlobale;


function oerp_init() {
	try {

		oerp_defautComptaGlobale = getConfig().isTBComptaLotPre();

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_chargerBanque(selection) {
	try {

		oerp_curBanque = selection;
		oerp_aBanques.setParam("Selection", selection);
		oerp_aBanques.initTree(oerp_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_initBanque() {
	try {

		document.getElementById('oerp-banque').value = oerp_curBanque;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_chargerEtablissement(selection) {
	try {

		oerp_curEtablissement = selection;
		oerp_aEtablissements.setParam("Selection", selection);
		oerp_aEtablissements.initTree(oerp_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_initEtablissement() {
	try {

		document.getElementById('oerp-etablissement').value = oerp_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_initIHM() {
	try {

		document.getElementById('oerp-bEnregistrerRV').collapsed = oerp_mode=="V";
		document.getElementById('oerp-bSupprimerRV').collapsed = oerp_mode!="M";
		document.getElementById('oerp-bAnnulerRV').collapsed = oerp_mode!="V" || oerp_etatRemise=="A";
		document.getElementById('oerp-bVisualiserRV').collapsed = oerp_mode!="V";
		document.getElementById('oerp-bValiderRV').collapsed = oerp_mode!="M";
		document.getElementById('oerp-bExportSepaRV').collapsed = oerp_mode!="V";

		document.getElementById('oerp-lignePrelevement').collapsed = oerp_mode=="V" || oerp_etatRemise=="P";
		oerp_annulerLigne();

		document.getElementById('oerp-dateEcheance').disabled = oerp_mode=="V";
		document.getElementById('oerp-refLot').disabled = oerp_mode=="V";
		document.getElementById('oerp-comptaGlobale').disabled = oerp_mode=="V";
		document.getElementById('oerp-commentaires').disabled = oerp_mode=="V";
		document.getElementById('oerp-banque').disabled = oerp_mode=="V";
		document.getElementById('oerp-etablissement').disabled = oerp_mode=="V" || oerp_etatRemise=="P" || oerp_aPrelevements.nbLignes()>0;

		document.getElementById('oerp-tPrelevements').disabled = false;

		oerp_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_nouvelleRemise() {
  try {

		document.getElementById('oerp-deckRemise').selectedIndex = 0;
		document.getElementById('oerp-tPrelevements').disabled = true;

		oerp_mode = "C";
		oerp_etatRemise = "N";
  	oerp_chargerBanque("");
		oerp_chargerEtablissement(etablissementDefaut);
		oerp_aPrelevements.deleteTree();

		document.getElementById('oerp-numRemise').value = "";
		document.getElementById('oerp-dateRemise').value = "";
		document.getElementById('oerp-etat').value = "Nouveau";
		document.getElementById('oerp-nbTransactions').value = "0";
		document.getElementById('oerp-montantTotal').value = "0.00";
		document.getElementById('oerp-dateEcheance').value = "";
		document.getElementById('oerp-refLot').value = "";
		document.getElementById('oerp-comptaGlobale').checked = oerp_defautComptaGlobale;
		document.getElementById('oerp-commentaires').value = "";

		document.getElementById('oerp-creation').setAttribute("label", "");
		document.getElementById('oerp-modification').setAttribute("label", "");
		document.getElementById('oerp-document').setAttribute("label", "");

		oerp_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerp_chargerRemise() {
  try {

		document.getElementById('oerp-deckRemise').selectedIndex = 0;
		document.getElementById('oerp-tPrelevements').disabled = true;

		var qLoad = new QueryHttp('TB/Prelevements/loadRemise.tmpl');
		qLoad.setParam("Remise_Id", oerp_remiseId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oerp_etatRemise = contenu.getAttribute("Etat");
		oerp_mode = (oerp_etatRemise=="N" || oerp_etatRemise=="P"?"M":"V");

		oerp_chargerBanque(contenu.getAttribute('Banque_Id'));
		oerp_chargerEtablissement(contenu.getAttribute('Etab_Id'));

		document.getElementById('oerp-numRemise').value = contenu.getAttribute("Num_Remise");
		document.getElementById('oerp-dateRemise').value = contenu.getAttribute("Date_Remise");
		document.getElementById('oerp-etat').value = contenu.getAttribute("Libelle_Etat");
		document.getElementById('oerp-montantTotal').value = contenu.getAttribute("Total");
		document.getElementById('oerp-nbTransactions').value = contenu.getAttribute("Nb_Transactions");
		document.getElementById('oerp-dateEcheance').value = contenu.getAttribute("Date_Echeance");
		document.getElementById('oerp-refLot').value = contenu.getAttribute("Ref_Lot");
		document.getElementById('oerp-comptaGlobale').checked = contenu.getAttribute("Compta_Globale")=="true";
		document.getElementById('oerp-commentaires').value = contenu.getAttribute("Commentaires");

		document.getElementById('oerp-creation').setAttribute("label","Remise cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oerp-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oerp-document').setAttribute("label","Remise N\u00B0 "+ contenu.getAttribute('Num_Remise'));

		oerp_aPrelevements.setParam('Remise_Id', oerp_remiseId);
		oerp_aPrelevements.initTree(oerp_initIHM);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerp_refreshTotaux() {
	try {

		var qTotaux = new QueryHttp('TB/Prelevements/getTotauxRemise.tmpl');
		qTotaux.setParam("Remise_Id", oerp_remiseId);
		var result = qTotaux.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oerp-nbTransactions').value = contenu.getAttribute("Nb_Transactions");
		document.getElementById('oerp-montantTotal').value = contenu.getAttribute("Total");

		document.getElementById('oerp-etablissement').disabled = (parseIntBis(contenu.getAttribute("Nb_Transactions"))>0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_enregistrerRemise(rafraichir) {
  try {

  	var ok = false;

		var qSave;

		if (oerp_mode=="C") {
			qSave = new QueryHttp("TB/Prelevements/createRemise.tmpl");
		}
		else {
			qSave = new QueryHttp("TB/Prelevements/updateRemise.tmpl");
			qSave.setParam("Remise_Id", oerp_remiseId);
		}

		var banqueId = document.getElementById('oerp-banque').value;
		var dateEcheance = document.getElementById('oerp-dateEcheance').value;
		var refLot = document.getElementById('oerp-refLot').value;
		var comptaGlobale = document.getElementById('oerp-comptaGlobale').checked;
		var etabId = document.getElementById('oerp-etablissement').value;
		var commentaires = document.getElementById('oerp-commentaires').value;

		var dateRef = new Date(parseDate(getDateCourante()));
		dateRef.setDate(dateRef.getDate()+3);
		var dateJ3 = dateRef.getTime();
		dateRef.setDate(dateRef.getDate()+11);
		var dateJ14 = dateRef.getTime();

		if (isEmpty(dateEcheance)) { showWarning("Veuillez saisir une date d'ex\u00E9cution des prelevements"); }
		else if (isEmpty(etabId)) { showWarning("Veuillez s\u00E9lectionner l'\u00E9tablissement \u00E9metteur des prelevements"); }
		else if (isEmpty(banqueId)) { showWarning("Veuillez s\u00E9lectionner la banque \u00E9mettrice des prelevements"); }
		else if (!isDate(dateEcheance)) { showWarning("Date d'ex\u00E9cution des prelevements incorrecte"); }
		else if (parseDate(dateEcheance)<dateJ3 || parseDate(dateEcheance)>dateJ14) { showWarning("La date d'\u00E9ch\u00E9ance doit \u00EAtre comprise entre J+3 et J+14"); }
		else {

			qSave.setParam("Banque_Id", banqueId);
			qSave.setParam("Date_Echeance", dateEcheance);
			qSave.setParam("Ref_Lot", refLot);
			qSave.setParam("Compta_Globale", comptaGlobale);
			qSave.setParam("Etab_Id", etabId);
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oerp_mode=="C") {
					oerp_remiseId = result.responseXML.documentElement.getAttribute("Remise_Id");
					if (rafraichir) {
						oerp_chargerRemise();
					}
				}

				oerp_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerp_supprimerRemise() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la remise ?")) {

			var qSup = new QueryHttp("TB/Prelevements/deleteRemise.tmpl");
			qSup.setParam("Remise_Id", oerp_remiseId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La remise a \u00E9t\u00E9 supprim\u00E9e.");
				retourMenuPrelevements();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oerp_annulerLigne() {
	try {

		if (oerp_aPrelevements.isSelected()) {
			oerp_aPrelevements.clearSelection();
		}

		oerp_curMandatId = "";
		document.getElementById('oerp-refPrelevement').value = "";
		document.getElementById('oerp-motifPaiement').value = "";
		document.getElementById('oerp-numeroRUM').value = "";
		document.getElementById('oerp-montant').value = "";
		document.getElementById('oerp-bMandat').disabled = false;
		document.getElementById('oerp-bSupprimer').disabled = true;
		document.getElementById('oerp-motifPaiement').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_validerLigne() {
	try {

		var refPrelevement = document.getElementById('oerp-refPrelevement').value;
		var motifPaiement = document.getElementById('oerp-motifPaiement').value;
		var montant = document.getElementById('oerp-montant').value;

		if (isEmpty(montant)) { showWarning("Veuillez saisir le montant du prelevement"); }
		else if (!isPositive(montant)) { showWarning("Montant du prelevement incorrect"); }
		else if (isEmpty(oerp_curMandatId)) { showWarning("Veuillez s\u00E9lectionner un mandat"); }
		else {

			var saved = true;
			if (oerp_mode=="C") {
				saved = oerp_enregistrerRemise(true);
			}

			if (saved) {
				var qValider;

				if (oerp_aPrelevements.isSelected()) {
					var prelevementId = oerp_aPrelevements.getSelectedCellText('oerp-colPrelevementId');
					qValider = new QueryHttp("TB/Prelevements/updatePrelevement.tmpl");
					qValider.setParam("Prelevement_Id", prelevementId);
				}
				else {
					qValider = new QueryHttp("TB/Prelevements/createPrelevement.tmpl");
					qValider.setParam("Remise_Id", oerp_remiseId);
				}

				qValider.setParam("Ref_Prelevement", refPrelevement);
				qValider.setParam("Motif_Paiement", motifPaiement);
				qValider.setParam("Mandat_Id", oerp_curMandatId);
				qValider.setParam("Montant", montant);

				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oerp_aPrelevements.initTree(oerp_annulerLigne);
					oerp_refreshTotaux();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_supprimerLigne() {
	try {

		if (oerp_aPrelevements.isSelected()) {
			var prelevementId = oerp_aPrelevements.getSelectedCellText('oerp-colPrelevementId');

			var qSup = new QueryHttp("TB/Prelevements/deletePrelevement.tmpl");
			qSup.setParam("Prelevement_Id", prelevementId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oerp_aPrelevements.initTree(oerp_annulerLigne);
				oerp_refreshTotaux();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_selectOnPrelevements() {
	try {

		if (oerp_mode!="V" && oerp_aPrelevements.isSelected()) {
			var i = oerp_aPrelevements.getCurrentIndex();
			document.getElementById('oerp-refPrelevement').value = oerp_aPrelevements.getCellText(i,'oerp-colRefPrelevement');
			document.getElementById('oerp-motifPaiement').value = oerp_aPrelevements.getCellText(i,'oerp-colMotifPaiement');
			document.getElementById('oerp-numeroRUM').value = oerp_aPrelevements.getCellText(i,'oerp-colNumeroRUM');
			document.getElementById('oerp-montant').value = oerp_aPrelevements.getCellText(i,'oerp-colMontant');
			oerp_curMandatId = oerp_aPrelevements.getCellText(i,'oerp-colMandatId');
			document.getElementById('oerp-bMandat').disabled = true;
			document.getElementById('oerp-bSupprimer').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_pressOnMontant(ev) {
	try {

		if (ev.keyCode==13) {
			oerp_validerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerp_demandeEnregistrement() {
  try {

		if (oerp_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la remise ?")) {
				oerp_enregistrerRemise(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerp_setModified(m) {
  try {

  	oerp_modified = m;
		if (m) {
			document.getElementById('oerp-capRemise').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oerp-bValiderRV').disabled = true;
		}
		else {
			document.getElementById('oerp-capRemise').setAttribute('image', null);
			document.getElementById('oerp-bValiderRV').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oerp_editerRemise() {
	try {

		document.getElementById('oerp-pdfRemise').setAttribute("src", "");
		document.getElementById("bRetourRemisePrelevements").collapsed = false;
		document.getElementById("oerp-deckRemise").selectedIndex = 1;

		var qGenPdf = new QueryHttp("TB/Prelevements/pdfRemise.tmpl");
		qGenPdf.setParam('Remise_Id', oerp_remiseId);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oerp-pdfRemise').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_validerRemise() {
  try {

		var dateEcheance = document.getElementById('oerp-dateEcheance').value;
		var dateRef = new Date(parseDate(getDateCourante()));
		dateRef.setDate(dateRef.getDate()+3);
		var dateJ3 = dateRef.getTime();
		dateRef.setDate(dateRef.getDate()+11);
		var dateJ14 = dateRef.getTime();

		if (oerp_aPrelevements.nbLignes()==0) {
			showWarning("La remise ne contient aucune ligne.");
		}
		else if (parseDate(dateEcheance)<dateJ3 || parseDate(dateEcheance)>dateJ14) { showWarning("La date d'\u00E9ch\u00E9ance doit \u00EAtre comprise entre J+3 et J+14"); }
  	else if (window.confirm("Confirmez-vous la validation de la remise ?")) {

			var qValider = new QueryHttp("TB/Prelevements/validRemise.tmpl");
			qValider.setParam('Remise_Id', oerp_remiseId);
			var result = qValider.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oerp_chargerRemise();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oerp_annulerRemise() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la remise ?")) {
			var qAnnuler = new QueryHttp("TB/Prelevements/cancelRemise.tmpl");
			qAnnuler.setParam('Remise_Id', oerp_remiseId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La remise a \u00E9t\u00E9 annul\u00E9e.");
				oerp_chargerRemise();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_downloadSepa() {
	try {

		var qSepa = new QueryHttp("TB/Prelevements/xmlRemisePrelevementSEPA.tmpl");
		qSepa.setParam("Remise_Id", oerp_remiseId);

		var result = qSepa.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierXML');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_rechercherMandat() {
	try {

		var etablissement = document.getElementById('oerp-etablissement').value;
		var url = "chrome://opensi/content/tb/mandats/popup-rechercheMandat.xul?"+ cookie();
    window.openDialog(url,'','chrome,modal,centerscreen', oerp_retourRechercherMandat, etablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oerp_retourRechercherMandat(numeroRUM, mandatId) {
	try {

		document.getElementById('oerp-numeroRUM').value = numeroRUM;
		oerp_curMandatId = mandatId;
		document.getElementById('oerp-montant').focus();

	} catch (e) {
    recup_erreur(e);
  }
}
