/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omp_aRemises = new Arbre('TB/Prelevements/list-remisePrelevement.tmpl', 'omp-tRemises');
var omp_aApercuRemise = new Arbre('TB/Prelevements/list-apercuRemisePrelevement.tmpl', 'omp-apercu');
var omp_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'omp-banque');
var omp_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omp-etablissement');
var omp_qListRP = new QueryHttp("TB/Prelevements/getDataListRP.tmpl");

var omp_pageCourante;
var omp_nbPages;
var omp_prep = false;


function omp_init() {
  try {

		omp_prep = (ParamValeur("Prepa")=="true");
		omp_aBanques.initTree();
		omp_aEtablissements.initTree(omp_initCriteres);

	} catch (e) {
  	recup_erreur(e);
  }
}


function omp_initCriteres() {
	try {

		document.getElementById('omp-numRemise').value = "";
		document.getElementById('omp-etat').value = omp_prep?"P":"N";
		document.getElementById('omp-banque').value = "";
		document.getElementById('omp-etablissement').value = etablissementDefaut;
		document.getElementById('omp-dateDebutRem').value = "";
		document.getElementById('omp-dateFinRem').value = "";
		document.getElementById('omp-dateDebutEch').value = "";
		document.getElementById('omp-dateFinEch').value = "";
		document.getElementById('omp-numPrelevement').value = "";
		document.getElementById('omp-refLot').value = "";
		document.getElementById('omp-montant').value = "";
		document.getElementById('omp-debiteur').value = "";
		document.getElementById('omp-motifPaiement').value = "";
		omp_listerRemises();

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_listerRemises() {
	try {

		var numRemise = document.getElementById('omp-numRemise').value;
		var etat = document.getElementById('omp-etat').value;
		var banque = document.getElementById('omp-banque').value;
		var etablissement = document.getElementById('omp-etablissement').value;
		var dateDebutRem = document.getElementById('omp-dateDebutRem').value;
		var dateFinRem = document.getElementById('omp-dateFinRem').value;
		var dateDebutEch = document.getElementById('omp-dateDebutEch').value;
		var dateFinEch = document.getElementById('omp-dateFinEch').value;
		var numPrelevement = document.getElementById('omp-numPrelevement').value;
		var refLot = document.getElementById('omp-refLot').value;
		var montant = document.getElementById('omp-montant').value;
		var debiteur = document.getElementById('omp-debiteur').value;
		var motifPaiement = document.getElementById('omp-motifPaiement').value;
		var nbLignesParPage = document.getElementById('omp-nbLignesParPage').value;

		if (!isEmpty(montant) && !isPositiveOrNull(montant)) { showWarning("Le montant est incorrect !"); }
		else if (!isEmpty(dateDebutRem) && !isDate(dateDebutRem)) { showWarning("Date de remise de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinRem) && !isDate(dateFinRem)) { showWarning("Date de remise de fin incorrecte !"); }
		else if (!isEmpty(dateDebutRem) && !isEmpty(dateFinRem) && !isDateInterval(dateDebutRem, dateFinRem)) { showWarning("Plage de dates de remise incorrecte !"); }
		else if (!isEmpty(dateDebutEch) && !isDate(dateDebutEch)) { showWarning("Date d'ex\u00E9cution de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinEch) && !isDate(dateFinEch)) { showWarning("Date d'ex\u00E9cution de fin incorrecte !"); }
		else if (!isEmpty(dateDebutEch) && !isEmpty(dateFinEch) && !isDateInterval(dateDebutEch, dateFinEch)) { showWarning("Plage de dates d'ex\u00E9cution incorrecte !"); }
		else {

			omp_pageCourante = 1;
			omp_nbPages = 1;
			document.getElementById('omp-pageDeb').value = 1;
			document.getElementById('omp-pageFin').value = 1;
			document.getElementById('omp-bPrec').disabled = true;
			document.getElementById('omp-bSuiv').disabled = true;

			document.getElementById('omp-tRemises').disabled = true;
			document.getElementById('omp-bEditionCsv').disabled = true;
			document.getElementById('omp-numRemiseSelect').value = "";
			omp_aApercuRemise.deleteTree();
			omp_aRemises.deleteTree();

			omp_qListRP.setParam("Num_Remise", numRemise);
			omp_qListRP.setParam("Etat", etat);
			omp_qListRP.setParam("Banque", banque);
			omp_qListRP.setParam("Etablissement", etablissement);
			omp_qListRP.setParam("Date_Debut_Rem", dateDebutRem);
			omp_qListRP.setParam("Date_Fin_Rem", dateFinRem);
			omp_qListRP.setParam("Date_Debut_Ech", dateDebutEch);
			omp_qListRP.setParam("Date_Fin_Ech", dateFinEch);
			omp_qListRP.setParam("Num_Prelevement", numPrelevement);
			omp_qListRP.setParam("Ref_Lot", refLot);
			omp_qListRP.setParam("Montant", montant);
			omp_qListRP.setParam("Debiteur", debiteur);
			omp_qListRP.setParam("Motif_Paiement", motifPaiement);
			omp_qListRP.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omp_qListRP.setParam("Current_Page", omp_pageCourante);

			var result = omp_qListRP.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('omp-totalRemises').value = contenu.getAttribute("Total");
			omp_nbPages = contenu.getAttribute("Nb_Pages");
			var listRemiseId = contenu.getAttribute("List_Remise_Id");

			omp_aRemises.setParam("List_Remise_Id", listRemiseId);
			omp_aRemises.initTree(omp_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_initPagination() {
	try {

		document.getElementById('omp-pageDeb').value = omp_pageCourante;
		document.getElementById('omp-pageFin').value = (omp_nbPages>0?omp_nbPages:1);
		document.getElementById('omp-bPrec').disabled = (omp_pageCourante==1);
		document.getElementById('omp-bSuiv').disabled = (omp_pageCourante>=omp_nbPages); // peut se produire si omp_nbPages=0

		document.getElementById('omp-tRemises').disabled = false;
		document.getElementById('omp-bEditionCsv').disabled = (omp_aRemises.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_pressOnPagePrec() {
	try {

		omp_pageCourante--;
		omp_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_pressOnPageSuiv() {
	try {

		omp_pageCourante++;
		omp_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_majPagination() {
	try {

		document.getElementById('omp-pageDeb').value = omp_pageCourante;
		document.getElementById('omp-bPrec').disabled = (omp_pageCourante==1);
		document.getElementById('omp-bSuiv').disabled = (omp_pageCourante==omp_nbPages);

		document.getElementById('omp-numRemiseSelect').value = "";

		document.getElementById('omp-tRemises').disabled = true;
		document.getElementById('omp-bEditionCsv').disabled = true;
		omp_aApercuRemise.deleteTree();

		omp_qListRP.setParam("Current_Page", omp_pageCourante);
		var result = omp_qListRP.execute();
		var listRemiseId = result.responseXML.documentElement.getAttribute("List_Remise_Id");

		omp_aRemises.setParam("List_Remise_Id", listRemiseId);
		omp_aRemises.initTree(omp_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_afterMajPagination() {
	try {

		document.getElementById('omp-tRemises').disabled = false;
		document.getElementById('omp-bEditionCsv').disabled=(omp_aRemises.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_selectOnListeRemises() {
	try {

		if (omp_aRemises.isSelected()) {
			var remiseId = omp_aRemises.getSelectedCellText('omp-colRemiseId');
			document.getElementById('omp-numRemiseSelect').value = omp_aRemises.getSelectedCellText('omp-colNumRemise');
			omp_aApercuRemise.setParam("Remise_Id", remiseId);
			omp_aApercuRemise.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_pressOnNouvelleRemise() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuPrelevements').collapsed = false;
		oerp_nouvelleRemise();

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omp_listerRemises();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omp_pressOnListeRemises(ev) {
  try {

		if (ev.keyCode==13) {
			omp_ouvrirRemise();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omp_ouvrirRemise() {
  try {

  	if (omp_aRemises.isSelected()) {
			var remiseId = omp_aRemises.getSelectedCellText('omp-colRemiseId');
			document.getElementById('bMenuPrelevements').collapsed = false;

			document.getElementById('deck').selectedIndex = 1;
			oerp_remiseId = remiseId;
			oerp_chargerRemise();
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omp_pressOnEditionCsv() {
	try {

		var numRemise = document.getElementById('omp-numRemise').value;
		var etat = document.getElementById('omp-etat').value;
		var banque = document.getElementById('omp-banque').value;
		var etablissement = document.getElementById('omp-etablissement').value;
		var dateDebutRem = document.getElementById('omp-dateDebutRem').value;
		var dateFinRem = document.getElementById('omp-dateFinRem').value;
		var dateDebutEch = document.getElementById('omp-dateDebutEch').value;
		var dateFinEch = document.getElementById('omp-dateFinEch').value;
		var numPrelevement = document.getElementById('omp-numPrelevement').value;
		var refLot = document.getElementById('omp-refLot').value;
		var montant = document.getElementById('omp-montant').value;
		var debiteur = document.getElementById('omp-debiteur').value;
		var motifPaiement = document.getElementById('omp-motifPaiement').value;

		if (!isEmpty(montant) && !isPositiveOrNull(montant)) { showWarning("Le montant est incorrect !"); }
		else if (!isEmpty(dateDebutRem) && !isDate(dateDebutRem)) { showWarning("Date de remise de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinRem) && !isDate(dateFinRem)) { showWarning("Date de remise de fin incorrecte !"); }
		else if (!isEmpty(dateDebutRem) && !isEmpty(dateFinRem) && !isDateInterval(dateDebutRem, dateFinRem)) { showWarning("Plage de dates de remise incorrecte !"); }
		else if (!isEmpty(dateDebutEch) && !isDate(dateDebutEch)) { showWarning("Date d'ex\u00E9cution de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFinEch) && !isDate(dateFinEch)) { showWarning("Date d'ex\u00E9cution de fin incorrecte !"); }
		else if (!isEmpty(dateDebutEch) && !isEmpty(dateFinEch) && !isDateInterval(dateDebutEch, dateFinEch)) { showWarning("Plage de dates d'ex\u00E9cution incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("TB/Prelevements/csvRemisePrelevement.tmpl");
			qEditionCsv.setParam("Num_Remise", numRemise);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Banque", banque);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Date_Debut_Rem", dateDebutRem);
			qEditionCsv.setParam("Date_Fin_Rem", dateFinRem);
			qEditionCsv.setParam("Date_Debut_Ech", dateDebutEch);
			qEditionCsv.setParam("Date_Fin_Ech", dateFinEch);
			qEditionCsv.setParam("Num_Prelevement", numPrelevement);
			qEditionCsv.setParam("Ref_Lot", refLot);
			qEditionCsv.setParam("Montant", montant);
			qEditionCsv.setParam("Debiteur", debiteur);
			qEditionCsv.setParam("Motif_Paiement", motifPaiement);

			var result = qEditionCsv.execute();
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omp_supprimerPreparations() {
  try {

		if (confirm("Confirmez-vous la suppression des remises de pr\u00E9l\u00E8vement en pr\u00E9paration ?")) {
			document.getElementById('omp-bSupprimerPrep').disabled = true;
			var qSup = new QueryHttp("TB/Prelevements/deletePreparations.tmpl");
			qSup.execute(omp_listerRemises);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}
