/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aEcheances = new Arbre('TB/Prelevements/list-echeancePrelevement.tmpl', 'tEcheances');
var aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'etablissement');

var nf2 = new NumberFormat("0.00", true);
var etablissementDefaut;



function init() {
	try {

		etablissementDefaut = getProfil().getEtabId();

		var qPossible = new QueryHttp("TB/Prelevements/isPreparationPossible.tmpl");
		var result = qPossible.execute();

		var possible = (result.responseXML.documentElement.getAttribute('Possible')=="true");

		if (possible) {
			aEtablissements.setParam("Selection", etablissementDefaut);
			aEtablissements.initTree(initFiltres);
		}
		else if (window.confirm("Impossible de pr\u00E9parer les remises de pr\u00E9l\u00E8vements.\nVous devez d'abord valider ou supprimer les remises en pr\u00E9paration.\nVoulez-vous voir les remises en pr\u00E9paration ?")) {
			window.location = "chrome://opensi/content/tb/prelevements/gestionPrelevements.xul?"+ cookie() +"&Prepa=true";
		}
		else {
			retourMenuPrincipal();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initFiltres() {
	try {

		document.getElementById('dateDebutEcheance').value = "";
		document.getElementById('dateFinEcheance').value = "";
		document.getElementById('etablissement').value = etablissementDefaut;
		listerEcheances();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnFiltre(event) {
	try {

		if (event.keyCode==13) {
			listerEcheances();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDateEcheance(event) {
	try {

		if (event.keyCode==13) {
			modifierDateEcheance();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function genererRemises() {
	try {

		document.getElementById("bGenerer").disabled = true;

		var nbCoches = 0;
		var listEP = "";

		for (var i=0; i<aEcheances.nbLignes(); i++) {
			if (aEcheances.getCellValue(i, "colSelect")=="true") {
				nbCoches++;
				listEP += aEcheances.getCellText(i, "colEcheance_Id") +",";
			}
  	}

		if (nbCoches<=0) {
			showWarning("Veuillez cocher au moins une ligne d'\u00E9ch\u00E9ance");
		}
		else {

			var qGenRem = new QueryHttp("TB/Prelevements/validPreparationRP.tmpl");
			qGenRem.setParam('ListEP', listEP);
			qGenRem.setParam('Etab_Id', document.getElementById('etablissement').value);

			var result = qGenRem.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.location = "chrome://opensi/content/tb/prelevements/gestionPrelevements.xul?"+ cookie() +"&Prepa=true";
			}
		}

		document.getElementById("bGenerer").disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function modifierDateEcheance() {
	try {

		var nbCoches = 0;
		var listEP = "";

		var dateEcheance = document.getElementById('dateEcheance').value;

		for (var i=0; i<aEcheances.nbLignes(); i++) {
			if (aEcheances.getCellValue(i, "colSelect")=="true") {
				nbCoches++;
				listEP += aEcheances.getCellText(i, "colEcheance_Id") +",";
			}
  	}

		if (!isDate(dateEcheance)) {
			showWarning("Nouvelle date d'\u00E9ch\u00E9ance incorrecte");
		}
		else if (parseDate(dateEcheance)<parseDate(getDateCourante())) {
			showWarning("La nouvelle date d'\u00E9ch\u00E9ance ne peut-\u00EAtre inf\u00E9rieure \u00E0 la date du jour");
		}
		else if (nbCoches<=0) {
			showWarning("Veuillez cocher au moins une ligne d'\u00E9ch\u00E9ance");
		}
		else if (window.confirm("Confirmez-vous le changement de date d'\u00E9ch\u00E9ance pour les \u00E9ch\u00E9ances s\u00E9lectionn\u00E9es ?")) {

			var qGenRem = new QueryHttp("TB/Prelevements/updateDateEcheance.tmpl");
			qGenRem.setParam('ListEP', listEP);
			qGenRem.setParam('Date_Echeance', dateEcheance);

			var result = qGenRem.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				listerEcheances();
				document.getElementById('dateEcheance').value = "";
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function listerEcheances() {
	try {

		var dateDebutEcheance = document.getElementById('dateDebutEcheance').value;
		var dateFinEcheance = document.getElementById('dateFinEcheance').value;

		if (!isEmpty(dateDebutEcheance) && !isDate(dateDebutEcheance)) { showWarning("Date de d\u00E9but \u00E9ch\u00E9ance incorrecte"); }
		else if (!isEmpty(dateFinEcheance) && !isDate(dateFinEcheance)) { showWarning("Date de fin \u00E9ch\u00E9ance incorrecte"); }
		else if (!isEmpty(dateDebutEcheance) && !isEmpty(dateFinEcheance) && !isDateInterval(dateDebutEcheance, dateFinEcheance)) { showWarning("Plage de dates d'\u00E9ch\u00E9ances incorrecte"); }
		else {

			aEcheances.setParam("Date_Debut_Echeance", dateDebutEcheance);
			aEcheances.setParam("Date_Fin_Echeance", dateFinEcheance);
			aEcheances.setParam("Etab_Id", document.getElementById('etablissement').value);

			aEcheances.initTree(refreshTotaux);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aEcheances.nbLignes(); i++) {

			if (aEcheances.isEditable(i, "colSelect")) {
				aEcheances.setCellValue(i, "colSelect", b);
  		}
		}

		refreshTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function refreshTotaux() {
	try {

		var nbCoches = 0;
		var total = 0;

		for (var i=0; i<aEcheances.nbLignes(); i++) {
			if (aEcheances.getCellValue(i, "colSelect")=="true") {
				nbCoches++;
				total += parseFloat(aEcheances.getCellText(i, "colMontant"));
			}
  	}

		document.getElementById('lblNbLignesCochees').value = nbCoches;
		document.getElementById('totalEcheances').value = nf2.format(total);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnEcheances(ev) {
	try {

		if (ev.keyCode==32 && aEcheances.isSelected()) {
			aEcheances.setSelectedCellValue("colSelect", aEcheances.getSelectedCellValue("colSelect")=="false");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/tb/prelevements/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}



function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/tb/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
