/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aBeneficiaires = new Arbre('TB/Virements/list-beneficiaire.tmpl', 'tBeneficiaires');



function init() {
  try {

		document.getElementById('numTiers').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCriteres(ev) {
  try {

		if (ev.keyCode==13) {
			listerBeneficiaires();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnListeBeneficiaires(ev) {
  try {

    if (ev.keyCode==13) {
			ouvrirBeneficiaire();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirBeneficiaire() {
  try {

		if (aBeneficiaires.isSelected()) {

			var nomSEPA = aBeneficiaires.getSelectedCellText('colNomSEPA');
			var tiersId = aBeneficiaires.getSelectedCellText('colTiersId');
			var typeTiers = aBeneficiaires.getSelectedCellText('colTypeTiers');
			var beneficiaire = isEmpty(nomSEPA)?aBeneficiaires.getSelectedCellText('colDenomination'):nomSEPA;
			var iban = aBeneficiaires.getSelectedCellText('colIBAN');
			var bic = aBeneficiaires.getSelectedCellText('colBIC');

			window.arguments[0](typeTiers, tiersId, beneficiaire, iban, bic);
    	window.close();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function listerBeneficiaires() {
	try {

		var numTiers = document.getElementById('numTiers').value;
		var denomination = document.getElementById('denomination').value;
		var nomSEPA = document.getElementById('nomSEPA').value;
		var typeTiers = document.getElementById('typeTiers').value;

		aBeneficiaires.setParam("Num_Tiers", numTiers);
		aBeneficiaires.setParam("Denomination", denomination);
		aBeneficiaires.setParam("Nom_SEPA", nomSEPA);
		aBeneficiaires.setParam("Type_Tiers", typeTiers);
		aBeneficiaires.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function reinitialiser() {
	try {

		aBeneficiaires.deleteTree();

		document.getElementById('numTiers').value = "";
		document.getElementById('denomination').value = "";
		document.getElementById('nomSEPA').value = "";
		document.getElementById('typeTiers').value = "";

	} catch (e) {
    recup_erreur(e);
  }
}

