Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;

function alert(title, message) {
  if (!title)
    title = "message";
  var promptService = Cc["@mozilla.org/embedcomp/prompt-service;1"].getService(Ci.nsIPromptService);
  promptService.alert(null, title, message);
}

function nsOpenDownloadListeners() {
  this.wrappedJSObject = this;
}

nsOpenDownloadListeners.prototype = {
  classDescription: "Open Download Listeners",
  classID:          Components.ID("{e59364a7-d8fd-4fa3-a173-1a5fc70bc6fa}"),
  contractID:       "@mozmonkey.com/opendownload/listeners;1",

  QueryInterface: XPCOMUtils.generateQI([Ci.nsISupports, Ci.nsIObserver]),

  // Is it currently listening?
	listening: false,

  // File download queue
	queue: [],

  addDownload: function(path) {
    this.queue.push(path);
  },

  // Start listening for downloads
	startListening: function() {

		this.listening = true;
		// Listeners
		var observerService = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);
		observerService.addObserver(this, "dl-done", false);
		observerService.addObserver(this, "dl-cancel", false);
		observerService.addObserver(this, "dl-failed", false);
    observerService.addObserver(this, "quit-application", false);
	},

  stopListening: function() {

    this.listening = false;
    var observerService = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);
		observerService.removeObserver(this, "dl-done");
		observerService.removeObserver(this, "dl-cancel");
		observerService.removeObserver(this, "dl-failed");
    observerService.removeObserver(this, "quit-application");
  },

  // Catch observer flags
	observe: function(subject, topic, data) { 

    var file = subject.QueryInterface(Ci.nsIDownload).targetFile;
		switch (topic) {
			case "dl-cancel":
			case "dl-failed":
				this.removeFromQueue(file.path);
			  break;
			case "dl-done":
		    // File in queue
		    if (this.inQueue(file.path) >= 0)
			    this.launchFile(file);
			  break;
      case "quit-application":
				this.stopListening();
			  break;
		}
	},

  // Launch the file
	launchFile: function(file) {
		try {
		  // Execute	 
		  var process = Cc["@mozilla.org/process/util;1"].createInstance(Ci.nsIProcess);
      process.init(file);
      var args = [];
		  process.run(false, args, args.length);
    } catch (e) {
      if (e.result == Cr.NS_ERROR_FILE_EXECUTION_FAILED) {
        if (this.inQueue(file.path) != -1) {
          this.removeFromQueue(file.path);
          try {
			      // Remove
			      file.remove(false);
          } catch (e) {}
        }
      } else {
        alert("An unknown error occurred.\n" + e);
      }
    }
	},

  // Remove file from download queue
	removeFromQueue: function(path) {
		var index = -1;
		if ((index = this.inQueue(path)) > -1)
			this.queue = (new Array()).concat(this.queue.slice(0, index), this.queue.slice(++index));
	},

  // Check if file path is in queue
	inQueue: function(path) {
    for (var i = 0; i < this.queue.length; i++)
			if (this.queue[i] == path)
				return i;
		  return -1;
	}
};

var components = [nsOpenDownloadListeners];
if (XPCOMUtils.generateNSGetFactory)
  var NSGetFactory = XPCOMUtils.generateNSGetFactory(components);
else
  var NSGetModule = XPCOMUtils.generateNSGetModule(components);