/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oea_aLignes = new Arbre("Compta/AbonnementsEcriture/list-ligneAbonnementEcriture.tmpl", "oea-listeLigneAbonnementEcriture");
var oea_aEcheances = new Arbre("Compta/AbonnementsEcriture/list-echeanceAbonnementEcriture.tmpl", "oea-listeEcheanceAbonnementEcriture");
var oea_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "oea-modeReglement");
var oea_aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'oea-journal');

var oea_abonnementId;
var oea_ligneId;
var oea_curModeReglement;
var oea_curJournal;
var oea_modified = false;



function oea_init() {
	try {

		oea_aJournaux.setParam("Sans_AN", true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerModeReglement(selection) {
	try {

		oea_curModeReglement = selection;
		oea_aModesReglement.setParam("Selection", selection);
		oea_aModesReglement.initTree(oea_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initModeReglement() {
	try {

		document.getElementById('oea-modeReglement').value = oea_curModeReglement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerJournal(selection) {
	try {

		oea_curJournal = selection;
		oea_aJournaux.setParam("Selection", selection);
		oea_aJournaux.initTree(oea_initJournal);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initJournal() {
	try {

		document.getElementById('oea-journal').value = oea_curJournal;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_nouveauAbonnement() {
	try {

		oea_abonnementId = "";

 		oea_annulerLigneAbonnement();
  	oea_aLignes.deleteTree();
  	oea_aEcheances.deleteTree();
		document.getElementById('oea-boxEcheances').collapsed = true;
		document.getElementById('oea-ligneSaisie').collapsed = false;

		document.getElementById('oea-libelle').disabled = false;
		document.getElementById('oea-dateDebutAbt').disabled = false;
		document.getElementById('oea-dateFinAbt').disabled = false;
		document.getElementById('oea-periodicite').disabled = false;
		document.getElementById('oea-dateFinMois').disabled = false;
		document.getElementById('oea-jourEcriture').disabled = false;
		document.getElementById('oea-journal').disabled = false;

		document.getElementById('oea-etat').value = "";
  	document.getElementById('oea-libelle').value = "";
		document.getElementById('oea-dateDebutAbt').value = "";
		document.getElementById('oea-dateFinAbt').value = "";
		document.getElementById('oea-periodicite').value = "";
		document.getElementById('oea-dateFinMois').checked = false;
		document.getElementById('oea-jourEcriture').value = "";
		oea_chargerJournal("");

		oea_pressOnDateFinMois();
		oea_pressOnPeriodicite();

		document.getElementById('oea-bEnregistrer').collapsed = false;
		document.getElementById('oea-bSupprimer').collapsed = true;
		document.getElementById('oea-bCopier').collapsed = true;
		document.getElementById('oea-bValider').collapsed = true;
		document.getElementById('oea-bAnnuler').collapsed = true;
		document.getElementById('oea-bEnregistrerLigne').disabled = true;

		oea_setModified(false);

		document.getElementById('oea-libelle').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerAbonnement() {
	try {

		var qLoad = new QueryHttp("Compta/AbonnementsEcriture/loadAbonnementEcriture.tmpl");
		qLoad.setParam("Abonnement_Id", oea_abonnementId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		var etat = contenu.getAttribute('Etat');

		document.getElementById('oea-etat').value = contenu.getAttribute('Lib_Etat');
		document.getElementById('oea-libelle').value = contenu.getAttribute('Libelle');
		document.getElementById('oea-dateDebutAbt').value = contenu.getAttribute('Date_Debut_Abt');
		document.getElementById('oea-dateFinAbt').value = contenu.getAttribute('Date_Fin_Abt');
		document.getElementById('oea-periodicite').value = contenu.getAttribute('Periodicite');
		document.getElementById('oea-dateFinMois').checked = contenu.getAttribute('Date_Fin_Mois')=="true";
		document.getElementById('oea-jourEcriture').value = contenu.getAttribute('Jour_Ecriture');
		oea_chargerJournal(contenu.getAttribute('Journal_Id'));

		document.getElementById('oea-libelle').disabled = etat!='N';
		document.getElementById('oea-dateDebutAbt').disabled = etat!='N';
		document.getElementById('oea-dateFinAbt').disabled = etat!='N';
		document.getElementById('oea-periodicite').disabled = etat!='N';
		document.getElementById('oea-dateFinMois').disabled = etat!='N';
		document.getElementById('oea-jourEcriture').disabled = etat!='N';
		document.getElementById('oea-journal').disabled = etat!='N';

		oea_pressOnDateFinMois();
		oea_pressOnPeriodicite();

		oea_aLignes.setParam("Abonnement_Id", oea_abonnementId);
		oea_aLignes.initTree(oea_annulerLigneAbonnement);

		oea_aEcheances.setParam("Abonnement_Id", oea_abonnementId);
		oea_aEcheances.initTree();

		document.getElementById('oea-boxEcheances').collapsed = etat=='N';
		document.getElementById('oea-ligneSaisie').collapsed = etat!='N';
		var hasEchGen = contenu.getAttribute('Has_Ech_Gen')=="true";

		document.getElementById('oea-bEnregistrer').collapsed = etat!='N';
		document.getElementById('oea-bSupprimer').collapsed = (etat!='N' && etat!='T') || hasEchGen;
		document.getElementById('oea-bAnnuler').collapsed = etat!='T' || !hasEchGen;
		document.getElementById('oea-bCopier').collapsed = false;
		document.getElementById('oea-bValider').collapsed = etat!='N';
		document.getElementById('oea-bEnregistrerLigne').disabled = false;
		document.getElementById('oea-bGenerer').disabled = false;
		document.getElementById('oea-bGenerer').collapsed = etat!='T';
		document.getElementById('oea-colSelect').collapsed = etat!='T';
		document.getElementById('oea-boxCocher').collapsed = etat!='T';

		oea_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_enregistrerAbonnement(rafraichir) {
	try {

		var libelle = document.getElementById('oea-libelle').value;
		var journal = document.getElementById('oea-journal').value;
		var dateDebutAbt = document.getElementById('oea-dateDebutAbt').value;
		var dateFinAbt = document.getElementById('oea-dateFinAbt').value;
		var periodicite = document.getElementById('oea-periodicite').value;
		var dateFinMois = document.getElementById('oea-dateFinMois').checked;
		var jourEcriture = document.getElementById('oea-jourEcriture').value;

		if (isEmpty(libelle)) { showWarning("Libell\u00E9 manquant"); }
		else if (isEmpty(journal)) { showWarning("Journal manquant"); }
		else if (isEmpty(periodicite)) { showWarning("P\u00E9riodicit\u00E9 manquante"); }
		else if (isEmpty(jourEcriture)) { showWarning("Jour d'\u00E9criture manquant"); }
		else if (periodicite!="J" && (parseIntBis(jourEcriture)<1 || parseIntBis(jourEcriture)>31)) { showWarning("Jour d'\u00E9criture incorrect"); }
		else if (!isDate(dateDebutAbt)) { showWarning("Date de d\u00E9but d'abonnement incorrecte"); }
		else if (!isEmpty(dateFinAbt) && !isDate(dateFinAbt)) { showWarning("Date de fin d'abonnement incorrecte"); }
		else if (!isEmpty(dateDebutAbt) && !isEmpty(dateFinAbt) && !isDateInterval(dateDebutAbt, dateFinAbt)) { showWarning("P\u00E9riode d'abonnement incorrecte"); }
		else {
			var qSave;

			if (!isEmpty(oea_abonnementId)) {
				qSave = new QueryHttp("Compta/AbonnementsEcriture/updateAbonnementEcriture.tmpl");
				qSave.setParam("Abonnement_Id", oea_abonnementId);
			}
			else {
				qSave = new QueryHttp("Compta/AbonnementsEcriture/createAbonnementEcriture.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Journal_Id", journal);
			qSave.setParam("Date_Debut_Abt", dateDebutAbt);
			qSave.setParam("Date_Fin_Abt", dateFinAbt);
			qSave.setParam("Periodicite", periodicite);
			qSave.setParam("Date_Fin_Mois", dateFinMois);
			qSave.setParam("Jour_Ecriture", jourEcriture);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (isEmpty(oea_abonnementId)) {
					oea_abonnementId = result.responseXML.documentElement.getAttribute('Abonnement_Id');
					if (rafraichir) {
						oea_chargerAbonnement();
					}
				}

				oea_setModified(false);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_supprimerAbonnement() {
	try {

		if (!isEmpty(oea_abonnementId) && window.confirm("Confirmez-vous la suppression de l'abonnement d'\u00E9criture ?")) {

			var qDelete = new QueryHttp("Compta/AbonnementsEcriture/deleteAbonnementEcriture.tmpl");
			qDelete.setParam("Abonnement_Id", oea_abonnementId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'abonnement a \u00E9t\u00E9 supprim\u00E9");
				retourMenuAbonnements();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_copierAbonnement() {
	try {

		if (window.confirm("Confirmez-vous la copie de l'abonnement d'\u00E9criture ?")) {

			var qCopy = new QueryHttp("Compta/AbonnementsEcriture/copyAbonnementEcriture.tmpl");
			qCopy.setParam("Abonnement_Id", oea_abonnementId);
			var result = qCopy.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_abonnementId = result.responseXML.documentElement.getAttribute('Abonnement_Id');
				oea_chargerAbonnement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_validerAbonnement() {
	try {

		if (window.confirm("Confirmez-vous la validation de l'abonnement d'\u00E9criture ?")) {

			var qValid = new QueryHttp("Compta/AbonnementsEcriture/validAbonnementEcriture.tmpl");
			qValid.setParam("Abonnement_Id", oea_abonnementId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_chargerAbonnement();
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oea_annulerAbonnement() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de l'abonnement d'\u00E9criture ?")) {

			var qCancel = new QueryHttp("Compta/AbonnementsEcriture/cancelAbonnementEcriture.tmpl");
			qCancel.setParam("Abonnement_Id", oea_abonnementId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_chargerAbonnement();
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oea_demandeEnregistrement() {
  try {

		if (oea_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'abonnement ?")) {
				oea_enregistrerAbonnement(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_setModified(m) {
  try {

  	oea_modified = m;
		if (m) {
			document.getElementById('oea-capAbonnement').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oea-bValider').disabled = true;
		}
		else {
			document.getElementById('oea-capAbonnement').setAttribute('image', null);
			document.getElementById('oea-bValider').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_pressOnDateFinMois() {
	try {

		var dateFinMois = document.getElementById('oea-dateFinMois').checked;

		document.getElementById('oea-jourEcriture').disabled = dateFinMois;

		if (dateFinMois) {
			document.getElementById('oea-jourEcriture').value = "31";
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oea_pressOnPeriodicite() {
	try {

		if (document.getElementById('oea-periodicite').value=="J") {
			document.getElementById('oea-dateFinMois').checked = false;
			document.getElementById('oea-dateFinMois').collapsed = true;
			document.getElementById('oea-jourEcriture').collapsed = true;
			document.getElementById('oea-lblJourEcriture').collapsed = true;
			document.getElementById('oea-jourEcriture').value = "0";
		}
		else {
			document.getElementById('oea-dateFinMois').collapsed = false;
			document.getElementById('oea-jourEcriture').collapsed = false;
			document.getElementById('oea-lblJourEcriture').collapsed = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function oea_chargerLigneAbonnement() {
	try {

		if (oea_aLignes.isSelected()) {
			oea_ligneId = oea_aLignes.getSelectedCellText('oea-colLigneId');

			var qLoad = new QueryHttp("Compta/AbonnementsEcriture/loadLigneAbonnementEcriture.tmpl");
			qLoad.setParam("Ligne_Id", oea_ligneId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oea-numCompte').value = contenu.getAttribute("Num_Compte");
				document.getElementById('oea-libelleLA').value = contenu.getAttribute("Libelle");
				document.getElementById('oea-commentaire').value = contenu.getAttribute("Commentaire");
				document.getElementById('oea-debit').value = contenu.getAttribute("Montant_D");
				document.getElementById('oea-credit').value = contenu.getAttribute("Montant_C");
				document.getElementById('oea-numPiece').value = contenu.getAttribute("Num_Piece");
				document.getElementById('oea-periodeLib').checked = contenu.getAttribute("Periode_Lib")=="true";
				oea_chargerModeReglement(contenu.getAttribute("Mode_Reg_Id"));

				document.getElementById('oea-bSupprimerLigne').disabled = false;
				document.getElementById('oea-bAnnulerLigne').disabled = false;
			}
  	}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_annulerLigneAbonnement() {
	try {

		oea_ligneId = "";
		oea_aLignes.clearSelection();

		// si l'abonnement contient des lignes, on charge le libell et le n pice de la dernire ligne
		if (!isEmpty(oea_abonnementId) && oea_aLignes.nbLignes()!=0) {
			var i = oea_aLignes.nbLignes()-1;
			document.getElementById('oea-libelleLA').value = oea_aLignes.getCellText(i, 'oea-colLibelleLA');
			document.getElementById('oea-numPiece').value = oea_aLignes.getCellText(i, 'oea-colNumPiece');
			document.getElementById('oea-periodeLib').checked = oea_aLignes.getCellText(i, 'oea-colPeriodeLib')=="true";
		}
		else {
			document.getElementById('oea-libelleLA').value = "";
			document.getElementById('oea-numPiece').value = "";
			document.getElementById('oea-periodeLib').checked = true;
		}

		document.getElementById('oea-numCompte').value = "";
		document.getElementById('oea-commentaire').value = "";
		document.getElementById('oea-debit').value = "";
		document.getElementById('oea-credit').value = "";
		oea_chargerModeReglement("");

		document.getElementById('oea-bSupprimerLigne').disabled = true;
		document.getElementById('oea-bAnnulerLigne').disabled = true;

		document.getElementById("oea-numCompte").focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_enregistrerLigneAbonnement() {
	try {

		var numCompte = document.getElementById('oea-numCompte').value;
		var libelle = document.getElementById('oea-libelleLA').value;
		var debit = document.getElementById('oea-debit').value;
		var credit = document.getElementById('oea-credit').value;
		var modeReglement = document.getElementById('oea-modeReglement').value;
		var commentaire = document.getElementById('oea-commentaire').value;
		var numPiece = document.getElementById('oea-numPiece').value;
		var periodeLib = document.getElementById('oea-periodeLib').checked;

		if (isEmpty(libelle)) { showWarning("Libell\u00E9 incorrect"); }
		else if (isEmpty(numCompte)) { showWarning("N\u00B0 Compte incorrect"); }
		else if (!isEmpty(debit) && (!isPositive(debit) || !checkNumber(debit,14,2))) { showWarning("Montant au d\u00E9bit incorrect"); }
		else if (!isEmpty(credit) && (!isPositive(credit) || !checkNumber(credit,14,2))) { showWarning("Montant au cr\u00E9dit incorrect"); }
		else if (isEmpty(debit) && isEmpty(credit)) { showWarning("D\u00E9bit ou cr\u00E9dit manquant"); }
		else if (!isEmpty(debit) && !isEmpty(credit)) { showWarning("Veuillez ne saisir qu'un d\u00E9bit ou qu'un cr\u00E9dit"); }
		else {
			var qSave;

			if (!isEmpty(oea_ligneId)) {
				qSave = new QueryHttp("Compta/AbonnementsEcriture/updateLigneAbonnementEcriture.tmpl");
				qSave.setParam("Ligne_Id", oea_ligneId);
			}
			else {
				qSave = new QueryHttp("Compta/AbonnementsEcriture/createLigneAbonnementEcriture.tmpl");
				qSave.setParam("Abonnement_Id", oea_abonnementId);
			}

			qSave.setParam("Num_Compte", numCompte);
			qSave.setParam("Libelle", libelle);
			qSave.setParam("Montant_D", debit);
			qSave.setParam("Montant_C", credit);
			qSave.setParam("Mode_Reg_Id", modeReglement);
			qSave.setParam("Commentaire", commentaire);
			qSave.setParam("Num_Piece", numPiece);
			qSave.setParam("Periode_Lib", periodeLib);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
	  		oea_chargerAbonnement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_supprimerLigneAbonnement() {
	try {

		if (!isEmpty(oea_ligneId)) {
			var qDelete = new QueryHttp("Compta/AbonnementsEcriture/deleteLigneAbonnementEcriture.tmpl");
			qDelete.setParam("Ligne_Id", oea_ligneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
  			oea_chargerAbonnement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_pressOnCompte(ev) {
	try {

		if (ev.keyCode==13) {
			oea_rechercherCompte();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_rechercherCompte() {
	try {

		var numCompte = document.getElementById('oea-numCompte').value;

		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
   	window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherCompte, numCompte, "", "", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById('oea-numCompte').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_pressOnListeEcheanceAbonnementEcriture(ev) {
	try {

		if (ev.keyCode==32 && oea_aEcheances.isSelected()) {
			oea_aEcheances.setSelectedCellValue("oea-colSelect", oea_aEcheances.getSelectedCellValue("oea-colSelect")=="false");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_toutCocher(b) {
	try {

		document.getElementById("oea-bGenerer").disabled = true;

		for (var i=0; i<oea_aEcheances.nbLignes(); i++) {
			if (oea_aEcheances.isEditable(i, "oea-colSelect")) {
				oea_aEcheances.setCellValue(i, "oea-colSelect", b);
  		}
		}

		document.getElementById("oea-bGenerer").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_genererEcritures() {
	try {

		document.getElementById("oea-bGenerer").disabled = true;

		var listEcheanceId = "";

		for (var i=0; i<oea_aEcheances.nbLignes(); i++) {
			if (oea_aEcheances.getCellValue(i, "oea-colSelect")=="true") {
				listEcheanceId += oea_aEcheances.getCellText(i, "oea-colEcheanceId") +",";
			}
  	}

		if (isEmpty(listEcheanceId)) {
			showWarning("Veuillez cocher au moins une \u00E9ch\u00E9ance");
			document.getElementById("oea-bGenerer").disabled = false;
		}
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration des \u00E9critures s\u00E9lectionn\u00E9es ?")) {

			var qGenerate = new QueryHttp("Compta/AbonnementsEcriture/generateEcritures.tmpl");
			qGenerate.setParam("List_Echeance_Id", listEcheanceId);

			var result = qGenerate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Les \u00E9critures ont \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9es");
				oea_chargerAbonnement();
			}
		}
		else {
			document.getElementById("oea-bGenerer").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
