/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ome_aApercuAbonnement = new Arbre('Compta/AbonnementsEcriture/list-apercuAbonnementEcriture.tmpl', 'ome-apercu');
var ome_aEcheances = new Arbre('Compta/AbonnementsEcriture/list-echeanceAGenerer.tmpl', 'ome-listeEcheances');



function ome_init() {
  try {

		var aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'ome-journal');
		aJournaux.setParam("Sans_AN", true);
		aJournaux.initTree();

		document.getElementById('ome-nbLignesCochees').value = 0;

  } catch (e) {
  	recup_erreur(e);
  }
}


function ome_initCriteres() {
	try {

		document.getElementById('ome-nonEchues').checked = false;
		document.getElementById('ome-libelle').value = "";
		document.getElementById('ome-journal').value = "";
		document.getElementById('ome-dateEcheanceDebut').value = "";
		document.getElementById('ome-dateEcheanceFin').value = "";

		ome_listerEcheances();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_listerEcheances() {
	try {

		var nonEchues = document.getElementById('ome-nonEchues').checked;
		var libelle = document.getElementById('ome-libelle').value;
		var journal = document.getElementById('ome-journal').value;
		var dateEcheanceDebut = document.getElementById('ome-dateEcheanceDebut').value;
		var dateEcheanceFin = document.getElementById('ome-dateEcheanceFin').value;

		if (!isEmpty(dateEcheanceDebut) && !isDate(dateEcheanceDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateEcheanceFin) && !isDate(dateEcheanceFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateEcheanceDebut) && !isEmpty(dateEcheanceFin) && !isDateInterval(dateEcheanceDebut, dateEcheanceFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			document.getElementById('ome-listeEcheances').disabled = true;
			document.getElementById('ome-bGenerer').disabled = true;
			ome_aApercuAbonnement.deleteTree();

			ome_aEcheances.setParam("Non_Echues", nonEchues);
			ome_aEcheances.setParam("Libelle", libelle);
			ome_aEcheances.setParam("Journal", journal);
			ome_aEcheances.setParam("Date_Echeance_Debut", dateEcheanceDebut);
			ome_aEcheances.setParam("Date_Echeance_Fin", dateEcheanceFin);

			ome_aEcheances.initTree(ome_afterRefreshEcheances);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_afterRefreshEcheances() {
	try {

		document.getElementById('ome-listeEcheances').disabled = false;
		document.getElementById('ome-bGenerer').disabled = false;
		ome_compterLignesCochees();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ome_listerEcheances();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_toutCocher(b) {
	try {

		document.getElementById("ome-bGenerer").disabled = true;

		for (var i=0; i<ome_aEcheances.nbLignes(); i++) {
			if (ome_aEcheances.isEditable(i, "ome-colSelect")) {
				ome_aEcheances.setCellValue(i, "ome-colSelect", b);
  		}
		}

		ome_compterLignesCochees();
		document.getElementById("ome-bGenerer").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_compterLignesCochees() {
	try {

		var nbCoches = 0;

		for (var i=0; i<ome_aEcheances.nbLignes(); i++) {
			if (ome_aEcheances.getCellValue(i, "ome-colSelect")=="true") {
				nbCoches++;
			}
  	}

		document.getElementById('ome-nbLignesCochees').value = nbCoches;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_selectOnListeEcheances() {
	try {

		if (ome_aEcheances.isSelected()) {
			var abonnementId = ome_aEcheances.getSelectedCellText('ome-colAbonnementId');

			ome_aApercuAbonnement.setParam("Abonnement_Id", abonnementId);
			ome_aApercuAbonnement.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_pressOnListeEcheances(ev) {
	try {

		if (ev.keyCode==32 && ome_aEcheances.isSelected()) {
			ome_aEcheances.setSelectedCellValue("ome-colSelect", ome_aEcheances.getSelectedCellValue("ome-colSelect")=="false");
			ome_compterLignesCochees();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_genererEcritures() {
	try {

		document.getElementById("ome-bGenerer").disabled = true;

		var listEcheanceId = "";

		for (var i=0; i<ome_aEcheances.nbLignes(); i++) {
			if (ome_aEcheances.getCellValue(i, "ome-colSelect")=="true") {
				listEcheanceId += ome_aEcheances.getCellText(i, "ome-colEcheanceId") +",";
			}
  	}

		if (isEmpty(listEcheanceId)) {
			showWarning("Veuillez cocher au moins une \u00E9ch\u00E9ance");
			document.getElementById("ome-bGenerer").disabled = false;
		}
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration des \u00E9critures s\u00E9lectionn\u00E9es ?")) {

			var qGenerate = new QueryHttp("Compta/AbonnementsEcriture/generateEcritures.tmpl");
			qGenerate.setParam("List_Echeance_Id", listEcheanceId);

			var result = qGenerate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ome_listerEcheances();
				showWarning("Les \u00E9critures ont \u00E9t\u00E9 g\u00E9n\u00E9r\u00E9es");
			}
		}
		else {
			document.getElementById("ome-bGenerer").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
