/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aCriteres = new Arbre("Compta/Analytique/Criteres/list-critereTriGLA.tmpl", 'lbListeCriteres');

var critereId1;
var critereId2;
var critereId3;
var critereId4;
var critereId5;

var critere1;
var critere2;
var critere3;
var critere4;
var critere5;

var selLigne;



function retourGrandLivre() {
	try {

		document.getElementById('pdfGrandLivre').setAttribute("src", "");
		document.getElementById('bRetourOptions').collapsed = true;
		document.getElementById('deckGrandLivre').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function init() {
	try {

		var aListeCentresDebut1 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreDebut1');
		var aListeCentresDebut2 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreDebut2');
		var aListeCentresDebut3 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreDebut3');
		var aListeCentresDebut4 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreDebut4');
		var aListeCentresDebut5 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreDebut5');

		var aListeCentresFin1 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreFin1');
		var aListeCentresFin2 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreFin2');
		var aListeCentresFin3 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreFin3');
		var aListeCentresFin4 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreFin4');
		var aListeCentresFin5 = new Arbre("Compta/Analytique/Criteres/list-centreProfit.tmpl", 'filtreCentreFin5');

		var qGet = new QueryHttp("Compta/Analytique/Criteres/getCriteresByFormat.tmpl");

		var result = qGet.execute();
		
		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			// enregistrement des id de critres dans l'ordre dans lequel ils vont apparaitre dans l'arbre de tri
			critereId1 = result.responseXML.documentElement.getAttribute('Critere_Id1');
			critereId2 = result.responseXML.documentElement.getAttribute('Critere_Id2');
			critereId3 = result.responseXML.documentElement.getAttribute('Critere_Id3');
			critereId4 = result.responseXML.documentElement.getAttribute('Critere_Id4');
			critereId5 = result.responseXML.documentElement.getAttribute('Critere_Id5');

			// enregistrement de l'ordre des criteres dans le tri
			critere1 = critereId1;
			critere2 = critereId2;
			critere3 = critereId3;
			critere4 = critereId4;
			critere5 = critereId5;

			selLigne = -1;

			// suppression des criteres inutiliss et prparation des listes de centres
			if (critereId1==null) {
				document.getElementById('rowCritere1').collapsed = true;
			} else {
				document.getElementById('chkCritere1').label = result.responseXML.documentElement.getAttribute('Intitule1');
				aListeCentresDebut1.setParam("Critere_Id", critereId1);
				aListeCentresDebut1.initTree();
				aListeCentresFin1.setParam("Critere_Id", critereId1);
				aListeCentresFin1.initTree();
			}
			if (critereId2==null) {
				document.getElementById('rowCritere2').collapsed = true;
			} else {
				document.getElementById('chkCritere2').label = result.responseXML.documentElement.getAttribute('Intitule2');
				aListeCentresDebut2.setParam("Critere_Id", critereId2);
				aListeCentresDebut2.initTree();
				aListeCentresFin2.setParam("Critere_Id", critereId2);
				aListeCentresFin2.initTree();
			}
			if (critereId3==null) {
				document.getElementById('rowCritere3').collapsed = true;
			} else {
				document.getElementById('chkCritere3').label = result.responseXML.documentElement.getAttribute('Intitule3');
				aListeCentresDebut3.setParam("Critere_Id", critereId3);
				aListeCentresDebut3.initTree();
				aListeCentresFin3.setParam("Critere_Id", critereId3);
				aListeCentresFin3.initTree();
			}
			if (critereId4==null) {
				document.getElementById('rowCritere4').collapsed = true;
			} else {
				document.getElementById('chkCritere4').label = result.responseXML.documentElement.getAttribute('Intitule4');
				aListeCentresDebut4.setParam("Critere_Id", critereId4);
				aListeCentresDebut4.initTree();
				aListeCentresFin4.setParam("Critere_Id", critereId4);
				aListeCentresFin4.initTree();
			}
			
			if (critereId5==null) {
				document.getElementById('rowCritere5').collapsed = true;
			}
			else {
				document.getElementById('chkCritere5').label = result.responseXML.documentElement.getAttribute('Intitule5');
				aListeCentresDebut5.setParam("Critere_Id", critereId5);
				aListeCentresDebut5.initTree();
				aListeCentresFin5.setParam("Critere_Id", critereId5);
				aListeCentresFin5.initTree();
			}			
			
			activeAll(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function activeAll(boolean) {
	try {
		activeSelection(boolean);
		activePresentation(boolean);
		activePeriode(boolean);
		activeTri(boolean);
		activeSortie(boolean);
		activeEdition(boolean);
	} catch (e) {
		recup_erreur(e);
	}
}

function activeSelection(boolean) {
	try {
		document.getElementById('rgSelection').disabled = !boolean;
		document.getElementById('lNumPlage').disabled = !boolean;

		document.getElementById('tbCompteSingle').disabled = !boolean || document.getElementById('rgSelection').value!=2;
		document.getElementById('bRechCompteSingle').disabled = document.getElementById('tbCompteSingle').disabled;

		document.getElementById('tbCompteDebut').disabled = !boolean || document.getElementById('rgSelection').value!=3;
		document.getElementById('bRechCompteDebut').disabled = document.getElementById('tbCompteDebut').disabled;
		document.getElementById('tbCompteFin').disabled = !boolean || document.getElementById('rgSelection').value!=3;
		document.getElementById('bRechCompteFin').disabled = document.getElementById('tbCompteFin').disabled;

		activeSelectionLigneCritere(1, boolean && document.getElementById('rgSelection').value==4);
		activeSelectionLigneCritere(2, boolean && document.getElementById('rgSelection').value==4);
		activeSelectionLigneCritere(3, boolean && document.getElementById('rgSelection').value==4);
		activeSelectionLigneCritere(4, boolean && document.getElementById('rgSelection').value==4);
		activeSelectionLigneCritere(5, boolean && document.getElementById('rgSelection').value==4);
	} catch (e) {
		recup_erreur(e);
	}
}

function activeSelectionLigneCritere(numero, boolean) {
	try {
		document.getElementById('chkCritere'+numero).disabled = !boolean;
		document.getElementById('lDebCentre'+numero).disabled = !boolean;
		document.getElementById('filtreCentreDebut'+numero).disabled = !boolean || !document.getElementById('chkCritere'+numero).checked;
		document.getElementById('lFinCentre'+numero).disabled = !boolean;
		document.getElementById('filtreCentreFin'+numero).disabled = !boolean || !document.getElementById('chkCritere'+numero).checked;
	} catch (e) {
		recup_erreur(e);
	}
}

function activePresentation(boolean) {
	try {
		document.getElementById('rgPresentation').disabled = !boolean;
		document.getElementById('lPresentation').disabled = !boolean;

		document.getElementById('chkPresRubrique').disabled = !boolean;
		document.getElementById('chkSsTotRubrique').disabled = !boolean
			|| !document.getElementById('chkPresRubrique').checked
			|| (document.getElementById('rgPresentation').value==1
				&& !document.getElementById('chkPresCompte').checked
				&& !document.getElementById('chkPresPeriode').checked);

		document.getElementById('chkPresCompte').disabled = !boolean;
		document.getElementById('chkSsTotCompte').disabled = !boolean
			|| !document.getElementById('chkPresCompte').checked
			|| (document.getElementById('rgPresentation').value==1
				&& !document.getElementById('chkPresPeriode').checked);

		document.getElementById('chkPresPeriode').disabled = !boolean;
		document.getElementById('chkSsTotPeriode').disabled = !boolean
			|| !document.getElementById('chkPresPeriode').checked
			|| (document.getElementById('rgPresentation').value==1);
	} catch (e) {
		recup_erreur(e);
	}
}

function activePeriode(boolean) {
	try {
		document.getElementById('rgPeriode').disabled = !boolean;
		document.getElementById('lFinPeriode').disabled = !boolean;

		document.getElementById('tbDateDebut').disabled = !boolean || document.getElementById('rgPeriode').value!=2;
		document.getElementById('tbDateFin').disabled = !boolean || document.getElementById('rgPeriode').value!=2;
	} catch (e) {
		recup_erreur(e);
	}
}

function activeTri(boolean) {
	try {
		document.getElementById('rgTri').disabled = !boolean;

		document.getElementById('lbListeCriteres').disabled = !boolean || document.getElementById('rgTri').value!=2;
		if (document.getElementById('lbListeCriteres').disabled) {
			document.getElementById('lbListeCriteres').currentIndex = -1;
			activeTriFleches(false);
		}
		else {
			resetListeCriteres();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function activeTriFleches(boolean) {
	try {

		document.getElementById('bFlecheHaut').disabled = !boolean || (document.getElementById('lbListeCriteres').currentIndex==-1) || (document.getElementById('lbListeCriteres').currentIndex==0);
		document.getElementById('bFlecheBas').disabled = !boolean || (document.getElementById('lbListeCriteres').currentIndex==-1) || (document.getElementById('lbListeCriteres').currentIndex==(document.getElementById('lbListeCriteres').itemCount-1));
	} catch (e) {
		recup_erreur(e);
	}
}

function activeSortie(boolean) {
	try {
		document.getElementById('rgSortie').disabled = !boolean;

		document.getElementById('lbListeCriteres').disabled = !boolean || document.getElementById('rgTri').value!=2;
		document.getElementById('bFlecheHaut').disabled = !boolean || document.getElementById('rgTri').value!=2;
		document.getElementById('bFlecheBas').disabled = !boolean || document.getElementById('rgTri').value!=2;
	} catch (e) {
		recup_erreur(e);
	}
}

function activeEdition(boolean) {
	try {
		document.getElementById('bEdition').disabled = !boolean;
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRgSelection() {
	try {
		activeSelection(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRechCompteDebut() {
	try {
		activeSelection(false);
		rechercheCompteDebut(document.getElementById('tbCompteDebut').value);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRechCompteFin() {
	try {
		activeSelection(false);
		rechercheCompteFin(document.getElementById('tbCompteFin').value);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRechCompteSingle() {
	try {
		activeSelection(false);
		rechercheCompteSingle(document.getElementById('tbCompteSingle').value);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkCritere1() {
	try {
		activeSelectionLigneCritere(1, true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkCritere2() {
	try {
		activeSelectionLigneCritere(2, true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkCritere3() {
	try {
		activeSelectionLigneCritere(3, true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkCritere4() {
	try {
		activeSelectionLigneCritere(4, true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkCritere5() {
	try {
		activeSelectionLigneCritere(5, true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRgPresentation() {
	try {
		pressOnPresentation();
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkPresRubrique() {
	try {
		pressOnPresentation();
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkPresCompte() {
	try {
		pressOnPresentation();
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnChkPresPeriode() {
	try {
		pressOnPresentation();
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnPresentation() {
	try {
		activePresentation(true);
		regulePresentation();
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRgPeriode() {
	try {
		activePeriode(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnRgTri() {
	try {

		if (document.getElementById('rgTri').value==1) {
			document.getElementById('lbListeCriteres').selectedIndex = -1;
			selLigne = -1;
		}
		activeTri(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeCriteres() {
	try {
		activeTriFleches(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnFlecheHaut() {
	try {
		activeTriFleches(false);
		selLigne = document.getElementById('lbListeCriteres').selectedIndex;
		deplacerCritereHaut(document.getElementById('lbListeCriteres').getSelectedItem(0).getElementsByTagName("listcell").item(1).getAttribute("label"));
		activeTriFleches(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnFlecheBas() {
	try {
		activeTriFleches(false);
		selLigne = document.getElementById('lbListeCriteres').selectedIndex;
		deplacerCritereBas(document.getElementById('lbListeCriteres').getSelectedItem(0).getElementsByTagName("listcell").item(1).getAttribute("label"));
		activeTriFleches(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnRgSortie() {
	try {
		activeSortie(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnEdition() {
	try {
		// verif select single
		if (document.getElementById('rgSelection').value==2
			&& !isNumeroCorrect(document.getElementById('tbCompteSingle').value)) {
			showWarning("Compte s\u00E9lectionn\u00E9 incorrect !");
		}
		// verif select plage
		else if (document.getElementById('rgSelection').value==3
			&& (!isNumeroCorrect(document.getElementById('tbCompteDebut').value)
				|| !isNumeroCorrect(document.getElementById('tbCompteFin').value)
				|| document.getElementById('tbCompteDebut').value > document.getElementById('tbCompteFin').value)) {
			showWarning("Plage de comptes s\u00E9lectionn\u00E9 incorrecte !");
		}
		// verif select critere
		else if (document.getElementById('rgSelection').value==4
			&& !(document.getElementById('chkCritere1').checked
				|| document.getElementById('chkCritere2').checked
				|| document.getElementById('chkCritere3').checked
				|| document.getElementById('chkCritere4').checked
				|| document.getElementById('chkCritere5').checked)) {
			showWarning("Veuillez s\u00E9lectionner au moins un crit\u00E8re !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere1').checked
			&& (isEmpty(document.getElementById('filtreCentreDebut1').value)
				|| isEmpty(document.getElementById('filtreCentreFin1').value))) {
			showWarning("Veuillez s\u00E9lectionner un centre de d\u00E9but et un centre de fin pour le crit\u00E8re n\u00B01 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere1').checked
			&& (document.getElementById('filtreCentreDebut1').value > document.getElementById('filtreCentreFin1').value)) {
			showWarning("La plage de centre est incorrecte pour le crit\u00E8re n\u00B01 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere2').checked
			&& (isEmpty(document.getElementById('filtreCentreDebut2').value)
				|| isEmpty(document.getElementById('filtreCentreFin2').value))) {
			showWarning("Veuillez s\u00E9lectionner un centre de d\u00E9but et un centre de fin pour le crit\u00E8re n\u00B02 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere2').checked
			&& (document.getElementById('filtreCentreDebut2').value > document.getElementById('filtreCentreFin2').value)) {
			showWarning("La plage de comptes est incorrecte pour le crit\u00E8re n\u00B02 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere3').checked
			&& (isEmpty(document.getElementById('filtreCentreDebut3').value)
				|| isEmpty(document.getElementById('filtreCentreFin3').value))) {
			showWarning("Veuillez s\u00E9lectionner un centre de d\u00E9but et un centre de fin pour le crit\u00E8re n\u00B03 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere3').checked
			&& (document.getElementById('filtreCentreDebut3').value > document.getElementById('filtreCentreFin3').value)) {
			showWarning("La plage de comptes est incorrecte pour le crit\u00E8re n\u00B03 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere4').checked
			&& (isEmpty(document.getElementById('filtreCentreDebut4').value)
				|| isEmpty(document.getElementById('filtreCentreFin4').value))) {
			showWarning("Veuillez s\u00E9lectionner un centre de d\u00E9but et un centre de fin pour le crit\u00E8re n\u00B04 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere4').checked
			&& (document.getElementById('filtreCentreDebut4').value > document.getElementById('filtreCentreFin4').value)) {
			showWarning("La plage de comptes est incorrecte pour le crit\u00E8re n\u00B04 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere5').checked
			&& (isEmpty(document.getElementById('filtreCentreDebut5').value)
				|| isEmpty(document.getElementById('filtreCentreFin5').value))) {
			showWarning("Veuillez s\u00E9lectionner un centre de d\u00E9but et un centre de fin pour le crit\u00E8re n\u00B05 !");
		}
		else if (document.getElementById('rgSelection').value==4
			&& document.getElementById('chkCritere5').checked
			&& (document.getElementById('filtreCentreDebut5').value > document.getElementById('filtreCentreFin5').value)) {
			showWarning("La plage de comptes est incorrecte pour le crit\u00E8re n\u00B05 !");
		}
		// verif periode
		else if (document.getElementById('rgPeriode').value==2
			&& (!isPeriode(document.getElementById('tbDateDebut').value)
				|| !isPeriode(document.getElementById('tbDateFin').value)
				|| !isPeriodeInterval(document.getElementById('tbDateDebut').value, document.getElementById('tbDateFin').value))) {
			showWarning("Periode incorrecte !");
		}
		// verif presentation
		else if (document.getElementById('rgPresentation').value==1
			&& !document.getElementById('chkPresRubrique').checked
			&& !document.getElementById('chkPresCompte').checked
			&& !document.getElementById('chkPresPeriode').checked) {
			showWarning("Veuillez choisir au moins un niveau de rupture pour le calcul des totaux !")
		}
		else {
			activeAll(false);
    	editGrandLivre();
    	activeAll(true);
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercheCompteSingle(numCompte) {
	try {
		var url = "chrome://opensi/content/compta/user/analytique/comptes/popup-rechercheCompteAnalytique.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', finRechercheCompteSingle, numCompte);
	} catch (e) {
		recup_erreur(e);
	}
}

function finRechercheCompteSingle(compteId, numCompte) {
	try {
		document.getElementById('tbCompteSingle').value = numCompte;
		activeSelection(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function rechercheCompteDebut(numCompte) {
	try {
		var url = "chrome://opensi/content/compta/user/analytique/comptes/popup-rechercheCompteAnalytique.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', finRechercheCompteDebut, numCompte);
	} catch (e) {
		recup_erreur(e);
	}
}

function finRechercheCompteDebut(compteId, numCompte) {
	try {
		document.getElementById('tbCompteDebut').value = numCompte;
		activeSelection(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function rechercheCompteFin(numCompte) {
	try {
		var url = "chrome://opensi/content/compta/user/analytique/comptes/popup-rechercheCompteAnalytique.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', finRechercheCompteFin, numCompte);
	} catch (e) {
		recup_erreur(e);
	}
}

function finRechercheCompteFin(compteId, numCompte) {
	try {
		document.getElementById('tbCompteFin').value = numCompte;
		activeSelection(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function isNumeroCorrect(val) {
	try {
		var str = val.toString();
		var ok = !isEmpty(str) && str.length<=10;

		if (ok) {
			for (var i=0;i<str.length && ok;i++) {
				var c = str.charAt(i);
				ok = ((c<='z' && c>='a') || (c<='Z' && c>='A') || (c<='9' && c>='0') || (c=='_'));
			}
		}
		return ok;
	} catch (e) {
		recup_erreur(e);
	}
}

function regulePresentation() {
	try {
		document.getElementById('chkPresRubrique').checked = !document.getElementById('chkPresRubrique').disabled && document.getElementById('chkPresRubrique').checked;
		document.getElementById('chkSsTotRubrique').checked = !document.getElementById('chkSsTotRubrique').disabled && document.getElementById('chkSsTotRubrique').checked;

		document.getElementById('chkPresCompte').checked = !document.getElementById('chkPresCompte').disabled && document.getElementById('chkPresCompte').checked;
		document.getElementById('chkSsTotCompte').checked = !document.getElementById('chkSsTotCompte').disabled && document.getElementById('chkSsTotCompte').checked;

		document.getElementById('chkPresPeriode').checked = !document.getElementById('chkPresPeriode').disabled && document.getElementById('chkPresPeriode').checked;
		document.getElementById('chkSsTotPeriode').checked = !document.getElementById('chkSsTotPeriode').disabled && document.getElementById('chkSsTotPeriode').checked;
	} catch (e) {
		recup_erreur(e);
	}
}

function deplacerCritereHaut(critereId) {
	try {
		if (critere5==critereId) {
			critere5 = critere4;
			critere4 = critereId;
		} else if (critere4==critereId) {
			critere4 = critere3;
			critere3 = critereId;
		} else if (critere3==critereId) {
			critere3 = critere2;
			critere2 = critereId;
		} else if (critere2==critereId) {
			critere2 = critere1;
			critere1 = critereId;
		}
		selLigne = selLigne-1;
		resetListeCriteres();
	} catch (e) {
		recup_erreur(e);
	}
}

function deplacerCritereBas(critereId) {
	try {

		if (critere1==critereId) {
			critere1 = critere2;
			critere2 = critereId;
		} else if (critere2==critereId) {
			critere2 = critere3;
			critere3 = critereId;
		} else if (critere3==critereId) {
			critere3 = critere4;
			critere4 = critereId;
		} else if (critere4==critereId) {
			critere4 = critere5;
			critere5 = critereId;
		}
		selLigne = selLigne+1
		resetListeCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function resetListeCriteres() {
	try {

		aCriteres.setParam("Critere_1", critere1==null?"":critere1);
		aCriteres.setParam("Critere_2", critere2==null?"":critere2);
		aCriteres.setParam("Critere_3", critere3==null?"":critere3);
		aCriteres.setParam("Critere_4", critere4==null?"":critere4);
		aCriteres.setParam("Critere_5", critere5==null?"":critere5);
		aCriteres.initTree(restoreSelectionListeCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function restoreSelectionListeCriteres() {
	try {

		document.getElementById("lbListeCriteres").selectedIndex = selLigne;

	} catch (e) {
		recup_erreur(e);
	}
}


function editGrandLivre() {
	try {

		var qEdit = new QueryHttp("Compta/Analytique/Ecritures/editionGrandLivre.tmpl");

		qEdit.setParam("Selection", document.getElementById('rgSelection').value);
		qEdit.setParam("CompteSingle", document.getElementById('tbCompteSingle').value);
		qEdit.setParam("CompteDebut", document.getElementById('tbCompteDebut').value);
		qEdit.setParam("CompteFin", document.getElementById('tbCompteFin').value);

 		qEdit.setParam("CritereId1", critereId1==null?"":critereId1);
 		qEdit.setParam("CritereId2", critereId2==null?"":critereId2);
 		qEdit.setParam("CritereId3", critereId3==null?"":critereId3);
 		qEdit.setParam("CritereId4", critereId4==null?"":critereId4);
 		qEdit.setParam("CritereId5", critereId5==null?"":critereId5);
		qEdit.setParam("ChkCritere1", document.getElementById('chkCritere1').checked);
		qEdit.setParam("DebCentre1", document.getElementById('filtreCentreDebut1').value);
		qEdit.setParam("FinCentre1", document.getElementById('filtreCentreFin1').value);
		qEdit.setParam("ChkCritere2", document.getElementById('chkCritere2').checked);
		qEdit.setParam("DebCentre2", document.getElementById('filtreCentreDebut2').value);
		qEdit.setParam("FinCentre2", document.getElementById('filtreCentreFin2').value);
		qEdit.setParam("ChkCritere3", document.getElementById('chkCritere3').checked);
		qEdit.setParam("DebCentre3", document.getElementById('filtreCentreDebut3').value);
		qEdit.setParam("FinCentre3", document.getElementById('filtreCentreFin3').value);
		qEdit.setParam("ChkCritere4", document.getElementById('chkCritere4').checked);
		qEdit.setParam("DebCentre4", document.getElementById('filtreCentreDebut4').value);
		qEdit.setParam("FinCentre4", document.getElementById('filtreCentreFin4').value);
		qEdit.setParam("ChkCritere5", document.getElementById('chkCritere5').checked);
		qEdit.setParam("DebCentre5", document.getElementById('filtreCentreDebut5').value);
		qEdit.setParam("FinCentre5", document.getElementById('filtreCentreFin5').value);

		qEdit.setParam("Presentation", document.getElementById('rgPresentation').value);
		qEdit.setParam("ChkPresRubrique", document.getElementById('chkPresRubrique').checked);
		qEdit.setParam("ChkSsTotRubrique", document.getElementById('chkSsTotRubrique').checked);
		qEdit.setParam("ChkPresCompte", document.getElementById('chkPresCompte').checked);
		qEdit.setParam("ChkSsTotCompte", document.getElementById('chkSsTotCompte').checked);
		qEdit.setParam("ChkPresPeriode", document.getElementById('chkPresPeriode').checked);
		qEdit.setParam("ChkSsTotPeriode", document.getElementById('chkSsTotPeriode').checked);

		qEdit.setParam("Periode", document.getElementById('rgPeriode').value);
		qEdit.setParam("DateDebut", document.getElementById('tbDateDebut').value);
		qEdit.setParam("DateFin", document.getElementById('tbDateFin').value);

 		qEdit.setParam("Tri", document.getElementById('rgTri').value);
 		qEdit.setParam("Critere1", critere1==null?"":critere1);
 		qEdit.setParam("Critere2", critere2==null?"":critere2);
 		qEdit.setParam("Critere3", critere3==null?"":critere3);
 		qEdit.setParam("Critere4", critere4==null?"":critere4);
 		qEdit.setParam("Critere5", critere5==null?"":critere5);

 		var sortie = document.getElementById('rgSortie').value;
 		qEdit.setParam("Sortie", sortie);

		var result = qEdit.execute();
 
 		var errors = new Errors(result);
 		if (errors.hasNext()) {
			errors.show();
		}
		else {
	 		var fichier = result.responseXML.documentElement.getAttribute("Fichier");

	 		if (sortie==1) {
				document.getElementById('bRetourOptions').collapsed = false;
	 			document.getElementById('deckGrandLivre').selectedIndex = 1;
	 			var page = getDirPdf()+fichier;
	 			document.getElementById('pdfGrandLivre').setAttribute("src", page);
	 		}
			else if (sortie==2) {				
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer() + fichier, file);
				}
	 		}
	 	}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
