/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var aFormExp = new Arbre("ComboListe/combo-formatsExportCompta.tmpl", "Format_Export");
var importFile;



function init() {
	try {

	  initImport();
	  initExport();

	} catch (e) {
	  recup_erreur(e);
	}
}


function initImport() {
	try {

		var aExos = new Arbre('ComboListe/combo-exercices.tmpl', 'ExerciceImport');
		aExos.setParam("Unclose_Only", true);
		aExos.initTree(initExerciceImport);

		var aFormatsImport = new Arbre('ComboListe/combo-formatsImportCompta.tmpl', 'Format_Import');
		aFormatsImport.initTree(initFormatImport);

	} catch (e) {
    recup_erreur(e);
  }
}


function initExerciceImport() {
	try {

		document.getElementById('ExerciceImport').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function initFormatImport() {
	try {

		document.getElementById('Format_Import').selectedIndex = 0;
		changeFormatImport();

	} catch (e) {
    recup_erreur(e);
  }
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function importer() {
	try {

		if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier");
		}
		else if (checkUploadFile(importFile)) {

			document.getElementById('boxJournal').collapsed = true;
			document.getElementById('bImporter').disabled = true;
			document.getElementById('progressionImport').collapsed = false;
			document.getElementById('pmImport').setAttribute("mode", "undetermined");

			uploadFile(importFile);

			var exerciceId = document.getElementById('ExerciceImport').value;
			var importId = document.getElementById('Format_Import').value;
			var supprimerAN = document.getElementById('supprimerAN').checked;

			var aRapport = new Arbre('Compta/Import/ProcessImport.tmpl', 'rapport');
			aRapport.setParam('Fichier', importFile.leafName);
			aRapport.setParam('Exercice_Id', exerciceId);
			aRapport.setParam('Import_Id', importId);
			aRapport.setParam('Supprimer_AN', supprimerAN);
			aRapport.initTree(importer_2);
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function importer_2() {
	try {

		document.getElementById('pmImport').setAttribute("mode", "none");
		document.getElementById('progressionImport').collapsed = true;
		document.getElementById('bImporter').disabled = false;
		document.getElementById('boxJournal').collapsed = false;

		showMessage("Import termin\u00E9");

	} catch (e) {
    recup_erreur(e);
  }
}


function changeFormatImport() {
	try {

		if (getProfil().isSpecANZSAN() && document.getElementById('Format_Import').getAttribute("label").startsWith("ACD")) {
			document.getElementById('supprimerAN').collapsed = false;
		}
		else {
			document.getElementById('supprimerAN').collapsed = true;
			document.getElementById('supprimerAN').checked = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


//fonctions pour l'export

function initExport() {
	try {

		var aExos = new Arbre("ComboListe/combo-exercices.tmpl", "ExerciceExport");
		aExos.initTree(initExerciceExport);

		aFormExp.setParam("Dispo_CG", "1");
		aFormExp.initTree(initFormatExport);

	} catch (e) {
    recup_erreur(e);
  }
}

function initExerciceExport() {
	try {

		document.getElementById('ExerciceExport').selectedIndex = 0;
		initialiserPeriode();

	} catch (e) {
    recup_erreur(e);
  }
}

function initFormatExport() {
	try {

		document.getElementById('Format_Export').selectedIndex = 0;
		var aJournaux = new Arbre("ComboListe/combo-journaux.tmpl", 'journalExport');
		aJournaux.initTree(initialiser);

	} catch (e) {
    recup_erreur(e);
  }
}


function initialiser() {
	document.getElementById("journalExport").selectedIndex = 0;
}


function initialiserPeriode() {

	if (document.getElementById('ExerciceExport').selectedIndex == -1){
		document.getElementById('ExerciceExport').selectedIndex = 0;
	}

	var exerciceId = document.getElementById('ExerciceExport').value;

	if (!isEmpty(exerciceId)) {
		var aPeriodesDebut = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'periode_initiale');
		aPeriodesDebut.setParam("Exercice_Id", exerciceId);
		aPeriodesDebut.initTree(initialiser2);

		var aPeriodesFin = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'periode_fin');
		aPeriodesFin.setParam("Exercice_Id", exerciceId);
		aPeriodesFin.initTree(initialiser2);
	}
}


function initialiser2() {

	document.getElementById("periode_initiale").selectedIndex = 0;
	document.getElementById("periode_fin").selectedIndex = 0;
}


function exporter() {
	try {

		document.getElementById('bExporter').disabled = true;

		var exerciceId = document.getElementById('ExerciceExport').value;
		var format = document.getElementById('Format_Export').value;
		var periode_initiale = document.getElementById("periode_initiale").value;
		var periode_fin = document.getElementById("periode_fin").value;
		var debut_ecriture = document.getElementById('Debut_Ecriture').value;
		var fin_ecriture = document.getElementById('Fin_Ecriture').value;

		if (document.getElementById('Periode').value=="pp" && (!isPeriode(periode_fin) || !isPeriode(periode_initiale) || !isPeriodeInterval(periode_initiale, periode_fin))) {
			showWarning("Plage de dates invalide !");
			document.getElementById('bExporter').disabled = false;
		}
		else if ((!isEmpty(debut_ecriture) && !isPositiveInteger(debut_ecriture)) || (!isEmpty(fin_ecriture) && !isPositiveInteger(fin_ecriture))
					|| (!isEmpty(debut_ecriture) && !isEmpty(fin_ecriture) && parseIntBis(debut_ecriture)>parseIntBis(fin_ecriture))) {
			showWarning("Plage de num\u00E9ros d'\u00E9critures invalide !");
			document.getElementById('bExporter').disabled = false;
		}
		else {

			document.getElementById('progressionExport').collapsed = false;
			document.getElementById('pmExport').setAttribute("mode", "undetermined");

			var qExport = new QueryHttp("Compta/Export/ProcessExport.tmpl");

			qExport.setParam("Exercice_Id", exerciceId);
			qExport.setParam("Periode", document.getElementById('Periode').value);
			qExport.setParam("Debut", periode_initiale);
			qExport.setParam("Fin", periode_fin);
			qExport.setParam("Journal_Id", document.getElementById('journalExport').value);
			qExport.setParam("Debut_Ecriture", debut_ecriture);
			qExport.setParam("Fin_Ecriture", fin_ecriture);
			qExport.setParam("Format", format);

			qExport.execute(exporter_2);

			if (format=="FEC18") {
				var qFEC = new QueryHttp("Compta/Export/GetInformationsFEC.tmpl");
				qFEC.setParam("Exercice_Id", exerciceId);
				var result = qFEC.execute();

				var fichierServFEC = result.responseXML.documentElement.getAttribute('fileName');
				var fichierSuggFEC = result.responseXML.documentElement.getAttribute('suggestedName');

				var fileFEC = fileChooser("save", fichierSuggFEC);
				if (fileFEC!=null) {
					downloadFile(getDirBuffer()+ fichierServFEC, fileFEC);
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function exporter_2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierServ = result.responseXML.documentElement.getAttribute('fileName');
			var fichierSugg = result.responseXML.documentElement.getAttribute('suggestedName');

			document.getElementById('pmExport').setAttribute("mode", "none");
			document.getElementById('progressionExport').collapsed = true;
			document.getElementById('bExporter').disabled = false;

			var file = fileChooser("save", fichierSugg);

			if (file!=null) {
				downloadFile(getDirBuffer()+ fichierServ, file);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

  } catch (e) {
    recup_erreur(e);
  }
}
