/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var currentClasse = -2;
var tabTitresClasse = new Array();

var aClasses = new Arbre('Compta/Comptes/list-compteByClasse.tmpl', 'Compte');
var qListNC = new QueryHttp("Compta/Comptes/getDataListNC.tmpl");

var pageCourante;
var nbPages;



function init() {
	try {

		chargerTitresClasse();
		chargerClasse(currentClasse);

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerTitresClasse() {
	try {

		tabTitresClasse.push("Comptes clients");
		tabTitresClasse.push("Comptes fournisseurs");
		tabTitresClasse.push("Comptes auxiliaires");

		var qGet = new QueryHttp("Compta/PlanComptable/getClasseNiveau1.tmpl");
		var result = qGet.execute();

		var classes = result.responseXML.documentElement.getElementsByTagName("classe");

		for (var i=0; i<classes.length; i++) {
			var numClasse = parseInt(classes.item(i).getAttribute('Num_Classe'));
			tabTitresClasse[numClasse+2] = "Classe "+ numClasse +" - "+ classes.item(i).getAttribute('Libelle');
		}

		document.getElementById("titreClasse").value = tabTitresClasse[currentClasse+2];

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerClasse(classe) {
	try {

		currentClasse = classe;
		document.getElementById("titreClasse").value = tabTitresClasse[currentClasse+2];

		if (currentClasse>0) {
			var niveau = document.getElementById("Niveau").value;
			var actif = document.getElementById('filterActif').checked;
			document.getElementById("num").flex = niveau;
			document.getElementById('pagination1').collapsed = true;
			document.getElementById('pagination2').collapsed = true;
			document.getElementById('niveaux').collapsed = false;
			aClasses.setParam("Arborescence", true);
			aClasses.setParam('Actif', actif);
			aClasses.setParam('Niveau', niveau);
			aClasses.setParam('Classe', currentClasse);
			aClasses.initTree();
		}
		else {
			document.getElementById("num").flex = 1;
			document.getElementById('pagination1').collapsed = false;
			document.getElementById('pagination2').collapsed = false;
			document.getElementById('niveaux').collapsed = true;
			listerComptes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechargerClasse() {
	try {

		chargerClasse(currentClasse);

	} catch (e) {
		recup_erreur(e);
	}
}


function listerComptes() {
	try {

		var typeCompte = currentClasse==-2?"C":currentClasse==-1?"F":"A";
		var actif = document.getElementById('filterActif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('Compte').disabled = true;
		aClasses.deleteTree();

		qListNC.setParam("Actif", actif);
		qListNC.setParam("Type_Compte", typeCompte);
		qListNC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListNC.setParam("Current_Page", pageCourante);

		var result = qListNC.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listCompteId = contenu.getAttribute("List_Compte_Id");

		aClasses.setParam("Arborescence", false);
		aClasses.setParam("List_Compte_Id", listCompteId);
		aClasses.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('Compte').disabled = true;

		qListNC.setParam("Current_Page", pageCourante);
		var result = qListNC.execute();
		var listCompteId = result.responseXML.documentElement.getAttribute("List_Compte_Id");

		aClasses.setParam("List_Compte_Id", listCompteId);
		aClasses.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('Compte').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirClasse() {
	try {

		if (aClasses.isSelected()){
  		var code = aClasses.getSelectedCellText('num');
			window.arguments[0](code);
		}
		window.close();

	} catch (e) {
    recup_erreur(e);
  }
}


function keypress(ev) {
	try {

		if (ev.keyCode==13) {
      ouvrirClasse();
    }

	} catch (e) {
    recup_erreur(e);
  }
}
