/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oc_aTranches = new Arbre("Compta/Comptes/list-trancheCollectif.tmpl", "oc-listeTranchesCollectifs");

var oc_currentTrancheId;



function oc_init() {
	try {

		oc_aTranches.initTree(oc_nouvelleTranche);

	} catch (e) {
		recup_erreur(e);
	}
}


function oc_selectTranche() {
	try {

		if (oc_aTranches.isSelected()) {
			document.getElementById('oc-compteDebut').value = oc_aTranches.getSelectedCellText('oc-colCompteDebut');
			document.getElementById('oc-compteFin').value = oc_aTranches.getSelectedCellText('oc-colCompteFin');
			oc_currentTrancheId = oc_aTranches.getSelectedCellText('oc-colTrancheId');

			document.getElementById('oc-bSupprimer').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oc_nouvelleTranche() {
	try {

		if (oc_aTranches.isSelected()) {
			oc_aTranches.clearSelection();
		}
		oc_currentTrancheId = "";

		document.getElementById('oc-compteDebut').value = "";
		document.getElementById('oc-compteFin').value = "";

		document.getElementById('oc-bSupprimer').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oc_supprimerTranche() {
	try {

		if (!isEmpty(oc_currentTrancheId)) {
			var compteDebut = oc_aTranches.getSelectedCellText('oc-colCompteDebut');
			var compteFin = oc_aTranches.getSelectedCellText('oc-colCompteFin');

			if (window.confirm("Confirmez-vous la suppression de la tranche du compte '"+ compteDebut +"' \u00E0 '"+ compteFin +"' ?")) {

				var qDelete = new QueryHttp("Compta/Comptes/deleteTrancheCollectif.tmpl");
				qDelete.setParam("Tranche_Id", oc_currentTrancheId);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oc_aTranches.initTree(oc_nouvelleTranche);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oc_enregistrerTranche() {
	try {

		var compteDebut = document.getElementById('oc-compteDebut').value;
		var compteFin = document.getElementById('oc-compteFin').value;

		if (!isCompteCorrect(compteDebut)) { showWarning("Compte de d\u00E9but incorrect"); }
		else if (!isCompteCorrect(compteFin)) { showWarning("Compte de fin incorrect"); }
		else if (compteDebut>compteFin) { showWarning("Le compte de d\u00E9but doit \u00EAtre inf\u00E9rieur au compte de fin"); }
		else {
			var qSave;
			
			if (isEmpty(oc_currentTrancheId)) {
				qSave = new QueryHttp("Compta/Comptes/createTrancheCollectif.tmpl");
			}
			else {
				qSave = new QueryHttp("Compta/Comptes/updateTrancheCollectif.tmpl");
				qSave.setParam("Tranche_Id", oc_currentTrancheId);
			}
			
			qSave.setParam("Min_Compte", compteDebut);
			qSave.setParam("Max_Compte", compteFin);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oc_aTranches.initTree(oc_nouvelleTranche);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
