/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oj_aJournal = new Arbre('Compta/Journaux/list-journal.tmpl', 'oj-listeJournaux');

var oj_journalId;



function oj_init() {
	try {

		oj_nouveauJournal();
    oj_aJournal.initTree();

		document.getElementById('oj-Code_Journal').focus();

		var aDossier = new Arbre('ComboListe/combo-dossiers.tmpl', 'oj-dossier');
		aDossier.initTree(oj_selDossier);

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_selDossier() {
	try {

		document.getElementById('oj-dossier').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_importerJournaux() {
	try {

		var dossierId = document.getElementById("oj-dossier").value;

		if (!isEmpty(dossierId) && window.confirm("Confirmez-vous la copie des journaux (qui ne sont pas pr\u00E9sents) du dossier "+ document.getElementById("oj-dossier").getAttribute("label") +" dans le dossier "+ getProfil().getCodeDossier())) {

			var queryEdit = new QueryHttp("Compta/Journaux/copyJournaux.tmpl");
			queryEdit.setParam("Dossier_Id", dossierId);
			var result = queryEdit.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La liste des journaux a \u00E9t\u00E9 mise \u00E0 jour !");
				oj_nouveauJournal();
				oj_aJournal.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_rechercherCompte(id) {
	try {

		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oj_retourRechercherCompte, "5", "G", "DE TRESORERIE", "5", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById('oj-Contrepartie').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_enableContrepartie() {
	try {

		document.getElementById("oj-rowContrepartie").collapsed = !(document.getElementById("oj-Type_Journal").value=="TR");

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_enregistrerJournal() {
	try {

		var codeJournal = document.getElementById('oj-Code_Journal').value;
		var intitule = document.getElementById('oj-Intitule').value;
		var typeJournal = document.getElementById('oj-Type_Journal').value;
		var contrepartie = document.getElementById('oj-Contrepartie').value;
		var actif = document.getElementById('oj-Actif').checked;

		if (isEmpty(codeJournal)) {
			showWarning("Code journal manquant");
		}
		else if (isEmpty(intitule)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else if (typeJournal=='TR' && (isEmpty(contrepartie) || !isCompteCorrect(contrepartie))) {
			showWarning("Num\u00E9ro de compte de contrepartie incorrect");
		}
		else {
			var qSaveJournal;

			if (isEmpty(oj_journalId)) {
				qSaveJournal = new QueryHttp("Compta/Journaux/createJournal.tmpl");
				qSaveJournal.setParam('Code_Journal', codeJournal);
			}
			else {
				qSaveJournal = new QueryHttp("Compta/Journaux/updateJournal.tmpl");
				qSaveJournal.setParam("Journal_Id", oj_journalId);
			}

			qSaveJournal.setParam('Contrepartie', contrepartie);
			qSaveJournal.setParam('Intitule', intitule);
			qSaveJournal.setParam('Type_Journal', typeJournal);
			qSaveJournal.setParam('Actif', actif);

			var result = qSaveJournal.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oj_nouveauJournal();
				oj_aJournal.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_nouveauJournal() {
	try {

		oj_journalId = "";
		document.getElementById('oj-bSupprimer').disabled = true;
		document.getElementById('oj-bNouveau').disabled = true;

		document.getElementById('oj-Code_Journal').disabled = false;
		document.getElementById('oj-Code_Journal').value = "";
		document.getElementById('oj-Type_Journal').value = "TR";
		document.getElementById('oj-Intitule').value = "";
		document.getElementById('oj-Contrepartie').value = "";
		document.getElementById('oj-rowContrepartie').collapsed = false;
		document.getElementById('oj-Type_Journal').disabled = false;
		document.getElementById('oj-Actif').checked = true;

		oj_aJournal.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_supprimerJournal() {
	try {

		var codeJournal = document.getElementById('oj-Code_Journal').value;
		var typeJournal = document.getElementById('oj-Type_Journal').value;

		if (typeJournal=="AN") {
			showWarning("Impossible de supprimer le journal "+ codeJournal);
		}
		else if (window.confirm("Confirmez-vous la suppression du journal "+ codeJournal +" ?")) {

			var qSupJournal = new QueryHttp("Compta/Journaux/deleteJournal.tmpl");
			qSupJournal.setParam('Journal_Id', oj_journalId);
			var result = qSupJournal.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oj_nouveauJournal();
				oj_aJournal.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oj_chargerJournal() {
	try {

		if (oj_aJournal.isSelected()) {
			oj_journalId = oj_aJournal.getSelectedCellText('oj-ColJournalId');
			document.getElementById('oj-Code_Journal').disabled = true;

			document.getElementById('oj-Code_Journal').value = oj_aJournal.getSelectedCellText('oj-ColCode_Journal');
			document.getElementById('oj-Intitule').value = oj_aJournal.getSelectedCellText('oj-ColIntitule');
			document.getElementById('oj-Type_Journal').value = oj_aJournal.getSelectedCellText('oj-ColType_Journal');
			document.getElementById('oj-Contrepartie').value = oj_aJournal.getSelectedCellText('oj-ColContrepartie');
			document.getElementById('oj-Actif').checked = oj_aJournal.getSelectedCellText('oj-ColActif')=="true";

			oj_enableContrepartie();

			document.getElementById('oj-Type_Journal').disabled = (document.getElementById('oj-Type_Journal').value=="AN");

			document.getElementById('oj-bSupprimer').disabled = false;
			document.getElementById('oj-bNouveau').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}
