/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var coherenceGeneraux = false;
var coherenceJournaux = false;
var coherenceTiers = false;
var coherenceCJ = false;

var lastFichierPDF = null;

var creditG = 0;
var debitG = 0;
var creditF = 0;
var debitF = 0;
var debitC = 0;
var creditC = 0;
var credit40 = 0;
var debit40 = 0;
var credit41 = 0;
var debit41 = 0;

var nfs = new NumberFormat("0.00", true);



function init() {
  try {

		document.getElementById('progression').setAttribute("mode", "undetermined");

		document.getElementById("Sous_Titre").value = "calcul en cours des \u00E0 nouveaux temporaires...";

		var qANTemp = new QueryHttp('Compta/UpdateDatabase/RegenererANouveaux.tmpl');
		qANTemp.execute(checkCoherence);

	} catch (e) {
    recup_erreur(e);
  }
}


function checkCoherence() {
  try {

		document.getElementById('progression').setAttribute("mode", "determined");
		document.getElementById('progression').value = 10;

		var qGet = new QueryHttp('Compta/Coherence/getNbOpExercice.tmpl');
		var result = qGet.execute();
		document.getElementById("Sous_Titre").value = "NOMBRE TOTAL D'ECRITURES DANS L'EXERCICE : "+ result.responseXML.documentElement.getAttribute('Nb_Op');

		document.getElementById('progression').value = 20;

		checkGeneraux();
		document.getElementById('progression').value = 45;

		checkJournaux();
		document.getElementById('progression').value = 55;

		checkComptesFournisseurs();
		document.getElementById('progression').value = 75;

		checkCollectifsFournisseurs();
		document.getElementById('progression').value = 80;

		checkComptesClients();
		document.getElementById('progression').value = 95;

		checkCollectifsClients();
		document.getElementById('progression').value = 100;

		document.getElementById('bEditer').collapsed = false;

		if (coherenceTiers && coherenceGeneraux && coherenceJournaux && coherenceCJ) {
			document.getElementById('bEntrer').collapsed = false;
			document.getElementById('bEntrer2').collapsed = false;
		}
		else {
			document.getElementById('bEnvoyer').collapsed = false;
			document.getElementById('bEnvoyer2').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function checkGeneraux() {
  try {

		document.getElementById("Credit_Compte").value = "0.00";
		document.getElementById("Debit_Compte").value = "0.00";
		document.getElementById("Ecart_Compte").value = "0.00";

		var credit = 0;
		var debit = 0;
		var ecart = 0;

		var qCheck = new QueryHttp('Compta/Coherence/checkComptes.tmpl');
		qCheck.setParam("Type_Compte", "G");
		var result = qCheck.execute();

		var childNodes = result.responseXML.documentElement.childNodes;

		for (i=1; i<childNodes.length; i++) {
			if (childNodes.item(i).nodeType==Node.ELEMENT_NODE) {
				credit += parseFloat(childNodes.item(i).getAttribute('Credit'));
				debit += parseFloat(childNodes.item(i).getAttribute('Debit'));
				ecart = debit - credit;

				document.getElementById("Credit_Compte").value = nfs.format(credit);
				document.getElementById("Debit_Compte").value = nfs.format(debit);
				document.getElementById("Ecart_Compte").value = nfs.format(ecart);
			}
		}

		creditG = credit;
		debitG = debit;

		if (ecart<0.01 && ecart>-0.01) {
			coherenceGeneraux = true;
			document.getElementById("Ecart_Compte").value = "0.00";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function checkJournaux() {
  try {

		document.getElementById("Credit_Journal").value = "0.00";
		document.getElementById("Debit_Journal").value = "0.00";
		document.getElementById("Ecart_Journal").value = "0.00";

		var credit = 0;
		var debit = 0;
		var ecart = 0;

		var qCheck = new QueryHttp("Compta/Coherence/checkJournaux.tmpl");
		var result = qCheck.execute();

		var childNodes = result.responseXML.documentElement.childNodes;

		for (i=1; i<childNodes.length; i++) {
			if (childNodes.item(i).nodeType==Node.ELEMENT_NODE) {
				credit += parseFloat(childNodes.item(i).getAttribute('Credit'));
				debit += parseFloat(childNodes.item(i).getAttribute('Debit'));
				ecart = debit - credit;

				document.getElementById("Credit_Journal").value = nfs.format(credit);
				document.getElementById("Debit_Journal").value = nfs.format(debit);
				document.getElementById("Ecart_Journal").value = nfs.format(ecart);
			}
		}

		if (ecart<0.01 && ecart>-0.01) {
			coherenceJournaux = true;
			document.getElementById("Ecart_Journal").value = "0.00";
		}

		var ecartCreditCJ = creditG - credit;
		var ecartDebitCJ = debitG - debit;

		if (ecartCreditCJ<0.01 && ecartCreditCJ>-0.01 && ecartDebitCJ<0.01 && ecartDebitCJ>-0.01) {
			coherenceCJ = true;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function checkComptesFournisseurs() {
  try {

		document.getElementById("Credit_Fournisseur").value = "0.00";
		document.getElementById("Debit_Fournisseur").value = "0.00";

		var credit = 0;
		var debit = 0;

		var qCheck = new QueryHttp('Compta/Coherence/checkComptes.tmpl');
		qCheck.setParam("Type_Compte", "F");
		var result = qCheck.execute();

		var childNodes = result.responseXML.documentElement.childNodes;

		for (i=1; i<childNodes.length; i++) {
			if (childNodes.item(i).nodeType==Node.ELEMENT_NODE) {
				credit += parseFloat(childNodes.item(i).getAttribute('Credit'));
				debit += parseFloat(childNodes.item(i).getAttribute('Debit'));

				document.getElementById("Credit_Fournisseur").value = nfs.format(credit);
				document.getElementById("Debit_Fournisseur").value = nfs.format(debit);
			}
		}

		creditF = credit;
		debitF = debit;

	} catch (e) {
    recup_erreur(e);
  }
}


function checkCollectifsFournisseurs() {
  try {

		var qCheck = new QueryHttp("Compta/Coherence/checkCollectifs.tmpl");
		qCheck.setParam("Racine", "40");
		var result = qCheck.execute();

		var contenu = result.responseXML.documentElement;

		credit40 = contenu.getAttribute('Credit');
		debit40 = contenu.getAttribute('Debit');

		document.getElementById("Credit_40").value = nfs.format(credit40);
		document.getElementById("Debit_40").value = nfs.format(debit40);

		var ecartCF40 = creditF-credit40;
		var ecartDF40 = debitF-debit40;

		document.getElementById("Ecart_CF").value = nfs.format(ecartCF40);
		document.getElementById("Ecart_DF").value = nfs.format(ecartDF40);

		if (ecartCF40<0.01 && ecartCF40>-0.01) {
			document.getElementById("Ecart_CF").value = "0.00";
		}

		if (ecartDF40<0.01 && ecartDF40>-0.01) {
			document.getElementById("Ecart_DF").value = "0.00";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function checkComptesClients() {
  try {

		document.getElementById("Credit_Client").value = "0.00";
		document.getElementById("Debit_Client").value = "0.00";

		var debit = 0;
		var credit = 0;

		var qCheck = new QueryHttp('Compta/Coherence/checkComptes.tmpl');
		qCheck.setParam("Type_Compte", "C");
		var result = qCheck.execute();

		var childNodes = result.responseXML.documentElement.childNodes;

		for (i=1; i<childNodes.length; i++) {
			if (childNodes.item(i).nodeType==Node.ELEMENT_NODE) {
				credit += parseFloat(childNodes.item(i).getAttribute('Credit'));
				debit += parseFloat(childNodes.item(i).getAttribute('Debit'));

				document.getElementById("Credit_Client").value = nfs.format(credit);
				document.getElementById("Debit_Client").value = nfs.format(debit);
			}
		}

		debitC = debit;
		creditC = credit;

	} catch (e) {
    recup_erreur(e);
  }
}


function checkCollectifsClients() {
  try {

    var qCheck = new QueryHttp("Compta/Coherence/checkCollectifs.tmpl");
		qCheck.setParam("Racine", "41");
		var result = qCheck.execute();

		var contenu = result.responseXML.documentElement;

		credit41 = contenu.getAttribute('Credit');
		debit41 = contenu.getAttribute('Debit');

		document.getElementById("Credit_41").value = nfs.format(credit41);
		document.getElementById("Debit_41").value = nfs.format(debit41);

		var ecartCC41 = creditC-credit41;
		var ecartDC41 = debitC-debit41;

		document.getElementById("Ecart_DC").value = nfs.format(ecartDC41);
		document.getElementById("Ecart_CC").value = nfs.format(ecartCC41);

		if (ecartCC41<0.01 && ecartCC41>-0.01) {
			document.getElementById("Ecart_CC").value = "0.00";
		}

		if (ecartDC41<0.01 && ecartDC41>-0.01) {
			document.getElementById("Ecart_DC").value = "0.00";
		}

		var ecartTiers = parseFloat(debit41)-debitC+parseFloat(credit41)-creditC+parseFloat(debit40)-debitF+parseFloat(credit40)-creditF;

		if (ecartTiers<0.001 && ecartTiers>-0.001) {
			coherenceTiers = true;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editerRapport() {
	try {

		document.getElementById('pdfRapport').setAttribute("src", "");

		if (lastFichierPDF==null) {
			genererRapport();
		}

		var page = getDirPdf() + lastFichierPDF;
		document.getElementById('pdfRapport').setAttribute("src", page);

		document.getElementById('deck').selectedIndex = 1;

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerRapport() {
	try {

		if (lastFichierPDF==null) {
			genererRapport();
		}

		var qSend = new QueryHttp("Compta/Coherence/sendRapportCoherence.tmpl");
		qSend.setParam("Fichier_Id", lastFichierPDF);
		qSend.execute();

		showMessage("Le rapport a \u00E9t\u00E9 envoy\u00E9");

	} catch (e) {
    recup_erreur(e);
  }
}


function genererRapport() {
	try {

		lastFichierPDF = null;

		var qEditionPdf = new QueryHttp("Compta/Coherence/pdfRapportCoherence.tmpl");
		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			lastFichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function entrerExercice() {
  try {

		window.location = "chrome://opensi/content/compta/user/menu_exercice.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuExercice() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_dossier.xul?"+ cookie();

  } catch (e) {
    recup_erreur(e);
  }
}


function retourChoixDossier() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu.xul?"+ cookie();

  } catch (e) {
    recup_erreur(e);
  }
}
