/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var lastFichierPDF = null;



function init() {
  try {

		document.getElementById('typeCompte').value = ParamValeur("Type")=="F"?"F":"C";
		document.getElementById('typePeriode').value = "A";
		document.getElementById('tri').value = "N";

		pressOnTypePeriode();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypePeriode() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;

		if (typePeriode=='A') {
			document.getElementById('periodeFin').disabled = true;
			document.getElementById('periodeFin').value = "";
		}
		else {
			document.getElementById('periodeFin').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function checkTranche() {
	try {

		var ok = false;

		var tranche1 = document.getElementById('tranche1').value;
		var tranche2 = document.getElementById('tranche2').value;
		var tranche3 = document.getElementById('tranche3').value;
		var tranche4 = document.getElementById('tranche4').value;

		if (isEmpty(tranche1) || !isPositive(tranche1)) {
			showWarning("Tranche 1 invalide");
			document.getElementById('tranche1').value = "";
		}
		else if (isEmpty(tranche2) || !isPositive(tranche2)) {
			showWarning("Tranche 2 invalide");
			document.getElementById('tranche2').value = "";
		}
		else if (isEmpty(tranche3) || !isPositive(tranche3)) {
			showWarning("Tranche 3 invalide");
			document.getElementById('tranche3').value = "";
		}
		else if (isEmpty(tranche4) || !isPositive(tranche4)) {
			showWarning("Tranche 4 invalide");
			document.getElementById('tranche4').value = "";
		}
		else if (!(parseIntBis(tranche1) <= parseIntBis(tranche2) && parseIntBis(tranche2) <= parseIntBis(tranche3) && parseIntBis(tranche3) <= parseIntBis(tranche4))) {
			showWarning("Tranches incoh\u00E9rentes");
		}
		else {
			document.getElementById('label2').value = "de "+ tranche1 +" \u00E0";
			document.getElementById('label3').value = "de "+ tranche2 +" \u00E0";
			document.getElementById('label4').value = "de "+ tranche3 +" \u00E0";
			document.getElementById('label5').value = tranche4 +" jours";
			ok = true;
		}

		return ok;

	} catch (e) {
    recup_erreur(e);
  }
}


function editionPDF() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;
		var periodeFin = document.getElementById('periodeFin').value;
		var typeCompte = document.getElementById("typeCompte").value;
		var tri = document.getElementById("tri").value;
		var tranche1 = document.getElementById('tranche1').value;
		var tranche2 = document.getElementById('tranche2').value;
		var tranche3 = document.getElementById('tranche3').value;
		var tranche4 = document.getElementById('tranche4').value;

		if (typePeriode=="D" && !isDate(periodeFin)) { showMessage("P\u00E9riode de fin incorrecte"); }
		else if(checkTranche()) {

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			document.getElementById('pdfBalanceAgee').setAttribute("src", "");
			lastFichierPDF = null;

			var qEditionPdf = new QueryHttp("Compta/Editions/pdfBalanceAgee.tmpl");

			qEditionPdf.setParam("Periode_Fin", periodeFin);
			qEditionPdf.setParam("Type_Compte", typeCompte);
			qEditionPdf.setParam("Tri", tri);
			qEditionPdf.setParam("Tranche_1", tranche1);
			qEditionPdf.setParam("Tranche_2", tranche2);
			qEditionPdf.setParam("Tranche_3", tranche3);
			qEditionPdf.setParam("Tranche_4", tranche4);

			qEditionPdf.execute(editionPDF_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function editionPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
			var page = getDirPdf() + fichierPDF;
			document.getElementById('pdfBalanceAgee').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourOptions').collapsed = false;

			lastFichierPDF = fichierPDF;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourOptions() {
  try {

		document.getElementById('pdfBalanceAgee').setAttribute("src", "");
   	document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourOptions').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		if (lastFichierPDF!=null) {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CGBA", lastFichierPDF);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

  } catch (e) {
    recup_erreur(e);
  }
}
