/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oib_aJournaux = new Arbre('ComboListe/combo-journaux.tmpl', 'oib-journal');
var oib_aLigneImport = new Arbre('Compta/ImportBanque/list-ligneImportBanque.tmpl', 'oib-treeLigneImport');
var oib_aEcritureBanque = new Arbre('Compta/ImportBanque/list-ligneEcritureBanque.tmpl', 'oib-treeLigneEcriture');

var oib_importId;
var oib_besoinAnnee;
var oib_ligneImportId;
var oib_journal;
var oib_paramId;
var oib_coherence;
var oib_etatValide;
var oib_soldesOk;
var oib_importFile;
var oib_selJournal;



function oib_init() {
 	try {

		oib_aJournaux.setParam("Type_Journal", "TR");

		oib_reset();

 		oib_activeLigneImport(false);

  	var aFormats = new Arbre('ComboListe/combo-formatsImportBanque.tmpl', 'oib-formatImport');
  	aFormats.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_reset() {
	try {

 		oib_importId = 0;
 		oib_besoinAnnee = false;
 		oib_ligneImportId = 0;
 		oib_journal = "";
 		oib_paramId = 0;
 		oib_coherence = false;
 		oib_etatValide = false;
 		oib_soldesOk = false;

 		oib_videImport();
 		oib_videLigneImport();
 		oib_videParam();

 		oib_chargerJournaux("");
 		ogi_setTabParamDisabled(true);

		document.getElementById('oib-menuImport').collapsed = false;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_chargerJournaux(selection) {
	try {

		oib_selJournal = selection;
		oib_aJournaux.setParam("Selection", oib_selJournal);
		oib_aJournaux.initTree(oib_initJournal);

	} catch (e) {
		recup_erreur(e);
	}
}


function oib_initJournal() {
  try {

		document.getElementById('oib-journal').value = oib_selJournal;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_activeImport(boolean) {
	try {

		if (oib_etatValide) {
			document.getElementById('oib-formatImport').disabled = true;
			document.getElementById('oib-anneeImport').disabled = true;
			document.getElementById('oib-pathFile').disabled = true;
			document.getElementById('oib-bImporter').disabled = true;
			document.getElementById('oib-soldeDebut').disabled = true;
			document.getElementById('oib-soldeFin').disabled = true;
		}
		else {
			document.getElementById('oib-formatImport').disabled = !boolean;
			document.getElementById('oib-anneeImport').disabled = !boolean;
			document.getElementById('oib-pathFile').disabled = !boolean;
			if (document.getElementById('oib-formatImport').value=="") {
				document.getElementById('oib-bImporter').disabled = true;
			}
			else {
				document.getElementById('oib-bImporter').disabled = !boolean;
			}
			document.getElementById('oib-soldeDebut').disabled = !boolean;
			document.getElementById('oib-soldeFin').disabled = !boolean;
		}

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_activeLigneImport(boolean) {
	try {

		if (oib_importId==0 || oib_etatValide) {
			document.getElementById('oib-dateLigne').disabled = true;
			document.getElementById('oib-libelleLigne').disabled = true;
			document.getElementById('oib-debitLigne').disabled = true;
			document.getElementById('oib-creditLigne').disabled = true;
			document.getElementById('oib-reglementLigne').disabled = true;
			document.getElementById('oib-pieceLigne').disabled = true;
			document.getElementById('oib-annulerLigne').disabled = true;
			document.getElementById('oib-validerLigne').disabled = true;
			document.getElementById('oib-supprimerLigne').disabled = true;
		}
		else {
			document.getElementById('oib-dateLigne').disabled = !boolean;
			document.getElementById('oib-libelleLigne').disabled = !boolean;
			document.getElementById('oib-debitLigne').disabled = !boolean;
			document.getElementById('oib-creditLigne').disabled = !boolean;
			document.getElementById('oib-reglementLigne').disabled = !boolean;
			document.getElementById('oib-pieceLigne').disabled = !boolean;
			document.getElementById('oib-annulerLigne').disabled = !boolean;
			document.getElementById('oib-validerLigne').disabled = !boolean;
			document.getElementById('oib-supprimerLigne').disabled = !boolean;
		}

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_activeParam(boolean) {
	try {

		if (oib_etatValide || oib_importId==0) {
			document.getElementById('oib-journal').disabled = true;
		}
		else {
			document.getElementById('oib-journal').disabled = !boolean;
		}
		oib_activeInfosParam(boolean);

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_activeInfosParam(boolean) {
	try {

		if (oib_paramId==0 || oib_etatValide) {
			document.getElementById('oib-centralisation').disabled = true;
			document.getElementById('oib-compteBanque').disabled = true;
			document.getElementById('oib-bRechBanque').disabled = true;
			document.getElementById('oib-concatLSM').disabled = true;
			document.getElementById('oib-compteAttente').disabled = true;
			document.getElementById('oib-bRechAttente').disabled = true;
		}
		else {
			document.getElementById('oib-centralisation').disabled = !boolean;
			document.getElementById('oib-compteBanque').disabled = !boolean;
			document.getElementById('oib-bRechBanque').disabled = !boolean;
			document.getElementById('oib-concatLSM').disabled = !boolean;
			document.getElementById('oib-compteAttente').disabled = !boolean;
			document.getElementById('oib-bRechAttente').disabled = !boolean;
		}

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_activeActionImport(boolean) {
	try {

		if (oib_importId==0 || oib_etatValide) {
			document.getElementById('oib-supprimer').disabled = true;
		}
		else {
			document.getElementById('oib-supprimer').disabled = !boolean;
		}
		if (oib_paramId==0 || oib_etatValide) {
			document.getElementById('oib-rafraichir').disabled = true;
		}
		else {
			document.getElementById('oib-rafraichir').disabled = !boolean;
		}
		if (!oib_coherence || oib_etatValide || !oib_soldesOk) {
			document.getElementById('oib-valider').disabled = true;
		}
		else {
			document.getElementById('oib-valider').disabled = !boolean;
		}

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_activeAll(boolean) {
	try {

		oib_activeImport(boolean);
		oib_activeLigneImport(boolean);
		oib_activeParam(boolean);
		oib_activeActionImport(boolean);
		ogi_setTabParamDisabled(oib_etatValide || oib_journal=="" || !boolean);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_videImport() {
	try {

		document.getElementById('oib-formatImport').value = "";
		document.getElementById('oib-pathFile').value = "";
		document.getElementById('oib-anneeImport').value = "";
		document.getElementById('oib-soldeDebut').value = "";
		document.getElementById('oib-soldeFin').value = "";
		document.getElementById('oib-soldeCalcule').value = "";
		document.getElementById('oib-journal').value = "";

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_videLigneImport() {
	try {

		document.getElementById('oib-dateLigne').value = "";
		document.getElementById('oib-libelleLigne').value = "";
		document.getElementById('oib-debitLigne').value = "";
		document.getElementById('oib-creditLigne').value = "";
		document.getElementById('oib-reglementLigne').value = "";
		document.getElementById('oib-pieceLigne').value = "";

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_videParam() {
	try {

		document.getElementById('oib-compteBanque').value = "";
		document.getElementById('oib-compteAttente').value = "";
		document.getElementById('oib-centralisation').checked = false;
		document.getElementById('oib-concatLSM').checked = false;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_nouveau() {
 	try {

 		oib_reset();
 		oib_activeAll(true);
  	oib_aLigneImport.deleteTree();
  	oib_aEcritureBanque.deleteTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_ouvrir(importId) {
 	try {

		ogi_setSelectedTab(0);
		oib_reset();
		oib_importId = importId;

		var qLoad = new QueryHttp("Compta/ImportBanque/loadImportBanque.tmpl");
		qLoad.setParam("Import_Id", oib_importId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		var fin = contenu.getAttribute('Solde_Fin');
		var calc = contenu.getAttribute('Solde_Calc');

		document.getElementById('oib-soldeDebut').value = contenu.getAttribute('Solde_Debut');
		document.getElementById('oib-soldeFin').value = fin;
		document.getElementById('oib-soldeCalcule').value = calc;
		oib_soldesOk = (fin==calc);

		oib_etatValide = contenu.getAttribute('Etat')=='V';

		var paramId = contenu.getAttribute('Param_Id');
		if (isEmpty(paramId)) {
			paramId = 0;
		}
		oib_paramId = paramId;

		ogi_setTabParamDisabled(oib_paramId==0);

		document.getElementById('oib-formatImport').value = contenu.getAttribute('Format_Import');
		oib_activeAnnee();

		oib_coherence = contenu.getAttribute('Coherence')=="true";

		oib_journal = contenu.getAttribute('Journal_Banque');
		oib_chargerJournaux(oib_journal);
		document.getElementById('oib-centralisation').checked = contenu.getAttribute('Centralisation')=="true";
		document.getElementById('oib-compteBanque').value = contenu.getAttribute('Compte_Banque');
		document.getElementById('oib-concatLSM').checked = contenu.getAttribute('Concat_LSM')=="true";
		document.getElementById('oib-compteAttente').value = contenu.getAttribute('Compte_Attente');

		oib_activeAll(true);

		oib_aLigneImport.setParam("Import_Id", oib_importId);
  	oib_aLigneImport.initTree();

  	oib_aEcritureBanque.setParam("Import_Id", oib_importId);
  	oib_aEcritureBanque.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			oib_importFile = file;
			document.getElementById("oib-pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oib_importer() {
	try {

		if (oib_importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier");
		}
		else if (checkUploadFile(oib_importFile)) {

			uploadFile(oib_importFile);

			var formatImport = document.getElementById('oib-formatImport').value;
			var qImport = new QueryHttp("Compta/ImportBanque/processImport.tmpl");
			qImport.setParam("Import_Id", oib_importId);
			qImport.setParam("Format_Id", formatImport);
			qImport.setParam("Fichier", oib_importFile.leafName);
			qImport.setParam("Annee", document.getElementById('oib-anneeImport').value);
			var result = qImport.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oib_ouvrir(result.responseXML.documentElement.getAttribute("Import_Id"));
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oib_activeAnnee() {
	try {

		if (document.getElementById('oib-formatImport').value!="") {
	  	var qGet = new QueryHttp("Compta/ImportBanque/getBesoinAnnee.tmpl");
	  	qGet.setParam("Format", document.getElementById('oib-formatImport').value);
	  	var result = qGet.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oib_besoinAnnee = (result.responseXML.documentElement.getAttribute("besoin")=="true");
	  		document.getElementById('oib-ligneAnnee').collapsed = !oib_besoinAnnee;
	  		if (!oib_besoinAnnee) {
	  			document.getElementById('oib-anneeImport').value = "";
	  		}
	  	}
	  }
		else {
	  	oib_besoinAnnee = false;
	  	document.getElementById('oib-ligneAnnee').collapsed = true;
	  	document.getElementById('oib-anneeImport').value = "";
	  }

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_verifAnnee(annee) {
	try {

		if (annee.length==4) {
			return isPositive(annee);
		}
		else {
			return false;
		}

	} catch (e) {
  		recup_erreur(e);
	}
}


function oib_pressOnImporter() {
	try {

		if (oib_importId==0 || window.confirm("Etes-vous s\u00FBr de vouloir \u00E9craser les pr\u00E9c\u00E9dentes donn\u00E9es de l'import ?")) {
			if (oib_besoinAnnee && isEmpty(document.getElementById('oib-anneeImport').value)) {
				showWarning("Veuillez saisir une ann\u00E9e concern\u00E9e pour ce type d'import !");
			}
			else if (oib_besoinAnnee && !oib_verifAnnee(document.getElementById('oib-anneeImport').value)) {
				showWarning("Veuillez saisir une ann\u00E9e au format 'yyyy' !");
			}
			else {
				oib_activeImport(false);
				var debut = document.getElementById('oib-soldeDebut').value;
				var fin = document.getElementById('oib-soldeFin').value;
	  		oib_importer();
	  		document.getElementById('oib-soldeDebut').value = debut;
	  		document.getElementById('oib-soldeFin').value = fin;
	  		if (oib_importId!=0) {
					oib_saveSoldes();
	  		}
	  		oib_activeImport(true);
	  	}
	  }

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_selectOnFormatImport() {
	try {

 		oib_activeAnnee();
 		oib_activeImport(true);

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_selectOnTreeLigneImport() {
	try {

 		if (oib_aLigneImport.isSelected()) {
 			var index = oib_aLigneImport.getCurrentIndex();
			oib_ligneImportId = oib_aLigneImport.getCellText(index,"oib-colLigneId");
			document.getElementById('oib-dateLigne').value = oib_aLigneImport.getCellText(index,'oib-colDate');
			document.getElementById('oib-libelleLigne').value = oib_aLigneImport.getCellText(index,'oib-colLibelle');
			document.getElementById('oib-debitLigne').value = oib_aLigneImport.getCellText(index,'oib-colDebit');
			document.getElementById('oib-creditLigne').value = oib_aLigneImport.getCellText(index,'oib-colCredit');
			document.getElementById('oib-reglementLigne').value = oib_aLigneImport.getCellText(index,'oib-colReglement');
			document.getElementById('oib-pieceLigne').value = oib_aLigneImport.getCellText(index,'oib-colNumPiece');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oib_pressOnAnnulerLigne() {
	try {

  	oib_annulerLigne();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_pressOnValiderLigne() {
	try {

  	if (isEmpty(document.getElementById('oib-dateLigne').value) || !isDate(document.getElementById('oib-dateLigne').value)) { showWarning("Date incorrecte !"); }
  	else if (isEmpty(document.getElementById('oib-libelleLigne').value)) { showWarning("Libell\u00E9 incorrect !"); }
		else if (!isEmpty(document.getElementById('oib-debitLigne').value) && !checkNumber(document.getElementById('oib-debitLigne').value, 16, 2)) { showWarning("Montant au d\u00E9bit incorrect !"); }
		else if (!isEmpty(document.getElementById('oib-debitLigne').value) && !isPositiveOrNull(document.getElementById('oib-debitLigne').value)) { showWarning("Montant au d\u00E9bit incorrect : montant n\u00E9gatif !"); }
		else if (!isEmpty(document.getElementById('oib-creditLigne').value) && !checkNumber(document.getElementById('oib-creditLigne').value, 16, 2)) { showWarning("Montant au cr\u00E9dit incorrect !"); }
		else if (!isEmpty(document.getElementById('oib-creditLigne').value) && !isPositiveOrNull(document.getElementById('oib-creditLigne').value)) { showWarning("Montant au cr\u00E9dit incorrect : montant n\u00E9gatif !"); }
		// verif debit ou credit : l'un ou l'autre doit tre vide mais pas les deux
		// doubles vides : (d="" || d=0) && (c="" || c=0)
		else if ((isEmpty(document.getElementById('oib-debitLigne').value)
				|| document.getElementById('oib-debitLigne').value==0)
			&& (isEmpty(document.getElementById('oib-creditLigne').value)
				|| document.getElementById('oib-creditLigne').value==0)) {
			showWarning("Veuillez saisir un debit ou un credit !");
		}
		// doubles montants : d=x && c=x  <=>  d!="" && d!=0 && c!="" && c!=0
		else if (!isEmpty(document.getElementById('oib-debitLigne').value)
			&& !isEmpty(document.getElementById('oib-creditLigne').value)
			&& document.getElementById('oib-debitLigne').value!=0
			&& document.getElementById('oib-creditLigne').value!=0) {
			showWarning("Veuillez ne saisir qu'un d\u00E9bit OU un cr\u00E9dit !");
		}
  	else {
  		oib_activeLigneImport(false);
 			oib_saveSoldes();
  		oib_saveLigne();
  	}

	} catch (e) {
 		recup_erreur(e);
	}
}


function oib_pressOnSupprimerLigne() {
	try {

  	if (oib_ligneImportId!=0) {
			oib_activeLigneImport(false);
			oib_saveSoldes();
  		oib_supprimerLigne();
  	}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_annulerLigne() {
	try {

		oib_ligneImportId = 0;
		oib_aLigneImport.clearSelection();

		document.getElementById('oib-dateLigne').value = "";
		document.getElementById('oib-libelleLigne').value = "";
		document.getElementById('oib-debitLigne').value = "";
		document.getElementById('oib-creditLigne').value = "";
		document.getElementById('oib-reglementLigne').value = "";
		document.getElementById('oib-pieceLigne').value = "";

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_saveLigne() {
	try {

		var qSave = new QueryHttp("Compta/ImportBanque/saveLigne.tmpl");

		qSave.setParam("Ligne_Id", oib_ligneImportId);
		qSave.setParam("Date", document.getElementById('oib-dateLigne').value);
		qSave.setParam("Libelle", document.getElementById('oib-libelleLigne').value);
		qSave.setParam("Montant_D", document.getElementById('oib-debitLigne').value);
		qSave.setParam("Montant_C", document.getElementById('oib-creditLigne').value);
		qSave.setParam("Mode_Reg", document.getElementById('oib-reglementLigne').value);
		qSave.setParam("Num_Piece", document.getElementById('oib-pieceLigne').value);
		qSave.setParam("Import_Id", oib_importId);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oib_activeAll(true);
		}
		else {
  		oib_ouvrir(oib_importId);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_supprimerLigne() {
	try {

		var qDelete = new QueryHttp("Compta/ImportBanque/deleteLigne.tmpl");
		qDelete.setParam("Ligne_Id", oib_ligneImportId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oib_activeAll(true);
		}
		else {
  		oib_ouvrir(oib_importId);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_selectOnJournal() {
	try {

		var journal = document.getElementById('oib-journal').value;
		ogi_setTabParamDisabled(isEmpty(journal));
		oib_saveSoldes();

		if (!isEmpty(journal)) {
			oib_saveJournal();
			oib_getParam();
		}
		else {
			oib_videParam();
			oib_paramId = 0;
			oib_activeParam(true);
			oib_activeActionImport(true);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_pressOnRechercherCompteBanque() {
	try {

		oib_recherche_compteBanque();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_pressOnRechercherCompteJournal() {
	try {

		oib_recherche_compteAttente();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_saveJournal() {
	try {

		var qSave = new QueryHttp("Compta/ImportBanque/saveJournalImport.tmpl");
  	qSave.setParam("Import_Id", oib_importId);
  	qSave.setParam("Journal_Banque", document.getElementById('oib-journal').value);
  	var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			oib_ouvrir(oib_importId);
  	}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_getParam() {
	try {

		var qGet = new QueryHttp("Compta/ImportBanque/loadParamImportBanque.tmpl");
		qGet.setParam("Param_Id", oib_paramId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oib_journal = contenu.getAttribute('Journal_Banque');
		document.getElementById('oib-journal').value = oib_journal;
		document.getElementById('oib-centralisation').checked = contenu.getAttribute('Centralisation')=="true";
		document.getElementById('oib-compteBanque').value = contenu.getAttribute('Compte_Banque');
		document.getElementById('oib-concatLSM').checked = contenu.getAttribute('Concat_LSM')=="true";
		document.getElementById('oib-compteAttente').value = contenu.getAttribute('Compte_Attente');

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_pressOnSupprimer() {
	try {

		oib_activeActionImport(false);
 		oib_supprimerImport();
 		oib_activeActionImport(true);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_pressOnRafraichir() {
	try {

		if (!isCompteCorrect(document.getElementById('oib-compteBanque').value)) { showWarning("Num\u00E9ro de compte de banque incorrect !"); }
		else if (!isCompteCorrect(document.getElementById('oib-compteAttente').value)) { showWarning("Num\u00E9ro de compte d'attente incorrect !"); }
		else {
			oib_activeActionImport(false);
			oib_saveSoldes();
			oib_saveParam();
			oib_refreshListeEcriture();
			oib_activeActionImport(true);
	  }

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_pressOnValider() {
	try {

 		oib_activeActionImport(false);
		oib_saveSoldes();
		if (oib_soldesOk) {
			oib_validerImport();
		}
		else {
			showWarning("Les soldes ne correspondent plus, la validation est annul\u00E9e !");
		}
		oib_activeActionImport(true);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_recherche_compteBanque() {
	try {

		var numCompte = document.getElementById('oib-compteBanque').value;
		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oib_retourRechercheCompteBanque, numCompte, "", "", "", false);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_retourRechercheCompteBanque(numCompte, compteId) {
	try {

		document.getElementById('oib-compteBanque').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function oib_recherche_compteAttente() {
	try {

		var numCompte = document.getElementById('oib-compteAttente').value;
		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oib_retourRechercheCompteAttente, numCompte, "", "", "", false);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_retourRechercheCompteAttente(numCompte, compteId) {
	try {

		document.getElementById('oib-compteAttente').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function oib_supprimerImport() {
	try {

		var qDelete = new QueryHttp("Compta/ImportBanque/deleteImport.tmpl");
		qDelete.setParam("Import_Id", oib_importId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			retourListeImport();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_saveParam() {
	try {

		var qSave = new QueryHttp("Compta/ImportBanque/saveParam.tmpl");

  	qSave.setParam("Param_Id", oib_paramId);
  	qSave.setParam("Compte_Banque", document.getElementById('oib-compteBanque').value);
  	qSave.setParam("Centralisation", document.getElementById('oib-centralisation').checked);
  	qSave.setParam("Concat_LSM", document.getElementById('oib-concatLSM').checked);
  	qSave.setParam("Compte_Attente", document.getElementById('oib-compteAttente').value);

  	var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			oib_paramId = result.responseXML.documentElement.getAttribute("Param_Id");
  	}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_refreshListeEcriture() {
	try {

		var qRefresh = new QueryHttp("Compta/ImportBanque/genListeEcriture.tmpl");
		qRefresh.setParam("Import_Id", oib_importId);
		var result = qRefresh.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var coherence = result.responseXML.documentElement.getAttribute("Coherence")=="true";
			if (!coherence) {
				var message = result.responseXML.documentElement.getAttribute("Message");
				showWarning(message);
			}
			oib_ouvrir(oib_importId);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_validerImport() {
	try {

		var qValid = new QueryHttp("Compta/ImportBanque/validateImport.tmpl");
		qValid.setParam("Import_Id", oib_importId);
		var result = qValid.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			showWarning("L'import a \u00E9t\u00E9 correctement effectu\u00E9");
			retourListeImport();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_saveSoldes() {
	try {

		var nf = new NumberFormat("0.00", false);
		if (!oib_verifSoldes()) {
			document.getElementById('oib-soldeDebut').value = nf.format(0);
			document.getElementById('oib-soldeFin').value = nf.format(0);
		}
		var qSave = new QueryHttp("Compta/ImportBanque/saveSoldes.tmpl");
		qSave.setParam("Import_Id", oib_importId);
		var debut = document.getElementById('oib-soldeDebut').value;
		var fin = document.getElementById('oib-soldeFin').value;
		qSave.setParam("Solde_Debut", debut);
		qSave.setParam("Solde_Fin", fin);
		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			oib_soldesOk = false;
		}
		else {
			var calc = result.responseXML.documentElement.getAttribute("Solde_Calc");
			calc = nf.format(calc);
			debut = nf.format(debut);
			fin = nf.format(fin);
			document.getElementById('oib-soldeCalcule').value = calc;
			document.getElementById('oib-soldeDebut').value = debut;
			document.getElementById('oib-soldeFin').value = fin;
			oib_soldesOk = (calc==fin);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oib_verifSoldes() {
	try {

		var ok = true;
		if (!checkNumber(document.getElementById('oib-soldeDebut').value, 14, 2)) {
			showWarning("Solde de d\u00E9but incorrect !");
			ok = false;
		}
		else if (!checkNumber(document.getElementById('oib-soldeFin').value, 14, 2)) {
			showWarning("Solde de fin incorrect !");
			ok = false;
		}
		return ok;

	} catch (e) {
  	recup_erreur(e);
	}
}
