/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oli_aImports = new Arbre("Compta/ImportBanque/list-importBanque.tmpl", "oli-listeImport");
var oli_qListIB = new QueryHttp("Compta/ImportBanque/getDataListIB.tmpl");

var oli_pageCourante;
var oli_nbPages;



function oli_init() {
	try {

		var aJournaux = new Arbre("ComboListe/combo-journaux.tmpl", "oli-journalBanque");
		aJournaux.setParam("Type_Journal", "TR");
 		aJournaux.initTree();

		oli_listerImports();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oli_initCriteres() {
	try {

		document.getElementById('oli-etat').value = "";
		document.getElementById('oli-journalBanque').value = "";
		document.getElementById('oli-dateM').value = "";

		oli_listerImports();

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_listerImports() {
	try {

		var etat = document.getElementById('oli-etat').value;
		var journalBanque = document.getElementById('oli-journalBanque').value;
		var dateM = document.getElementById('oli-dateM').value;
		var nbLignesParPage = document.getElementById('oli-nbLignesParPage').value;

		if (!isEmpty(dateM) && !isDate(dateM)) { showWarning("Date de modification incorrecte"); }
		else {

			oli_pageCourante = 1;
			oli_nbPages = 1;
			document.getElementById('oli-pageDeb').value = 1;
			document.getElementById('oli-pageFin').value = 1;
			document.getElementById('oli-bPrec').disabled = true;
			document.getElementById('oli-bSuiv').disabled = true;

			document.getElementById('oli-listeImport').disabled = true;
			oli_aImports.deleteTree();

			oli_qListIB.setParam("Etat", etat);
			oli_qListIB.setParam("Journal_Banque", journalBanque);
			oli_qListIB.setParam("Date_M", dateM);
			oli_qListIB.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oli_qListIB.setParam("Current_Page", oli_pageCourante);

			var result = oli_qListIB.execute();

			var contenu = result.responseXML.documentElement;

			oli_nbPages = contenu.getAttribute("Nb_Pages");
			var listImportId = contenu.getAttribute("List_Import_Id");

			oli_aImports.setParam("List_Import_Id", listImportId);
			oli_aImports.initTree(oli_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_initPagination() {
	try {

		document.getElementById('oli-pageDeb').value = oli_pageCourante;
		document.getElementById('oli-pageFin').value = (oli_nbPages>0?oli_nbPages:1);
		document.getElementById('oli-bPrec').disabled = (oli_pageCourante==1);
		document.getElementById('oli-bSuiv').disabled = (oli_pageCourante>=oli_nbPages); // peut se produire si oli_nbPages=0

		oli_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_pressOnPagePrec() {
	try {

		oli_pageCourante--;
		oli_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_pressOnPageSuiv() {
	try {

		oli_pageCourante++;
		oli_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_majPagination() {
	try {

		document.getElementById('oli-pageDeb').value = oli_pageCourante;
		document.getElementById('oli-bPrec').disabled = (oli_pageCourante==1);
		document.getElementById('oli-bSuiv').disabled = (oli_pageCourante==oli_nbPages);

		document.getElementById('oli-listeImport').disabled = true;

		oli_qListIB.setParam("Current_Page", oli_pageCourante);
		var result = oli_qListIB.execute();
		var listImportId = result.responseXML.documentElement.getAttribute("List_Import_Id");

		oli_aImports.setParam("List_Import_Id", listImportId);
		oli_aImports.initTree(oli_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_afterMajPagination() {
	try {

		document.getElementById('oli-listeImport').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_pressOnNouveauImport() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bRetourListeImports').collapsed = false;
		oib_nouveau();

	} catch (e) {
		recup_erreur(e);
	}
}


function oli_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oli_listerImports();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oli_pressOnListeImport(ev) {
  try {

		if (ev.keyCode==13) {
			oli_ouvrirImport();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oli_ouvrirImport() {
  try {

  	if (oli_aImports.isSelected()) {
			var importId = oli_aImports.getSelectedCellText('oli-colImportId');
			oib_ouvrir(importId);
			document.getElementById('bRetourListeImports').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}
