/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aModeles = new Arbre("Compta/ModelesEcriture/list-modeleEcriture.tmpl", "listeModeleEcriture");
var aLignes = new Arbre("Compta/ModelesEcriture/list-ligneModeleEcriture.tmpl", "listeLigneModeleEcriture");
var aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "modeReglement");

var currentModeleId = "";
var currentLigneId = "";
var curModeReglement;



function init() {
	try {

 		aModeles.initTree();
		nouveauModele();

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerModeReglement(selection) {
	try {

		curModeReglement = selection;
		aModesReglement.setParam("Selection", selection);
		aModesReglement.initTree(initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function initModeReglement() {
	try {

		document.getElementById('modeReglement').value = curModeReglement;

	} catch (e) {
		recup_erreur(e);
	}
}


function nouveauModele() {
	try {

		currentModeleId = "";
		aModeles.clearSelection();

 		annulerLigneModele();
  	aLignes.deleteTree();

  	document.getElementById('libelle').value = "";
  	document.getElementById('raccourci').value = 0;

		document.getElementById('bNouveau').collapsed = true;
		document.getElementById('bEnregistrer').disabled = false;
		document.getElementById('bSupprimer').collapsed = true;
		document.getElementById('bCopier').collapsed = true;
		document.getElementById('bValider').collapsed = true;
		document.getElementById('bEnregistrerLigne').disabled = true;

		document.getElementById('libelle').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeModele() {
	try {

 		if (aModeles.isSelected()) {
			currentModeleId = aModeles.getSelectedCellText("colModeleId");
			chargerModele();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerModele() {
	try {

		var qLoad = new QueryHttp("Compta/ModelesEcriture/loadModeleEcriture.tmpl");
		qLoad.setParam("Modele_Id", currentModeleId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		var etat = contenu.getAttribute('Etat');

		document.getElementById('libelle').value = contenu.getAttribute('Libelle');
		document.getElementById('raccourci').value = contenu.getAttribute('Raccourci');

		aLignes.setParam("Modele_Id", currentModeleId);
		aLignes.initTree(annulerLigneModele);

		document.getElementById('bNouveau').collapsed = false;
		document.getElementById('bEnregistrer').disabled = false;
		document.getElementById('bSupprimer').collapsed = false;
		document.getElementById('bCopier').collapsed = false;
		document.getElementById('bValider').collapsed = etat=='V';
		document.getElementById('bEnregistrerLigne').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function enregistrerModele() {
	try {

		var libelle = document.getElementById('libelle').value;
		var raccourci = document.getElementById('raccourci').value;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(currentModeleId)) {
				qSave = new QueryHttp("Compta/ModelesEcriture/updateModeleEcriture.tmpl");
				qSave.setParam("Modele_Id", currentModeleId);
			}
			else {
				qSave = new QueryHttp("Compta/ModelesEcriture/createModeleEcriture.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Raccourci", raccourci);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aModeles.initTree();
				if (isEmpty(currentModeleId)) {
					currentModeleId = result.responseXML.documentElement.getAttribute('Modele_Id');
					chargerModele();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function supprimerModele() {
	try {

		if (!isEmpty(currentModeleId) && window.confirm("Confirmez-vous la suppression du mod\u00E8le d'\u00E9criture ?")) {

			var qDelete = new QueryHttp("Compta/ModelesEcriture/deleteModeleEcriture.tmpl");
			qDelete.setParam("Modele_Id", currentModeleId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aModeles.initTree();
				nouveauModele();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function copierModele() {
	try {

		if (window.confirm("Confirmez-vous la copie du mod\u00E8le d'\u00E9criture ?")) {

			var qCopy = new QueryHttp("Compta/ModelesEcriture/copyModeleEcriture.tmpl");
			qCopy.setParam("Modele_Id", currentModeleId);
			var result = qCopy.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aModeles.initTree();
				currentModeleId = result.responseXML.documentElement.getAttribute('Modele_Id');
				chargerModele();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerModele() {
	try {

		if (window.confirm("Confirmez-vous la validation du mod\u00E8le d'\u00E9criture ?")) {

			var qValid = new QueryHttp("Compta/ModelesEcriture/validModeleEcriture.tmpl");
			qValid.setParam("Modele_Id", currentModeleId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aModeles.initTree();
				chargerModele();
			}
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function chargerLigneModele() {
	try {

		if (aLignes.isSelected()) {
			currentLigneId = aLignes.getSelectedCellText('colLigneId');

			var qLoad = new QueryHttp("Compta/ModelesEcriture/loadLigneModeleEcriture.tmpl");
			qLoad.setParam("Ligne_Id", currentLigneId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('numCompte').value = contenu.getAttribute("Num_Compte");
				document.getElementById('libelleLM').value = contenu.getAttribute("Libelle");
				document.getElementById('commentaire').value = contenu.getAttribute("Commentaire");
				document.getElementById('debit').value = contenu.getAttribute("Montant_D");
				document.getElementById('credit').value = contenu.getAttribute("Montant_C");
				document.getElementById('numPiece').value = contenu.getAttribute("Num_Piece");
				document.getElementById('typeCalcul').value = contenu.getAttribute("Type_Calcul");
				document.getElementById('periodeLib').checked = contenu.getAttribute("Periode_Lib")=="true";
				chargerModeReglement(contenu.getAttribute("Mode_Reg_Id"));

				document.getElementById('bSupprimerLigne').disabled = false;
				document.getElementById('bAnnulerLigne').disabled = false;
			}
  	}

	} catch (e) {
		recup_erreur(e);
	}
}


function annulerLigneModele() {
	try {

		currentLigneId = "";
		aLignes.clearSelection();

		// si le modle contient des lignes, on charge le libell, le n pice et le type de calcul de la dernire ligne
		if (!isEmpty(currentModeleId) && aLignes.nbLignes()!=0) {
			var i = aLignes.nbLignes()-1;
			document.getElementById('libelleLM').value = aLignes.getCellText(i, 'colLibelleLM');
			document.getElementById('numPiece').value = aLignes.getCellText(i, 'colNumPiece');
			document.getElementById('typeCalcul').value = aLignes.getCellText(i, 'colValTypeCalcul');
			document.getElementById('periodeLib').checked = aLignes.getCellText(i, 'colPeriodeLib')=="true";
		}
		else {
			document.getElementById('libelleLM').value = "";
			document.getElementById('numPiece').value = "";
			document.getElementById('typeCalcul').value = "";
			document.getElementById('periodeLib').checked = true;
		}

		document.getElementById('numCompte').value = "";
		document.getElementById('commentaire').value = "";
		document.getElementById('debit').value = "";
		document.getElementById('credit').value = "";
		chargerModeReglement("");

		document.getElementById('bSupprimerLigne').disabled = true;
		document.getElementById('bAnnulerLigne').disabled = true;

		document.getElementById("numCompte").focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function enregistrerLigneModele() {
	try {

		var numCompte = document.getElementById('numCompte').value;
		var libelle = document.getElementById('libelleLM').value;
		var debit = document.getElementById('debit').value;
		var credit = document.getElementById('credit').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var commentaire = document.getElementById('commentaire').value;
		var numPiece = document.getElementById('numPiece').value;
		var typeCalcul = document.getElementById('typeCalcul').value;
		var periodeLib = document.getElementById('periodeLib').checked;

		if (isEmpty(libelle)) { showWarning("Libell\u00E9 incorrect"); }
		else if (isEmpty(numCompte)) { showWarning("N\u00B0 Compte incorrect"); }
		else if (isEmpty(typeCalcul)) { showWarning("Veuillez choisir un type de calcul"); }
		else if (typeCalcul=='F' && !isEmpty(debit) && (!isPositive(debit) || !checkNumber(debit,12,2))) { showWarning("Montant au d\u00E9bit incorrect"); }
		else if (typeCalcul=='F' && !isEmpty(credit) && (!isPositive(credit) || !checkNumber(credit,12,2))) { showWarning("Montant au cr\u00E9dit incorrect"); }
		else if (typeCalcul=='P' && !isEmpty(debit) && (!isPositive(debit) || !checkDecimal(debit,4) || debit>100)) { showWarning("Pourcentage au d\u00E9bit incorrect"); }
		else if (typeCalcul=='P' && !isEmpty(credit) && (!isPositive(credit) || !checkDecimal(credit,4) || credit>100)) { showWarning("Pourcentage au cr\u00E9dit incorrect"); }
		else if (typeCalcul!='S' && isEmpty(debit) && isEmpty(credit)) { showWarning("D\u00E9bit ou cr\u00E9dit manquant"); }
		else if (typeCalcul!='S' && !isEmpty(debit) && !isEmpty(credit)) { showWarning("Veuillez ne saisir qu'un d\u00E9bit ou qu'un cr\u00E9dit"); }
		else if (typeCalcul=='S' && (!isEmpty(debit) || !isEmpty(credit))) { showWarning("Veuillez ne pas saisir de montants dans une ligne sans montant"); }
		else {
			var qSave;

			if (!isEmpty(currentLigneId)) {
				qSave = new QueryHttp("Compta/ModelesEcriture/updateLigneModeleEcriture.tmpl");
				qSave.setParam("Ligne_Id", currentLigneId);
			}
			else {
				qSave = new QueryHttp("Compta/ModelesEcriture/createLigneModeleEcriture.tmpl");
				qSave.setParam("Modele_Id", currentModeleId);
			}

			qSave.setParam("Num_Compte", numCompte);
			qSave.setParam("Libelle", libelle);
			qSave.setParam("Montant_D", debit);
			qSave.setParam("Montant_C", credit);
			qSave.setParam("Mode_Reg_Id", modeReglement);
			qSave.setParam("Commentaire", commentaire);
			qSave.setParam("Num_Piece", numPiece);
			qSave.setParam("Type_Calcul", typeCalcul);
			qSave.setParam("Periode_Lib", periodeLib);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aModeles.initTree();
	  		chargerModele();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function supprimerLigneModele() {
	try {

		if (!isEmpty(currentLigneId)) {
			var qDelete = new QueryHttp("Compta/ModelesEcriture/deleteLigneModeleEcriture.tmpl");
			qDelete.setParam("Ligne_Id", currentLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aModeles.initTree();
  			chargerModele();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCompte(ev) {
	try {

		if (ev.keyCode==13) {
			rechercherCompte();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherCompte() {
	try {

		var numCompte = document.getElementById('numCompte').value;

		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
   	window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte, numCompte, "", "", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById('numCompte').value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
		recup_erreur(e);
	}
}
