/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");
jsLoader.loadSubScript("chrome://opensi/content/compta/user/saisie/ligneVentilation.js");



function init() {
  try {

		oav_init();
		osa_init();

    var opId = ParamValeur('Op_Id');
		var codeJournal = ParamValeur('Code_Journal');

		if (!isEmpty(opId)) {
			osa_initSaisieEcr(opId);
			document.getElementById('dk-menuSaisie').selectedIndex = 1;
			document.getElementById('bEtatAvancement').collapsed = false;
		}
		else if (!isEmpty(codeJournal)) {
			gms_ouvrirSaisie(codeJournal, ParamValeur('Periode'));
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function gms_ouvrirSaisie(codeJournal, periode) {
  try {

		osa_initSaisie(codeJournal, periode);
		document.getElementById('dk-menuSaisie').selectedIndex = 1;
		document.getElementById('bEtatAvancement').collapsed = false;

  } catch (e) {
    recup_erreur(e);
  }
}


function gms_openRechercheEcriture() {
  try {
		
		var url = "chrome://opensi/content/compta/user/saisie/popup-rechercheEcriture.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', gms_retourRechercherEcriture);

  } catch (e) {
    recup_erreur(e);
  }
}


function gms_retourRechercherEcriture(opId) {
  try {
	
		osa_initSaisieEcr(opId);
		document.getElementById('dk-menuSaisie').selectedIndex = 1;
		document.getElementById('bEtatAvancement').collapsed = false;
		
	} catch (e) {
    recup_erreur(e);
  }
}


function retourAvancement() {
  try {

		document.getElementById('oav-pdfAvancement').setAttribute('src', '');
  	document.getElementById('oav-deck').selectedIndex = 0;
		document.getElementById('dk-menuSaisie').selectedIndex = 0;
		document.getElementById('bEtatAvancement').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function getCurrentDeck() {
  try {

		return document.getElementById('dk-menuSaisie').selectedIndex;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
