/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


function oav_init() {
  try {

  	var qGet = new QueryHttp("Compta/Commons/getInfosExerciceN1.tmpl");
  	var result = qGet.execute();
  	document.getElementById('oav-boxExercice').collapsed = result.responseXML.documentElement.getAttribute("Exist")=="false";

  	document.getElementById('oav-deck').selectedIndex = 0;
  	document.getElementById('oav-pdfAvancement').setAttribute('src', '');
  	document.getElementById('oav-rgpExercice').value = "N";

		var aJournal = new Arbre("ComboListe/combo-journaux.tmpl", 'oav-journal');
		aJournal.initTree(oav_initJournal);

		var aPeriode = new Arbre("ComboListe/combo-periodesExercice.tmpl", 'oav-periode');
		aPeriode.initTree(oav_initPeriode);

		var qDate = new QueryHttp("GetDates.tmpl");
		document.getElementById('oav-labelAvancement').value = "Etat d'avancement au "+ qDate.execute().responseXML.documentElement.getAttribute("auj");
		oav_chargerAvancement();

	} catch (e) {
    recup_erreur(e);
  }
}


function oav_initPeriode() {
  try {

		document.getElementById('oav-periode').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function oav_initJournal() {
  try {

		document.getElementById('oav-journal').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function oav_chargerAvancement() {
  try {

		var XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
		var rgp = document.getElementById('oav-rgpExercice').value;

		var qGet = new QueryHttp("Compta/Saisie/getEtatAvancement.tmpl");
		qGet.setParam("Exercice_Precedent", rgp=="N1");
		var result = qGet.execute();
		var listCodeJournal = result.responseXML.documentElement.getAttribute("List_Code_Journal").split(",");
		var listJournalId = result.responseXML.documentElement.getAttribute("List_Journal_Id").split(",");
		var listTotalJournal = result.responseXML.documentElement.getAttribute("List_Total_Journal").split(",");
		var listLibellePeriode = result.responseXML.documentElement.getAttribute("List_Libelle_Periode").split(",");
		var listNbOp = result.responseXML.documentElement.getAttribute("List_Nb_Op").split(",");
		var listTotalPeriode = result.responseXML.documentElement.getAttribute("List_Total_Periode").split(",");
		var totalGeneral = result.responseXML.documentElement.getAttribute("Total_General");

		var gridAvancement = document.getElementById('oav-gridAvancement');
		while (gridAvancement.hasChildNodes()) { gridAvancement.removeChild(gridAvancement.firstChild); }

	  var columns = document.createElementNS(XUL_NS, "xul:columns");
	  var column = document.createElementNS(XUL_NS, "xul:column");
	  column.setAttribute("style", "min-width:50px");
	  columns.appendChild(column);
	  for (var i=0; i<listCodeJournal.length; i++) {
	  	column = document.createElementNS(XUL_NS, "xul:column");
	  	column.setAttribute("style", "min-width:50px");
	  	columns.appendChild(column);
	  }
	  column = document.createElementNS(XUL_NS, "xul:column");
  	column.setAttribute("style", "min-width:50px");
	  columns.appendChild(column);
	  gridAvancement.appendChild(columns);
	  var rows = document.createElementNS(XUL_NS, "xul:rows");
	  var row = document.createElementNS(XUL_NS, "xul:row");
	  var label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "case_entete");
	  label.setAttribute("value", "");
	  row.appendChild(label);
	  for (var i=0; i<listCodeJournal.length; i++) {
		  var codeJournal = listCodeJournal[i];
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "row_entete");
		  label.setAttribute("value", codeJournal);
		  label.setAttribute("style", "text-align:center;font-weight:bold");
		  row.appendChild(label);
	  }
	  label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "row_entete");
	  label.setAttribute("value", "Total");
	  label.setAttribute("style", "text-align:center;font-weight:bold");
	  row.appendChild(label);
	  rows.appendChild(row);

	  var rang = 0;
	  for (var i=0; i<listLibellePeriode.length; i++) {
	  	row = document.createElementNS(XUL_NS, "xul:row");
		  var periode = listLibellePeriode[i];
		  var totalPeriode = listTotalPeriode[i];
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "col_entete");
		  label.setAttribute("value", periode);
		  label.setAttribute("style", "text-align:center;font-weight:bold");
		  row.appendChild(label);
		  for (var j=0; j<listJournalId.length; j++) {
		  	var journalId = listJournalId[j];
		  	var nbOp = listNbOp[rang];
		  	rang++;
		  	label = document.createElementNS(XUL_NS, "xul:label");
			  label.setAttribute("class", "case");
			  label.setAttribute("value", nbOp);
			  label.setAttribute("style", "text-align:right");
				if (rgp=="N") {
					var regexPeriode = /\D/g;
					label.setAttribute("ondblclick", "gms_ouvrirSaisie("+ journalId +", '"+ periode.replace(regexPeriode, '') +"')");
				}
			  row.appendChild(label);
		  }
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "case");
		  label.setAttribute("value", totalPeriode);
		  label.setAttribute("style", "text-align:right");
		  row.appendChild(label);
		  rows.appendChild(row);
	  }

	  row = document.createElementNS(XUL_NS, "xul:row");
	  row.setAttribute("style", "border-bottom: solid 1px");
	  label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "case_entete");
	  label.setAttribute("value", "Total");
	  label.setAttribute("style", "text-align:center;font-weight:bold");
	  row.appendChild(label);
	  for (var i=0; i<listTotalJournal.length; i++) {
		  var codeJournal = listCodeJournal[i];
		  var nbOp = listTotalJournal[i];
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "row_case");
		  label.setAttribute("value", nbOp);
		  label.setAttribute("style", "text-align:right");
		  row.appendChild(label);
	  }
	  label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "row_case");
	  label.setAttribute("value", totalGeneral);
	  label.setAttribute("style", "text-align:right");
	  row.appendChild(label);
	  rows.appendChild(row);
	  gridAvancement.appendChild(rows);

	} catch (e) {
    recup_erreur(e);
  }
}


function oav_clickOnOK() {
  try {

		var codeJournal = document.getElementById('oav-journal').value;
		var periode = document.getElementById('oav-periode').value;

		gms_ouvrirSaisie(codeJournal, periode);

	} catch (e) {
    recup_erreur(e);
  }
}


function oav_menuOpEcritures() {
	try {

		window.location = "chrome://opensi/content/compta/user/autres/cp_journaux.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}


function oav_pdfAvancement() {
	try {

		document.getElementById('oav-pdfAvancement').setAttribute('src', '');
		document.getElementById('oav-deck').selectedIndex = 1;
		document.getElementById('bEtatAvancement').collapsed = false;

		var exercicePrecedent =  document.getElementById('oav-rgpExercice').value=="N1";

		var qGenPdf = new QueryHttp("Compta/Saisie/pdfEtatAvancement.tmpl");
		qGenPdf.setParam('Exercice_Precedent', exercicePrecedent);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oav-pdfAvancement').setAttribute('src', page);

	} catch (e) {
    recup_erreur(e);
  }
}



function oav_csvAvancement() {
	try {

		var exercicePrecedent =  document.getElementById('oav-rgpExercice').value=="N1";

		var queryEdit = new QueryHttp("Compta/Saisie/csvEtatAvancement.tmpl");
		queryEdit.setParam("Exercice_Precedent", exercicePrecedent);

		var result = queryEdit.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
		var file = fileChooser("save", fichier);

		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


