/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var osa_currentPeriode;
var osa_currentJournal;
var osa_currentTypeJournal;

var osa_writeable = false;

var osa_currentPage;
var osa_currentNbPages;

var osa_currentRechId;

var osa_aEcritures = new Arbre('Compta/Saisie/liste-ecritures.tmpl', 'osa-treeEcritures');

var qSaveEcr = new QueryHttp("Compta/Saisie/saveEcriture.tmpl");
var qSupEcr = new QueryHttp("Compta/Saisie/deleteEcriture.tmpl");
var osa_adrSaveEcrAna = "Compta/Analytique/Ecritures/saveEcriture.tmpl";
var osa_adrDelEcrAna = "Compta/Analytique/Ecritures/deleteEcriture.tmpl";
var osa_adrGetVentil = "Compta/Analytique/Ecritures/listeEcritures.tmpl";
var osa_adrGetPreVentil = "Compta/Analytique/Comptes/getVentilations.tmpl";

var osa_dsEcritures;

var osa_ECRITURES_NS = "http://www.opensi.org/compta/operations";

var osa_opIdToLoad = null;
var osa_pageToLoad = null;

var nfMt = new NumberFormat("0.00", true);

var osa_modeRaccourci = false;
var osa_modele = new Array();
var osa_currentLigne = 0;
var osa_montantPourcent = -1;
var osa_tabLP = new Array(); // tableau des lignes en pourcentage

var osa_rappelAuto = false;
var osa_modeRappel = new osa_ModeRappel();

var osa_activeAnalytique = false;
var osa_compteChargeProduit = false;

var osa_tabVentilation = new Array();
var osa_idxVentilation = -1;

var osa_compteSaisie = "";
var osa_appelPopup = false;
var osa_appelRechCompteAna = false;

/* Classe de ligne utilise pour la manipulation de donne lors de l'aide  la saisie par modle */
function osa_LigneModele() {
	this.compte = "";
	this.libelle = "";
	this.reglement = "";
	this.infos = "";
	this.debit = 0;
	this.credit = 0;
	this.piece = "";
	this.calcul = "P";
	this.periode = false;
	this.debitCalc = 0; // utilis pour stocker la valeur calcule en cas de pourcentage
	this.creditCalc = 0;
	this.tabLPId=0;
}

/* Classe de mode utilise pour la gestion du rappel auto et de l'auto-apprentissage */
function osa_ModeRappel() {
	this.active = false;
	this.contrepartie = "";
	this.codeTVA = 1;
	this.compteTVA = "";
	this.taux = 0;
	this.typeCompte = "";
	this.etat = 0; // 0:verif tiers, 1:charge contrepartie, 2:charge tva
	this.debitRef = 0;
	this.creditRef = 0;
	this.debitCp = 0;
	this.creditCp = 0;
	this.debitTVA = 0;
	this.creditTVA = 0;
	}


function osa_init() {
	try {

		var aJournal = new Arbre('ComboListe/combo-journaux.tmpl', 'osa-journal');
		aJournal.initTree();

		var aPeriode = new Arbre('ComboListe/combo-periodesExercice.tmpl', 'osa-periode');
		aPeriode.initTree();

		var aModeReg = new Arbre('ComboListe/combo-modesReglement.tmpl', 'osa-reglement');
		aModeReg.initTree();

		var config = getConfig();

		osa_rappelAuto = config.isRappelAutoSaisie();
		osa_activeAnalytique = config.isActAnalytique();

		document.getElementById('osa-ColAnalytique').collapsed = !osa_activeAnalytique;
		if (osa_activeAnalytique) {
			document.getElementById('osa-ColAnalytique').removeAttribute("ignoreincolumnpicker");
		}
		document.getElementById('osa-colSaisieAna').collapsed = !osa_activeAnalytique;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_initSaisie(codeJournal, periode) {
	try {

		document.getElementById('osa-journal').value = codeJournal;
		document.getElementById('osa-periode').value = periode;

		osa_chargerJournal();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_initSaisieEcr(opId) {
	try {

		var qLocEcr = new QueryHttp("Compta/Saisie/getLocationEcriture.tmpl");
		qLocEcr.setParam('Op_Id', opId);
		qLocEcr.setParam('Nb_Ecr_Page', 10);
		var result = qLocEcr.execute();

		var contenu = result.responseXML.documentElement;

		osa_opIdToLoad = opId;
		osa_pageToLoad = contenu.getAttribute('Page');

		setTimeout("osa_initSaisie('"+ contenu.getAttribute('Journal_Id') +"','"+ contenu.getAttribute('Periode') +"');", 100);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_chargerJournal() {
	try {

		osa_razInfosCpte();
		osa_razSoldesEcr();

		osa_currentJournal = document.getElementById('osa-journal').value;
		osa_currentPeriode = document.getElementById('osa-periode').value;

		var qGet = new QueryHttp("Compta/Saisie/getInfosJournal.tmpl");
		qGet.setParam('Periode', osa_currentPeriode);
		qGet.setParam('Journal_Id', osa_currentJournal);
		var result = qGet.execute();

		osa_currentTypeJournal = result.responseXML.documentElement.getAttribute('Type_Journal');
		osa_writeable = result.responseXML.documentElement.getAttribute('Writeable')=="true";

		var nbEcritures = result.responseXML.documentElement.getAttribute('Nb_Ecritures');

		osa_currentNbPages = parseIntBis(nbEcritures/10+1);

		if (osa_pageToLoad==null) {
			osa_chargerPage(osa_currentNbPages);
		}
		else {
			osa_chargerPage(osa_pageToLoad);
			osa_pageToLoad = null;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_chargerPage(p) {
	try {

		osa_disableAll(true);

		osa_currentPage = parseIntBis(p);	// parseint important correction bug page suivante au retour rvision des comptes
		document.getElementById('osa-pagination').value = "Page N\u00B0 "+ osa_currentPage +" / "+ osa_currentNbPages;

		osa_dsEcritures = new RDFDataSource();

		osa_aEcritures.setParam('Journal_Id', osa_currentJournal);
		osa_aEcritures.setParam('Periode', preparePeriodeJava(osa_currentPeriode));
		osa_aEcritures.setParam('Num_Page', osa_currentPage);
		osa_aEcritures.initTree(osa_initTreeEcritures);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pageDebut() {
	try {

		osa_chargerPage(1);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pagePrec() {
	try {

		if (osa_currentPage>1) {
			osa_chargerPage(osa_currentPage-1);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pageSuiv() {
	try {

		if (osa_currentPage<osa_currentNbPages) {
			osa_chargerPage(osa_currentPage+1);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pageFin() {
	try {

		osa_chargerPage(osa_currentNbPages);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_disableAll(b) {
	try {

		osa_setLigneEditable(!b);
		osa_disableNearlyAll();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_disableNearlyAll(b) {
	try {

		document.getElementById('osa-treeEcritures').disabled = b;

		document.getElementById('osa-bPageDebut').disabled = b;
		document.getElementById('osa-bPagePrec').disabled = b;
		document.getElementById('osa-bPageFin').disabled = b;
		document.getElementById('osa-bPageSuiv').disabled = b;

		document.getElementById('osa-journal').disabled = b;
		document.getElementById('osa-periode').disabled = b;
		document.getElementById('osa-bPeriodeSuiv').disabled = b;
		document.getElementById('osa-bPeriodePrec').disabled = b;
		document.getElementById('osa-bPlanComptable').disabled = b;
		document.getElementById('osa-bRevision').disabled = b;
		document.getElementById('osa-bRechercher').disabled = b;

	} catch (e) {
		recup_erreur(e);
	}
}

function osa_initTreeEcritures(dsource) {
	try {

		var treeEcritures = document.getElementById('osa-treeEcritures');

		dsource.copyAllToDataSource(osa_dsEcritures);

		treeEcritures.database.RemoveDataSource(dsource.getRawDataSource());
		treeEcritures.database.AddDataSource(osa_dsEcritures.getRawDataSource());

		// on remet le tableau des ecritures analytiques  zero dans tous les cas
		osa_tabVentilation = new Array();

		if (osa_currentTypeJournal!="AN") {
			document.getElementById('osa-ColDateOp').collapsed = true;
			document.getElementById('osa-ColJourOp').collapsed = false;
		}
		else {
			document.getElementById('osa-ColDateOp').collapsed = false;
			document.getElementById('osa-ColJourOp').collapsed = true;
		}

		document.getElementById('osa-ligneSaisie').collapsed = !osa_writeable;
		if (osa_aEcritures.isNotNull()) {

			osa_ajouterSeparateur(osa_aEcritures.nbLignes());
			if (osa_currentPage==osa_currentNbPages) {
				// saisie sur dernire page uniquement
				if (osa_writeable) {
					osa_ajouterLigneVide(osa_aEcritures.nbLignes());
					osa_selectLigne(osa_aEcritures.nbLignes()-1);
				}
				else {
					osa_selectLigne(osa_aEcritures.nbLignes()-2);
				}
			}
			else {
				osa_selectLigne(0);
			}

			if (osa_opIdToLoad!=null) {
				osa_selectLigneOp(osa_opIdToLoad);
				osa_opIdToLoad = null;
			}
		}
		else if (osa_writeable) {
			osa_ajouterLigneVide(0);
			osa_selectLigne(0);
		}

		osa_disableAll(false);
		osa_enableModeRaccourci(false);

		if (osa_aEcritures.isSelected() && (!isEmpty(osa_aEcritures.getSelectedCellText('osa-ColLettre')) || osa_aEcritures.getSelectedCellValue('osa-ColPointage')=="1")) {
			osa_setLigneEditable(false);
		}

		document.getElementById('osa-bPageDebut').disabled = (osa_currentPage == 1);
		document.getElementById('osa-bPagePrec').disabled = (osa_currentPage == 1);
		document.getElementById('osa-bPageFin').disabled = (osa_currentPage == osa_currentNbPages);
		document.getElementById('osa-bPageSuiv').disabled = (osa_currentPage == osa_currentNbPages);

		document.getElementById('osa-jour').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_selectLigne(idx) {
	try {

		if (osa_aEcritures.nbLignes()>idx) {
			osa_aEcritures.select(idx);
			osa_aEcritures.ensureRowIsVisible(idx);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_supprimerLigne(idx) {
	try {

		osa_dsEcritures.getNode(osa_ECRITURES_NS).removeChildAt(idx+1);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_targetName(item) {
	try {

		return osa_ECRITURES_NS +"/rdf#"+ item;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ajouterSeparateur(idx) {
	try {

		var child = osa_dsEcritures.getAnonymousNode();
		child.addTargetOnce(osa_targetName('type_desc'), 'separator');
		osa_dsEcritures.getNode(osa_ECRITURES_NS).addChildAt(child,idx+1); // idx +1 car index commence  1

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ajouterLigneVide(idx) {
	try {

		var child = osa_dsEcritures.getAnonymousNode();
		child.addTargetOnce(osa_targetName('Prop'), 'enabled');
		child.addTargetOnce(osa_targetName('Modif'), '1');
		child.addTargetOnce(osa_targetName('Ecriture_Id'), '0');
		child.addTargetOnce(osa_targetName('Op_Id'), '0');
		osa_dsEcritures.getNode(osa_ECRITURES_NS).addChildAt(child,idx+1); // idx +1 car index commence  1

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_selectLigneOp(opId) {
	try {

		for(var i=0; i<osa_aEcritures.nbLignes(); i++) {
			if (parseIntBis(osa_aEcritures.getCellText(i, 'osa-ColOpId'))==opId) {
				osa_selectLigne(i);
				break;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_lignePrecedente() {
	try {

		if (osa_aEcritures.isNotNull()) {
			var idx = osa_aEcritures.getCurrentIndex() - 1;
			if (idx>=0 && !(osa_aEcritures.isSeparator(idx) && parseFloat(document.getElementById('osa-soldeEC').value)!=0)) {
				while (osa_aEcritures.isSeparator(idx)) idx--;
				osa_selectLigne(idx);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ligneSuivante() {
	try {

		if (osa_aEcritures.isNotNull()) {
			var rc = osa_aEcritures.nbLignes();
			var idx = osa_aEcritures.getCurrentIndex() + 1;
			if (idx<rc && !(osa_aEcritures.isSeparator(idx) && parseFloat(document.getElementById('osa-soldeEC').value)!=0)) {
				while (idx<rc && osa_aEcritures.isSeparator(idx)) idx++;
				osa_selectLigne(idx);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ligneDefilPrec() {
	try {

		if (osa_aEcritures.isNotNull()) {
			var idx = osa_aEcritures.getCurrentIndex() - 10;
			if (idx<=0) {
				osa_ligneDebut();
			}
			else {
				while (idx>0 && osa_aEcritures.isSeparator(idx)) idx--;
				osa_selectLigne(idx);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ligneDefilSuiv() {
	try {

		if (osa_aEcritures.isNotNull()) {
			var rc = osa_aEcritures.nbLignes();
			var idx = osa_aEcritures.getCurrentIndex() + 10;
			if (idx>=rc) {
				osa_ligneFin();
			}
			else {
				while (idx<rc && osa_aEcritures.isSeparator(idx)) idx++;
				osa_selectLigne(idx);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ligneFin() {
	try {

		if (osa_aEcritures.isNotNull()) {
			osa_selectLigne(osa_aEcritures.nbLignes() - 1);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ligneDebut() {
	try {

		osa_selectLigne(0);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_reporterLigne() {
	try {

		if (osa_aEcritures.isSelected()) {

			var idx = osa_aEcritures.getCurrentIndex();

			document.getElementById('osa-jour').value = osa_aEcritures.getCellText(idx, 'osa-ColJourOp');
			var numCompte = osa_aEcritures.getCellText(idx, 'osa-ColNumCompte');
			document.getElementById('osa-compte').value = numCompte;

			// gestion de l'analytique
			osa_verifCompteChargeProduit();
			document.getElementById('osa-libelle').value = osa_aEcritures.getCellText(idx, 'osa-ColLibelle');
			// on va charger l'analytique dans la structure de gestion des lignes d'critures ana
			// la rfrence  cette structure est stocke dans le tree
			// on charge d'abord la rfrence existante
			var idxVentil = osa_aEcritures.getCellText(idx, 'osa-ColVentilation');
			if (isEmpty(idxVentil)) {
				osa_idxVentilation = -1;
			} else {
				osa_idxVentilation = idxVentil;
			}
			// on vrifie la prsence d'une ventilation non charge

			if (osa_idxVentilation!=-1) {
				// il existe dj une ventilation charge
				var ventilation = osa_tabVentilation[osa_idxVentilation];
				if (ventilation.length==1) {
					document.getElementById('osa-analytique').value = ventilation[0].numero;
				} else if (ventilation.length>1) {
					document.getElementById('osa-analytique').value = "Aff. multiple";
				} else {
					document.getElementById('osa-analytique').value = "";
				}
			} else {
				var analytique = osa_aEcritures.getCellText(idx, 'osa-ColAnalytique');
				if (!isEmpty(analytique)) {
					var opId = osa_aEcritures.getCellText(idx, 'osa-ColOpId');
					//on charge la ventilation
					var ventilation = osa_loadVentilation(opId);
					osa_tabVentilation.push(ventilation);
					osa_idxVentilation = (osa_tabVentilation.length-1);
					if (ventilation.length==0) {
						// il y a eu un problme, la ventilation reste vide
						document.getElementById('osa-analytique').value = "";
					} else {
						// pas de problme au chargement, on met  jour la col ventil
						var child = osa_getChild(idx);
						child.addTargetOnce(osa_targetName('Ventilation'), osa_idxVentilation+"");
						if (ventilation.length==1) {
							document.getElementById('osa-analytique').value = ventilation[0].numero;
						} else {
							document.getElementById('osa-analytique').value = "Aff. multiple";
						}
					}
				} else {
					document.getElementById('osa-analytique').value = "";
				}
			}
			osa_activeSaisieAnalytique(osa_compteChargeProduit);
			// fin gestion de l'analytique

			document.getElementById('osa-contrepartie').value = osa_aEcritures.getCellText(idx, 'osa-ColContrepartie');
			document.getElementById('osa-echeance').value = osa_aEcritures.getCellText(idx, 'osa-ColEcheance');
			document.getElementById('osa-reglement').value = osa_aEcritures.getCellText(idx, 'osa-ColModeRegId');
			document.getElementById('osa-commentaire').value = osa_aEcritures.getCellText(idx, 'osa-ColCommentaire');
			document.getElementById('osa-debit').value = osa_aEcritures.getCellText(idx, 'osa-ColDebit').replace(/ /gi,'');
			document.getElementById('osa-credit').value = osa_aEcritures.getCellText(idx, 'osa-ColCredit').replace(/ /gi,'');
			document.getElementById('osa-piece').value = osa_aEcritures.getCellText(idx, 'osa-ColPiece');

			document.getElementById('osa-controleCoherence').value = "";
			document.getElementById('osa-controleCoherence').collapsed = true;

			if (osa_aEcritures.isSeparator(idx)) {
				osa_setLigneEditable(false);
				osa_razInfosCpte();
				osa_razSoldesEcr();
			}
			else {
				osa_refreshInfosCpte(numCompte);
				if (isEmpty(osa_aEcritures.getCellText(idx, 'osa-ColLettre')) && osa_aEcritures.getCellValue(idx, 'osa-ColPointage')!="1") {
					osa_setLigneEditable(true);
				}
				else {
					osa_setLigneEditable(false);
				}
				osa_refreshSoldesEcr(idx);
			}

			if (!isEmpty(numCompte) && osa_aEcritures.getCellText(idx, 'osa-ColModif')=='1') {
				if (isEmpty(document.getElementById('osa-debit').value)) {
					document.getElementById('osa-credit').focus();
				}
				else {
					document.getElementById('osa-debit').focus();
				}
			}
			else {
				document.getElementById('osa-jour').focus();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function osa_loadVentilation(opId) {
	try {
		var qGetVentilation = new QueryHttp(osa_adrGetVentil);
		qGetVentilation.setParam('Op_Id', opId);
		var result = qGetVentilation.execute();
		var resultLignes = result.responseXML.documentElement.getElementsByTagName("ligne");
		var ventilation = new Array();
		for (var i=0; i<resultLignes.length; i++) {
			var resultLigne = resultLignes.item(i);
			var ligne = new Ligne();
			ligne.id = resultLigne.getAttribute("id");
			ligne.numero = resultLigne.getAttribute("numero");
			ligne.intitule = resultLigne.getAttribute("intitule");
			ligne.montant = resultLigne.getAttribute("montant");
			ligne.pourcentage = resultLigne.getAttribute("pourcentage");
			ventilation.push(ligne);
		}
		return ventilation;
	} catch (e) {
		recup_erreur(e);
	}
}


function osa_refreshSoldesEcr(idx) {
	try {

		var debit = 0;
		var credit = 0;

		var rd2 = new Arrondi(2);

		var i = idx;
		while (i>=0 && !osa_aEcritures.isSeparator(i)) {
			var d = osa_aEcritures.getCellText(i, 'osa-ColDebit').replace(/ /gi,'');
			var c = osa_aEcritures.getCellText(i, 'osa-ColCredit').replace(/ /gi,'');
			if (d!="") debit += rd2.round(parseFloat(d));
			if (c!="") credit += rd2.round(parseFloat(c));
			i--;
		}
		i = idx + 1;
		while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
			var d = osa_aEcritures.getCellText(i, 'osa-ColDebit').replace(/ /gi,'');
			var c = osa_aEcritures.getCellText(i, 'osa-ColCredit').replace(/ /gi,'');
			if (d!="") debit += rd2.round(parseFloat(d));
			if (c!="") credit += rd2.round(parseFloat(c));
			i++;
		}

	 	document.getElementById("osa-debitEC").value = nfMt.format(debit);
	 	document.getElementById("osa-creditEC").value = nfMt.format(credit);
		document.getElementById("osa-soldeEC").value = nfMt.format(rd2.round(debit) - rd2.round(credit));

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_razSoldesEcr() {
	try {

		document.getElementById("osa-debitEC").value = "";
	 	document.getElementById("osa-creditEC").value = "";
		document.getElementById("osa-soldeEC").value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_existeCompte(numCompte) {
	try {

		var qExist = new QueryHttp("Compta/Comptes/existNumCompte.tmpl");
		qExist.setParam("Num_Compte", numCompte);
		qExist.setParam("Assignable", true);
		var result = qExist.execute();

		return result.responseXML.documentElement.getAttribute('Exist')=="true";

 	} catch (e) {
		recup_erreur(e);
		return false;
	}
}


function osa_refreshInfosCpte(numCompte) {
	try {

		var qGet = new QueryHttp("Compta/Comptes/getInfosCompte.tmpl");
		qGet.setParam("Num_Compte", numCompte);
		qGet.setParam("Infos_Compte", true);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			if (contenu.getAttribute('Exist')=="true") {
				var typeCompte = contenu.getAttribute('Type_Compte');
				document.getElementById('osa-typeCompte').value = typeCompte;
				document.getElementById('osa-intituleCompte').value = contenu.getAttribute('Intitule');
				document.getElementById('osa-debitCompteN').value = contenu.getAttribute('Debit_N');
				document.getElementById('osa-creditCompteN').value = contenu.getAttribute('Credit_N');
				document.getElementById('osa-soldeCompteN').value = contenu.getAttribute('Solde_N');
				document.getElementById('osa-debitCompteN1').value = contenu.getAttribute('Debit_N1');
				document.getElementById('osa-creditCompteN1').value = contenu.getAttribute('Credit_N1');
				document.getElementById('osa-soldeCompteN1').value = contenu.getAttribute('Solde_N1');

				// en mode rappel, hors raccourci, si le compte sur la premiere ligne est un compte de tiers on active le rappel
				if(!osa_modeRaccourci && osa_rappelAuto && osa_isPremiereLigne() && (typeCompte=="F" || typeCompte=="C") && (osa_currentTypeJournal=="AC" || osa_currentTypeJournal=="VE")) {
					osa_modeRappel.active = true;
					osa_modeRappel.typeCompte = typeCompte;
					osa_modeRappel.contrepartie = contenu.getAttribute('Contrepartie');
					osa_modeRappel.codeTVA = contenu.getAttribute('Code_TVA');

					if (osa_modeRappel.codeTVA!=1) {
						osa_fillModeRappelTVA();
					}
				}
			}
			else {
				osa_razInfosCpte();
			}
		}

 	} catch (e) {
		recup_erreur(e);
	}
}


function osa_fillModeRappelTVA() {
	try {

		var qGet = new QueryHttp("Compta/Saisie/getInfosTauxTVA.tmpl");
		qGet.setParam("Code_TVA", osa_modeRappel.codeTVA);
		var result = qGet.execute();

		osa_modeRappel.taux = result.responseXML.documentElement.getAttribute('Taux_TVA');

		if (osa_modeRappel.typeCompte=='F') {
			osa_modeRappel.compteTVA = result.responseXML.documentElement.getAttribute('Compte_TVA_Achat');
		}
		else if (osa_modeRappel.typeCompte=='C') {
			osa_modeRappel.compteTVA = result.responseXML.documentElement.getAttribute('Compte_TVA_Vente');
		}

 	} catch (e) {
		recup_erreur(e);
	}
}


function osa_razInfosCpte() {
	try {

		document.getElementById('osa-intituleCompte').value = "";
		document.getElementById('osa-typeCompte').value = "";
		document.getElementById('osa-debitCompteN').value = "";
		document.getElementById('osa-creditCompteN').value = "";
		document.getElementById('osa-soldeCompteN').value = "";
		document.getElementById('osa-debitCompteN1').value = "";
		document.getElementById('osa-creditCompteN1').value = "";
		document.getElementById('osa-soldeCompteN1').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_getChild(idx) {
	try {

		var child = null;
		var children = osa_dsEcritures.getNode(osa_ECRITURES_NS).getChildren();

		while (children.hasMoreElements()) {
			var c = children.getNext();
			if (osa_dsEcritures.getNode(osa_ECRITURES_NS).getChildIndex(c) == idx+1) {
				child = c;
				break;
			}
		}
		return child;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_validerLigne() {
	try {

		if (osa_checkLigne()) {
		// la ligne est valide

			// si on est dans le mode raccourci
			// on peut calculer le pourcentage d'origine et passer  la ligne de modele suivante
			if (osa_modeRaccourci) {
				// la ligne saisie tait un pourcentage en le montant total n'avait pas t calcul
				if (osa_modele[osa_currentLigne].calcul=='P' && osa_montantPourcent==-1) {
					// preparation de l'arrondi
					var rd2 = new Arrondi(2);
					// debit modele !=0 et debit courant non vide et non nul et montant pourcent = -1 -> calcul montant pourcent
					if (osa_modele[osa_currentLigne].debit!=0
					&& !isEmpty(document.getElementById('osa-debit').value)
					&& document.getElementById('osa-debit').value!=0) {
						osa_montantPourcent = rd2.round(document.getElementById('osa-debit').value*100/osa_modele[osa_currentLigne].debit);
						osa_modele[osa_currentLigne].debitCalc = rd2.round(document.getElementById('osa-debit').value);
					}
					// credit modele !=0 et credit courant non vide et non nul et montant pourcent = -1 -> calcul montant pourcent
					if (osa_modele[osa_currentLigne].credit!=0
					&& !isEmpty(document.getElementById('osa-credit').value)
					&& document.getElementById('osa-credit').value!=0) {
						osa_montantPourcent = rd2.round(document.getElementById('osa-credit').value*100/osa_modele[osa_currentLigne].credit);
						osa_modele[osa_currentLigne].creditCalc = rd2.round(document.getElementById('osa-credit').value);
					}
				}

				// passage  la ligne suivante du modele
				osa_currentLigne++;

				// si on a atteint la fin du modele, on quitte le mode raccourci
				if (osa_currentLigne>=osa_modele.length) {
					osa_enableModeRaccourci(false);
				}
			}


			if (osa_modeRappel.active) {
				if (osa_modeRappel.etat==0) {
					osa_modeRappel.debitRef = isEmpty(document.getElementById('osa-debit').value)?0:document.getElementById('osa-debit').value;
					osa_modeRappel.creditRef = isEmpty(document.getElementById('osa-credit').value)?0:document.getElementById('osa-credit').value;
					if (osa_modeRappel.codeTVA!=1) {
						// on a une tva, on peut donc en dduire le montant de la contrepartie
						var rd2 = new Arrondi(2);
						osa_modeRappel.creditCp = rd2.round(parseFloat(osa_modeRappel.debitRef)*100/(100+parseFloat(osa_modeRappel.taux)));
						osa_modeRappel.debitCp = rd2.round(parseFloat(osa_modeRappel.creditRef)*100/(100+parseFloat(osa_modeRappel.taux)));
						osa_modeRappel.creditTVA = rd2.round(parseFloat(osa_modeRappel.debitRef)*parseFloat(osa_modeRappel.taux)/(100+parseFloat(osa_modeRappel.taux)));
						osa_modeRappel.debitTVA = rd2.round(parseFloat(osa_modeRappel.creditRef)*parseFloat(osa_modeRappel.taux)/(100+parseFloat(osa_modeRappel.taux)));
						// lissage de la valeur
						var deb = parseFloat(osa_modeRappel.debitCp)+parseFloat(osa_modeRappel.debitTVA);
						var cre = parseFloat(osa_modeRappel.creditCp)+parseFloat(osa_modeRappel.creditTVA);
						if (deb<parseFloat(osa_modeRappel.creditRef)) {
							osa_modeRappel.debitTVA += osa_modeRappel.creditRef-deb;
						} else {
							osa_modeRappel.debitTVA -= deb-osa_modeRappel.creditRef;
						}
						if (cre<parseFloat(osa_modeRappel.debitRef)) {
							osa_modeRappel.creditTVA += osa_modeRappel.debitRef-cre;
						} else {
							osa_modeRappel.creditTVA -= cre-osa_modeRappel.debitRef;
						}
					}
				}
				// verif du respect de la contrepartie du rappel
				// en etat 0, il n'ya rien  vrifier
				// en etat 1, on verifie la contrepartie
				if (osa_modeRappel.etat==1 && !isEmpty(osa_modeRappel.contrepartie) && document.getElementById('osa-compte').value!=osa_modeRappel.contrepartie) {
					osa_modeRappel = new osa_ModeRappel();
				}
				// en etat 2, si le taux tva n'est pas respect, c'est pas grave puisque c'est la dernire ligne
			}
			if (osa_modeRappel.active) {
				// passage du rappel  l'etat suivant
				osa_modeRappel.etat++;
				if (osa_modeRappel.etat>2) {
				// on a atteint la fin thorique du modele de rappel, il est donc reinitialis
					osa_modeRappel = new osa_ModeRappel();
				}
			}

			var idx = osa_aEcritures.getCurrentIndex();
			var child = osa_getChild(idx);

			child.addTargetOnce(osa_targetName('Jour_Op'), document.getElementById('osa-jour').value);
			child.addTargetOnce(osa_targetName('Num_Compte'), document.getElementById('osa-compte').value);
			child.addTargetOnce(osa_targetName('Libelle'), document.getElementById('osa-libelle').value);
			child.addTargetOnce(osa_targetName('Contrepartie'), document.getElementById('osa-contrepartie').value);
			child.addTargetOnce(osa_targetName('Echeance'), document.getElementById('osa-echeance').value);
			child.addTargetOnce(osa_targetName('Mode_Reg_Id'), document.getElementById('osa-reglement').value);
			if (!isEmpty(document.getElementById('osa-reglement').value)) {
				child.addTargetOnce(osa_targetName('Lib_Mode_Reg'), document.getElementById('osa-reglement').getAttribute('label'));
			}
			child.addTargetOnce(osa_targetName('Commentaire'), document.getElementById('osa-commentaire').value);
			var debit = document.getElementById('osa-debit').value;
			var credit = document.getElementById('osa-credit').value;
			child.addTargetOnce(osa_targetName('Debit'), isEmpty(debit)?debit:nfMt.format(debit));
			child.addTargetOnce(osa_targetName('Credit'), isEmpty(credit)?credit:nfMt.format(credit));
			child.addTargetOnce(osa_targetName('Num_Piece'), document.getElementById('osa-piece').value);

			// gestion analytique
			if (osa_activeAnalytique) {
				if (!document.getElementById('osa-analytique').disabled) {
					// lorsque la saisie est active, la verif a laiss passer soit <vide> soit un compte ana valide seul
					var num = document.getElementById('osa-analytique').value;
					if (isEmpty(num)) {
						// si la saisie d'analytique est vide et active, on dtruit toute ventilation existante
						var ventilVide = new Array();
						if (osa_idxVentilation==-1) {
							osa_tabVentilation.push(ventilVide);
							osa_idxVentilation = osa_tabVentilation.length-1;
						} else {
							osa_tabVentilation[osa_idxVentilation] = ventilVide;
						}
					} else {
						// si le champ ventilation a t saisie  la vole, il faut crer la ligne correspondante
						// pour l'instant on recree systematiquement une ligne solo
						var go = false;
						if (osa_idxVentilation==-1) {
							go = true;
						} else if (osa_tabVentilation[osa_idxVentilation].length==0) {
							// on crit une ventil simple sans avoir valid le numro de compte
							go = true;
						} else {
							go = (num!=osa_tabVentilation[osa_idxVentilation][0].numero);
						}
						if (go) {
							var qGetCompteByNum = new QueryHttp("Compta/Analytique/Comptes/getCompteByNumero.tmpl");
							qGetCompteByNum.setParam("Numero", num);
							var result = qGetCompteByNum.execute();
							var errors = new Errors(result);

							if (errors.hasNext()) {
								errors.show();
							}
							else {
								if (result.responseXML.documentElement.getAttribute("Actif")=="true") {
									// creation de la ligne
									var numero = result.responseXML.documentElement.getAttribute("Numero");
									var intitule = result.responseXML.documentElement.getAttribute("Intitule");
									osa_createVentilationLigne(numero, intitule);
								} else {
									// le compte aurait chang d'tat depuis la validation : pb
								}
							}
						}
					}
				}
				// on met  jour la ligne du tableau
				child.addTargetOnce(osa_targetName('Analytique'), document.getElementById('osa-analytique').value);
				child.addTargetOnce(osa_targetName('Ventilation'), osa_idxVentilation+"");

				osa_resetSaisieAnalytique();
			}

			var modif = false;

			if (!osa_ecritureSansMontant(idx)) {
				if (osa_ecritureStable(idx)) {

					if (!osa_isEcritureEnModif(idx)) {
						idx = osa_getDernierIndexEcriture(idx);	// correction bug dcrit mail sb - 27/02/2018
						osa_ajouterSeparateur(idx+1);
						osa_ajouterLigneVide(idx+2);
						osa_selectLigne(idx+2);
					}
					else {
						osa_selectEcritureSuivante(idx);
					}

					osa_enregistrerEcriture(idx);

					// on a termin une criture
					// on relance le mode rappel
					if (osa_rappelAuto) {
						osa_modeRappel = new osa_ModeRappel();
					}
				}
				else if (osa_aEcritures.nbLignes()==idx+1 || osa_aEcritures.isSeparator(idx+1)) {
					osa_toModeModif(idx);
					osa_insererLignePreremplie(idx);
				}
				else {
					osa_toModeModif(idx);
					modif = true;
					osa_selectLigne(idx+1);
				}
			}

			if (modif && !isEmpty(document.getElementById('osa-compte').value)) {
				if (isEmpty(document.getElementById('osa-debit').value)) {
					document.getElementById('osa-credit').focus();
				}
				else {
					document.getElementById('osa-debit').focus();
				}
			}
			else {
				document.getElementById('osa-jour').focus();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_insererLignePreremplie(idx) {
	try {

		osa_ajouterLigneVide(idx+1);

		var child = osa_getChild(idx+1);

		child.addTargetOnce(osa_targetName('Ecriture_Id'), osa_aEcritures.getCellText(idx, 'osa-ColEcritureId'));
		child.addTargetOnce(osa_targetName('Jour_Op'), document.getElementById('osa-jour').value);
		child.addTargetOnce(osa_targetName('Num_Compte'), document.getElementById('osa-contrepartie').value);
		child.addTargetOnce(osa_targetName('Libelle'), document.getElementById('osa-libelle').value);
		child.addTargetOnce(osa_targetName('Echeance'), document.getElementById('osa-echeance').value);
		child.addTargetOnce(osa_targetName('Num_Piece'), document.getElementById('osa-piece').value);

		osa_selectLigne(idx+1);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_checkLigne() {
	try {

		var jour = document.getElementById('osa-jour').value;
		var compte = document.getElementById('osa-compte').value;
		var libelle = document.getElementById('osa-libelle').value;
		var contrepartie = document.getElementById('osa-contrepartie').value;
		var echeance = document.getElementById('osa-echeance').value;
		var commentaire = document.getElementById('osa-commentaire').value;
		var debit = document.getElementById('osa-debit').value;
		var credit = document.getElementById('osa-credit').value;
		var piece = document.getElementById('osa-piece').value;

		if (isEmpty(jour)) {
			document.getElementById('osa-jour').focus();
			showWarning("Date manquante");
			return false;
		}

		if (!isDate(jour +"/"+ osa_currentPeriode.substring(0,2) +"/20"+ osa_currentPeriode.substring(2,4))) {
			document.getElementById('osa-jour').focus();
			showWarning("Date incorrecte (format jj)");
			return false;
		}

		if (isEmpty(compte)) {
			document.getElementById('osa-compte').focus();
			showWarning("Num\u00E9ro de compte manquant");
			return false;
		}

		if (!osa_existeCompte(compte)) {
			document.getElementById('osa-compte').focus();
			showWarning("Num\u00E9ro de compte incorrect");
			return false;
		}

		if (isEmpty(libelle)) {
			document.getElementById('osa-libelle').focus();
			showWarning("Libell\u00E9 de l'\u00E9criture manquant");
			return false;
		}

		if (libelle.indexOf("|")!=-1) {
			document.getElementById('osa-libelle').focus();
			showWarning("Caract\u00E8re | interdit dans le libell\u00E9");
			return false;
		}

		if (!isEmpty(contrepartie) && !osa_existeCompte(contrepartie)) {
			document.getElementById('osa-contrepartie').focus();
			showWarning("Contrepartie incorrecte");
			return false;
		}

		if (!isEmpty(echeance) && !isDate(echeance)) {
			document.getElementById('osa-echeance').focus();
			showWarning("Date d'\u00E9ch\u00E9ance incorrecte (format jj/mm/aaaa)");
			return false;
		}

		if (commentaire.indexOf("|")!=-1) {
			document.getElementById('osa-commentaire').focus();
			showWarning("Caract\u00E8re | interdit dans le champ Infos");
			return false;
		}

		if (isEmpty(debit) && isEmpty(credit)) {
			document.getElementById('osa-debit').focus();
			showWarning("Montant de la ligne manquant");
			return false;
		}

		if (!isEmpty(debit) && !isEmpty(credit)) {
			document.getElementById('osa-debit').focus();
			showWarning("Veuillez ne remplir que le d\u00E9bit ou que le cr\u00E9dit de la ligne");
			return false;
		}

		if (isEmpty(debit) && (!isPositive(credit) || !checkDecimal(credit, 2))) {
			document.getElementById('osa-credit').focus();
			showWarning("Montant au cr\u00E9dit incorrect");
			return false;
		}

		if (isEmpty(credit) && (!isPositive(debit) || !checkDecimal(debit, 2))) {
			document.getElementById('osa-debit').focus();
			showWarning("Montant au d\u00E9bit incorrect");
			return false;
		}

		if (piece.indexOf("|")!=-1) {
			document.getElementById('osa-piece').focus();
			showWarning("Caract\u00E8re | interdit dans le champ N\u00B0 Pi\u00E8ce");
			return false;
		}

		if (osa_activeAnalytique) {
			if (osa_compteChargeProduit) {
				if (osa_idxVentilation!=-1 && osa_tabVentilation[osa_idxVentilation].length>0) {
					// dans tous les cas il faut vrifier les totaux de la ventilation
					var rd2 = new Arrondi(2);
					var ventilation = osa_tabVentilation[osa_idxVentilation];
					var sumM = 0;
					var sumP = 0;
					var montant = ((debit==0)?credit:debit);
					for (var i=0; i<ventilation.length; i++) {
						var ligne = ventilation[i];
						var m = parseFloat(ligne.montant);
						m = (isNaN(m)?0:m);
						var p = parseFloat(ligne.pourcentage);
						p = (isNaN(p)?0:p);
						sumM += m;
						sumP += p;
					}
					sumM = rd2.round(sumM);
					sumP = rd2.round(sumP);

					if (sumP==0) {
						// on est en mode saisie de montants
						if (sumM!=montant) {
							showWarning("Le montant de la ventilation analytique est diff\u00E9rent du montant de la ligne saisie !");
							if (debit!=0) {
								document.getElementById('osa-debit').focus();
							} else {
								document.getElementById('osa-credit').focus();
							}
							return false;
						}
					} else if (sumP!=100) {
						// on est en mode pourcentages et une ventilation incomplte a t saisie
						showWarning("La ventilation analytique ne couvre pas 100% du montant de la ligne de saisie !");
						osa_popupVentilation();
						return false;
					}
					// dans le cas d'une ventilation  une seule ligne dont les totaux sont corrects
					// le numro de compte a pu tre saisie  la vole
					if (osa_tabVentilation[osa_idxVentilation].length==1) {
						var compteAna = document.getElementById('osa-analytique').value;
						if (!isEmpty(compteAna)) {
							var exist = osa_existeCompteAna(compteAna)
							if (!exist) {
								document.getElementById('osa-analytique').focus();
								return false;
							}
						}
					}
				} else {
					// on traite ici les saisies  la vole
					// sans tableau de ventilation ou sur un tableau vide
					var compteAna = document.getElementById('osa-analytique').value;
					if (!isEmpty(compteAna)) {
						var exist = osa_existeCompteAna(compteAna)
						if (!exist) {
							document.getElementById('osa-analytique').focus();
							return false;
						}
					}
				}
			} else if (osa_idxVentilation!=-1 && osa_tabVentilation[osa_idxVentilation].length>0) {
				if (window.confirm("Une ventilation analytique a \u00E9t\u00E9 d\u00E9tect\u00E9e sur un compte ni charge ni produit !\n"
									+"Voulez-vous supprimer cette ventilation ?\n"
									+"Annulez pour la conserver et changer le compte utilis\u00E9.")) {
					// on annule la ventilation
					osa_tabVentilation[osa_idxVentilation] = new Array();
				} else {
					// on modifie le compte
					document.getElementById('osa-compte').focus();
					return false;
				}
			}
		}
		return true;

	} catch (e) {
		recup_erreur(e);
		return false;
	}
}

function osa_existeCompteAna(numero) {
	try {
		var qGetCompteByNum = new QueryHttp("Compta/Analytique/Comptes/getCompteByNumero.tmpl");
		qGetCompteByNum.setParam("Numero", numero);
		var result = qGetCompteByNum.execute();
		var errors = new Errors(result);

		if (errors.hasNext()) {
			errors.show();
			return false;
		} else {
			if (result.responseXML.documentElement.getAttribute("Actif")=="false") {
				showWarning("Le compte num\u00E9ro "+ numero +" est invalide !");
				// on ne compte que les comptes actifs
				return false;
			} else {
				return true;
			}
		}
	} catch (e) {
		recup_erreur(e);
		return false;
	}
}

function osa_isEcritureEnModif(idx) {
	try {

		return osa_aEcritures.getCellText(idx, 'osa-ColEcritureId')!='0';

	} catch (e) {
		recup_erreur(e);
		return false;
	}
}


function osa_toModeModif(idx) {
	try {

		var i = idx;
		var child;

		while (i>=0 && !osa_aEcritures.isSeparator(i)) {
			child = osa_getChild(i);
			child.addTargetOnce(osa_targetName('Prop'), 'enabled');
			child.addTargetOnce(osa_targetName('Modif'), '1');
			i--;
		}
		i = idx + 1;
		while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
			child = osa_getChild(i);
			child.addTargetOnce(osa_targetName('Prop'), 'enabled');
			child.addTargetOnce(osa_targetName('Modif'), '1');
			i++;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_getDernierIndexEcriture(idx) {
	try {

		var i = idx + 1;

		while (i<osa_aEcritures.nbLignes()) {
			if (osa_aEcritures.isSeparator(i)) {
				break;
			}
			i++;
		}

		return i - 1;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_selectEcritureSuivante(idx) {
	try {

		var i = idx + 1;

		while (i<osa_aEcritures.nbLignes()) {
			if (osa_aEcritures.isSeparator(i)) {
				osa_selectLigne(i+1);
				break;
			}
			i++;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ecritureStable(idx) {
	try {

		osa_refreshSoldesEcr(idx);
		return document.getElementById('osa-debitEC').value==document.getElementById('osa-creditEC').value && parseFloat(document.getElementById('osa-debitEC').value)>0 && parseFloat(document.getElementById('osa-creditEC').value)>0;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_ecritureSansMontant(idx) {
	try {

		var i = idx;
		while (i>=0 && !osa_aEcritures.isSeparator(i)) {
			if (isEmpty(osa_aEcritures.getCellText(i, 'osa-ColDebit')) && isEmpty(osa_aEcritures.getCellText(i, 'osa-ColCredit'))) return true;
			i--;
		}
		i = idx + 1;
		while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
			if (isEmpty(osa_aEcritures.getCellText(i, 'osa-ColDebit')) && isEmpty(osa_aEcritures.getCellText(i, 'osa-ColCredit'))) return true;
			i++;
		}

		return false;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnLibelle(event) {
	try {
		// F3
		if (event.keyCode==114) {
			document.getElementById('osa-libelle').value = document.getElementById('osa-intituleCompte').value;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnCredit() {
	try {

		var credit = document.getElementById('osa-credit').value;

		if (parseFloat(credit)==0) {
			document.getElementById('osa-credit').value = "";
			credit = "";
		}

		var rd2 = new Arrondi(2);

		if (credit=="*" && !osa_modeRaccourci) {

			var debitOp = osa_aEcritures.getSelectedCellText('osa-ColDebit');
			var creditOp = osa_aEcritures.getSelectedCellText('osa-ColCredit');
			var soldeOp = (isEmpty(debitOp)?0:debitOp) - (isEmpty(creditOp)?0:creditOp);
			var solde = rd2.round(parseFloat(document.getElementById("osa-soldeEC").value.replace(/ /gi,'')) - soldeOp);

			if (solde>0) {
				document.getElementById('osa-credit').value = solde;
			}
			else if (solde<0) {
				document.getElementById('osa-credit').value = "";
				document.getElementById('osa-debit').value = Math.abs(solde);
			}
			else {
				document.getElementById('osa-credit').value = "";
			}
		}
		else if (!isEmpty(credit)) {
			try {
				document.getElementById('osa-credit').value = rd2.round(eval(credit));
			}	catch(e) {}
		}

		document.getElementById('osa-piece').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnDebit() {
	try {

		var debit = document.getElementById('osa-debit').value;

		if (parseFloat(debit)==0) {
			document.getElementById('osa-debit').value = "";
			debit = "";
		}

		var rd2 = new Arrondi(2);

		if (isEmpty(debit)) {
			document.getElementById('osa-credit').focus();
		}
		else if (debit=="*" && !osa_modeRaccourci) {

			var debitOp = osa_aEcritures.getSelectedCellText('osa-ColDebit');
			var creditOp = osa_aEcritures.getSelectedCellText('osa-ColCredit');
			var soldeOp = (isEmpty(debitOp)?0:debitOp) - (isEmpty(creditOp)?0:creditOp);
			var solde = rd2.round(parseFloat(document.getElementById("osa-soldeEC").value.replace(/ /gi,'')) - soldeOp);

			if (solde<0) {
				document.getElementById('osa-debit').value = Math.abs(solde);
			}
			else if (solde>0) {
				document.getElementById('osa-debit').value = "";
				document.getElementById('osa-credit').value = solde;
			}
			else {
				document.getElementById('osa-debit').value = "";
			}
			document.getElementById('osa-piece').focus();
		}
		else {
			try {
				document.getElementById('osa-debit').value = rd2.round(eval(debit));
			}	catch(e) {}
			document.getElementById('osa-piece').focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_backupCompte() {
	try {
		osa_compteSaisie = document.getElementById('osa-compte').value;
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_pressOnCompte() {
	try {

		var numCompte = document.getElementById('osa-compte').value;

		var qSearch = new QueryHttp("Compta/Comptes/searchNumCompte.tmpl");
		qSearch.setParam("Num_Compte", numCompte);
		qSearch.setParam("Search_Like", true);
		qSearch.setParam("Centralisateur", false);
		var result = qSearch.execute();

		var compteId = result.responseXML.documentElement.getAttribute("Compte_Id");
		if (!isEmpty(compteId)) {
			var findCompte = result.responseXML.documentElement.getAttribute("Num_Compte");

			if (document.getElementById('osa-compte').value!=findCompte) {
				// pour viter appel  osa_changeOnCompte() si le compte n'a pas chang
				document.getElementById('osa-compte').value = findCompte;
			}

			if (osa_compteSaisie != document.getElementById('osa-compte').value) {
				osa_resetPreVentilation();
			}
		}
		else {
			osa_openRechercheCompte('osa-compte');
		}

		osa_refreshInfosCpte(document.getElementById('osa-compte').value);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnContrepartie() {
	try {

		var numCompte = document.getElementById('osa-contrepartie').value;

		if (!isEmpty(numCompte)) {
			var qSearch = new QueryHttp("Compta/Comptes/searchNumCompte.tmpl");
			qSearch.setParam("Num_Compte", numCompte);
			qSearch.setParam("Search_Like", true);
			qSearch.setParam("Centralisateur", false);
			var result = qSearch.execute();

			var compteId = result.responseXML.documentElement.getAttribute("Compte_Id");
			if (!isEmpty(compteId)) {
				document.getElementById('osa-contrepartie').value = result.responseXML.documentElement.getAttribute("Num_Compte");
			}
			else {
				osa_openRechercheCompte('osa-contrepartie');
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnLigneSaisie(event) {
	try {

		if ((event.keyCode==13 || (event.keyCode==9 && !event.shiftKey)) && osa_aEcritures.isSelected() && !osa_aEcritures.isSeparator(osa_aEcritures.getCurrentIndex())) {

			if (event.keyCode==9) event.preventDefault();

			// entre
			switch (event.target.id) {
				case 'osa-jour':
					document.getElementById('osa-compte').focus();
					break;
				case 'osa-compte':
					osa_pressOnCompte();
					osa_checkCoherence();
					document.getElementById('osa-libelle').focus();
					break;
				case 'osa-libelle':
					if (osa_activeAnalytique) {
						if (!document.getElementById('osa-analytique').disabled) {
							document.getElementById('osa-analytique').focus();
						} else if (osa_idxVentilation!=-1) {
							if (osa_verifAppelPopup()) {
								osa_popupVentilation();
							} else {
								document.getElementById('osa-contrepartie').focus();
							}
						} else {
							document.getElementById('osa-contrepartie').focus();
						}
					} else {
						document.getElementById('osa-contrepartie').focus();
					}
					break;
				case 'osa-analytique':
					osa_pressOnAnalytique();
					break;
				case 'osa-contrepartie':
					osa_pressOnContrepartie();
					document.getElementById('osa-echeance').focus();
					break;
				case 'osa-echeance':
					if (!document.getElementById('osa-reglement').disabled) {
						document.getElementById('osa-reglement').focus();
					}
					else {
						document.getElementById('osa-commentaire').focus();
					}
					break;
				case 'osa-reglement':
					document.getElementById('osa-commentaire').focus();
					break;
				case 'osa-commentaire':
					document.getElementById('osa-debit').focus();
					break;
				case 'osa-debit':
					osa_pressOnDebit();
					osa_checkCoherence();
					break;
				case 'osa-credit':
					osa_pressOnCredit();
					osa_checkCoherence();
					break;
				case 'osa-piece':
					if (osa_modeRaccourci) {
						if (osa_checkModele()) {
							// on valide et si ok, on calcule le montant total et on passe  la ligne suivante du modele
							osa_validerLigne();
							// si non valid on recharge la ligne du modele, sinon on charge la suivante
							if (osa_modeRaccourci) {
								osa_executeModele();
							}
						} else {
							// il y a eu un probleme
							if (!osa_modeRaccourci) {
								// on a quitt le mode raccourci, on valide donc la ligne
								osa_validerLigne();
							} else {
								// on veut rester dans le mode raccourci, on reload donc les primaries
								osa_executeModelePrimaries();
							}
						}
					} else {
						// le mode rappel auto ne fonctionne que hors raccourci
						// chargement effectu dans refresh infos compte
						osa_validerLigne();
						if (osa_modeRappel.active) {
							// on charge les donnes auto-apprises
							osa_executeRappel();
						}
					}
					break;
			}
		}
		else if ((event.keyCode==27 || (event.shiftKey && event.keyCode==9)) && osa_aEcritures.isSelected() && !osa_aEcritures.isSeparator(osa_aEcritures.getCurrentIndex()) && !event.ctrlKey) {

			if (event.keyCode==9) event.preventDefault();

			// echap
			switch (event.target.id) {
				case 'osa-compte':
					document.getElementById('osa-jour').focus();
					break;
				case 'osa-libelle':
					document.getElementById('osa-compte').focus();
					break;
				case 'osa-analytique':
					document.getElementById('osa-libelle').focus();
					break;
				case 'osa-contrepartie':
					if (osa_activeAnalytique && !document.getElementById('osa-analytique').disabled) {
						document.getElementById('osa-analytique').focus();
					} else {
						document.getElementById('osa-libelle').focus();
					}
					break;
				case 'osa-echeance':
					document.getElementById('osa-contrepartie').focus();
					break;
				case 'osa-reglement':
					document.getElementById('osa-echeance').focus();
					break;
				case 'osa-commentaire':
					if (!document.getElementById('osa-reglement').disabled) {
						document.getElementById('osa-reglement').focus();
					}
					else {
						document.getElementById('osa-echeance').focus();
					}
					break;
				case 'osa-debit':
					document.getElementById('osa-commentaire').focus();
					break;
				case 'osa-credit':
					document.getElementById('osa-debit').focus();
					break;
				case 'osa-piece':
					document.getElementById('osa-credit').focus();
					break;
			}
		}
		else if (event.keyCode==38 && event.target.id=="osa-jour") {
			// flche haut
			osa_lignePrecedente();
		}
		else if (event.keyCode==40 && event.target.id=="osa-jour") {
			// flche bas
			osa_ligneSuivante();
		}
		else if (event.keyCode==33) {
			// page up
			osa_ligneDefilPrec();
		}
		else if (event.keyCode==34) {
			// page down
			osa_ligneDefilSuiv();
		}
		else if (event.keyCode==35) {
			// fin
			osa_ligneFin();
		}
		else if (event.keyCode==36) {
			// orig
			osa_ligneDebut();
		}
		else if ((event.keyCode==45 || event.key=='o' || event.key=='O') && event.ctrlKey) {
			// ctrl + inser (ou ctrl + o pour les macs - touche inser inexistante)
			// insrer une ligne
			osa_insererOperation();
		}
		else if (event.keyCode==46 && event.ctrlKey) {
			// ctrl + suppr
			// supprimer une ligne

			event.preventDefault();	// ncessaire sinon l'appui sur suppr (du ctrl + suppr) s'excute et efface le champ slectionn osa-jour !
			osa_supprimerOperation();
		}
		else if (event.keyCode==46 && event.altKey) {
			// alt + suppr
			// supprimer une criture complte

			osa_supprimerEcriture();
		}
		else if (event.keyCode==27 && event.ctrlKey && osa_modeRaccourci) {
			// ctrl + esc
			osa_enableModeRaccourci(false);
		}
		else if (event.keyCode==115) {
			// F4
			// popup de ventilation
			if (osa_activeAnalytique && osa_compteChargeProduit) {
				osa_popupVentilation();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnAnalytique() {
	try {

		if (!osa_appelRechCompteAna && !document.getElementById("osa-analytique").getAttribute("readonly")) {

			var numCompte = document.getElementById('osa-analytique').value;

			if (isEmpty(numCompte)) {
				document.getElementById('osa-contrepartie').focus();
			}
			else if (numCompte=="*") {
				osa_popupVentilation();
			}
			else {			
				var qSearch = new QueryHttp("Compta/Analytique/Comptes/searchNumCompte.tmpl");
				qSearch.setParam("Num_Compte", numCompte);
				qSearch.setParam("Search_Like", true);
				var result = qSearch.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var findCompte = result.responseXML.documentElement.getAttribute("Num_Compte");

					if (!isEmpty(findCompte)) {
						var compteId = result.responseXML.documentElement.getAttribute("Compte_Id");
						osa_finRechercheCompteAna(compteId, findCompte);
					}
					else {
						osa_appelRechCompteAna = true;
						var url = "chrome://opensi/content/compta/user/analytique/comptes/popup-rechercheCompteAnalytique.xul";
    				window.openDialog(url,'','chrome,modal,centerscreen', osa_finRechercheCompteAna, numCompte);
						osa_appelRechCompteAna = false;
					}
				}
			}
		}
		else {
			document.getElementById('osa-contrepartie').focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_finRechercheCompteAna(compteId, numCompte) {
	try {

		document.getElementById('osa-analytique').value = numCompte;
		document.getElementById('osa-contrepartie').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_createVentilationLigne(numero, intitule) {
	try {
		//document.getElementById('osa-analytique').value = numero;
		// creation de la ligne solo
		var ligne = new Ligne();
		ligne.id = 0;
		ligne.numero = numero;
		ligne.intitule = intitule;
		ligne.montant = 0;
		ligne.pourcentage = 100;
		// creation de la ventilation
		var ventilation = new Array();
		ventilation.push(ligne);
		if (osa_idxVentilation==-1) {
			// ajout de ventilation
			osa_tabVentilation.push(ventilation);
			osa_idxVentilation = osa_tabVentilation.length-1;
		} else {
			// modification de ventilation
			osa_tabVentilation[osa_idxVentilation] = ventilation;
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnDate(ev) {
	try {

		if (ev.keyCode==120 && !osa_modeRaccourci && osa_isPremiereLigne()) {
			// F9

			var url = "chrome://opensi/content/compta/user/modelesecriture/popup-rechercheModeleEcriture.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', osa_loadModeleById);
		}
		else if (ev.ctrlKey && ev.charCode>=49 && ev.charCode<=57 && !osa_modeRaccourci && osa_isPremiereLigne()) {
			// ctrl + n de raccourci

			switch(ev.charCode) {
				case 49:	osa_loadModeleByRaccourci(1); break;
				case 50:	osa_loadModeleByRaccourci(2); break;
				case 51:	osa_loadModeleByRaccourci(3); break;
				case 52:	osa_loadModeleByRaccourci(4); break;
				case 53:	osa_loadModeleByRaccourci(5); break;
				case 54:	osa_loadModeleByRaccourci(6); break;
				case 55:	osa_loadModeleByRaccourci(7); break;
				case 56:	osa_loadModeleByRaccourci(8); break;
				case 57:	osa_loadModeleByRaccourci(9); break;
				default:
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_isPremiereLigne() {
	try {

		var idx = osa_aEcritures.getCurrentIndex();

		// verif si on est pas en modif d'une ecriture et si on est bien la premire ligne d'une saisie : idx  0 ou ligne prec = separator
		return !osa_isEcritureEnModif(idx) && (idx==0 || osa_aEcritures.isSeparator(idx-1));

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_enableModeRaccourci(b) {
	try {
		osa_modeRaccourci = b;
		osa_disableNearlyAll(b);
		document.getElementById("osa-modeleActif").collapsed = !b;

		if (b) {
			osa_executeModele();
		} else {
			osa_modele.length = 0;
			osa_currentLigne = 0;
			osa_montantPourcent = -1;
			osa_tabLP.length = 0;
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_executeModele() {
	try {
		osa_executeModelePrimaries();

		document.getElementById('osa-libelle').value = osa_modele[osa_currentLigne].libelle+(osa_modele[osa_currentLigne].periode?" du mois de "+document.getElementById('osa-periode').label:"");
		document.getElementById('osa-reglement').value = osa_modele[osa_currentLigne].reglement;
		document.getElementById('osa-commentaire').value = osa_modele[osa_currentLigne].infos;
		document.getElementById('osa-piece').value = osa_modele[osa_currentLigne].piece;
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_executeModelePrimaries() {
	try {
		// compte
		if (document.getElementById('osa-compte').value!=osa_modele[osa_currentLigne].compte) {
			document.getElementById('osa-compte').value = osa_modele[osa_currentLigne].compte;
			osa_resetPreVentilation();
		}
		osa_refreshInfosCpte(osa_modele[osa_currentLigne].compte);

		// debit et credit
		document.getElementById('osa-credit').value = "";
		document.getElementById('osa-debit').value = "";
		// calcul sans montant
		if (osa_modele[osa_currentLigne].calcul=='S') {
			// saisie libre au dbit ou au crdit
			document.getElementById('osa-debit').focus();
		}

		// calcul montant fixe
		else if (osa_modele[osa_currentLigne].calcul=='F') {
			// pas de saisie
			document.getElementById('osa-debit').value = (osa_modele[osa_currentLigne].debit==0?"":osa_modele[osa_currentLigne].debit);
			document.getElementById('osa-credit').value = (osa_modele[osa_currentLigne].credit==0?"":osa_modele[osa_currentLigne].credit);
			document.getElementById('osa-piece').focus();
		}

		// calcul pourcentage
		else if (osa_modele[osa_currentLigne].calcul=='P') {
			// calcul de la valeur  100% lors de la premiere saisie -> checkModele
			if (osa_montantPourcent==-1) {
				// calcul au dbit
				if (osa_modele[osa_currentLigne].debit!=0) {
					document.getElementById('osa-debit').focus();
				}
				// calcul au crdit
				else if (osa_modele[osa_currentLigne].credit!=0) {
					document.getElementById('osa-credit').focus();
				} else {
					// pb sur la ligne du modele
					document.getElementById('osa-debit').focus();
				}
			}
			// calcul de la valeur au dbit ou au crdit lors des saisies suivantes
			else {
				// preparation de l'arrondi
				var rd2 = new Arrondi(2);

				// calcul au dbit
				if (osa_modele[osa_currentLigne].debit!=0) {
					osa_modele[osa_currentLigne].debitCalc = rd2.round(osa_montantPourcent*osa_modele[osa_currentLigne].debit/100);
					document.getElementById('osa-debit').value = osa_modele[osa_currentLigne].debitCalc;
					document.getElementById('osa-piece').focus();
				}
				// calcul au crdit
				else if (osa_modele[osa_currentLigne].credit!=0) {
					osa_modele[osa_currentLigne].creditCalc = rd2.round(osa_montantPourcent*osa_modele[osa_currentLigne].credit/100);
					document.getElementById('osa-credit').value = osa_modele[osa_currentLigne].creditCalc;
					document.getElementById('osa-piece').focus();
				} else {
					// pb sur la ligne du modele
					document.getElementById('osa-debit').focus();
				}

				// test si dernire valeur en pourcent
				if (osa_modele[osa_currentLigne].tabLPId==osa_tabLP.length-1) {
					// calcul des sommes
					var sumD = 0;
					var sumC = 0;
					for (var i=0; i<osa_tabLP.length; i++) {
						sumD += osa_tabLP[i].debitCalc;
						sumC += osa_tabLP[i].creditCalc;
					}
					sumD = rd2.round(sumD);
					sumC = rd2.round(sumC);
					// ajustement calcul au dbit
					if (osa_modele[osa_currentLigne].debit!=0) {
						if (sumC<sumD) {
							osa_modele[osa_currentLigne].debitCalc -= (sumD-sumC);
						} else {
							osa_modele[osa_currentLigne].debitCalc += (sumC-sumD);
						}
						document.getElementById('osa-debit').value = osa_modele[osa_currentLigne].debitCalc;
					}
					// ajustement calcul au crdit
					else if (osa_modele[osa_currentLigne].credit!=0) {
						if (sumD<sumC) {
							osa_modele[osa_currentLigne].creditCalc -= (sumC-sumD);
						} else {
							osa_modele[osa_currentLigne].creditCalc += (sumD-sumC);
						}
						document.getElementById('osa-credit').value = osa_modele[osa_currentLigne].creditCalc;
					} else {
						// pb sur la ligne du modele
						document.getElementById('osa-debit').focus();
					}
				}
			}
		} else {
			// pb sur la ligne du modele : type de calcul
			document.getElementById('osa-debit').focus();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

// verif cohrence par rapport au modele : compte, debit, credit
// renvoie true si aucun problme
// set osa_modeRaccourci = false si quitter
function osa_checkModele() {
	try {
		var probleme = false;
		var quitter = false;
		// verif compte
		if (document.getElementById('osa-compte').value!=osa_modele[osa_currentLigne].compte) {
			probleme = true;
			quitter = window.confirm("Vous avez modifi\u00E9 le compte de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
					"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
					"Voulez-vous quitter le mode raccourci ?");
		}
		// montant fixe
		else if (osa_modele[osa_currentLigne].calcul=='F') {
			// debit
			// debit modele = 0 -> debit courant vide ou 0
			if (osa_modele[osa_currentLigne].debit==0
			&& !isEmpty(document.getElementById('osa-debit').value)
			&& document.getElementById('osa-debit').value!=0) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le d\u00E9bit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci \u00E9tait \u00E0 l'origine nul.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// debit modele !=0 -> debit courant = debit modele
			else if (osa_modele[osa_currentLigne].debit!=0
			&& document.getElementById('osa-debit').value!=parseFloat(osa_modele[osa_currentLigne].debit)) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le d\u00E9bit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci \u00E9tait \u00E0 l'origine fix\u00E9 \u00E0 une valeur pr\u00E9cise.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// credit
			// credit modele = 0 -> credit courant vide ou 0
			else if (osa_modele[osa_currentLigne].credit==0
			&& !isEmpty(document.getElementById('osa-credit').value)
			&& document.getElementById('osa-credit').value!=0) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le cr\u00E9dit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci \u00E9tait \u00E0 l'origine nul.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// credit modele !=0 -> credit courant = credit modele
			else if (osa_modele[osa_currentLigne].credit!=0
			&& document.getElementById('osa-credit').value!=parseFloat(osa_modele[osa_currentLigne].credit)) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le cr\u00E9dit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci \u00E9tait \u00E0 l'origine fix\u00E9 \u00E0 une valeur pr\u00E9cise.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
		}
		// montant pourcentage
		else if (osa_modele[osa_currentLigne].calcul=='P') {
			// debit
			var rd2 = new Arrondi(2);
			// debit modele = 0 -> debit courant vide ou 0
			if (osa_modele[osa_currentLigne].debit==0
			&& !isEmpty(document.getElementById('osa-debit').value)
			&& document.getElementById('osa-debit').value!=0) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le d\u00E9bit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci correspondait \u00E0 l'origine \u00E0 un pourcentage nul.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// debit modele !=0 -> debit courant non vide et non nul
			else if (osa_modele[osa_currentLigne].debit!=0
			&& (isEmpty(document.getElementById('osa-debit').value) || document.getElementById('osa-debit').value==0)) {
				probleme = true;
				quitter = window.confirm("Le mod\u00E8le attend un montant au d\u00E9bit.\n"+
				"Celui-ci correspondait \u00E0 l'origine \u00E0 un pourcentage.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// debit modele !=0 et debit courant non vide et non nul et montant pourcent != -1 -> debit courant = montant pourcent * debit modele / 100
			else if (osa_modele[osa_currentLigne].debit!=0
			&& !isEmpty(document.getElementById('osa-debit').value)
			&& document.getElementById('osa-debit').value!=0
			&& osa_montantPourcent!=-1
			&& document.getElementById('osa-debit').value!=rd2.round(osa_montantPourcent*osa_modele[osa_currentLigne].debit/100)) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le d\u00E9bit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci correspondait \u00E0 l'origine \u00E0 un pourcentage de votre premi\u00E8re saisie.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// credit
			// credit modele = 0 -> credit courant vide ou 0
			else if (osa_modele[osa_currentLigne].credit==0
			&& !isEmpty(document.getElementById('osa-credit').value)
			&& document.getElementById('osa-credit').value!=0) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le cr\u00E9dit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci correspondait \u00E0 l'origine \u00E0 un pourcentage nul.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// credit modele !=0 -> credit courant non vide et non nul
			else if (osa_modele[osa_currentLigne].credit!=0
			&& (isEmpty(document.getElementById('osa-credit').value) || document.getElementById('osa-credit').value==0)) {
				probleme = true;
				quitter = window.confirm("Le mod\u00E8le attend un montant au cr\u00E9dit.\n"+
				"Celui-ci correspondait \u00E0 l'origine \u00E0 un pourcentage.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
			// credit modele !=0 et credit courant non vide et non nul et montant pourcent != -1 -> credit courant = montant pourcent * credit modele / 100
			else if (osa_modele[osa_currentLigne].credit!=0
			&& !isEmpty(document.getElementById('osa-credit').value)
			&& document.getElementById('osa-credit').value!=0
			&& osa_montantPourcent!=-1
			&& document.getElementById('osa-credit').value!=rd2.round(osa_montantPourcent*osa_modele[osa_currentLigne].credit/100)) {
				probleme = true;
				quitter = window.confirm("Vous avez modifi\u00E9 le cr\u00E9dit de r\u00E9f\u00E9rence du mod\u00E8le.\n"+
				"Celui-ci correspondait \u00E0 l'origine \u00E0 un pourcentage de votre premi\u00E8re saisie.\n"+
				"Si vous continuez la saisie, vous quitterez le mod\u00E8le actuel.\n"+
				"Voulez-vous quitter le mode raccourci ?");
			}
		}
		if (quitter) {
			osa_enableModeRaccourci(false);
			//osa_modeRaccourci = false;
		}
		return !probleme;
	} catch (e) {
		recup_erreur(e);
	}
}


function osa_loadModeleById(modeleId) {
	try {

		var qLoad = new QueryHttp("Compta/ModelesEcriture/getLigneModeleEcriture.tmpl");
		qLoad.setParam("Modele_Id", modeleId);
		var result = qLoad.execute();

		osa_loadLignes(result.responseXML.documentElement.getElementsByTagName("ligneModele"));

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_loadModeleByRaccourci(raccourci) {
	try {

		var qLoad = new QueryHttp("Compta/ModelesEcriture/getLigneModeleEcriture.tmpl");
		qLoad.setParam("Raccourci", raccourci);
		var result = qLoad.execute();

		osa_loadLignes(result.responseXML.documentElement.getElementsByTagName("ligneModele"));

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_loadLignes(tabLignes) {
	try {

		if (tabLignes.length!=0) {
			osa_modele = new Array();
			osa_currentLigne = 0;
			osa_montantPourcent = -1;
			osa_tabLP = new Array();

			for (var i=0; i<tabLignes.length; i++) {
				var ligneXml = tabLignes.item(i);
				var ligne = new osa_LigneModele();

				ligne.compte = ligneXml.getAttribute("Num_Compte");
				ligne.libelle = ligneXml.getAttribute("Libelle");
				ligne.reglement = ligneXml.getAttribute("Mode_Reg_Id");
				ligne.infos = ligneXml.getAttribute("Commentaire");
				ligne.debit = ligneXml.getAttribute("Debit");
				ligne.credit = ligneXml.getAttribute("Credit");
				ligne.piece = ligneXml.getAttribute("Num_Piece");
				ligne.calcul = ligneXml.getAttribute("Type_Calcul");
				ligne.periode = ligneXml.getAttribute("Periode_Lib")=="true";

				osa_modele[i] = ligne;

				// si c'est un pourcentage on ajoute la ligne au tableau des lignes en pourcentage
				if (osa_modele[i].calcul=='P') {
					ligne.tabLPId = osa_tabLP.length;
					osa_tabLP[ligne.tabLPId] = ligne;
				}
			}
			osa_enableModeRaccourci(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_executeRappel() {
	try {
		var rd2 = new Arrondi(2);
		if (osa_modeRappel.etat==1) {
			// chargement de la contrepartie;
			if (!isEmpty(osa_modeRappel.contrepartie)) {
				if (document.getElementById('osa-compte').value!=osa_modeRappel.contrepartie) {
					document.getElementById('osa-compte').value = osa_modeRappel.contrepartie;
					osa_resetPreVentilation();
				}
				osa_refreshInfosCpte(osa_modeRappel.contrepartie);
				document.getElementById('osa-debit').focus();
			} else {
				document.getElementById('osa-compte').focus();
			}
			if (osa_modeRappel.codeTVA!=1) {
				// on a une tva, on peut donc en dduire le montant de la contrepartie
				document.getElementById('osa-debit').value = (osa_modeRappel.debitCp==0)?"":rd2.round(osa_modeRappel.debitCp);
				document.getElementById('osa-credit').value = (osa_modeRappel.creditCp==0)?"":rd2.round(osa_modeRappel.creditCp);
				if (!isEmpty(osa_modeRappel.contrepartie)) {
					document.getElementById('osa-piece').focus();
				}
			}
		} else if (osa_modeRappel.etat==2) {
			// chargement de la tva
			if (document.getElementById('osa-compte').value!=osa_modeRappel.compteTVA) {
				document.getElementById('osa-compte').value = osa_modeRappel.compteTVA;
				osa_resetPreVentilation();
			}
			if (!isEmpty(osa_modeRappel.compteTVA)) {
				document.getElementById('osa-debit').focus();
			} else {
				document.getElementById('osa-compte').focus();
			}
			if (osa_modeRappel.codeTVA!=1) {
				document.getElementById('osa-debit').value = (osa_modeRappel.debitTVA==0)?"":rd2.round(osa_modeRappel.debitTVA);
				document.getElementById('osa-credit').value = (osa_modeRappel.creditTVA==0)?"":rd2.round(osa_modeRappel.creditTVA);
				if (!isEmpty(osa_modeRappel.compteTVA)) {
					document.getElementById('osa-piece').focus();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_insererOperation() {
	try {

		var idx = osa_aEcritures.getCurrentIndex();
		if (osa_writeable && !osa_aEcritures.isSeparator(idx)) {
			if (osa_aEcritures.getCellText(idx, 'osa-ColEcritureId')!='0') {
				osa_toModeModif(idx);
			}
			osa_insererLignePreremplie(idx);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_pressOnTreeEcritures(event) {
	try {

		if (event.keyCode==13) {
			osa_menuRevision();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_setLigneEditable(editable) {
	try {

		var b = !editable;

		if (b) {
			document.getElementById("osa-jour").setAttribute("readonly",true);
			document.getElementById("osa-compte").setAttribute("readonly",true);
			document.getElementById("osa-libelle").setAttribute("readonly",true);
			document.getElementById("osa-analytique").setAttribute("readonly",true);
			document.getElementById("osa-contrepartie").setAttribute("readonly",true);
			document.getElementById("osa-echeance").setAttribute("readonly",true);
			document.getElementById("osa-commentaire").setAttribute("readonly",true);
			document.getElementById("osa-debit").setAttribute("readonly",true);
			document.getElementById("osa-credit").setAttribute("readonly",true);
			document.getElementById("osa-piece").setAttribute("readonly",true);
		}
		else {
			document.getElementById("osa-jour").removeAttribute("readonly");
			document.getElementById("osa-compte").removeAttribute("readonly");
			document.getElementById("osa-libelle").removeAttribute("readonly");
			document.getElementById("osa-analytique").removeAttribute("readonly");
			document.getElementById("osa-contrepartie").removeAttribute("readonly");
			document.getElementById("osa-echeance").removeAttribute("readonly");
			document.getElementById("osa-commentaire").removeAttribute("readonly");
			document.getElementById("osa-debit").removeAttribute("readonly");
			document.getElementById("osa-credit").removeAttribute("readonly");
			document.getElementById("osa-piece").removeAttribute("readonly");
		}

		document.getElementById("osa-reglement").disabled = b;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_checkCoherence() {
	try {

		if (osa_currentTypeJournal=="AC" || osa_currentTypeJournal=="VE") {

			switch (document.getElementById('osa-typeCompte').value) {
				case 'F':
					if (isEmpty(document.getElementById('osa-debit').value)) {
						document.getElementById('osa-controleCoherence').value = "";
						document.getElementById('osa-controleCoherence').collapsed = true;
					}
					else {
						document.getElementById('osa-controleCoherence').value = "Attention ! Vous d\u00E9bitez un compte fournisseur. Etes-vous s\u00FBr de comptabiliser un avoir ?";
						document.getElementById('osa-controleCoherence').collapsed = false;
					}
					break;
				case 'C':
					if (isEmpty(document.getElementById('osa-credit').value)) {
						document.getElementById('osa-controleCoherence').value = "";
						document.getElementById('osa-controleCoherence').collapsed = true;
					}
					else {
						document.getElementById('osa-controleCoherence').value = "Attention ! Vous cr\u00E9ditez un compte client. Etes-vous s\u00FBr de comptabiliser un avoir ?";
						document.getElementById('osa-controleCoherence').collapsed = false;
					}
					break;
				default:
					document.getElementById('osa-controleCoherence').value = "";
					document.getElementById('osa-controleCoherence').collapsed = true;
					break;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_enregistrerEcriture(idx) {
	try {
		// puisqu'on enregistre ds qu'une criture est stable
		// idx est un indice d'opration parmi toutes celles qui compose l'criture
		var i = idx;
		var listeOp = "";

		// on recherche donc l'indice du dbut de l'criture
		while (i>=0 && !osa_aEcritures.isSeparator(i)) {
			i--;
		}

		i++;
		// ind sera l'indice de dbut d'criture
		var ind = i;

		// on rcupre toutes les oprations jusqu'au prochain sparateur
		while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {

			listeOp += osa_aEcritures.getCellText(i, 'osa-ColOpId') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColJourOp') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColNumCompte') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColLibelle').replace(/\|/gi,'') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColContrepartie') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColEcheance') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColModeRegId') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColCommentaire').replace(/\|/gi,'') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColDebit').replace(/ /gi,'') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColCredit').replace(/ /gi,'') +"|";
			listeOp += osa_aEcritures.getCellText(i, 'osa-ColPiece').replace(/\|/gi,'') +"|";
			i++;
		}

		qSaveEcr.setParam('Ecriture_Id', osa_aEcritures.getCellText(idx, 'osa-ColEcritureId'));
		qSaveEcr.setParam('Journal_Id', osa_currentJournal);
		qSaveEcr.setParam('Periode', osa_currentPeriode);
		qSaveEcr.setParam('ListeOp', listeOp);

		var result = qSaveEcr.execute();

		var contenu = result.responseXML.documentElement;
		var numero = contenu.getAttribute('Numero');
		var ecritureId = contenu.getAttribute('Ecriture_Id');
		var opids = contenu.getAttribute('Liste_Op_Id').split(/,/gi);

		i = ind;
		var j = 0;

		// on affecte les ids d'criture et d'opration  toutes les oprations qui composent l'criture
		while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
			var child = osa_getChild(i);
			child.addTargetOnce(osa_targetName('Numero'), numero);
			child.addTargetOnce(osa_targetName('Ecriture_Id'), ecritureId);
			child.addTargetOnce(osa_targetName('Prop'), '');
			child.addTargetOnce(osa_targetName('Modif'), '');
			child.addTargetOnce(osa_targetName('Op_Id'), opids[j++]);
			i++;
		}

		// gestion de l'analytique
		if (osa_activeAnalytique) {
			// on va maintenant sauvegarder les ventilations analytiques des oprations
			i = ind;
			var tabVentil = new Array();
			while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
				tabVentil.push(osa_aEcritures.getCellText(i, 'osa-ColVentilation'));
				i++;
			}
			i = ind;

			while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
				var ventil = osa_aEcritures.getCellText(i, 'osa-ColVentilation');

				if (ventil!="-1") {
					if (!isEmpty(ventil) && osa_tabVentilation[ventil].length>0) {
						var qSaveEcrAna = new QueryHttp(osa_adrSaveEcrAna);
						qSaveEcrAna.setParam("Ecriture_Id", ecritureId);
						qSaveEcrAna.setParam("Op_Id", osa_aEcritures.getCellText(i, 'osa-ColOpId'));
						var montantD = osa_aEcritures.getCellText(i, 'osa-ColDebit').replace(/ /gi,'');
						var montantC = osa_aEcritures.getCellText(i, 'osa-ColCredit').replace(/ /gi,'');
						montantD = ((isEmpty(montantD))?0:montantD);
						montantC = ((isEmpty(montantC))?0:montantC);
						qSaveEcrAna.setParam("Debit_Op", montantD);
						qSaveEcrAna.setParam("Credit_Op", montantC);
						var tabLigne = osa_tabVentilation[ventil];
						var listeLignes = "";
						for (var j=0; j<tabLigne.length; j++) {
							listeLignes += tabLigne[j].id + "|";
							listeLignes += tabLigne[j].numero + "|";
							listeLignes += tabLigne[j].intitule + "|";
							listeLignes += tabLigne[j].montant + "|";
							listeLignes += tabLigne[j].pourcentage + "|";
						}

						qSaveEcrAna.setParam("Liste", listeLignes);
						result = qSaveEcrAna.execute();
						var errors = new Errors(result);

						if (errors.hasNext()) {
							errors.show();
						} else {
							var listeEcrAnaId = result.responseXML.documentElement.getAttribute('Liste_Ecr_Ana_Id');
							// maj de l'id de ligne de ventil
							var tabId  = listeEcrAnaId.split("|");
							for (var j=0; j<tabId.length-1; j++) {
								tabLigne[j].id = tabId[j];
							}
						}
					} else {
						// si une ventilation vide est enregistre sur la ligne, on veut supprimer les critures ana
						var qDelEcrAna = new QueryHttp(osa_adrDelEcrAna);
						qDelEcrAna.setParam("Op_Id", osa_aEcritures.getCellText(i, 'osa-ColOpId'));
						result = qDelEcrAna.execute();
						var errors = new Errors(result);
						if (errors.hasNext()) {
							errors.show();
						}
					}
				}
				i++;
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function osa_supprimerEcriture() {
	try {

		if (osa_writeable && osa_aEcritures.isSelected()) {

			var idx = osa_aEcritures.getCurrentIndex();

			if (!osa_aEcritures.isSeparator(idx) && osa_isEcritureSupprimable(idx) && confirm("Voulez-vous supprimer l'\u00E9criture courante ?")) {

				var ecritureId = osa_aEcritures.getCellText(idx, 'osa-ColEcritureId');

				// suppression  l'cran
				var i = idx;

				while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
					osa_supprimerLigne(i);
				}

				i = idx - 1;
				while (i>=0 && !osa_aEcritures.isSeparator(i)) {
					osa_supprimerLigne(i);
					i--;
				}

				i++;
				if (i<osa_aEcritures.nbLignes() && osa_aEcritures.isSeparator(i)) {
					osa_supprimerLigne(i); // suppression d'un sparateur
					if (i==osa_aEcritures.nbLignes()) {
						osa_selectLigne(i-1);
					}
					else {
						osa_selectLigne(i);
					}
				}
				else if (osa_aEcritures.nbLignes()==0) {
					// si suppression de l'criture en cours d'criture et seule sur la page, pour rafficher une ligne de saisie
					osa_ajouterLigneVide(0);
					osa_selectLigne(0);
				}
				else if (osa_aEcritures.isSeparator(i-1) && i==osa_aEcritures.nbLignes()) {
					// si suppression de l'criture en cours d'criture et seule ligne d'une criture, pour rafficher une ligne de saisie
					osa_ajouterLigneVide(osa_aEcritures.nbLignes());
					osa_selectLigne(osa_aEcritures.nbLignes() - 1);
				}

				// suppression sur le serveur
				if (ecritureId!="" && ecritureId!="0") {
					qSupEcr.setParam('Ecriture_Id', ecritureId);
					var result = qSupEcr.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_supprimerOperation() {
	try {

		if (osa_writeable && osa_aEcritures.isSelected()) {

			var idx = osa_aEcritures.getCurrentIndex();

			if ((idx==osa_aEcritures.nbLignes()-1 || osa_aEcritures.isSeparator(idx+1)) && (idx==0 || osa_aEcritures.isSeparator(idx-1))) {
				// si opration toute seule, on demande la suppression de l'criture complte
				osa_supprimerEcriture();
			}
			else if (osa_isOperationSupprimable(idx) && confirm("Voulez-vous supprimer la ligne courante ?")) {

				osa_toModeModif(idx);
				osa_supprimerLigne(idx);

				if (idx>osa_aEcritures.nbLignes()-1 || (osa_aEcritures.nbLignes()>idx && osa_aEcritures.isSeparator(idx))) {
					osa_selectLigne(idx-1);
				}
				else {
					osa_selectLigne(idx);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_isEcritureSupprimable(idx) {
	try {

		var i = idx;
		while (i>=0 && !osa_aEcritures.isSeparator(i)) {
			if (!osa_isOperationSupprimable(i)) return false;
			i--;
		}
		i = idx + 1;
		while (i<osa_aEcritures.nbLignes() && !osa_aEcritures.isSeparator(i)) {
			if (!osa_isOperationSupprimable(i)) return false;
			i++;
		}
		return true;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_isOperationSupprimable(idx) {
	try {

		// proposer dlettrage si lettre ?

		var supprimable = true;

		if (osa_aEcritures.isSeparator(idx)) {
			supprimable = false;
		}
		else if (!isEmpty(osa_aEcritures.getCellText(idx, 'osa-ColLettre'))) {
			supprimable = false;
			showWarning("Impossible de supprimer l'\u00E9criture (\u00E9criture lettr\u00E9e)");
		}
		else if (osa_aEcritures.getCellValue(idx, 'osa-ColPointage')=="1") {
			supprimable = false;
			showWarning("Impossible de supprimer l'\u00E9criture (\u00E9criture point\u00E9e ou appartenant \u00E0 un rapprochement bancaire cl\u00F4tur\u00E9)");
		}
		else if (osa_aEcritures.getCellText(idx, 'osa-ColEtat')=="T") {
			supprimable = false;
			showWarning("Impossible de supprimer l'\u00E9criture (\u00E9criture bloqu\u00E9e)");
		}
		else if (osa_aEcritures.getCellText(idx, 'osa-ColEtat')=="V") {
			supprimable = false;
			showWarning("Impossible de supprimer l'\u00E9criture (\u00E9criture cl\u00F4tur\u00E9e)");
		}

		return supprimable;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_periodePrec() {
	try {

		var wPeriode = document.getElementById('osa-periode');
		var idxPeriode = wPeriode.selectedIndex - 1;
		var maxIndex = wPeriode.getElementsByTagName('menuitem').length - 2;
		wPeriode.selectedIndex = (idxPeriode>=0?idxPeriode:maxIndex);
		osa_chargerJournal();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_periodeSuiv() {
	try {

		var wPeriode = document.getElementById('osa-periode');
		var idxPeriode = wPeriode.selectedIndex + 1;
		var maxIndex = wPeriode.getElementsByTagName('menuitem').length - 2;
		wPeriode.selectedIndex = (idxPeriode<=maxIndex?idxPeriode:0);
		osa_chargerJournal();

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_openRechercheCompte(rechId) {
	try {

		var numCompte = document.getElementById(rechId).value;
		osa_currentRechId = rechId;

		var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', osa_retourRechercheCompte, numCompte, "", "", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_retourRechercheCompte(numCompte, compteId) {
	try {

		if (osa_currentRechId=="osa-compte" && document.getElementById('osa-compte').value!=numCompte) {
			document.getElementById('osa-compte').value = numCompte;
			osa_resetPreVentilation();
		}

		document.getElementById(osa_currentRechId).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_openPlanComptable() {
	try {

		// comment connaitre l'lment qui avait le focus prcdemment ???
		//var previousFocusId = ?;
		//osa_currentRechId = (previousFocusId=="osa-compte" || previousFocusId=="osa-contrepartie"?previousFocusId:null);

		osa_currentRechId = null;

		var url = "chrome://opensi/content/compta/user/comptes/popup-planComptable.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', osa_retourPlanComptable);

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_retourPlanComptable(numCompte) {
	try {

		if (osa_currentRechId!=null) {
			document.getElementById(osa_currentRechId).value = numCompte;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_menuRevision() {
	try {

		if (osa_aEcritures.isSelected()) {

			var idx = osa_aEcritures.getCurrentIndex();

			var numCompte = osa_aEcritures.getCellText(idx, 'osa-ColNumCompte');
			var opId = osa_aEcritures.getCellText(idx, 'osa-ColOpId');
			var lettre = osa_aEcritures.getCellText(idx, 'osa-ColLettre');

			if (!isEmpty(numCompte)) {
			 	var prec = "chrome://opensi/content/compta/user/saisie/menuSaisie.xul?"+ cookie();
				if (opId=="0") {
					prec += "&Journal_Id="+ osa_currentJournal +"&Periode="+ osa_currentPeriode;
				}
				else {
					prec += "&Op_Id="+ opId;
				}

				var page = "chrome://opensi/content/compta/user/consultation/menu_consultation.xul?"+ cookie();
				page += "&compte="+ numCompte;
				page += "&let="+ (isEmpty(lettre)?'0':'1');
				page += "&numop="+ opId;
				page += "&prec="+ urlEncode(prec);
				page += "&nomprec=Saisie";
				window.location = page;
			}
			else {
				window.location = "chrome://opensi/content/compta/user/consultation/menu_consultation.xul";
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_enCoursDeSaisie() {
	try {

		for (var i=0; i<osa_aEcritures.nbLignes()-1; i++) {
			if (osa_aEcritures.getCellText(i, 'osa-ColModif')=='1') {
				return true;
			}
		}

		return false;

	} catch (e) {
		recup_erreur(e);
	}
}


function osa_confirmerAction(fonction) {
	try {

		if (!osa_enCoursDeSaisie() || window.confirm("Attention, des \u00E9critures sont en cours de saisie et ne seront pas enregistr\u00E9es ! Souhaitez-vous poursuivre ?")) {
			fonction();
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function osa_changeOnCompte() {
	try {
		osa_verifCompteChargeProduit();
		osa_activeSaisieAnalytique(osa_compteChargeProduit);
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_resetPreVentilation() {
	try {
		osa_verifCompteChargeProduit();
		if (osa_activeAnalytique) {
			if (osa_idxVentilation==-1) {
				if (osa_compteChargeProduit) {
					var tabLignes = osa_loadPreVentilation(document.getElementById('osa-compte').value);
					if (tabLignes.length>0) {
						osa_recupVentilation(tabLignes);
					}
				}
			} else {
				if (osa_compteChargeProduit) {
					var tabLignes = osa_loadPreVentilation(document.getElementById('osa-compte').value);
					if (tabLignes.length>0
						&& (osa_tabVentilation[osa_idxVentilation].length==0
							|| window.confirm("Une pr\u00E9ventilation est disponible pour ce compte.\n"
								+"Voulez-vous remplacer la ventilation actuelle par cette preventilation ?"))) {
						osa_recupVentilation(tabLignes);
					}
				} else if (osa_tabVentilation[osa_idxVentilation].length==0
					|| window.confirm("L'utilisation de ce compte n'est pas compatible avec la ventilation pr\u00E9sente sur la ligne.\n"
						+" Voulez-vous supprimer la ventilation?")) {
					osa_recupVentilation(new Array());
				} else {
					document.getElementById('osa-compte').value = "";
				}
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_verifCompteChargeProduit() {
	try {
		var compte = document.getElementById('osa-compte').value;
		var char = compte.charAt(0);
		var bool = (char=="6" || char=="7");
		if (bool) {
			osa_compteChargeProduit = true;
		} else {
			osa_compteChargeProduit = false;
		}
		return bool;
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_loadPreVentilation(compteGen) {
	try {
		var qGetPreVentilation = new QueryHttp(osa_adrGetPreVentil);
		qGetPreVentilation.setParam('CompteGen', compteGen);
		var result = qGetPreVentilation.execute();
		var resultLignes = result.responseXML.documentElement.getElementsByTagName("preventilation");
		var ventilation = new Array();
		for (var i=0; i<resultLignes.length; i++) {
			var resultLigne = resultLignes.item(i);
			var ligne = new Ligne();
			ligne.id = 0;
			ligne.numero = resultLigne.getAttribute("compteAna");
			ligne.intitule = resultLigne.getAttribute("libelle");
			ligne.montant = 0;
			ligne.pourcentage = resultLigne.getAttribute("ventilation");
			ventilation.push(ligne);
		}
		return ventilation;
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_activeSaisieAnalytique(boolean) {
	try {
		document.getElementById('osa-analytique').blur();
		if (!boolean) {
			// on veut desactiver : a marche  tous les coups
			document.getElementById('osa-analytique').disabled = true;
		} else {
			if (osa_idxVentilation==-1) {
				document.getElementById('osa-analytique').disabled = false;
			} else {
				if (osa_tabVentilation[osa_idxVentilation].length>1) {
					document.getElementById('osa-analytique').disabled = true;
				} else if (osa_tabVentilation[osa_idxVentilation].length==1) {
					var pourcentage = osa_tabVentilation[osa_idxVentilation][0].pourcentage;
					if (pourcentage==0 || pourcentage==100) {
						document.getElementById('osa-analytique').disabled = false;
					} else {
						// il s'agit d'une preventilation incomplete
						document.getElementById('osa-analytique').disabled = true;
					}
				} else {
					document.getElementById('osa-analytique').disabled = false;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function osa_popupVentilation() {
	try {
		if (!osa_appelPopup) {
			osa_appelPopup = true;
			var tab = new Array();
			var ventilation = new Array();
			if (osa_idxVentilation!=-1) {
				ventilation = osa_tabVentilation[osa_idxVentilation];
				for (var i=0; i<ventilation.length; i++) {
					var ligne = ventilation[i];
					tab.push(ligne.id);
					tab.push(ligne.numero);
					tab.push(ligne.intitule);
					tab.push(ligne.montant);
					tab.push(ligne.pourcentage);
				}
			}
			var connu = false;
			var debit = document.getElementById('osa-debit').value;
			var credit = document.getElementById('osa-credit').value;
			debit = (isEmpty(debit) || !isPositive(debit) || !checkDecimal(debit, 2))?0:debit;
			credit = (isEmpty(credit) || !isPositive(credit) || !checkDecimal(credit, 2))?0:credit;
			var montant = (debit==0)?credit:debit;
			var lock = document.getElementById("osa-analytique").getAttribute("readonly");
			var url = "chrome://opensi/content/compta/user/saisie/popup-ventilationAna.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', osa_recupVentilation, montant, lock, ventilation);
			osa_appelPopup = false;
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_recupVentilation(tabLignes) {
	try {

		if (osa_idxVentilation==-1) {
			osa_tabVentilation.push(tabLignes);
			osa_idxVentilation = osa_tabVentilation.length-1;
		} else {
			osa_tabVentilation[osa_idxVentilation] = tabLignes;
		}

		var idx = osa_aEcritures.getCurrentIndex();
		if ((idx+1)!=osa_aEcritures.nbLignes()) {
			//on est pas sur la ligne de saisie
			osa_toModeModif(idx);
		}
		var child = osa_getChild(idx);
		child.addTargetOnce(osa_targetName('Ventilation'), osa_idxVentilation+"");

		if (document.getElementById('osa-analytique').value=="*") {
			document.getElementById('osa-contrepartie').focus();
		}
		if (tabLignes.length==1) {
			var pourcentage = tabLignes[0].pourcentage;
			if (pourcentage==0 || pourcentage==100) {
				document.getElementById('osa-analytique').value = tabLignes[0].numero;
				//document.getElementById('osa-analytique').disabled = false;
			} else {
				// il s'agit d'une preventilation incomplete
				document.getElementById('osa-analytique').value = "Aff. multiple";
				//document.getElementById('osa-analytique').disabled = true;
			}
		} else if (tabLignes.length>1) {
			document.getElementById('osa-analytique').value = "Aff. multiple";
			//document.getElementById('osa-analytique').disabled = true;
		} else {
			document.getElementById('osa-analytique').value = "";
			//document.getElementById('osa-analytique').disabled = false;
		}
		osa_activeSaisieAnalytique(osa_compteChargeProduit);
		child.addTargetOnce(osa_targetName('Analytique'), document.getElementById('osa-analytique').value);
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_verifAppelPopup() {
	try {
	var ok = false;
		var ventilation = osa_tabVentilation[osa_idxVentilation];
		var sumP = 0;
		for (var i=0; i<ventilation.length; i++) {
			var p = parseFloat(ventilation[i].pourcentage);
			sumP += (isNaN(p)?0:p);
		}
		if (sumP!=0 && sumP!=100) {
			ok = true;
		}
		return ok;
	} catch (e) {
		recup_erreur(e);
	}
}

function osa_resetSaisieAnalytique() {
	try {
		osa_idxVentilation = -1;
		osa_compteChargeProduit = false;
		osa_activeSaisieAnalytique(false);
		document.getElementById('osa-analytique').value = "";
	} catch (e) {
		recup_erreur(e);
	}
}
