/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aOperations = new Arbre("Compta/Saisie/list-rechercheEcritures.tmpl", "listeOperations");
var qListRE = new QueryHttp("Compta/Saisie/getDataListRE.tmpl");

var pageCourante;
var nbPages;



function init() {
  try {

		var aJournaux = new Arbre("ComboListe/combo-journaux.tmpl", "journal");
		aJournaux.initTree();

    document.getElementById('numCompte').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerOperations();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixOperation();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirOperation(opId) {
  try {

		window.arguments[0](opId);
    setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup

  } catch (e) {
    recup_erreur(e);
  }
}


function choixOperation() {
	try {

		if (aOperations.isSelected()) {
			var opId = aOperations.getSelectedCellText('colOpId');
			ouvrirOperation(opId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('numCompte').value = "";
		document.getElementById('journal').value = "";
		document.getElementById('libelle').value = "";
		document.getElementById('numPiece').value = "";
		document.getElementById('lettrage').value = "";
		document.getElementById('dateOp').value = "";
		document.getElementById('dateOpDebut').value = "";
		document.getElementById('dateOpFin').value = "";
		document.getElementById('debit').value = "";
		document.getElementById('debitDebut').value = "";
		document.getElementById('debitFin').value = "";
		document.getElementById('credit').value = "";
		document.getElementById('creditDebut').value = "";
		document.getElementById('creditFin').value = "";

		document.getElementById('typeDate').value = "E";
		document.getElementById('typeDebit').value = "E";
		document.getElementById('typeCredit').value = "E";
		pressOnTypeDate();
		pressOnTypeDebit();
		pressOnTypeCredit();

		listerOperations();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerOperations() {
	try {

		var numCompte = document.getElementById('numCompte').value;
		var journal = document.getElementById('journal').value;
		var libelle = document.getElementById('libelle').value;
		var numPiece = document.getElementById('numPiece').value;
		var lettrage = document.getElementById('lettrage').value;
		var dateOp = document.getElementById('dateOp').value;
		var dateOpDebut = document.getElementById('dateOpDebut').value;
		var dateOpFin = document.getElementById('dateOpFin').value;
		var debit = document.getElementById('debit').value;
		var debitDebut = document.getElementById('debitDebut').value;
		var debitFin = document.getElementById('debitFin').value;
		var credit = document.getElementById('credit').value;
		var creditDebut = document.getElementById('creditDebut').value;
		var creditFin = document.getElementById('creditFin').value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		if (!isEmpty(dateOp) && !isDate(dateOp)) { showWarning("Date incorrecte") }
		else if (!isEmpty(dateOpDebut) && !isDate(dateOpDebut)) { showWarning("Date d'\u00E9criture de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateOpFin) && !isDate(dateOpFin)) { showWarning("Date d'\u00E9criture de fin incorrecte"); }
		else if (!isEmpty(dateOpDebut) && !isEmpty(dateOpFin) && !isDateInterval(dateOpDebut, dateOpFin)) { showWarning("Plage de dates d'\u00E9criture incorrecte"); }
		else if (!isEmpty(debit) && !isPositive(debit)) { showWarning("D\u00E9bit incorrect") }
		else if (!isEmpty(debitDebut) && !isPositiveOrNull(debitDebut)) { showWarning("D\u00E9bit de d\u00E9but incorrect"); }
		else if (!isEmpty(debitFin) && !isPositive(debitFin)) { showWarning("D\u00E9bit de fin incorrect"); }
		else if (!isEmpty(debitDebut) && !isEmpty(debitFin) && parseFloat(debitDebut)>parseFloat(debitFin)) { showWarning("Plage de d\u00E9bits incorrecte"); }
		else if (!isEmpty(credit) && !isPositive(credit)) { showWarning("Cr\u00E9dit incorrect") }
		else if (!isEmpty(creditDebut) && !isPositiveOrNull(creditDebut)) { showWarning("Cr\u00E9dit de d\u00E9but incorrect"); }
		else if (!isEmpty(creditFin) && !isPositive(creditFin)) { showWarning("Cr\u00E9dit de fin incorrect"); }
		else if (!isEmpty(creditDebut) && !isEmpty(creditFin) && parseFloat(creditDebut)>parseFloat(creditFin)) { showWarning("Plage de cr\u00E9dits incorrecte"); }
		else {

			pageCourante = 1;
			nbPages = 1;
			document.getElementById('pageDeb').value = 1;
			document.getElementById('pageFin').value = 1;
			document.getElementById('bPrec').disabled = true;
			document.getElementById('bSuiv').disabled = true;

			document.getElementById('listeOperations').disabled = true;
			document.getElementById('bEditionCsv').disabled = true;
			aOperations.deleteTree();

			qListRE.setParam("Num_Compte", numCompte);
			qListRE.setParam("Journal", journal);
			qListRE.setParam("Libelle", libelle);
			qListRE.setParam("Num_Piece", numPiece);
			qListRE.setParam("Lettrage", lettrage);
			qListRE.setParam("Date_Op", dateOp);
			qListRE.setParam("Date_Op_Debut", dateOpDebut);
			qListRE.setParam("Date_Op_Fin", dateOpFin);
			qListRE.setParam("Debit", debit);
			qListRE.setParam("Debit_Debut", debitDebut);
			qListRE.setParam("Debit_Fin", debitFin);
			qListRE.setParam("Credit", credit);
			qListRE.setParam("Credit_Debut", creditDebut);
			qListRE.setParam("Credit_Fin", creditFin);
			qListRE.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			qListRE.setParam("Current_Page", pageCourante);

			var result = qListRE.execute();

			var contenu = result.responseXML.documentElement;

			nbPages = contenu.getAttribute("Nb_Pages");
			var listOpId = contenu.getAttribute("List_Op_Id");

			aOperations.setParam("List_Op_Id", listOpId);
			aOperations.initTree(initPagination);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeOperations').disabled = true;
		document.getElementById('bEditionCsv').disabled = true;

		qListRE.setParam("Current_Page", pageCourante);
		var result = qListRE.execute();
		var listOpId = result.responseXML.documentElement.getAttribute("List_Op_Id");

		aOperations.setParam("List_Op_Id", listOpId);
		aOperations.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeOperations').disabled = false;
		document.getElementById('bEditionCsv').disabled = aOperations.nbLignes()==0;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTypeDebit() {
	try {

		var typeDebit = document.getElementById('typeDebit').value;

		if (typeDebit=="E") {
			document.getElementById('debit').disabled = false;
			document.getElementById('debitDebut').disabled = true;
			document.getElementById('debitFin').disabled = true;
			document.getElementById('debitDebut').value = "";
			document.getElementById('debitFin').value = "";
		}
		else {
			document.getElementById('debit').disabled = true;
			document.getElementById('debit').value = "";
			document.getElementById('debitDebut').disabled = false;
			document.getElementById('debitFin').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTypeCredit() {
	try {

		var typeCredit = document.getElementById('typeCredit').value;

		if (typeCredit=="E") {
			document.getElementById('credit').disabled = false;
			document.getElementById('creditDebut').disabled = true;
			document.getElementById('creditFin').disabled = true;
			document.getElementById('creditDebut').value = "";
			document.getElementById('creditFin').value = "";
		}
		else {
			document.getElementById('credit').disabled = true;
			document.getElementById('credit').value = "";
			document.getElementById('creditDebut').disabled = false;
			document.getElementById('creditFin').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTypeDate() {
	try {

		var typeDate = document.getElementById('typeDate').value;

		if (typeDate=="E") {
			document.getElementById('dateOp').disabled = false;
			document.getElementById('dateOpDebut').disabled = true;
			document.getElementById('dateOpFin').disabled = true;
			document.getElementById('dateOpDebut').value = "";
			document.getElementById('dateOpFin').value = "";
		}
		else {
			document.getElementById('dateOp').disabled = true;
			document.getElementById('dateOp').value = "";
			document.getElementById('dateOpDebut').disabled = false;
			document.getElementById('dateOpFin').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherCompte() {
	try {

		var numCompte = document.getElementById('numCompte').value;

    var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte, numCompte, "", "", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById("numCompte").value = numCompte;
		listerOperations();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnEditionCsv() {
	try {

		var numCompte = document.getElementById('numCompte').value;
		var journal = document.getElementById('journal').value;
		var libelle = document.getElementById('libelle').value;
		var numPiece = document.getElementById('numPiece').value;
		var lettrage = document.getElementById('lettrage').value;
		var dateOp = document.getElementById('dateOp').value;
		var dateOpDebut = document.getElementById('dateOpDebut').value;
		var dateOpFin = document.getElementById('dateOpFin').value;
		var debit = document.getElementById('debit').value;
		var debitDebut = document.getElementById('debitDebut').value;
		var debitFin = document.getElementById('debitFin').value;
		var credit = document.getElementById('credit').value;
		var creditDebut = document.getElementById('creditDebut').value;
		var creditFin = document.getElementById('creditFin').value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		if (!isEmpty(dateOp) && !isDate(dateOp)) { showWarning("Date incorrecte") }
		else if (!isEmpty(dateOpDebut) && !isDate(dateOpDebut)) { showWarning("Date d'\u00E9criture de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateOpFin) && !isDate(dateOpFin)) { showWarning("Date d'\u00E9criture de fin incorrecte"); }
		else if (!isEmpty(dateOpDebut) && !isEmpty(dateOpFin) && !isDateInterval(dateOpDebut, dateOpFin)) { showWarning("Plage de dates d'\u00E9criture incorrecte"); }
		else if (!isEmpty(debit) && !isPositive(debit)) { showWarning("D\u00E9bit incorrect") }
		else if (!isEmpty(debitDebut) && !isPositiveOrNull(debitDebut)) { showWarning("D\u00E9bit de d\u00E9but incorrect"); }
		else if (!isEmpty(debitFin) && !isPositive(debitFin)) { showWarning("D\u00E9bit de fin incorrect"); }
		else if (!isEmpty(debitDebut) && !isEmpty(debitFin) && parseFloat(debitDebut)>parseFloat(debitFin)) { showWarning("Plage de d\u00E9bits incorrecte"); }
		else if (!isEmpty(credit) && !isPositive(credit)) { showWarning("Cr\u00E9dit incorrect") }
		else if (!isEmpty(creditDebut) && !isPositiveOrNull(creditDebut)) { showWarning("Cr\u00E9dit de d\u00E9but incorrect"); }
		else if (!isEmpty(creditFin) && !isPositive(creditFin)) { showWarning("Cr\u00E9dit de fin incorrect"); }
		else if (!isEmpty(creditDebut) && !isEmpty(creditFin) && parseFloat(creditDebut)>parseFloat(creditFin)) { showWarning("Plage de cr\u00E9dits incorrecte"); }
		else {

			var qEditionCsv = new QueryHttp("Compta/Saisie/csvRechercheEcritures.tmpl");

			qEditionCsv.setParam("Num_Compte", numCompte);
			qEditionCsv.setParam("Journal", journal);
			qEditionCsv.setParam("Libelle", libelle);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Lettrage", lettrage);
			qEditionCsv.setParam("Date_Op", dateOp);
			qEditionCsv.setParam("Date_Op_Debut", dateOpDebut);
			qEditionCsv.setParam("Date_Op_Fin", dateOpFin);
			qEditionCsv.setParam("Debit", debit);
			qEditionCsv.setParam("Debit_Debut", debitDebut);
			qEditionCsv.setParam("Debit_Fin", debitFin);
			qEditionCsv.setParam("Credit", credit);
			qEditionCsv.setParam("Credit_Debut", creditDebut);
			qEditionCsv.setParam("Credit_Fin", creditFin);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
