/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ode_exerciceId;
var ode_updatable = false;
var ode_nomBase;


function ode_init() {
	try {

		var qGetExo = new QueryHttp("Config/cg/getLastExercice.tmpl");
		var result = qGetExo.execute();
		ode_exerciceId = result.responseXML.documentElement.getAttribute('Exercice_Id');
		ode_updatable = (result.responseXML.documentElement.getAttribute('Updatable')=="true");
		ode_nomBase = result.responseXML.documentElement.getAttribute('Nom_Base');
		document.getElementById("ode-dateDebut").value = result.responseXML.documentElement.getAttribute('Debut');
		document.getElementById("ode-dateFin").value = result.responseXML.documentElement.getAttribute('Fin');
		var many = (result.responseXML.documentElement.getAttribute('Many')=="true");
		if (many) { document.getElementById("ode-dateDebut").disabled = true; }

	} catch (e) {
		recup_erreur(e);
	}
}


function ode_enregistrer() {
	try {

		if (ode_updatable) {
			var dateDebut = document.getElementById("ode-dateDebut").value;
			var dateFin = document.getElementById("ode-dateFin").value;

			if (!isDate(dateDebut) || !isDate(dateFin)) {
				showWarning("Veuillez v\u00E9rifier le format des dates");
			}
			else if (!isStrictDateInterval(dateDebut, dateFin)) {
				showWarning("La date de fin doit \u00EAtre strictement sup\u00E9rieure \u00E0 la date de d\u00E9but");
			}
			else {
				var qSaveDates = new QueryHttp("Config/cg/saveDatesExercice.tmpl");
				qSaveDates.setParam("Date_Debut", dateDebut);
				qSaveDates.setParam("Date_Fin", dateFin);
				qSaveDates.setParam("Exercice_Id", ode_exerciceId);
				qSaveDates.setParam("Nom_Base", ode_nomBase);
				var result = qSaveDates.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showMessage("modifications sauvegard\u00E9es !");
				}
			}
		}
		else {
			showWarning("Acc\u00E8s refus\u00E9");
		}

	} catch (e) {
		recup_erreur(e);
	}
}
