/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var importFile;
var tmplUpload;
var pDocId;
var docId;
var typeLogo;



function init() {
  try {

		typeLogo = window.arguments[0];
		docId = window.arguments[1];

		if (typeLogo=="E") {
			tmplUpload = "Config/globale/uploadLogoEtablissement.tmpl";
			pDocId = "Etablissement_Id";
		}
		else if (typeLogo=="W") {
			tmplUpload = "Config/gc/ecommerce/uploadLogo.tmpl";
			pDocId = "Site_Id";
		}
		else if (typeLogo=="S") {
			tmplUpload = "Config/globale/uploadLogoSociete.tmpl";
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLogo() {
  try {

  	if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier");
		}
		else if (importFile.fileSize>307200) {
			showWarning("Taille de fichier trop importante !");
		}
		else if (!validExtension(getFileExtension(importFile.leafName).toLowerCase())) {
			showWarning("Fichier non valide ! (types accept\u00E9s : *.jpeg, *.jpg)");
		}
		else if (checkUploadFile(importFile)) {

			uploadFile(importFile);

			var qUpload = new QueryHttp(tmplUpload);
			if (typeLogo!="S") {
				qUpload.setParam(pDocId, docId);
			}
			qUpload.setParam("Fichier", importFile.leafName);
			var result = qUpload.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.close();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function validExtension(ext) {
  try {

		return ext=="jpg" || ext=="jpeg";

	} catch (e) {
    recup_erreur(e);
  }
}
