/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oct_aCriteres = new Arbre('Config/ct/list-critereContactClient.tmpl', 'oct-listeCriteres');

var oct_currentCritereId = "";



function oct_init() {
	try {

		oct_listerCriteres();

	} catch (e) {
    recup_erreur(e);
  }
}


function oct_listerCriteres() {
	try {

		oct_aCriteres.setParam("Actif", document.getElementById("oct-filtreActif").checked);
		oct_aCriteres.initTree();
		oct_nouveauCritere();

	} catch (e) {
		recup_erreur(e);
	}
}


function oct_nouveauCritere() {
	try {

		oct_currentCritereId = "";
		oct_aCriteres.clearSelection();

		document.getElementById('oct-libelle').value = "";
		document.getElementById('oct-actif').checked = true;

		document.getElementById('oct-bEnregistrer').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oct_chargerCritere() {
	try {

		if (oct_aCriteres.isSelected()) {
			oct_currentCritereId = oct_aCriteres.getSelectedCellText("oct-colCritereId");

			var qLoad = new QueryHttp("Config/ct/loadCritereContactClient.tmpl");
			qLoad.setParam("Critere_Id", oct_currentCritereId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oct-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('oct-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('oct-bEnregistrer').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oct_enregistrerCritere() {
	try {

		var libelle = document.getElementById('oct-libelle').value;
		var actif = document.getElementById('oct-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave = new QueryHttp("Config/ct/updateCritereContactClient.tmpl");

			qSave.setParam("Critere_Id", oct_currentCritereId);
			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oct_listerCriteres();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
