/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var otc_aTypesCompte = new Arbre('Config/ct/list-typeProspect.tmpl', 'otc-listeComptes');

var otc_currentTypeId = "";



function otc_init() {
	try {

		otc_listerTypesCompte();

	} catch (e) {
    recup_erreur(e);
  }
}


function otc_listerTypesCompte() {
	try {

		otc_aTypesCompte.setParam("Actif", document.getElementById("otc-filtreActif").checked);
		otc_aTypesCompte.initTree();
		otc_nouveauTypeCompte();

	} catch (e) {
		recup_erreur(e);
	}
}


function otc_nouveauTypeCompte() {
	try {

		otc_currentTypeId = "";
		otc_aTypesCompte.clearSelection();

		document.getElementById('otc-libelle').value = "";
		document.getElementById('otc-actif').checked = true;

		document.getElementById('otc-bSupprimer').collapsed = true;
		document.getElementById('otc-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function otc_chargerTypeCompte() {
	try {

		if (otc_aTypesCompte.isSelected()) {
			otc_currentTypeId = otc_aTypesCompte.getSelectedCellText("otc-colTypeId");

			var qLoad = new QueryHttp("Config/ct/loadTypeProspect.tmpl");
			qLoad.setParam("Type_Id", otc_currentTypeId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('otc-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('otc-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('otc-bSupprimer').collapsed = false;
				document.getElementById('otc-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otc_enregistrerTypeCompte() {
	try {

		var libelle = document.getElementById('otc-libelle').value;
		var actif = document.getElementById('otc-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(otc_currentTypeId)) {
				qSave = new QueryHttp("Config/ct/updateTypeProspect.tmpl");
				qSave.setParam("Type_Id", otc_currentTypeId);
			}
			else {
				qSave = new QueryHttp("Config/ct/createTypeProspect.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				otc_listerTypesCompte();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otc_supprimerTypeCompte() {
	try {

		if (!isEmpty(otc_currentTypeId) && window.confirm("Confirmez-vous la suppression du type de compte s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/ct/deleteTypeProspect.tmpl");
			qDelete.setParam("Type_Id", otc_currentTypeId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				otc_listerTypesCompte();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
