/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var aAttLog = new Arbre("Config/dl/list-attestationLogiciel.tmpl", "oal-listAttLog");



function oal_init() {
	try {

		document.getElementById("oal-bEditionPDF").disabled = true;
		aAttLog.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oal_pressOnListAttLog() {
	try {

		if (aAttLog.isSelected()) {
			document.getElementById("oal-bEditionPDF").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oal_pdfAttestation() {
	try {

		if (aAttLog.isSelected()) {
			var query = new QueryHttp("Config/dl/pdfAttestationLogiciel.tmpl");
			query.setParam("Attestation_Id", aAttLog.getSelectedCellText("oal-colAttestation_Id"));
			var result = query.execute();

			var fichier = result.responseXML.documentElement.getAttribute('FichierPDF');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirPdf()+ fichier, file);
			}

			aAttLog.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}



