/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oca_aConditionnementsArticle = new Arbre("Config/gc/articles/list-conditionnementArticle.tmpl", "oca-listeConditionnementsArticle");

var oca_currentConditionnementId = "";



function oca_init() {
	try {

		oca_listerConditionnementsArticle();

	} catch (e) {
    recup_erreur(e);
  }
}


function oca_listerConditionnementsArticle() {
	try {

		oca_aConditionnementsArticle.setParam("Actif", document.getElementById("oca-filtreActif").checked);
		oca_aConditionnementsArticle.initTree();
		oca_nouveauConditionnementArticle();

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_nouveauConditionnementArticle() {
	try {

		oca_currentConditionnementId = "";
		oca_aConditionnementsArticle.clearSelection();

		document.getElementById('oca-libelle').value = "";
		document.getElementById('oca-actif').checked = true;

		document.getElementById('oca-bSupprimer').collapsed = true;
		document.getElementById('oca-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oca_chargerConditionnementArticle() {
	try {

		if (oca_aConditionnementsArticle.isSelected()) {
			oca_currentConditionnementId = oca_aConditionnementsArticle.getSelectedCellText("oca-colConditionnementId");

			var qLoad = new QueryHttp("Config/gc/articles/loadConditionnementArticle.tmpl");
			qLoad.setParam("Conditionnement_Id", oca_currentConditionnementId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oca-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('oca-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('oca-bSupprimer').collapsed = false;
				document.getElementById('oca-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oca_enregistrerConditionnementArticle() {
	try {

		var libelle = document.getElementById('oca-libelle').value;
		var actif = document.getElementById('oca-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(oca_currentConditionnementId)) {
				qSave = new QueryHttp("Config/gc/articles/updateConditionnementArticle.tmpl");
				qSave.setParam("Conditionnement_Id", oca_currentConditionnementId);
			}
			else {
				qSave = new QueryHttp("Config/gc/articles/createConditionnementArticle.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oca_listerConditionnementsArticle();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oca_supprimerConditionnementArticle() {
	try {

		if (!isEmpty(oca_currentConditionnementId) && window.confirm("Confirmez-vous la suppression du conditionnement s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/articles/deleteConditionnementArticle.tmpl");
			qDelete.setParam("Conditionnement_Id", oca_currentConditionnementId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oca_listerConditionnementsArticle();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
