/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aCptes = new Arbre('Config/gc/articles/list-compteFamilleArticle.tmpl','tComptes');
var currentChampCompte;
var familleId;



function init() {
  try {

		familleId = window.arguments[0];
		var typeVentilation = window.arguments[1];

		if (typeVentilation=="N") {
			document.getElementById('titre').value = "Affectation des comptes nationaux";
			document.getElementById('colPays').collapsed = true;
		}
		else if (typeVentilation=="U") {
			document.getElementById('titre').value = "Affectation des comptes UE";
		}
		else {
			document.getElementById('titre').value = "Affectation des comptes internationaux";
			document.getElementById('colTauxTVA').collapsed = true;
		}

		aCptes.setParam("Famille_Id", familleId);
		aCptes.setParam("Type_Ventilation", typeVentilation);
		aCptes.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function affecterComptes() {
	try {

		var listCodeTVA = "";

		for (var i=0; i<aCptes.nbLignes(); i++) {
			if (aCptes.getCellValue(i, "colSelect")=="true") {
				listCodeTVA += aCptes.getCellText(i, "colCodeTVA") +",";
			}
  	}

		var compteAchat = document.getElementById('Compte_Achat').value;
		var compteVente = document.getElementById('Compte_Vente').value;

		if (isEmpty(listCodeTVA)) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (isEmpty(compteAchat) && isEmpty(compteVente)) {
			showWarning("Veuillez s\u00E9lectionner au moins un compte");
		}
		else {
			var qAssign = new QueryHttp("Config/gc/articles/assignCompteFamilleArticle.tmpl");

			qAssign.setParam('Famille_Id', familleId);
			qAssign.setParam('Compte_Achat', compteAchat);
			qAssign.setParam('Compte_Vente', compteVente);
			qAssign.setParam('List_Code_TVA', listCodeTVA);

			var result = qAssign.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('Compte_Achat').value = "";
				document.getElementById('Compte_Vente').value = "";
				aCptes.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aCptes.nbLignes(); i++) {
			aCptes.setCellValue(i, "colSelect", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changerCompte(id, debCompte, titre) {
  try {

  	currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourChangerCompte, debCompte, "G", titre, debCompte, false);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}
