/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aCptes = new Arbre('Config/gc/articles/list-compteFamilleArticleTVANationalUE.tmpl','tComptes');
var currentChampCompte;
var familleId;



function init() {
  try {

		familleId = window.arguments[0];

		aCptes.setParam("Famille_Id", familleId);
		aCptes.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function affecterComptes() {
	try {

		var listCodeTVA = "";
		var listCodePays = "";

		for (var i=0; i<aCptes.nbLignes(); i++) {
			if (aCptes.getCellValue(i, "colSelect")=="true") {
				listCodeTVA += aCptes.getCellText(i, "colCodeTVA") +",";
				listCodePays += aCptes.getCellText(i, "colCodePays") +",";
			}
  	}

		var compteVente = document.getElementById('Compte_Vente').value;

		if (isEmpty(listCodeTVA)) {
			showWarning("Veuillez cocher au moins une ligne");
		}
		else if (isEmpty(compteVente)) {
			showWarning("Veuillez s\u00E9lectionner un compte de vente");
		}
		else {
			var qAssign = new QueryHttp("Config/gc/articles/assignCompteFamilleArticleTVANationalUE.tmpl");

			qAssign.setParam('Famille_Id', familleId);
			qAssign.setParam('Compte_Vente', compteVente);
			qAssign.setParam('List_Code_TVA', listCodeTVA);
			qAssign.setParam('List_Code_Pays', listCodePays);

			var result = qAssign.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('Compte_Vente').value = "";
				aCptes.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aCptes.nbLignes(); i++) {
			aCptes.setCellValue(i, "colSelect", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changerCompte(id, debCompte, titre) {
  try {

  	currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourChangerCompte, debCompte, "G", titre, debCompte, false);

  } catch (e) {
    recup_erreur(e);
  }
}


function retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}
