/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var importFile;



function init() {
  try {

    window.resizeTo(500,160);

  } catch (e) {
    recup_erreur(e);
  }
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerCGV() {
  try {

		if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier");
		}
		else if (importFile.fileSize>102400) {
			showWarning("Taille de fichier trop importante ! (100 Ko max.)");
		}
		else if (importFile.leafName.length>50) {
			showWarning("Nom de fichier trop grand ! (50 caract\u00E8res max.)");
		}
		else if (!validExtension(getFileExtension(importFile.leafName).toLowerCase())) {
			showWarning("Fichier non valide ! (types accept\u00E9s : *.pdf)");
		}
		else if (checkUploadFile(importFile)) {

			uploadFile(importFile);

			var qUpload = new QueryHttp("Config/gc/ecommerce/processUploadCGV.tmpl");
			qUpload.setParam('Fichier', importFile.leafName);
			qUpload.setParam('Site_Id', window.arguments[1]);
			var result = qUpload.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				window.arguments[0](importFile.leafName);
				window.close();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function validExtension(ext) {
  try {

		return ext=="pdf";

	} catch (e) {
    recup_erreur(e);
  }
}
