/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofn_aFormats = new Arbre("Config/gc/list-formatNumerotation.tmpl", "ofn-tFormats");
var ofn_formatId;



function ofn_init() {
	try {

		ofn_aFormats.initTree(ofn_nouveauFormat);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofn_nouveauFormat() {
	try {

		ofn_formatId = "";

		document.getElementById("ofn-intitule").value = "";
		document.getElementById("ofn-zoneFixe").value = "";
		document.getElementById("ofn-nbChiffresAnnee").selectedIndex = 0;
		document.getElementById("ofn-nbChiffresNumero").value = "4";
		document.getElementById("ofn-pattern").value = "";
		document.getElementById("ofn-numDebut").value = "1";
		document.getElementById("ofn-typeReinitialisation").selectedIndex = 0;

		document.getElementById("ofn-bNouveau").collapsed = true;
		document.getElementById("ofn-bSupprimer").collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_ouvrirFormat() {
	try {

		if (ofn_aFormats.isSelected()) {
			ofn_formatId = ofn_aFormats.getSelectedCellText("ofn-colFormatId");

			var qLoad = new QueryHttp("Config/gc/getFormatNumerotation.tmpl");
			qLoad.setParam("Format_Id", ofn_formatId);
			var result = qLoad.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById("ofn-intitule").value = contenu.getAttribute("Intitule");
			document.getElementById("ofn-pattern").value = contenu.getAttribute("Pattern");
			document.getElementById("ofn-numDebut").value = contenu.getAttribute("Numero_Init");
			document.getElementById("ofn-typeReinitialisation").value = contenu.getAttribute("Periode_Init");

			document.getElementById("ofn-bNouveau").collapsed = false;
			document.getElementById("ofn-bSupprimer").collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_enregistrerFormat() {
	try {

		var intitule = document.getElementById("ofn-intitule").value;
		var pattern = document.getElementById("ofn-pattern").value;
		var numDebut = document.getElementById("ofn-numDebut").value;
		var typeReinitialisation = document.getElementById("ofn-typeReinitialisation").value;

		if (isEmpty(intitule)) {
			showWarning("Intitul\u00E9 incorrect");
		}
		else if (ofn_checkPattern(pattern, numDebut, typeReinitialisation)) {

			var qSave;
			if (isEmpty(ofn_formatId)) {
				qSave = new QueryHttp("Config/gc/createFormatNumerotation.tmpl");
			}
			else {
				qSave = new QueryHttp("Config/gc/updateFormatNumerotation.tmpl");
				qSave.setParam("Format_Id", ofn_formatId);
			}

			qSave.setParam("Intitule", intitule);
			qSave.setParam("Pattern", pattern);
			qSave.setParam("Numero_Init", numDebut);
			qSave.setParam("Periode_Init", typeReinitialisation);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ofn_aFormats.initTree(ofn_nouveauFormat);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_supprimerFormat() {
	try {

		var qSup = new QueryHttp("Config/gc/deleteFormatNumerotation.tmpl");
		qSup.setParam("Format_Id", ofn_formatId);
		var result = qSup.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofn_aFormats.initTree(ofn_nouveauFormat);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_checkPattern(pattern, numDebut, typeReinitialisation) {
	try {

		var ok = false;

		var nbOccurrencesAnnee = 0;
		var deb = pattern.indexOf("[aa");
		while (deb != -1) {
		  nbOccurrencesAnnee++;
		  deb = pattern.indexOf("[aa",deb+1);
		}

		var nbOccurrencesMois = 0;
		deb = pattern.indexOf("[mm]");
		while (deb != -1) {
		  nbOccurrencesMois++;
		  deb = pattern.indexOf("[mm]",deb+1);
		}

		var nbOccurrencesNumero = 0;
		deb = pattern.indexOf("[0");
		while (deb != -1) {
		  nbOccurrencesNumero++;
		  deb = pattern.indexOf("[0",deb+1);
		}

		var nbChiffresNumero = 0;
		if (nbOccurrencesNumero==1) {
			deb = pattern.indexOf("[0");
			var fin = pattern.indexOf("0]",deb+1);
			nbChiffresNumero = fin-deb;
		}

		var purgePattern = pattern.replace(/\[/g, "");
		purgePattern = purgePattern.replace(/\]/g, "");

		if (isEmpty(purgePattern)) { showWarning("Le format du num\u00E9ro ne doit pas \u00EAtre vide"); }
		else if (purgePattern.length>20) { showWarning("Le format du num\u00E9ro ne doit pas exc\u00E9der 20 caract\u00E8res"); }
		else if (nbOccurrencesAnnee>1) { showWarning("L'ann\u00E9e ne doit pas appara\u00EEtre plus d'une fois"); }
		else if (nbOccurrencesMois>1) { showWarning("Le mois ne doit pas appara\u00EEtre plus d'une fois"); }
		else if (nbOccurrencesAnnee==0 && nbOccurrencesMois==1) { showWarning("Le mois ne doit pas appara\u00EEtre si l'ann\u00E9e n'y est pas"); }
		else if (nbOccurrencesNumero!=1) { showWarning("Le num\u00E9ro incr\u00E9mental doit appara\u00EEtre une seule fois"); }
		else if (isEmpty(numDebut) || !isPositiveInteger(numDebut)) { showWarning("Le num\u00E9ro de d\u00E9part est incorrect"); }
		else if (parseIntBis(numDebut) > Math.pow(10,nbChiffresNumero)-1) { showWarning("Le nombre de chiffres du num\u00E9ro de d\u00E9part est plus \u00E9lev\u00E9 que celui du num\u00E9ro incr\u00E9mental"); }
		else if (typeReinitialisation=="A" && nbOccurrencesAnnee!=1) { showWarning("La r\u00E9initialisation ne peut pas \u00EAtre annuelle si l'ann\u00E9e ne figure pas dans le format"); }
		else if (typeReinitialisation=="M" && nbOccurrencesMois!=1) { showWarning("La r\u00E9initialisation ne peut pas \u00EAtre mensuelle si le mois ne figure pas dans le format"); }
		else {
			ok = true;
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_reinitPattern() {
	try {

		document.getElementById("ofn-pattern").value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_ajouterZoneFixe() {
	try {

		var zoneFixe = document.getElementById("ofn-zoneFixe").value;

		if (isEmpty(zoneFixe)) {
			showWarning("La zone fixe est vide");
		}
		else if (!isCleAlpha(zoneFixe)) {
			showWarning("La zone fixe contient des caract\u00E8res invalides");
		}
		else {
			document.getElementById("ofn-pattern").value += zoneFixe;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_ajouterAnnee() {
	try {

		document.getElementById("ofn-pattern").value += (document.getElementById("ofn-nbChiffresAnnee").value=="2"?"[aa]":"[aaaa]");

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_ajouterMois() {
	try {

		document.getElementById("ofn-pattern").value += "[mm]";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofn_ajouterNumero() {
	try {

		var nbChiffres = document.getElementById("ofn-nbChiffresNumero").value;

		if (isEmpty(nbChiffres) || !isPositiveInteger(nbChiffres)) {
			showWarning("Le nombre de chiffres du num\u00E9ro incr\u00E9mental est incorrect");
		}
		else {
			nbChiffres = parseIntBis(nbChiffres);
			document.getElementById("ofn-pattern").value += "[";
			for (var i=0; i<nbChiffres; i++) {
				document.getElementById("ofn-pattern").value += "0";
			}
			document.getElementById("ofn-pattern").value += "]";
		}

	} catch (e) {
		recup_erreur(e);
	}
}
