/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omm_aMotifsMvtStock = new Arbre("Config/gc/list-motifMvtStock.tmpl", "omm-listeMotifsMvtStock");

var omm_currentMotifId = "";



function omm_init() {
	try {

		omm_listerMotifsMvtStock();

	} catch (e) {
    recup_erreur(e);
  }
}


function omm_listerMotifsMvtStock() {
	try {

		omm_aMotifsMvtStock.initTree();
		omm_nouveauMotifMvtStock();

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_nouveauMotifMvtStock() {
	try {

		omm_currentMotifId = "";
		omm_aMotifsMvtStock.clearSelection();

		document.getElementById('omm-libelle').value = "";

		document.getElementById('omm-bSupprimer').collapsed = true;
		document.getElementById('omm-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function omm_chargerMotifMvtStock() {
	try {

		if (omm_aMotifsMvtStock.isSelected()) {
			omm_currentMotifId = omm_aMotifsMvtStock.getSelectedCellText("omm-colMotifId");

			var qLoad = new QueryHttp("Config/gc/loadMotifMvtStock.tmpl");
			qLoad.setParam("Motif_Id", omm_currentMotifId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('omm-libelle').value = contenu.getAttribute('Libelle');

				document.getElementById('omm-bSupprimer').collapsed = false;
				document.getElementById('omm-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omm_enregistrerMotifMvtStock() {
	try {

		var libelle = document.getElementById('omm-libelle').value;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(omm_currentMotifId)) {
				qSave = new QueryHttp("Config/gc/updateMotifMvtStock.tmpl");
				qSave.setParam("Motif_Id", omm_currentMotifId);
			}
			else {
				qSave = new QueryHttp("Config/gc/createMotifMvtStock.tmpl");
			}

			qSave.setParam("Libelle", libelle);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omm_listerMotifsMvtStock();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omm_supprimerMotifMvtStock() {
	try {

		if (!isEmpty(omm_currentMotifId) && window.confirm("Confirmez-vous la suppression du motif s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/deleteMotifMvtStock.tmpl");
			qDelete.setParam("Motif_Id", omm_currentMotifId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omm_listerMotifsMvtStock();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
