/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var opa_aPolesActivite = new Arbre("Config/gc/list-poleActivite.tmpl", "opa-listePolesActivite");

var opa_currentPoleId = "";



function opa_init() {
	try {

		opa_listerPolesActivite();

	} catch (e) {
    recup_erreur(e);
  }
}


function opa_listerPolesActivite() {
	try {

		opa_aPolesActivite.setParam("Actif", document.getElementById("opa-filtreActif").checked);
		opa_aPolesActivite.initTree();
		opa_nouveauPoleActivite();

	} catch (e) {
		recup_erreur(e);
	}
}


function opa_nouveauPoleActivite() {
	try {

		opa_currentPoleId = "";
		opa_aPolesActivite.clearSelection();

		document.getElementById('opa-codePole').value = "";
		document.getElementById('opa-intitule').value = "";
		document.getElementById('opa-actif').checked = true;

		document.getElementById('opa-bSupprimer').collapsed = true;
		document.getElementById('opa-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function opa_chargerPoleActivite() {
	try {

		if (opa_aPolesActivite.isSelected()) {
			opa_currentPoleId = opa_aPolesActivite.getSelectedCellText("opa-colPoleId");

			var qLoad = new QueryHttp("Config/gc/loadPoleActivite.tmpl");
			qLoad.setParam("Pole_Id", opa_currentPoleId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('opa-codePole').value = contenu.getAttribute('Code_Pole');
				document.getElementById('opa-intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('opa-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('opa-bSupprimer').collapsed = false;
				document.getElementById('opa-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opa_enregistrerPoleActivite() {
	try {

		var codePole = document.getElementById('opa-codePole').value;
		var intitule = document.getElementById('opa-intitule').value;
		var actif = document.getElementById('opa-actif').checked;

		if (isEmpty(codePole)) {
			showWarning("Code p\u00F4le manquant");
		}
		else if (isEmpty(intitule)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(opa_currentPoleId)) {
				qSave = new QueryHttp("Config/gc/updatePoleActivite.tmpl");
				qSave.setParam("Pole_Id", opa_currentPoleId);
			}
			else {
				qSave = new QueryHttp("Config/gc/createPoleActivite.tmpl");
			}

			qSave.setParam("Code_Pole", codePole);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opa_listerPolesActivite();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opa_supprimerPoleActivite() {
	try {

		if (!isEmpty(opa_currentPoleId) && window.confirm("Confirmez-vous la suppression du p\u00F4le d'activit\u00E9 s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/deletePoleActivite.tmpl");
			qDelete.setParam("Pole_Id", opa_currentPoleId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opa_listerPolesActivite();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
