/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ota_aTarifsVente = new Arbre("Config/gc/ventes/list-tarifVente.tmpl", "ota-listeTarifsVente");

var ota_currentTarifId = "";



function ota_init() {
	try {

		ota_listerTarifsVente();

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_listerTarifsVente() {
	try {

		ota_aTarifsVente.setParam("Actif", document.getElementById("ota-filtreActif").checked);
		ota_aTarifsVente.initTree();
		ota_nouveauTarifVente();

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_nouveauTarifVente() {
	try {

		ota_currentTarifId = "";
		ota_aTarifsVente.clearSelection();

		document.getElementById('ota-codeTarif').value = "";
		document.getElementById('ota-intitule').value = "";
		document.getElementById('ota-actif').checked = true;
		document.getElementById('ota-coeffDefaut').value = "";
		document.getElementById('ota-arrondiHT').value = 2;
		document.getElementById('ota-arrondiTTC').value = 2;

		document.getElementById('ota-bSupprimer').collapsed = true;
		document.getElementById('ota-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_chargerTarifVente() {
	try {

		if (ota_aTarifsVente.isSelected()) {
			ota_currentTarifId = ota_aTarifsVente.getSelectedCellText("ota-colTarifId");

			var qLoad = new QueryHttp("Config/gc/ventes/loadTarifVente.tmpl");
			qLoad.setParam("Tarif_Id", ota_currentTarifId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ota-codeTarif').value = contenu.getAttribute('Code_Tarif');
				document.getElementById('ota-intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('ota-actif').checked = contenu.getAttribute('Actif')=="true";
				document.getElementById('ota-coeffDefaut').value = contenu.getAttribute('Coeff_Defaut');
				document.getElementById('ota-arrondiHT').value = contenu.getAttribute('Arrondi_HT');
				document.getElementById('ota-arrondiTTC').value = contenu.getAttribute('Arrondi_TTC');

				document.getElementById('ota-bSupprimer').collapsed = false;
				document.getElementById('ota-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_enregistrerTarifVente() {
	try {

		var codeTarif = document.getElementById('ota-codeTarif').value;
		var intitule = document.getElementById('ota-intitule').value;
		var actif = document.getElementById('ota-actif').checked;
		var coeffDefaut = document.getElementById('ota-coeffDefaut').value;
		var arrondiHT = document.getElementById('ota-arrondiHT').value;
		var arrondiTTC = document.getElementById('ota-arrondiTTC').value;

		if (isEmpty(codeTarif)) {
			showWarning("Code tarif manquant");
		}
		else if (isEmpty(intitule)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else if (!isPositiveOrNull(coeffDefaut)  || !checkNumber(coeffDefaut,12,6)) {
			showWarning("Coefficient par d\u00E9faut incorrect");
		}
		else if (parseIntBis(arrondiHT)<2 || parseIntBis(arrondiHT)>4) {
			showWarning("Arrondi HT incorrect");
		}
		else if (parseIntBis(arrondiTTC)<2 || parseIntBis(arrondiTTC)>4) {
			showWarning("Arrondi TTC incorrect");
		}
		else {
			var qSave;

			if (!isEmpty(ota_currentTarifId)) {
				qSave = new QueryHttp("Config/gc/ventes/updateTarifVente.tmpl");
				qSave.setParam("Tarif_Id", ota_currentTarifId);
			}
			else {
				qSave = new QueryHttp("Config/gc/ventes/createTarifVente.tmpl");
				document.getElementById('ota-buttonBox').collapsed = true;
				document.getElementById('ota-pmBox').collapsed = false;
				document.getElementById('ota-pm').setAttribute('mode', 'undetermined');
			}

			qSave.setParam("Code_Tarif", codeTarif);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Actif", actif);
			qSave.setParam("Coeff_Defaut", coeffDefaut);
			qSave.setParam("Arrondi_HT", arrondiHT);
			qSave.setParam("Arrondi_TTC", arrondiTTC);

			qSave.execute(ota_enregistrerTarifVente_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_enregistrerTarifVente_2(result) {
	try {

		if (isEmpty(ota_currentTarifId)) {
			document.getElementById('ota-pm').setAttribute('mode', 'none');
			document.getElementById('ota-pmBox').collapsed = true;
			document.getElementById('ota-buttonBox').collapsed = false;
		}

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ota_listerTarifsVente();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_supprimerTarifVente() {
	try {

		if (!isEmpty(ota_currentTarifId) && window.confirm("Confirmez-vous la suppression du tarif de vente s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/ventes/deleteTarifVente.tmpl");
			qDelete.setParam("Tarif_Id", ota_currentTarifId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ota_listerTarifsVente();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
