/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ots_aTypesSuiviCC = new Arbre('Config/gc/ventes/list-typeSuiviCC.tmpl', 'ots-listeTypesSuiviCC');

var ots_currentTypeSuiviId = "";



function ots_init() {
	try {

		ots_listerTypesSuiviCC();

	} catch (e) {
    recup_erreur(e);
  }
}


function ots_listerTypesSuiviCC() {
	try {

		ots_aTypesSuiviCC.initTree();
		ots_nouveauTypeSuiviCC();

	} catch (e) {
		recup_erreur(e);
	}
}


function ots_nouveauTypeSuiviCC() {
	try {

		ots_currentTypeSuiviId = "";
		ots_aTypesSuiviCC.clearSelection();

		document.getElementById('ots-libelle').value = "";

		document.getElementById('ots-bSupprimer').collapsed = true;
		document.getElementById('ots-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ots_chargerTypeSuiviCC() {
	try {

		if (ots_aTypesSuiviCC.isSelected()) {
			ots_currentTypeSuiviId = ots_aTypesSuiviCC.getSelectedCellText("ots-colTypeSuiviId");

			var qLoad = new QueryHttp("Config/gc/ventes/loadTypeSuiviCC.tmpl");
			qLoad.setParam("Type_Suivi_Id", ots_currentTypeSuiviId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('ots-libelle').value = contenu.getAttribute('Libelle');

				document.getElementById('ots-bSupprimer').collapsed = false;
				document.getElementById('ots-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ots_enregistrerTypeSuiviCC() {
	try {

		var libelle = document.getElementById('ots-libelle').value;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(ots_currentTypeSuiviId)) {
				qSave = new QueryHttp("Config/gc/ventes/updateTypeSuiviCC.tmpl");
				qSave.setParam("Type_Suivi_Id", ots_currentTypeSuiviId);
			}
			else {
				qSave = new QueryHttp("Config/gc/ventes/createTypeSuiviCC.tmpl");
			}

			qSave.setParam("Libelle", libelle);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ots_listerTypesSuiviCC();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ots_supprimerTypeSuiviCC() {
	try {

		if (!isEmpty(ots_currentTypeSuiviId) && window.confirm("Confirmez-vous la suppression du type de suivi s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/ventes/deleteTypeSuiviCC.tmpl");
			qDelete.setParam("Type_Suivi_Id", ots_currentTypeSuiviId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ots_listerTypesSuiviCC();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
