/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var affectationId;
var importFile;



function init() {
	try {

		affectationId = window.arguments[1];

	} catch (e) {
		recup_erreur(e);
	}
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function importerFichier() {
	try {

		if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier \u00E0 importer");
		}
		else {
			var extension = getFileExtension(importFile.leafName).toLowerCase();

			if (!isEmpty(extension) && extension!="csv" && extension!="txt") {
				showWarning("Format de fichier incorrect (formats accept\u00E9s : *.csv, *.txt)");
			}
			else if (checkUploadFile(importFile)) {

				var supprimerAvant = document.getElementById('supprimerAvant').checked;

				uploadFile(importFile);

	   		var qImport = new QueryHttp("Config/gc/ventes/importCodePostalAffectationDepotLigneCC.tmpl");
	   		qImport.setParam("Affectation_Id", affectationId);
	   		qImport.setParam("Fichier", importFile.leafName);
				qImport.setParam("Supprimer_Avant", supprimerAvant);

	   		var result = qImport.execute();

	   		var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var nbLines = result.responseXML.documentElement.getElementsByTagName("erreurs").length;

					if (nbLines==0) {
						showMessage("Import termin\u00E9 avec succ\u00E8s : "+ result.responseXML.documentElement.getAttribute('Nb_Lines_OK') +" lignes import\u00E9es");
					}
					else {
						var rapport = result.responseXML.documentElement.getAttribute('Fichier_Rapport');

						var messages = new Array();
						var lines = new Array();
						var cells = new Array();

						for (var j=0; j<nbLines; j++) {
							var erreur = result.responseXML.documentElement.getElementsByTagName('erreurs')[j];
							messages[j] = erreur.getAttribute("Message");
							lines[j] = erreur.getAttribute("Ligne");
							cells[j] = erreur.getAttribute("Cellule");
						}

						window.openDialog("chrome://opensi/content/facturation/user/csv/popup-rapportErreurs.xul",'','chrome,modal,centerscreen', lines, cells, messages, rapport);
					}
				}

		   	window.arguments[0]();
		   	window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
