/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oe_aEtablissements = new Arbre('Config/globale/list-etablissement.tmpl', 'oe-listeEtablissements');
var oe_aCoord = new Arbre('Config/globale/list-coordEtablissementVente.tmpl', 'oe-listeCoord');

var oe_currentEtablissementId = "";
var oe_currentCoordId = "";



function oe_init() {
	try {

		var aPaysLivCEV = new Arbre("ComboListe/combo-pays.tmpl", "oe-codePaysLivCEV");
		aPaysLivCEV.initTree();

		var aPaysCEV = new Arbre("ComboListe/combo-pays.tmpl", "oe-codePaysCEV");
		aPaysCEV.initTree();

		oe_chargerPays();

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_chargerPays() {
	try {

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oe-codePays");
		aPays.initTree(oe_chargerDepotsDefaut);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerDepotsDefaut() {
	try {

		var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oe-depotDefaut');
		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Quarantaine", false);
		aDepots.setParam("No_Check_Rights", true);
		aDepots.initTree(oe_chargerDepotsRC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerDepotsRC() {
	try {

		var aDepotsRC = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oe-depotRC');
		aDepotsRC.setParam("Depot_Vente", false);
		aDepotsRC.setParam("No_Check_Rights", true);
		aDepotsRC.initTree(oe_initEmailVCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailVCC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailVCC');
		aEmails.initTree(oe_initEmailACC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailACC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailACC');
		aEmails.initTree(oe_initEmailECC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailECC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailECC');
		aEmails.initTree(oe_initEmailPCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailPCC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailPCC');
		aEmails.initTree(oe_initEmailRCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailRCC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailRCC');
		aEmails.initTree(oe_initEmailVFC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailVFC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailVFC');
		aEmails.initTree(oe_initEmailVAC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailVAC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailVAC');
		aEmails.initTree(oe_initEmailRRC);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailRRC() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailRRC');
		aEmails.initTree(oe_initEmailVRP);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailVRP() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailVRP');
		aEmails.initTree(oe_initEmailVBL);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_initEmailVBL() {
	try {

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'oe-emailVBL');
		aEmails.initTree(oe_listerEtablissements);

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_listerEtablissements() {
	try {

		oe_aEtablissements.setParam("Actif", document.getElementById("oe-filtreActif").checked);
		oe_aEtablissements.initTree();
		oe_nouveauEtablissement();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_nouveauEtablissement() {
	try {

		document.getElementById('oe-panneau').selectedIndex = 0;
		oe_hideButtons(false);

		oe_currentEtablissementId = "";
		oe_aEtablissements.clearSelection();

		document.getElementById('oe-codeEtab').value = "";
		document.getElementById('oe-intitule').value = "";
		document.getElementById('oe-actif').checked = true;
		document.getElementById('oe-denomination').value = "";
		document.getElementById('oe-adresse1').value = "";
		document.getElementById('oe-adresse2').value = "";
		document.getElementById('oe-adresse3').value = "";
		document.getElementById('oe-codePostal').value = "";
		document.getElementById('oe-ville').value = "";
		document.getElementById('oe-codePays').value = "";
		document.getElementById('oe-tel').value = "";
		document.getElementById('oe-fax').value = "";
		document.getElementById('oe-email').value = "";
		document.getElementById('oe-siteWeb').value = "";
		document.getElementById('oe-numeroTVA').value = "";
		document.getElementById('oe-numeroICS').value = "";
		document.getElementById('oe-depotDefaut').value = "";
		document.getElementById('oe-depotRC').value = "";
		document.getElementById('oe-contenuLogo').value = "N";
		document.getElementById('oe-urlLogo').value = "";
		document.getElementById('oe-emailVCC').value = "";
		document.getElementById('oe-emailACC').value = "";
		document.getElementById('oe-emailECC').value = "";
		document.getElementById('oe-emailPCC').value = "";
		document.getElementById('oe-emailRCC').value = "";
		document.getElementById('oe-emailVFC').value = "";
		document.getElementById('oe-emailVAC').value = "";
		document.getElementById('oe-emailRRC').value = "";
		document.getElementById('oe-emailVRP').value = "";
		document.getElementById('oe-emailVBL').value = "";

		document.getElementById('oe-bVoirLogo').collapsed = true;
		document.getElementById('oe-bChangerLogo').collapsed = true;
		document.getElementById('oe-bSupprimerLogo').collapsed = true;
		document.getElementById('oe-bSupprimer').collapsed = true;
		document.getElementById('oe-bNouveau').collapsed = true;
		document.getElementById('oe-tabCoord').collapsed = true;

		oe_loadLogo();

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_chargerEtablissement() {
	try {

		if (oe_aEtablissements.isSelected()) {
			oe_currentEtablissementId = oe_aEtablissements.getSelectedCellText("oe-colEtablissementId");

			var qLoad = new QueryHttp("Config/globale/loadEtablissement.tmpl");
			qLoad.setParam("Etablissement_Id", oe_currentEtablissementId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oe-codeEtab').value = contenu.getAttribute('Code_Etab');
				document.getElementById('oe-intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('oe-actif').checked = contenu.getAttribute('Actif')=="true";
				document.getElementById('oe-denomination').value = contenu.getAttribute('Denomination');
				document.getElementById('oe-adresse1').value = contenu.getAttribute('Adresse_1');
				document.getElementById('oe-adresse2').value = contenu.getAttribute('Adresse_2');
				document.getElementById('oe-adresse3').value = contenu.getAttribute('Adresse_3');
				document.getElementById('oe-codePostal').value = contenu.getAttribute('Code_Postal');
				document.getElementById('oe-ville').value = contenu.getAttribute('Ville');
				document.getElementById('oe-codePays').value = contenu.getAttribute('Code_Pays');
				document.getElementById('oe-tel').value = contenu.getAttribute('Tel');
				document.getElementById('oe-fax').value = contenu.getAttribute('Fax');
				document.getElementById('oe-email').value = contenu.getAttribute('Email');
				document.getElementById('oe-siteWeb').value = contenu.getAttribute('Site_Web');
				document.getElementById('oe-numeroTVA').value = contenu.getAttribute('Numero_TVA');
				document.getElementById('oe-numeroICS').value = contenu.getAttribute('Numero_ICS');
				document.getElementById('oe-depotDefaut').value = contenu.getAttribute('Depot_Defaut');
				document.getElementById('oe-depotRC').value = contenu.getAttribute('Depot_RC');
				document.getElementById('oe-contenuLogo').value = contenu.getAttribute('Contenu_Logo');
				document.getElementById('oe-urlLogo').value = contenu.getAttribute('URL_Logo');
				document.getElementById('oe-emailVCC').value = contenu.getAttribute('Email_VCC');
				document.getElementById('oe-emailACC').value = contenu.getAttribute('Email_ACC');
				document.getElementById('oe-emailECC').value = contenu.getAttribute('Email_ECC');
				document.getElementById('oe-emailPCC').value = contenu.getAttribute('Email_PCC');
				document.getElementById('oe-emailRCC').value = contenu.getAttribute('Email_RCC');
				document.getElementById('oe-emailVFC').value = contenu.getAttribute('Email_VFC');
				document.getElementById('oe-emailVAC').value = contenu.getAttribute('Email_VAC');
				document.getElementById('oe-emailRRC').value = contenu.getAttribute('Email_RRC');
				document.getElementById('oe-emailVRP').value = contenu.getAttribute('Email_VRP');
				document.getElementById('oe-emailVBL').value = contenu.getAttribute('Email_VBL');

				document.getElementById('oe-bVoirLogo').collapsed = false;
				document.getElementById('oe-bChangerLogo').collapsed = false;
				document.getElementById('oe-bSupprimerLogo').collapsed = false;
				document.getElementById('oe-bSupprimer').collapsed = false;
				document.getElementById('oe-bNouveau').collapsed = false;
				document.getElementById('oe-tabCoord').collapsed = false;

				oe_listerCoord();
				oe_loadLogo();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_enregistrerEtablissement() {
	try {

		var codeEtab = document.getElementById('oe-codeEtab').value;
		var intitule = document.getElementById('oe-intitule').value;
		var actif = document.getElementById('oe-actif').checked;
		var denomination = document.getElementById('oe-denomination').value;
		var adresse1 = document.getElementById('oe-adresse1').value;
		var adresse2 = document.getElementById('oe-adresse2').value;
		var adresse3 = document.getElementById('oe-adresse3').value;
		var codePostal = document.getElementById('oe-codePostal').value;
		var ville = document.getElementById('oe-ville').value;
		var codePays = document.getElementById('oe-codePays').value;
		var tel = document.getElementById('oe-tel').value;
		var fax = document.getElementById('oe-fax').value;
		var email = document.getElementById('oe-email').value;
		var siteWeb = document.getElementById('oe-siteWeb').value;
		var numeroTVA = document.getElementById('oe-numeroTVA').value;
		var numeroICS = document.getElementById('oe-numeroICS').value;
		var depotDefaut = document.getElementById('oe-depotDefaut').value;
		var depotRC = document.getElementById('oe-depotRC').value;
		var contenuLogo = document.getElementById('oe-contenuLogo').value;
		var urlLogo = document.getElementById('oe-urlLogo').value;
		var emailVCC = document.getElementById('oe-emailVCC').value;
		var emailACC = document.getElementById('oe-emailACC').value;
		var emailECC = document.getElementById('oe-emailECC').value;
		var emailPCC = document.getElementById('oe-emailPCC').value;
		var emailRCC = document.getElementById('oe-emailRCC').value;
		var emailVFC = document.getElementById('oe-emailVFC').value;
		var emailVAC = document.getElementById('oe-emailVAC').value;
		var emailRRC = document.getElementById('oe-emailRRC').value;
		var emailVRP = document.getElementById('oe-emailVRP').value;
		var emailVBL = document.getElementById('oe-emailVBL').value;

		if (isEmpty(intitule)) { showWarning("Intitul\u00E9 manquant"); }
		else if (isEmpty(codeEtab)) { showWarning("Code \u00E9tablissement manquant"); }
		else if (!isCleAlpha(codeEtab)) { showWarning("Le code \u00E9tablissement ne doit pas contenir d'accents ni de caract\u00E8res sp\u00E9ciaux") }
		else if (isEmpty(depotDefaut)) { showWarning("D\u00E9p\u00F4t principal manquant"); }
		else if (isEmpty(depotRC)) { showWarning("D\u00E9p\u00F4t pour les retours client manquant"); }
		else if (!isEmpty(tel) && !isPhone(tel)) { showWarning("T\u00E9l\u00E9phone incorrect"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Fax incorrect"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("E-Mail incorrect"); }
		else if (isEmpty(denomination)) { showWarning("D\u00E9nomination manquante"); }
		else if (isEmpty(adresse1)) { showWarning("Adresse manquante"); }
		else if (isEmpty(ville)) { showWarning("Ville manquante"); }
		else if (isEmpty(codePays)) { showWarning("Pays manquant"); }
		else {
			var qSave;

			if (!isEmpty(oe_currentEtablissementId)) {
				qSave = new QueryHttp("Config/globale/updateEtablissement.tmpl");
				qSave.setParam("Etablissement_Id", oe_currentEtablissementId);
			}
			else {
				qSave = new QueryHttp("Config/globale/createEtablissement.tmpl");
			}

			qSave.setParam("Code_Etab", codeEtab);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Actif", actif);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Tel", tel);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Site_Web", siteWeb);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Numero_ICS", numeroICS);
			qSave.setParam("Depot_Defaut", depotDefaut);
			qSave.setParam("Depot_RC", depotRC);
			qSave.setParam("Contenu_Logo", contenuLogo);
			qSave.setParam("URL_Logo", urlLogo);
			qSave.setParam("Email_VCC", emailVCC);
			qSave.setParam("Email_ACC", emailACC);
			qSave.setParam("Email_ECC", emailECC);
			qSave.setParam("Email_PCC", emailPCC);
			qSave.setParam("Email_RCC", emailRCC);
			qSave.setParam("Email_VFC", emailVFC);
			qSave.setParam("Email_VAC", emailVAC);
			qSave.setParam("Email_RRC", emailRRC);
			qSave.setParam("Email_VRP", emailVRP);
			qSave.setParam("Email_VBL", emailVBL);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oe_listerEtablissements();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_supprimerEtablissement() {
	try {

		if (!isEmpty(oe_currentEtablissementId) && window.confirm("Confirmez-vous la suppression de l'\u00E9tablissement s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/globale/deleteEtablissement.tmpl");
			qDelete.setParam("Etablissement_Id", oe_currentEtablissementId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oe_listerEtablissements();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_hideButtons(b) {
	try {

		document.getElementById('oe-buttons').collapsed = b;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oe_loadLogo() {
  try {

		document.getElementById('oe-vignette').setAttribute("src", getDirServeur() +"data/"+ getProfil().getCodeDossier() +"/logos/ETS_"+ oe_currentEtablissementId +"_small.jpg?"+ nocache());

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_voirLogo() {
  try {

		var urlLogo = getDirServeur() +"data/"+ getProfil().getCodeDossier() +"/logos/ETS_"+ oe_currentEtablissementId +".jpg?"+ nocache();

		var url = "chrome://opensi/content/config/commun/popup-visualisationLogo.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', urlLogo);

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_changerLogo() {
  try {

		var url = "chrome://opensi/content/config/commun/popup-chargementLogo.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "E", oe_currentEtablissementId);

		oe_loadLogo();

	} catch (e) {
    recup_erreur(e);
  }
}


function oe_supprimerLogo() {
  try {

		if (window.confirm("Confirmez-vous la suppression du logo ?")) {
			var qDelete = new QueryHttp("Config/globale/deleteLogoEtablissement.tmpl");
			qDelete.setParam("Etablissement_Id", oe_currentEtablissementId);
			qDelete.execute();

			document.getElementById('oe-vignette').setAttribute("src", "chrome://opensi/content/design/default_logo.jpg");
		}

	} catch (e) {
    recup_erreur(e);
  }
}



// Gestion des coordonnes par pays


function oe_listerCoord() {
	try {

		oe_aCoord.setParam("Etablissement_Id", oe_currentEtablissementId);
		oe_aCoord.initTree();

		oe_nouveauCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_nouveauCoord() {
	try {

		oe_currentCoordId = "";
		oe_aCoord.clearSelection();

		document.getElementById('oe-codePaysLivCEV').value = "";
		document.getElementById('oe-numeroTVACEV').value = "";
		document.getElementById('oe-denominationCEV').value = "";
		document.getElementById('oe-adresse1CEV').value = "";
		document.getElementById('oe-adresse2CEV').value = "";
		document.getElementById('oe-adresse3CEV').value = "";
		document.getElementById('oe-codePostalCEV').value = "";
		document.getElementById('oe-villeCEV').value = "";
		document.getElementById('oe-codePaysCEV').value = "";
		document.getElementById('oe-telCEV').value = "";
		document.getElementById('oe-faxCEV').value = "";
		document.getElementById('oe-emailCEV').value = "";
		document.getElementById('oe-siteWebCEV').value = "";

		document.getElementById('oe-bSupprimerCoord').collapsed = true;
		document.getElementById('oe-bNouveauCoord').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_chargerCoord() {
	try {

		if (oe_aCoord.isSelected()) {
			oe_currentCoordId = oe_aCoord.getSelectedCellText("oe-colCoordIdCEV");

			var qLoad = new QueryHttp("Config/globale/loadCoordEtablissementVente.tmpl");
			qLoad.setParam("Coord_Id", oe_currentCoordId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oe-codePaysLivCEV').value = contenu.getAttribute('Code_Pays_Liv');
				document.getElementById('oe-numeroTVACEV').value = contenu.getAttribute('Numero_TVA');
				document.getElementById('oe-denominationCEV').value = contenu.getAttribute('Denomination');
				document.getElementById('oe-adresse1CEV').value = contenu.getAttribute('Adresse_1');
				document.getElementById('oe-adresse2CEV').value = contenu.getAttribute('Adresse_2');
				document.getElementById('oe-adresse3CEV').value = contenu.getAttribute('Adresse_3');
				document.getElementById('oe-codePostalCEV').value = contenu.getAttribute('Code_Postal');
				document.getElementById('oe-villeCEV').value = contenu.getAttribute('Ville');
				document.getElementById('oe-codePaysCEV').value = contenu.getAttribute('Code_Pays');
				document.getElementById('oe-telCEV').value = contenu.getAttribute('Tel');
				document.getElementById('oe-faxCEV').value = contenu.getAttribute('Fax');
				document.getElementById('oe-emailCEV').value = contenu.getAttribute('Email');
				document.getElementById('oe-siteWebCEV').value = contenu.getAttribute('Site_Web');

				document.getElementById('oe-bSupprimerCoord').collapsed = false;
				document.getElementById('oe-bNouveauCoord').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_enregistrerCoord() {
	try {

		var codePaysLiv = document.getElementById('oe-codePaysLivCEV').value;
		var numeroTVA = document.getElementById('oe-numeroTVACEV').value;
		var denomination = document.getElementById('oe-denominationCEV').value;
		var adresse1 = document.getElementById('oe-adresse1CEV').value;
		var adresse2 = document.getElementById('oe-adresse2CEV').value;
		var adresse3 = document.getElementById('oe-adresse3CEV').value;
		var codePostal = document.getElementById('oe-codePostalCEV').value;
		var ville = document.getElementById('oe-villeCEV').value;
		var codePays = document.getElementById('oe-codePaysCEV').value;
		var tel = document.getElementById('oe-telCEV').value;
		var fax = document.getElementById('oe-faxCEV').value;
		var email = document.getElementById('oe-emailCEV').value;
		var siteWeb = document.getElementById('oe-siteWebCEV').value;

		if (!isEmpty(tel) && !isPhone(tel)) { showWarning("T\u00E9l\u00E9phone incorrect"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Fax incorrect"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("E-Mail incorrect"); }
		else if (isEmpty(denomination)) { showWarning("D\u00E9nomination manquante"); }
		else if (isEmpty(adresse1)) { showWarning("Adresse manquante"); }
		else if (isEmpty(ville)) { showWarning("Ville manquante"); }
		else if (isEmpty(codePays)) { showWarning("Pays manquant"); }
		else if (isEmpty(codePaysLiv)) { showWarning("Pays de livraison manquant"); }
		else {
			var qSave;

			if (isEmpty(oe_currentCoordId)) {
				qSave = new QueryHttp("Config/globale/createCoordEtablissementVente.tmpl");
				qSave.setParam("Etablissement_Id", oe_currentEtablissementId);
			}
			else {
				qSave = new QueryHttp("Config/globale/updateCoordEtablissementVente.tmpl");
				qSave.setParam("Coord_Id", oe_currentCoordId);
			}

			qSave.setParam("Code_Pays_Liv", codePaysLiv);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Tel", tel);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Site_Web", siteWeb);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oe_listerCoord();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_supprimerCoord() {
	try {

		if (window.confirm("Confirmez-vous la suppression des coordonn\u00E9es s\u00E9lectionn\u00E9es ?")) {
			var qDelete = new QueryHttp("Config/globale/deleteCoordEtablissementVente.tmpl");
			qDelete.setParam("Coord_Id", oe_currentCoordId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oe_listerCoord();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oe_reporterCoord() {
	try {

		document.getElementById('oe-numeroTVACEV').value = document.getElementById('oe-numeroTVA').value;
		document.getElementById('oe-denominationCEV').value = document.getElementById('oe-denomination').value;
		document.getElementById('oe-adresse1CEV').value = document.getElementById('oe-adresse1').value;
		document.getElementById('oe-adresse2CEV').value = document.getElementById('oe-adresse2').value;
		document.getElementById('oe-adresse3CEV').value = document.getElementById('oe-adresse3').value;
		document.getElementById('oe-codePostalCEV').value = document.getElementById('oe-codePostal').value;
		document.getElementById('oe-villeCEV').value = document.getElementById('oe-ville').value;
		document.getElementById('oe-codePaysCEV').value = document.getElementById('oe-codePays').value;
		document.getElementById('oe-telCEV').value = document.getElementById('oe-tel').value;
		document.getElementById('oe-faxCEV').value = document.getElementById('oe-fax').value;
		document.getElementById('oe-emailCEV').value = document.getElementById('oe-email').value;
		document.getElementById('oe-siteWebCEV').value = document.getElementById('oe-siteWeb').value;

	} catch (e) {
		recup_erreur(e);
	}
}
