/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var osf_aAccesFTP = new Arbre('Config/globale/list-accesFTP.tmpl', 'osf-listeAccesFTP');
var osf_currentAccesId = "";
var osf_changePassword = false;


function osf_init() {
	try {

		osf_listerAccesFTP();

	} catch (e) {
    recup_erreur(e);
  }
}


function osf_listerAccesFTP() {
	try {

		osf_aAccesFTP.initTree();
		osf_nouveauAccesFTP();

	} catch (e) {
		recup_erreur(e);
	}
}


function osf_nouveauAccesFTP() {
	try {

		osf_currentAccesId = "";
		osf_aAccesFTP.clearSelection();

		document.getElementById('osf-libelle').value = "";
		document.getElementById('osf-serveurIP').value = "";
		document.getElementById('osf-numeroPort').value = "";
		document.getElementById('osf-protocole').value = "F";
		document.getElementById('osf-login').value = "";
		document.getElementById('osf-password').value = "";

		osf_changePassword = false;
		document.getElementById('osf-password').disabled = false;
		document.getElementById('osf-bChangerPassword').disabled = true;

		document.getElementById('osf-bSupprimer').collapsed = true;
		document.getElementById('osf-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function osf_chargerAccesFTP() {
	try {

		if (osf_aAccesFTP.isSelected()) {
			osf_currentAccesId = osf_aAccesFTP.getSelectedCellText('osf-colAccesId');

			var qLoad = new QueryHttp("Config/globale/loadAccesFTP.tmpl");
			qLoad.setParam("Acces_Id", osf_currentAccesId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('osf-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('osf-serveurIP').value = contenu.getAttribute('Serveur_IP');
				document.getElementById('osf-numeroPort').value = contenu.getAttribute('Numero_Port');
				document.getElementById('osf-protocole').value = contenu.getAttribute('Protocole');
				document.getElementById('osf-login').value = contenu.getAttribute('Login');

				document.getElementById('osf-bSupprimer').collapsed = false;
				document.getElementById('osf-bNouveau').collapsed = false;
				document.getElementById('osf-bChangerPassword').disabled = false;
				document.getElementById('osf-password').value = "**********";
				document.getElementById('osf-password').disabled = true;
				osf_changePassword = false;
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function osf_enregistrerAccesFTP() {
	try {

		var libelle = document.getElementById('osf-libelle').value;
		var serveurIP = document.getElementById('osf-serveurIP').value;
		var login = document.getElementById('osf-login').value;
		var password = document.getElementById('osf-password').value;
		var numeroPort = document.getElementById('osf-numeroPort').value;
		var protocole = document.getElementById('osf-protocole').value;

		var regexIP = /^[^:\/]*$/;

		if (isEmpty(libelle)) { showWarning("Libell\u00E9 manquant"); }
		else if (isEmpty(serveurIP) || !regexIP.test(serveurIP)) { showWarning("Adresse du serveur incorrecte"); }
		else if (isEmpty(login)) { showWarning("Login manquant"); }
		else if (isEmpty(password)) { showWarning("Mot de passe manquant"); }
		else if (isEmpty(numeroPort) || !isPositiveInteger(numeroPort)) { showWarning("Num\u00E9ro de port incorrect"); }
		else if (isEmpty(protocole)) { showWarning("Protocole manquant"); }
		else {
			var qSave;

			if (!isEmpty(osf_currentAccesId)) {
				qSave = new QueryHttp("Config/globale/updateAccesFTP.tmpl");
				qSave.setParam("Change_Password", osf_changePassword);
				qSave.setParam("Acces_Id", osf_currentAccesId);
			}
			else {
				qSave = new QueryHttp("Config/globale/createAccesFTP.tmpl");
			}
			qSave.setParam('Libelle', libelle);
			qSave.setParam('Serveur_IP', serveurIP);
			qSave.setParam('Login', login);
			qSave.setParam('Password', password);
			qSave.setParam('Numero_Port', numeroPort);
			qSave.setParam('Protocole', protocole);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osf_listerAccesFTP();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function osf_supprimerAccesFTP() {
	try {

		if (!isEmpty(osf_currentAccesId) && window.confirm("Confirmez-vous la suppression du serveur FTP s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/globale/deleteAccesFTP.tmpl");
			qDelete.setParam("Acces_Id", osf_currentAccesId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osf_listerAccesFTP();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function osf_changerPassword() {
	try {

		if (osf_aAccesFTP.isSelected()) {
			osf_changePassword = true;
			document.getElementById('osf-bChangerPassword').disabled = true;
			document.getElementById('osf-password').value = "";
			document.getElementById('osf-password').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}
